/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.configuration;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Inspector
extends HandlerBase {
    public String componentName = new String();
    public String packageName = new String();
    public String categoryName;
    public String transformationFile = new String("instance.xsl");

    public InputSource resolveEntity(String string, String string2) throws SAXException {
        if (new File(string2).getName().equalsIgnoreCase("schema.description2.dtd")) {
            this.transformationFile = "instance2.xsl";
        }
        return new InputSource(string2);
    }

    public void setDocumentLocator(Locator locator) {
        System.out.println("** Start validating: " + locator.getSystemId());
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        if (this.componentName.length() == 0 && string == "schema:component") {
            this.componentName = attributeList.getValue("cfg:name");
            this.packageName = attributeList.getValue("cfg:package");
            this.categoryName = attributeList.getValue("schema:category");
            if (this.categoryName == null) {
                this.categoryName = new String("PrivateApplProfile");
            }
        }
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
        System.out.println("** Document is valid!");
    }

    public void error(SAXParseException sAXParseException) throws SAXParseException {
        throw sAXParseException;
    }

    public void warning(SAXParseException sAXParseException) throws SAXParseException {
        System.out.println("** Warning, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId());
        System.out.println("   " + sAXParseException.getMessage());
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.err.println("Usage: cmd filename");
            System.exit(1);
        }
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(true);
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(new File(stringArray[0]), (HandlerBase)new Inspector());
        }
        catch (SAXParseException sAXParseException) {
            System.out.println("\n** Parsing error, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId());
            System.out.println("   " + sAXParseException.getMessage());
            System.exit(1);
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            exception.printStackTrace();
            System.exit(1);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
            System.exit(1);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }
}

