/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.tr;

import com.jclark.xsl.expr.ExprContext;
import com.jclark.xsl.expr.PathPattern;
import com.jclark.xsl.expr.PatternList;
import com.jclark.xsl.expr.TopLevelPattern;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.XSLException;
import com.jclark.xsl.tr.Action;
import com.jclark.xsl.tr.Importance;
import com.jclark.xsl.tr.Priority;
import java.util.Enumeration;
import java.util.Vector;

class TemplateRuleSet {
    private Vector rules = new Vector();
    private PatternList patternList = new PatternList();
    private Action builtinAction;

    TemplateRuleSet(Action builtinAction) {
        this.builtinAction = builtinAction;
    }

    void compile() {
        TemplateRuleSet.reverse(this.rules);
        TemplateRuleSet.sortRulesVector(this.rules);
        Enumeration iter = this.rules.elements();
        while (iter.hasMoreElements()) {
            Rule r = (Rule)iter.nextElement();
            this.patternList.add(r.pattern, r);
        }
    }

    private static void reverse(Vector v) {
        int i = 0;
        for (int j = v.size() - 1; i < j; ++i, --j) {
            Object tem = v.elementAt(i);
            v.setElementAt(v.elementAt(j), i);
            v.setElementAt(tem, j);
        }
    }

    private static void sortRulesVector(Vector v) {
        int sz = v.size();
        for (int i = 1; i < sz; ++i) {
            Rule tem;
            int j;
            Rule rule = (Rule)v.elementAt(i);
            for (j = i; j > 0 && Rule.isBetter(rule, tem = (Rule)v.elementAt(j - 1)); --j) {
                v.setElementAt(tem, j);
            }
            v.setElementAt(rule, j);
        }
    }

    void add(TopLevelPattern pattern, Importance importImportance, Priority priority, Action action) {
        PathPattern[] alternatives = pattern.getAlternatives();
        for (int i = 0; i < alternatives.length; ++i) {
            Rule r = new Rule(alternatives[i], importImportance, priority, action);
            this.rules.addElement(r);
        }
    }

    Action getAction(Node node, ExprContext context) throws XSLException {
        Rule r = (Rule)this.patternList.get(node, context);
        if (r == null) {
            return this.builtinAction;
        }
        return r.action;
    }

    Action getImportAction(Node node, ExprContext context, int importLevel) throws XSLException {
        Enumeration rules = this.patternList.getAll(node, context);
        Rule r = (Rule)rules.nextElement();
        Importance minImportance = r.importImportance;
        int currentLevel = 0;
        while (rules.hasMoreElements()) {
            r = (Rule)rules.nextElement();
            if (r.importImportance.compareTo(minImportance) >= 0) continue;
            if (currentLevel == importLevel) {
                return r.action;
            }
            ++currentLevel;
            minImportance = r.importImportance;
        }
        return this.builtinAction;
    }

    private static class Rule {
        static Importance zero = Importance.create();
        final PathPattern pattern;
        final Importance importImportance;
        final Priority priority;
        final Action action;

        Rule(PathPattern pattern, Importance importImportance, Priority priority, Action action) {
            this.importImportance = importImportance;
            this.priority = priority == null ? Priority.createDefault(pattern.getDefaultPriority()) : priority;
            this.pattern = pattern;
            this.action = action;
        }

        static boolean isBetter(Rule rule1, Rule rule2) {
            int n = rule1.importImportance.compareTo(rule2.importImportance);
            if (n == 0) {
                return rule1.priority.compareTo(rule2.priority) > 0;
            }
            return n > 0;
        }

        public String toString() {
            return "r:" + this.hashCode() + ":" + this.pattern.toString() + "|" + this.importImportance.compareTo(zero);
        }
    }
}

