/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.tr;

import com.jclark.xsl.expr.CloneableNodeIterator;
import com.jclark.xsl.expr.CloneableNodeIteratorImpl;
import com.jclark.xsl.expr.ExtensionContext;
import com.jclark.xsl.expr.KeyValuesTable;
import com.jclark.xsl.expr.SingleNodeIterator;
import com.jclark.xsl.expr.StringVariant;
import com.jclark.xsl.expr.Variant;
import com.jclark.xsl.expr.VariantBase;
import com.jclark.xsl.om.Name;
import com.jclark.xsl.om.NameTable;
import com.jclark.xsl.om.NamespacePrefixMap;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.NodeIterator;
import com.jclark.xsl.om.XSLException;
import com.jclark.xsl.sax.SaxFilterMaker;
import com.jclark.xsl.tr.Action;
import com.jclark.xsl.tr.KeyDefinition;
import com.jclark.xsl.tr.ParameterSet;
import com.jclark.xsl.tr.ProcessContext;
import com.jclark.xsl.tr.Result;
import com.jclark.xsl.tr.ResultFragmentVariant;
import com.jclark.xsl.tr.SheetDetails;
import com.jclark.xsl.tr.VariableInfo;
import com.jclark.xsl.tr.XMLProcessor;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;

class ProcessContextImpl
implements ProcessContext {
    static final int OPEN_ACTION_INIT_SIZE = 2;
    static StringVariant emptyStringVariant = new StringVariant("");
    private final SheetDetails sheet;
    private final ParameterSet params;
    private Node root;
    private Hashtable variableValueTable = new Hashtable();
    private Name evalGlobalVariableName = null;
    private Name[] actionNames = new Name[2];
    private Node[] actionNodes = new Node[2];
    private int[] actionImportLevels = null;
    private int[] actionForEachLevels = null;
    private int nOpenActions = 0;
    private VariableBindings localVariables;
    private Name[] currentParamNames = null;
    private Variant[] currentParamValues = null;
    private int position = 1;
    private int lastPosition = 1;
    private NodeIterator currentIter = null;
    private Hashtable extensionTable = new Hashtable();
    private Hashtable documentTable = new Hashtable();
    private XMLProcessor processor;
    private Hashtable attributeSetInUseTable = new Hashtable();
    private Hashtable nameAliasTable;
    private Hashtable namespacePrefixMapAliasTable;
    private NameTable nameTable;
    private Hashtable objectTable = new Hashtable();
    private Hashtable docsKeyTables = new Hashtable();
    private int nResultFragmentNodes = 0;

    ProcessContextImpl(SheetDetails sheet, Node root, XMLProcessor processor, ParameterSet params) {
        this.sheet = sheet;
        this.root = root;
        this.processor = processor;
        this.params = params;
        if (sheet.haveNamespaceAliases()) {
            this.nameAliasTable = new Hashtable();
            this.namespacePrefixMapAliasTable = new Hashtable();
        } else {
            this.nameAliasTable = null;
            this.namespacePrefixMapAliasTable = null;
        }
        this.nameTable = root.getNamespacePrefixMap().getNameTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(NodeIterator iter, Action action, Result result) throws XSLException {
        int n;
        int savePosition = this.position;
        int saveLastPosition = this.lastPosition;
        NodeIterator saveCurrentIter = this.currentIter;
        this.currentIter = iter;
        this.position = 0;
        this.lastPosition = 0;
        if (this.actionForEachLevels == null) {
            this.actionForEachLevels = new int[this.nOpenActions];
        } else if (this.nOpenActions > this.actionForEachLevels.length) {
            int[] oldActionForEachLevels = this.actionForEachLevels;
            this.actionForEachLevels = new int[this.nOpenActions];
            System.arraycopy(oldActionForEachLevels, 0, this.actionForEachLevels, 0, oldActionForEachLevels.length);
        }
        int n2 = this.nOpenActions - 1;
        this.actionForEachLevels[n2] = this.actionForEachLevels[n2] + 1;
        try {
            Node node;
            while ((node = this.currentIter.next()) != null) {
                ++this.position;
                action.invoke(this, node, result);
            }
            n = this.nOpenActions - 1;
        }
        catch (Throwable throwable) {
            int n3 = this.nOpenActions - 1;
            this.actionForEachLevels[n3] = this.actionForEachLevels[n3] - 1;
            this.position = savePosition;
            this.lastPosition = saveLastPosition;
            this.currentIter = saveCurrentIter;
            throw throwable;
        }
        this.actionForEachLevels[n] = this.actionForEachLevels[n] - 1;
        this.position = savePosition;
        this.lastPosition = saveLastPosition;
        this.currentIter = saveCurrentIter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(NodeIterator iter, Name modeName, Name[] paramNames, Variant[] paramValues, Result result) throws XSLException {
        int savePosition = this.position;
        int saveLastPosition = this.lastPosition;
        NodeIterator saveCurrentIter = this.currentIter;
        this.currentIter = iter;
        this.position = 0;
        this.lastPosition = 0;
        Name[] saveParamNames = this.currentParamNames;
        this.currentParamNames = paramNames;
        Variant[] saveParamValues = this.currentParamValues;
        this.currentParamValues = paramValues;
        try {
            Node node;
            while ((node = this.currentIter.next()) != null) {
                ++this.position;
                if (paramValues == null) {
                    this.processSafe(node, modeName, result);
                    continue;
                }
                this.processUnsafe(node, modeName, result);
            }
        }
        finally {
            this.position = savePosition;
            this.lastPosition = saveLastPosition;
            this.currentIter = saveCurrentIter;
            this.currentParamNames = saveParamNames;
            this.currentParamValues = saveParamValues;
        }
    }

    private void processUnsafe(Node node, Name name, Result result) throws XSLException {
        this.getAction(name, node).invoke(this, node, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processSafe(Node node, Name name, Result result) throws XSLException {
        int i;
        if (name == null) {
            for (i = 0; i < this.nOpenActions; ++i) {
                if (this.actionNames[i] != null || !this.actionNodes[i].equals(node)) continue;
                return;
            }
        } else {
            for (i = 0; i < this.nOpenActions; ++i) {
                if (!name.equals(this.actionNames[i]) || !this.actionNodes[i].equals(node)) continue;
                return;
            }
        }
        if (this.nOpenActions == this.actionNames.length) {
            Name[] oldActionNames = this.actionNames;
            this.actionNames = new Name[this.nOpenActions * 2];
            System.arraycopy(oldActionNames, 0, this.actionNames, 0, this.nOpenActions);
            Node[] oldActionNodes = this.actionNodes;
            this.actionNodes = new Node[this.nOpenActions * 2];
            System.arraycopy(oldActionNodes, 0, this.actionNodes, 0, this.nOpenActions);
        }
        this.actionNames[this.nOpenActions] = name;
        this.actionNodes[this.nOpenActions] = node;
        ++this.nOpenActions;
        try {
            this.getAction(name, node).invoke(this, node, result);
        }
        finally {
            --this.nOpenActions;
        }
    }

    private final Action getAction(Name name, Node node) throws XSLException {
        return this.sheet.getModeTemplateRuleSet(name).getAction(node, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyImports(Node node, Result result) throws XSLException {
        if (this.actionForEachLevels != null && this.actionForEachLevels.length >= this.nOpenActions && this.actionForEachLevels[this.nOpenActions - 1] > 0) {
            throw new XSLException("xsl:apply-templates inside xsl:for-each", node);
        }
        if (this.actionImportLevels == null) {
            this.actionImportLevels = new int[this.nOpenActions];
        } else if (this.nOpenActions > this.actionImportLevels.length) {
            int[] oldActionImportLevels = this.actionImportLevels;
            this.actionImportLevels = new int[this.nOpenActions];
            System.arraycopy(oldActionImportLevels, 0, this.actionImportLevels, 0, oldActionImportLevels.length);
        }
        Name[] saveParamNames = this.currentParamNames;
        this.currentParamNames = null;
        Variant[] saveParamValues = this.currentParamValues;
        this.currentParamValues = null;
        try {
            int n = this.nOpenActions - 1;
            int n2 = this.actionImportLevels[n];
            this.actionImportLevels[n] = n2 + 1;
            this.sheet.getModeTemplateRuleSet(this.actionNames[this.nOpenActions - 1]).getImportAction(node, this, n2).invoke(this, node, result);
            int n3 = this.nOpenActions - 1;
            this.actionImportLevels[n3] = this.actionImportLevels[n3] - 1;
        }
        finally {
            this.currentParamNames = saveParamNames;
            this.currentParamValues = saveParamValues;
        }
    }

    public int getPosition() {
        return this.position;
    }

    public SaxFilterMaker getSaxExtensionFilter() {
        return this.sheet.getSaxExtensionFilter();
    }

    public int getLastPosition() throws XSLException {
        if (this.lastPosition == 0) {
            this.lastPosition = this.position;
            NodeIterator iter = this.cloneCurrentIter();
            while (iter.next() != null) {
                ++this.lastPosition;
            }
        }
        return this.lastPosition;
    }

    private NodeIterator cloneCurrentIter() {
        if (!(this.currentIter instanceof CloneableNodeIterator)) {
            this.currentIter = new CloneableNodeIteratorImpl(this.currentIter);
        }
        return (NodeIterator)((CloneableNodeIterator)this.currentIter).clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Variant getGlobalVariableValue(Name name) throws XSLException {
        Variant value = (Variant)this.variableValueTable.get(name);
        if (value != null) {
            return value;
        }
        VariableInfo info = this.sheet.getGlobalVariableInfo(name);
        if (info == null) {
            return null;
        }
        Object obj = this.params.getParameter(name);
        if (obj != null) {
            value = VariantBase.create(obj).makePermanent();
            this.variableValueTable.put(obj, value);
            return value;
        }
        this.variableValueTable.put(name, emptyStringVariant);
        Name temp = this.evalGlobalVariableName;
        this.evalGlobalVariableName = name;
        try {
            value = info.getExpr().eval(this.root, this).makePermanent();
        }
        finally {
            this.evalGlobalVariableName = temp;
        }
        this.variableValueTable.put(name, value);
        return value;
    }

    public Variant getLocalVariableValue(Name name) {
        VariableBindings p = this.localVariables;
        while (p != null) {
            if (p.name.equals(name)) {
                return p.value;
            }
            p = p.next;
        }
        throw new Error("no such local variable");
    }

    public void bindLocalVariable(Name name, Variant value) throws XSLException {
        this.localVariables = new VariableBindings(name, value.makePermanent(), this.localVariables);
    }

    public void unbindLocalVariables(int n) {
        while (n > 0) {
            this.localVariables = this.localVariables.next;
            --n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeWithParams(Action action, Name[] paramNames, Variant[] paramValues, Node node, Result result) throws XSLException {
        Name[] saveParamNames = this.currentParamNames;
        this.currentParamNames = paramNames;
        Variant[] saveParamValues = this.currentParamValues;
        this.currentParamValues = paramValues;
        try {
            action.invoke(this, node, result);
        }
        finally {
            this.currentParamNames = saveParamNames;
            this.currentParamValues = saveParamValues;
        }
    }

    public Variant getParam(Name name) {
        if (this.currentParamNames != null) {
            for (int i = 0; i < this.currentParamNames.length; ++i) {
                if (!name.equals(this.currentParamNames[i])) continue;
                return this.currentParamValues[i];
            }
        }
        return null;
    }

    public ProcessContext.Memento createMemento() {
        final VariableBindings rememberLocalVariables = this.localVariables;
        final int rememberPosition = this.position;
        final int rememberLastPosition = this.lastPosition;
        final NodeIterator rememberCurrentIter = this.lastPosition == 0 ? this.cloneCurrentIter() : null;
        final Name rememberEvalGlobalVariableName = this.evalGlobalVariableName;
        return new ProcessContext.Memento(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void invoke(Action action, Node node, Result result) throws XSLException {
                Name[] saveParamNames = ProcessContextImpl.this.currentParamNames;
                ProcessContextImpl.access$002(ProcessContextImpl.this, null);
                Variant[] saveParamValues = ProcessContextImpl.this.currentParamValues;
                ProcessContextImpl.access$102(ProcessContextImpl.this, null);
                int savePosition = ProcessContextImpl.this.position;
                ProcessContextImpl.this.position = rememberPosition;
                int saveLastPosition = ProcessContextImpl.this.lastPosition;
                ProcessContextImpl.this.lastPosition = rememberLastPosition;
                NodeIterator saveCurrentIter = ProcessContextImpl.this.currentIter;
                ProcessContextImpl.this.currentIter = rememberCurrentIter;
                VariableBindings saveLocalVariables = ProcessContextImpl.this.localVariables;
                ProcessContextImpl.this.localVariables = rememberLocalVariables;
                Object saveGlobalVariableValue = null;
                if (rememberEvalGlobalVariableName != null) {
                    saveGlobalVariableValue = ProcessContextImpl.this.variableValueTable.get(rememberEvalGlobalVariableName);
                    ProcessContextImpl.this.variableValueTable.put(rememberEvalGlobalVariableName, emptyStringVariant);
                }
                try {
                    action.invoke(ProcessContextImpl.this, node, result);
                }
                finally {
                    ProcessContextImpl.access$002(ProcessContextImpl.this, saveParamNames);
                    ProcessContextImpl.access$102(ProcessContextImpl.this, saveParamValues);
                    ProcessContextImpl.this.localVariables = saveLocalVariables;
                    ProcessContextImpl.this.position = savePosition;
                    ProcessContextImpl.this.lastPosition = saveLastPosition;
                    ProcessContextImpl.this.currentIter = saveCurrentIter;
                    if (rememberEvalGlobalVariableName != null) {
                        ProcessContextImpl.this.variableValueTable.put(rememberEvalGlobalVariableName, saveGlobalVariableValue);
                    }
                }
            }
        };
    }

    public ExtensionContext getExtensionContext(String namespace) throws XSLException {
        ExtensionContext extension = (ExtensionContext)this.extensionTable.get(namespace);
        if (extension == null) {
            extension = this.sheet.createExtensionContext(namespace);
            if (extension == null) {
                extension = new ExtensionContext(){

                    public boolean available(String name) {
                        return false;
                    }

                    public Object call(String name, Node currentNode, Object[] args) throws XSLException {
                        throw new XSLException("implementation of extension namespace not available");
                    }
                };
            }
            this.extensionTable.put(namespace, extension);
        }
        return extension;
    }

    public Variant getSystemProperty(Name name) {
        return this.sheet.getSystemProperty(name);
    }

    public Node getCurrent(Node node) {
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void useAttributeSet(Name name, Node node, Result result) throws XSLException {
        try {
            Action action = this.sheet.getAttributeSet(name);
            if (action == null) {
                return;
            }
            boolean[] inUse = (boolean[])this.attributeSetInUseTable.get(name);
            if (inUse == null) {
                inUse = new boolean[1];
                this.attributeSetInUseTable.put(name, inUse);
            }
            if (inUse[0]) {
                throw new XSLException("circular attribute set usage", node);
            }
            inUse[0] = true;
            try {
                action.invoke(this, node, result);
            }
            finally {
                inUse[0] = false;
            }
        }
        catch (ClassCastException e) {
            // empty catch block
        }
    }

    public NodeIterator getDocument(URL baseURL, String uriRef) throws XSLException {
        int fragmentIndex = uriRef.indexOf(35);
        String fragment = null;
        if (fragmentIndex >= 0) {
            fragment = uriRef.substring(fragmentIndex + 1);
            uriRef = uriRef.substring(0, fragmentIndex);
        }
        try {
            URL url = uriRef.length() == 0 ? baseURL : new URL(baseURL, uriRef);
            Node node = (Node)this.documentTable.get(url);
            if (node == null) {
                node = this.processor.load(url, this.documentTable.size() + 1 + this.nResultFragmentNodes, this.sheet.getSourceLoadContext(), this.root.getNamespacePrefixMap().getNameTable());
                this.documentTable.put(url, node);
            }
            return new SingleNodeIterator(node);
        }
        catch (MalformedURLException e) {
            throw new XSLException(e);
        }
        catch (IOException e) {
            throw new XSLException(e);
        }
    }

    public KeyValuesTable getKeyValuesTable(Name keyName, Node contextNode) {
        KeyValuesTable kvt;
        String docsTablesKey = contextNode.getRoot().getGeneratedId();
        Hashtable<Name, KeyValuesTable> docKeys = (Hashtable<Name, KeyValuesTable>)this.docsKeyTables.get(docsTablesKey);
        if (docKeys == null) {
            docKeys = new Hashtable<Name, KeyValuesTable>();
            this.docsKeyTables.put(docsTablesKey, docKeys);
        }
        if ((kvt = (KeyValuesTable)docKeys.get(keyName)) == null) {
            KeyDefinition kd = this.sheet.getKeyDefinition(keyName);
            if (kd == null) {
                System.err.println("No key definition element for: " + keyName.toString());
                return null;
            }
            kvt = new KeyValuesTable(kd.getMatchPattern(), kd.getUseExpression(), contextNode, this);
            docKeys.put(keyName, kvt);
        }
        return kvt;
    }

    public Name unaliasName(Name name) {
        if (this.nameAliasTable == null) {
            return name;
        }
        Name unaliasedName = (Name)this.nameAliasTable.get(name);
        if (unaliasedName == null) {
            String ns = this.sheet.getNamespaceAlias(name.getNamespace());
            unaliasedName = ns == null ? name : this.nameTable.createName(name.toString(), ns);
        }
        this.nameAliasTable.put(name, unaliasedName);
        return unaliasedName;
    }

    public NamespacePrefixMap unaliasNamespacePrefixMap(NamespacePrefixMap map) {
        if (this.namespacePrefixMapAliasTable == null) {
            return map;
        }
        NamespacePrefixMap unaliasedMap = (NamespacePrefixMap)this.namespacePrefixMapAliasTable.get(map);
        if (unaliasedMap == null) {
            unaliasedMap = map;
            String ns = this.sheet.getNamespaceAlias(map.getDefaultNamespace());
            if (ns != null) {
                unaliasedMap = unaliasedMap.bindDefault(ns);
            }
            int size = map.getSize();
            for (int i = 0; i < size; ++i) {
                ns = this.sheet.getNamespaceAlias(map.getNamespace(i));
                if (ns == null) continue;
                unaliasedMap = unaliasedMap.bind(map.getPrefix(i), ns);
            }
        }
        this.namespacePrefixMapAliasTable.put(map, unaliasedMap);
        return unaliasedMap;
    }

    public void put(Object key, Object value) {
        this.objectTable.put(key, value);
    }

    public Object get(Object key) {
        return this.objectTable.get(key);
    }

    public Node getTree(Variant variant) throws XSLException {
        if (!(variant instanceof ResultFragmentVariant)) {
            return null;
        }
        return ((ResultFragmentVariant)variant).getTree(this);
    }

    public Result createNodeResult(Node baseNode, Node[] rootNodeRef) throws XSLException {
        return this.processor.createResult(baseNode, this.documentTable.size() + ++this.nResultFragmentNodes, this.sheet.getSourceLoadContext(), rootNodeRef);
    }

    static /* synthetic */ Name[] access$002(ProcessContextImpl x0, Name[] x1) {
        x0.currentParamNames = x1;
        return x1;
    }

    static /* synthetic */ Variant[] access$102(ProcessContextImpl x0, Variant[] x1) {
        x0.currentParamValues = x1;
        return x1;
    }

    static final class VariableBindings {
        final VariableBindings next;
        final Variant value;
        final Name name;

        VariableBindings(Name name, Variant value, VariableBindings next) {
            this.name = name;
            this.value = value;
            this.next = next;
        }
    }
}

