/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb.bind.tuple;

import com.sleepycat.bdb.bind.tuple.MarshalledTupleKeyEntity;
import com.sleepycat.bdb.bind.tuple.TupleFormat;
import com.sleepycat.bdb.bind.tuple.TupleInput;
import com.sleepycat.bdb.bind.tuple.TupleOutput;
import com.sleepycat.bdb.bind.tuple.TupleTupleKeyExtractor;
import com.sleepycat.bdb.bind.tuple.TupleTupleMarshalledBinding;
import java.io.IOException;

public class TupleTupleMarshalledKeyExtractor
extends TupleTupleKeyExtractor {
    private String keyName;
    private TupleTupleMarshalledBinding binding;

    public TupleTupleMarshalledKeyExtractor(TupleTupleMarshalledBinding binding, TupleFormat indexKeyFormat, String keyName, boolean usePrimaryKey, boolean useValue) {
        super(usePrimaryKey ? (TupleFormat)binding.getKeyFormat() : null, useValue ? (TupleFormat)binding.getValueFormat() : null, indexKeyFormat);
        this.binding = binding;
        this.keyName = keyName;
    }

    public void extractIndexKey(TupleInput primaryKeyInput, TupleInput valueInput, TupleOutput indexKeyOutput) throws IOException {
        MarshalledTupleKeyEntity entity = (MarshalledTupleKeyEntity)this.binding.dataToObject(primaryKeyInput, valueInput);
        entity.marshalIndexKey(this.keyName, indexKeyOutput);
    }

    public void clearIndexKey(TupleInput valueInput, TupleOutput valueOutput) throws IOException {
        MarshalledTupleKeyEntity entity = (MarshalledTupleKeyEntity)this.binding.dataToObject(null, valueInput);
        entity.clearIndexKey(this.keyName);
        this.binding.objectToValue((Object)entity, valueOutput);
    }
}

