/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb.bind.tuple;

import com.sleepycat.bdb.bind.tuple.MarshalledTupleData;
import com.sleepycat.bdb.bind.tuple.TupleBinding;
import com.sleepycat.bdb.bind.tuple.TupleFormat;
import com.sleepycat.bdb.bind.tuple.TupleInput;
import com.sleepycat.bdb.bind.tuple.TupleOutput;
import com.sleepycat.bdb.util.IOExceptionWrapper;
import java.io.IOException;

public class TupleMarshalledBinding
extends TupleBinding {
    private Class cls;

    public TupleMarshalledBinding(TupleFormat format, Class cls) {
        super(format);
        this.cls = cls;
        if (!MarshalledTupleData.class.isAssignableFrom(cls)) {
            throw new IllegalArgumentException(cls.toString() + " does not implement MarshalledTupleData");
        }
    }

    public Object dataToObject(TupleInput input) throws IOException {
        try {
            MarshalledTupleData obj = (MarshalledTupleData)this.cls.newInstance();
            obj.unmarshalData(input);
            return obj;
        }
        catch (IllegalAccessException e) {
            throw new IOExceptionWrapper(e);
        }
        catch (InstantiationException e) {
            throw new IOExceptionWrapper(e);
        }
    }

    public void objectToData(Object object, TupleOutput output) throws IOException {
        MarshalledTupleData obj = (MarshalledTupleData)object;
        obj.marshalData(output);
    }
}

