/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb;

import com.sleepycat.bdb.DataEnvironment;
import com.sleepycat.bdb.util.RuntimeExceptionWrapper;
import com.sleepycat.db.Db;
import com.sleepycat.db.DbEnv;
import com.sleepycat.db.DbException;
import com.sleepycat.db.DbTxn;

public class CurrentTransaction {
    private DbEnv dbEnv;
    private ThreadLocal currentTrans = new ThreadLocal();

    public static CurrentTransaction getInstance(DbEnv env) {
        DataEnvironment currentTxn = DataEnvironment.getEnvironment(env);
        return currentTxn.isTxnMode() ? currentTxn : null;
    }

    CurrentTransaction(DbEnv dbEnv) {
        this.dbEnv = dbEnv;
    }

    public final DbEnv getEnv() {
        return this.dbEnv;
    }

    public final boolean isAutoCommit() {
        try {
            return (this.dbEnv.getFlags() & Db.DB_AUTO_COMMIT) != 0;
        }
        catch (DbException e) {
            throw new RuntimeExceptionWrapper(e);
        }
    }

    public final boolean isDirtyRead() {
        Trans trans = (Trans)this.currentTrans.get();
        return trans != null ? trans.dirtyRead : false;
    }

    public final boolean isNoWait() {
        Trans trans = (Trans)this.currentTrans.get();
        return trans != null ? trans.noWait : false;
    }

    public final DbTxn getTxn() {
        Trans trans = (Trans)this.currentTrans.get();
        return trans != null ? trans.txn : null;
    }

    public final DbTxn beginTxn() throws DbException {
        return this.beginTxn(false, false);
    }

    public final DbTxn beginTxn(boolean dirtyRead, boolean noWait) throws DbException {
        Trans trans;
        int flags = 0;
        if (dirtyRead) {
            flags |= Db.DB_DIRTY_READ;
        }
        if (noWait) {
            flags |= Db.DB_TXN_NOWAIT;
        }
        if ((trans = (Trans)this.currentTrans.get()) != null) {
            if (trans.txn != null) {
                DbTxn parentTxn = trans.txn;
                trans = new Trans(trans, dirtyRead, noWait);
                trans.txn = this.dbEnv.txnBegin(parentTxn, flags);
                this.currentTrans.set(trans);
            } else {
                trans.txn = this.dbEnv.txnBegin(null, flags);
            }
        } else {
            trans = new Trans(null, dirtyRead, noWait);
            trans.txn = this.dbEnv.txnBegin(null, flags);
            this.currentTrans.set(trans);
        }
        return trans.txn;
    }

    public final DbTxn commitTxn() throws DbException, IllegalStateException {
        Trans trans = (Trans)this.currentTrans.get();
        if (trans != null && trans.txn != null) {
            DbTxn parent = this.closeTxn(trans);
            trans.txn.commit(0);
            return parent;
        }
        throw new IllegalStateException("No transaction is active");
    }

    public final DbTxn abortTxn() throws DbException, IllegalStateException {
        Trans trans = (Trans)this.currentTrans.get();
        if (trans != null && trans.txn != null) {
            DbTxn parent = this.closeTxn(trans);
            trans.txn.abort();
            return parent;
        }
        throw new IllegalStateException("No transaction is active");
    }

    private DbTxn closeTxn(Trans trans) {
        this.currentTrans.set(trans.parent);
        return trans.parent != null ? trans.parent.txn : null;
    }

    private static class Trans {
        private DbTxn txn;
        private Trans parent;
        private boolean dirtyRead;
        private boolean noWait;

        private Trans(Trans parent, boolean dirtyRead, boolean noWait) {
            this.parent = parent;
            this.dirtyRead = dirtyRead;
            this.noWait = noWait;
        }
    }
}

