/*
 * Decompiled with CFR 0.152.
 */
package mod._xmloff.Impress;

import com.sun.star.beans.XPropertySet;
import com.sun.star.frame.XController;
import com.sun.star.frame.XModel;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import ifc.xml.sax._XDocumentHandler;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.SOfficeFactory;

public class XMLSettingsImporter
extends TestCase {
    XComponent xImpressDoc = null;

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        try {
            printWriter.println("creating an impress document");
            this.xImpressDoc = sOfficeFactory.createImpressDoc(null);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create document", exception);
        }
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("    disposing document ");
        this.xImpressDoc.dispose();
    }

    public synchronized TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) throws StatusException {
        XInterface xInterface = null;
        Object object = null;
        printWriter.println("creating a test environment");
        XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)testParameters.getMSF();
        try {
            object = xMultiServiceFactory.createInstance("com.sun.star.comp.Impress.XMLSettingsImporter");
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Can't create component.", exception);
        }
        xInterface = (XInterface)object;
        printWriter.println("creating a new environment for Paragraph object");
        TestEnvironment testEnvironment = new TestEnvironment(xInterface);
        testEnvironment.addObjRelation("TargetDocument", this.xImpressDoc);
        String[][] stringArrayArray = new String[][]{{"start", "office:document-settings", "xmlns:office", "CDATA", "http://openoffice.org/2000/office", "xmlns:xlink", "CDATA", "http://www.w3.org/1999/xlink", "xmlns:presentation", "CDATA", "http://openoffice.org/2000/presentation", "xmlns:config", "CDATA", "http://openoffice.org/2001/config", "office:version", "CDATA", "1.0"}, {"start", "office:settings"}, {"start", "config:config-item-map-indexed", "config:name", "CDATA", "Views"}, {"start", "config:config-item-map-entry"}, {"start", "config:config-item", "config:name", "CDATA", "IsLayerMode"}, {"chars", "true"}, {"end", "config:config-item"}, {"end", "config:config-item-map-entry"}, {"end", "config:config-item-map-indexed"}, {"end", "office:settings"}, {"end", "office:document-settings"}};
        testEnvironment.addObjRelation("XDocumentHandler.XMLData", stringArrayArray);
        XModel xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)this.xImpressDoc);
        XController xController = xModel.getCurrentController();
        final XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xController);
        try {
            printWriter.println("Property \"IsLayerMode\" before import is " + xPropertySet.getPropertyValue("IsLayerMode"));
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Can't create component.", exception);
        }
        final PrintWriter printWriter2 = printWriter;
        testEnvironment.addObjRelation("XDocumentHandler.ImportChecker", new _XDocumentHandler.ImportChecker(){

            public boolean checkImport() {
                Boolean bl;
                try {
                    bl = (Boolean)xPropertySet.getPropertyValue("IsLayerMode");
                }
                catch (com.sun.star.uno.Exception exception) {
                    exception.printStackTrace(printWriter2);
                    throw new StatusException("Can't get property value.", exception);
                }
                printWriter2.println("Property \"IsLayerMode\" after import is " + bl);
                return bl == true;
            }
        });
        return testEnvironment;
    }
}

