/*
 * Decompiled with CFR 0.152.
 */
package mod._xmloff.Draw;

import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.style.XStyleFamiliesSupplier;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import ifc.xml.sax._XDocumentHandler;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.SOfficeFactory;

public class XMLStylesImporter
extends TestCase {
    XComponent xDrawDoc = null;

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        try {
            printWriter.println("creating a drawdocument");
            this.xDrawDoc = sOfficeFactory.createDrawDoc(null);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create document", exception);
        }
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("    disposing document ");
        this.xDrawDoc.dispose();
    }

    public synchronized TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) throws StatusException {
        XInterface xInterface = null;
        Object object = null;
        printWriter.println("creating a test environment");
        XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)testParameters.getMSF();
        try {
            object = xMultiServiceFactory.createInstance("com.sun.star.comp.Draw.XMLStylesImporter");
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Can't create component.", exception);
        }
        xInterface = (XInterface)object;
        printWriter.println("creating a new environment for Paragraph object");
        TestEnvironment testEnvironment = new TestEnvironment(xInterface);
        testEnvironment.addObjRelation("TargetDocument", this.xDrawDoc);
        String[][] stringArrayArray = new String[][]{{"start", "office:document-styles", "xmlns:office", "CDATA", "http://openoffice.org/2000/office", "xmlns:style", "CDATA", "http://openoffice.org/2000/style"}, {"start", "office:styles"}, {"start", "style:style", "style:name", "CDATA", "New style for test XMLStylesImporter", "style:family", "CDATA", "graphics"}, {"end", "style:style"}, {"end", "office:styles"}, {"end", "office:document"}};
        testEnvironment.addObjRelation("XDocumentHandler.XMLData", stringArrayArray);
        final PrintWriter printWriter2 = printWriter;
        XStyleFamiliesSupplier xStyleFamiliesSupplier = (XStyleFamiliesSupplier)UnoRuntime.queryInterface(XStyleFamiliesSupplier.class, (Object)this.xDrawDoc);
        final XNameAccess xNameAccess = xStyleFamiliesSupplier.getStyleFamilies();
        testEnvironment.addObjRelation("XDocumentHandler.ImportChecker", new _XDocumentHandler.ImportChecker(){

            public boolean checkImport() {
                try {
                    Object object = xNameAccess.getByName("graphics");
                    XNameContainer xNameContainer = (XNameContainer)UnoRuntime.queryInterface(XNameContainer.class, object);
                    boolean bl = xNameContainer.hasByName("New style for test XMLStylesImporter");
                    printWriter2.println("Does style with name 'New style for test XMLStylesImporter' exist? " + String.valueOf(bl));
                    return bl;
                }
                catch (com.sun.star.uno.Exception exception) {
                    printWriter2.println("Exception while checking import :");
                    exception.printStackTrace(printWriter2);
                    return false;
                }
            }
        });
        return testEnvironment;
    }
}

