/*
 * Decompiled with CFR 0.152.
 */
package mod._xmloff.Draw;

import com.sun.star.beans.XPropertySet;
import com.sun.star.document.XDocumentInfoSupplier;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import ifc.xml.sax._XDocumentHandler;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.SOfficeFactory;

public class XMLMetaImporter
extends TestCase {
    XComponent xDrawDoc = null;

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        try {
            printWriter.println("creating a drawdocument");
            this.xDrawDoc = sOfficeFactory.createDrawDoc(null);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create document", exception);
        }
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("    disposing document ");
        this.xDrawDoc.dispose();
    }

    public synchronized TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) {
        XInterface xInterface = null;
        Object object = null;
        printWriter.println("creating a test environment");
        XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)testParameters.getMSF();
        try {
            object = xMultiServiceFactory.createInstance("com.sun.star.comp.Draw.XMLMetaImporter");
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Can't create component.", exception);
        }
        xInterface = (XInterface)object;
        printWriter.println("creating a new environment for Paragraph object");
        TestEnvironment testEnvironment = new TestEnvironment(xInterface);
        testEnvironment.addObjRelation("TargetDocument", this.xDrawDoc);
        String[][] stringArrayArray = new String[][]{{"start", "office:document-meta", "xmlns:office", "CDATA", "http://openoffice.org/2000/office", "xmlns:meta", "CDATA", "http://openoffice.org/2000/meta", "xmlns:dc", "CDATA", "http://purl.org/dc/elements/1.1/"}, {"start", "office:meta"}, {"start", "dc:title"}, {"chars", "XMLMetaImporter"}, {"end", "dc:title"}, {"end", "office:meta"}, {"end", "office:document-meta"}};
        testEnvironment.addObjRelation("XDocumentHandler.XMLData", stringArrayArray);
        XDocumentInfoSupplier xDocumentInfoSupplier = (XDocumentInfoSupplier)UnoRuntime.queryInterface(XDocumentInfoSupplier.class, (Object)this.xDrawDoc);
        final XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xDocumentInfoSupplier.getDocumentInfo());
        final PrintWriter printWriter2 = printWriter;
        testEnvironment.addObjRelation("XDocumentHandler.ImportChecker", new _XDocumentHandler.ImportChecker(){

            public boolean checkImport() {
                try {
                    String string = (String)xPropertySet.getPropertyValue("Title");
                    printWriter2.println("Title returned = '" + string + "'");
                    return "XMLMetaImporter".equals(string);
                }
                catch (com.sun.star.uno.Exception exception) {
                    printWriter2.println("Exception occured while checking filter :");
                    exception.printStackTrace(printWriter2);
                    return false;
                }
            }
        });
        return testEnvironment;
    }
}

