/*
 * Decompiled with CFR 0.152.
 */
package mod._toolkit;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleAction;
import com.sun.star.accessibility.XAccessibleComponent;
import com.sun.star.accessibility.XAccessibleSelection;
import com.sun.star.awt.XExtendedToolkit;
import com.sun.star.awt.XTopWindow;
import com.sun.star.awt.XWindow;
import com.sun.star.frame.XController;
import com.sun.star.frame.XDispatch;
import com.sun.star.frame.XDispatchProvider;
import com.sun.star.frame.XModel;
import com.sun.star.lang.DisposedException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.URL;
import com.sun.star.util.XURLTransformer;
import ifc.accessibility._XAccessibleEventBroadcaster;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.AccessibilityTools;
import util.DesktopTools;
import util.SOfficeFactory;
import util.utils;

public class AccessibleComboBox
extends TestCase {
    private static XTextDocument xTextDoc = null;
    private static XAccessibleAction action = null;

    protected TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) {
        XInterface xInterface = null;
        try {
            xInterface = (XInterface)((XMultiServiceFactory)testParameters.getMSF()).createInstance("com.sun.star.awt.Toolkit");
        }
        catch (Exception exception) {
            printWriter.println("Couldn't get toolkit");
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't get toolkit", exception);
        }
        XExtendedToolkit xExtendedToolkit = (XExtendedToolkit)UnoRuntime.queryInterface(XExtendedToolkit.class, (Object)xInterface);
        DiagThread diagThread = new DiagThread(xTextDoc, (XMultiServiceFactory)testParameters.getMSF());
        diagThread.start();
        utils.shortWait(testParameters.getInt("ShortWait"));
        AccessibilityTools accessibilityTools = new AccessibilityTools();
        utils.shortWait(testParameters.getInt("ShortWait"));
        XTopWindow xTopWindow = xExtendedToolkit.getActiveTopWindow();
        XWindow xWindow = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)xTopWindow);
        XAccessible xAccessible = AccessibilityTools.getAccessibleObject(xWindow);
        xInterface = AccessibilityTools.getAccessibleObjectForRole(xAccessible, (short)44, "Cancel");
        action = (XAccessibleAction)UnoRuntime.queryInterface(XAccessibleAction.class, (Object)xInterface);
        xInterface = AccessibilityTools.getAccessibleObjectForRole(xAccessible, (short)39);
        XAccessibleSelection xAccessibleSelection = (XAccessibleSelection)UnoRuntime.queryInterface(XAccessibleSelection.class, (Object)xInterface);
        try {
            xAccessibleSelection.selectAccessibleChild(0);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            indexOutOfBoundsException.printStackTrace(printWriter);
        }
        utils.shortWait(testParameters.getInt("ShortWait"));
        AccessibilityTools.printAccessibleTree(printWriter, xAccessible, testParameters.getBool("DebugIsActive"));
        xInterface = AccessibilityTools.getAccessibleObjectForRole(xAccessible, (short)40, "", "AccessibleComboBox");
        printWriter.println("ImplementationName " + utils.getImplName(xInterface));
        TestEnvironment testEnvironment = new TestEnvironment(xInterface);
        final XAccessibleComponent xAccessibleComponent = (XAccessibleComponent)UnoRuntime.queryInterface(XAccessibleComponent.class, (Object)xInterface);
        final XAccessibleComponent xAccessibleComponent2 = (XAccessibleComponent)UnoRuntime.queryInterface(XAccessibleComponent.class, (Object)action);
        testEnvironment.addObjRelation("EventProducer", new _XAccessibleEventBroadcaster.EventProducer(){

            public void fireEvent() {
                xAccessibleComponent2.grabFocus();
                xAccessibleComponent.grabFocus();
            }
        });
        return testEnvironment;
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("    closing dialog ");
        try {
            action.doAccessibleAction(0);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            printWriter.println("Couldn't close dialog");
        }
        catch (DisposedException disposedException) {
            printWriter.println("Dialog already disposed");
        }
        DesktopTools.closeDoc(xTextDoc);
    }

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        try {
            SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
            xTextDoc = sOfficeFactory.createTextDoc(null);
        }
        catch (Exception exception) {
            throw new StatusException("Can't create document", exception);
        }
    }

    public class DiagThread
    extends Thread {
        public XTextDocument xTextDoc = null;
        public XMultiServiceFactory msf = null;

        public DiagThread(XTextDocument xTextDocument, XMultiServiceFactory xMultiServiceFactory) {
            this.xTextDoc = xTextDocument;
            this.msf = xMultiServiceFactory;
        }

        public void run() {
            XModel xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)this.xTextDoc);
            XController xController = xModel.getCurrentController();
            try {
                String string = ".uno:FontDialog";
                XDispatchProvider xDispatchProvider = (XDispatchProvider)UnoRuntime.queryInterface(XDispatchProvider.class, (Object)xController);
                XURLTransformer xURLTransformer = (XURLTransformer)UnoRuntime.queryInterface(XURLTransformer.class, this.msf.createInstance("com.sun.star.util.URLTransformer"));
                URL[] uRLArray = new URL[]{new URL()};
                uRLArray[0].Complete = string;
                xURLTransformer.parseStrict(uRLArray);
                URL uRL = uRLArray[0];
                XDispatch xDispatch = xDispatchProvider.queryDispatch(uRL, "", 0);
                if (xDispatch != null) {
                    xDispatch.dispatch(uRL, null);
                }
            }
            catch (Exception exception) {
                AccessibleComboBox.this.log.println("Couldn't open dialog");
            }
        }
    }
}

