/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XIndexAccess;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XText;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextTable;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;

public class SwXTextTableRow
extends TestCase {
    XTextDocument xTextDoc;

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        try {
            printWriter.println("creating a textdocument");
            this.xTextDoc = sOfficeFactory.createTextDoc(null);
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create document", exception);
        }
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("    disposing xTextDoc ");
        DesktopTools.closeDoc(this.xTextDoc);
    }

    protected synchronized TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) {
        Object object;
        XPropertySet xPropertySet = null;
        XTextTable xTextTable = null;
        printWriter.println("Creating a test environment");
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        try {
            printWriter.println("creating a texttable");
            xTextTable = SOfficeFactory.createTextTable(this.xTextDoc, 5, 5);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
        }
        XText xText = this.xTextDoc.getText();
        XTextCursor xTextCursor = xText.createTextCursor();
        try {
            printWriter.println("inserting texttable");
            xText.insertTextContent(xTextCursor, xTextTable, false);
        }
        catch (Exception exception) {
            printWriter.println("Exception!");
        }
        try {
            printWriter.println("getting table row");
            object = xTextTable.getRows();
            XIndexAccess xIndexAccess = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, object);
            xPropertySet = (XPropertySet)AnyConverter.toObject((Type)new Type(XPropertySet.class), (Object)xIndexAccess.getByIndex(1));
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
        }
        printWriter.println("creating a new environment for TextTableRow object");
        object = new TestEnvironment(xPropertySet);
        printWriter.println("adding TextDocument as mod relation to environment");
        ((TestEnvironment)object).addObjRelation("TEXTDOC", this.xTextDoc);
        return object;
    }
}

