/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.container.XNameAccess;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XBookmarksSupplier;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;

public class SwXBookmarks
extends TestCase {
    XTextDocument xTextDoc;
    SOfficeFactory SOF;

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        this.SOF = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        try {
            printWriter.println("creating a textdocument");
            this.xTextDoc = this.SOF.createTextDoc(null);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create document", exception);
        }
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("    disposing xTextDoc ");
        DesktopTools.closeDoc(this.xTextDoc);
    }

    public synchronized TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) throws StatusException {
        XInterface xInterface = null;
        printWriter.println("creating a test environment");
        try {
            xInterface = SOfficeFactory.createBookmark(this.xTextDoc);
            SOfficeFactory.insertTextContent(this.xTextDoc, xInterface);
            xInterface = SOfficeFactory.createBookmark(this.xTextDoc);
            SOfficeFactory.insertTextContent(this.xTextDoc, xInterface);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create Bookmark", exception);
        }
        XBookmarksSupplier xBookmarksSupplier = (XBookmarksSupplier)UnoRuntime.queryInterface(XBookmarksSupplier.class, (Object)this.xTextDoc);
        XNameAccess xNameAccess = xBookmarksSupplier.getBookmarks();
        xInterface = xNameAccess;
        printWriter.println("creating a new environment for Bookmarks object");
        TestEnvironment testEnvironment = new TestEnvironment(xInterface);
        return testEnvironment;
    }
}

