/*
 * Decompiled with CFR 0.152.
 */
package mod._sc;

import com.sun.star.container.XIndexAccess;
import com.sun.star.document.XExporter;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.sheet.XSpreadsheets;
import com.sun.star.table.XCell;
import com.sun.star.uno.Any;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.xml.sax.XDocumentHandler;
import ifc.document._XFilter;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.CalcTools;
import util.DesktopTools;
import util.SOfficeFactory;
import util.XMLTools;

public class XMLContentExporter
extends TestCase {
    static XComponent xSheetDoc;
    static ContentFilterChecker Filter;

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        try {
            printWriter.println("creating a calc document");
            xSheetDoc = sOfficeFactory.openDoc("scalc", "_blank");
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create document", exception);
        }
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("    disposing xCalcDoc ");
        DesktopTools.closeDoc(xSheetDoc);
    }

    protected synchronized TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) {
        Object object;
        XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)testParameters.getMSF();
        XInterface xInterface = null;
        ContentFilterChecker contentFilterChecker = new ContentFilterChecker(printWriter);
        Any any = new Any(new Type(XDocumentHandler.class), (Object)contentFilterChecker);
        try {
            xInterface = (XInterface)xMultiServiceFactory.createInstanceWithArguments("com.sun.star.comp.Calc.XMLContentExporter", new Object[]{any});
            object = (XExporter)UnoRuntime.queryInterface(XExporter.class, (Object)xInterface);
            object.setSourceDocument(xSheetDoc);
            XSpreadsheetDocument xSpreadsheetDocument = (XSpreadsheetDocument)UnoRuntime.queryInterface(XSpreadsheetDocument.class, (Object)xSheetDoc);
            XSpreadsheets xSpreadsheets = xSpreadsheetDocument.getSheets();
            XIndexAccess xIndexAccess = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)xSpreadsheets);
            XSpreadsheet xSpreadsheet = (XSpreadsheet)AnyConverter.toObject((Type)new Type(XSpreadsheet.class), (Object)xIndexAccess.getByIndex(0));
            XCell xCell = xSpreadsheet.getCellByPosition(0, 0);
            xCell.setFormula("XMLContentExporter");
            printWriter.println("fill sheet 1 with contnet...");
            CalcTools.fillCalcSheetWithContent(xSheetDoc, 1, 1, 1, 5, 5);
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Can't create component.", exception);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Can't create environment.", exception);
        }
        contentFilterChecker.addTag("office:document-content");
        contentFilterChecker.addTagEnclosed("office:body", "office:document-content");
        contentFilterChecker.addTagEnclosed("office:script", "office:document-content");
        contentFilterChecker.addTagEnclosed("table:table", "office:body");
        contentFilterChecker.addTagEnclosed("table:table-column", "table:table");
        contentFilterChecker.addTagEnclosed("table:table-row", "table:table");
        contentFilterChecker.addTagEnclosed("table:table-cell", "table:table-row");
        contentFilterChecker.addTagEnclosed("text:p", "table:table-cell");
        contentFilterChecker.addCharactersEnclosed("XMLContentExporter", "text:p");
        printWriter.println("creating a new environment");
        object = new TestEnvironment(xInterface);
        ((TestEnvironment)object).addObjRelation("MediaDescriptor", XMLTools.createMediaDescriptor(new String[]{"FilterName"}, new Object[]{"scalc: StarOffice XML (Calc)"}));
        ((TestEnvironment)object).addObjRelation("SourceDocument", xSheetDoc);
        ((TestEnvironment)object).addObjRelation("XFilter.Checker", contentFilterChecker);
        return object;
    }

    protected class ContentFilterChecker
    extends XMLTools.XMLTagsChecker
    implements _XFilter.FilterChecker {
        public ContentFilterChecker(PrintWriter printWriter) {
            super(printWriter);
        }

        public boolean checkFilter() {
            return this.checkTags();
        }
    }
}

