/*
 * Decompiled with CFR 0.152.
 */
package mod._sc;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleAction;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleText;
import com.sun.star.awt.XExtendedToolkit;
import com.sun.star.awt.XWindow;
import com.sun.star.beans.PropertyValue;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.AccessibilityTools;
import util.SOfficeFactory;
import util.utils;

public class ScAccessibleCsvRuler
extends TestCase {
    Thread lThread = null;
    static XAccessibleAction accAction = null;

    protected TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) {
        XInterface xInterface = null;
        this.shortWait();
        XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)testParameters.getMSF();
        try {
            xInterface = (XInterface)xMultiServiceFactory.createInstance("com.sun.star.awt.Toolkit");
        }
        catch (Exception exception) {
            printWriter.println("Couldn't get toolkit");
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't get toolkit", exception);
        }
        XExtendedToolkit xExtendedToolkit = (XExtendedToolkit)UnoRuntime.queryInterface(XExtendedToolkit.class, (Object)xInterface);
        XWindow xWindow = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)xExtendedToolkit.getActiveTopWindow());
        XAccessible xAccessible = AccessibilityTools.getAccessibleObject(xWindow);
        xInterface = AccessibilityTools.getAccessibleObjectForRole(xAccessible, (short)44, "Cancel");
        accAction = (XAccessibleAction)UnoRuntime.queryInterface(XAccessibleAction.class, (Object)xInterface);
        XAccessibleContext xAccessibleContext = AccessibilityTools.getAccessibleObjectForRole(xAccessible, (short)46);
        printWriter.println("Click on: " + xAccessibleContext.getAccessibleName());
        XAccessibleAction xAccessibleAction = (XAccessibleAction)UnoRuntime.queryInterface(XAccessibleAction.class, (Object)xAccessibleContext);
        try {
            xAccessibleAction.doAccessibleAction(0);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        AccessibilityTools.printAccessibleTree(printWriter, xAccessible);
        xInterface = AccessibilityTools.getAccessibleObjectForRole(xAccessible, (short)60, "Ruler", true);
        printWriter.println("ImplementationName " + utils.getImplName(xInterface));
        TestEnvironment testEnvironment = new TestEnvironment(xInterface);
        testEnvironment.addObjRelation("EditOnly", "This method isn't supported in this dialog");
        XAccessibleText xAccessibleText = (XAccessibleText)UnoRuntime.queryInterface(XAccessibleText.class, (Object)xInterface);
        int n = 100;
        for (int i = 0; i < 1000; ++i) {
            try {
                xAccessibleText.getCharacterBounds(i);
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                n = i - 1;
                break;
            }
        }
        testEnvironment.addObjRelation("LimitedBounds", new Integer(n));
        testEnvironment.addObjRelation("PreviousUsed", new int[]{11, 22, 33, 44, 55, 66, 77, 88, 99});
        return testEnvironment;
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
    }

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        printWriter.println("opening dialog");
        PropertyValue[] propertyValueArray = new PropertyValue[1];
        try {
            propertyValueArray[0] = new PropertyValue();
            propertyValueArray[0].Name = "InteractionHandler";
            propertyValueArray[0].Value = ((XMultiServiceFactory)testParameters.getMSF()).createInstance("com.sun.star.comp.uui.UUIInteractionHandler");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.lThread = new loadThread(sOfficeFactory, propertyValueArray);
        this.lThread.start();
        this.shortWait();
    }

    private void shortWait() {
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            this.log.println("While waiting :" + interruptedException);
        }
    }

    public class loadThread
    extends Thread {
        private SOfficeFactory SOF = null;
        private PropertyValue[] args = null;
        public XComponent xSpreadSheedDoc = null;

        public loadThread(SOfficeFactory sOfficeFactory, PropertyValue[] propertyValueArray) {
            this.SOF = sOfficeFactory;
            this.args = propertyValueArray;
        }

        public void run() {
            try {
                String string = utils.getFullTestURL("10test.csv");
                ScAccessibleCsvRuler.this.log.println("loading " + string);
                this.SOF.loadDocument(string, this.args);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new StatusException("Couldn't create document ", exception);
            }
        }
    }
}

