/*
 * Decompiled with CFR 0.152.
 */
package mod._fwl;

import com.sun.star.beans.NamedValue;
import com.sun.star.beans.Property;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.beans.XPropertySetInfo;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import java.util.HashSet;
import lib.Status;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.utils;

public class PathSettings
extends TestCase {
    private static NamedValue[] m_Properties;
    private static XPropertySet xPS;

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("restore old values of path settings...");
        for (int i = 0; i < m_Properties.length; ++i) {
            try {
                xPS.setPropertyValue(PathSettings.m_Properties[i].Name, PathSettings.m_Properties[i].Value);
                continue;
            }
            catch (UnknownPropertyException unknownPropertyException) {
                continue;
            }
            catch (PropertyVetoException propertyVetoException) {
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
            catch (WrappedTargetException wrappedTargetException) {
                // empty catch block
            }
        }
    }

    protected TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) {
        XInterface xInterface = null;
        Object object = null;
        try {
            object = ((XMultiServiceFactory)testParameters.getMSF()).createInstance("com.sun.star.comp.framework.PathSettings");
        }
        catch (Exception exception) {
            printWriter.println("Couldn't get service");
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't get GridControl", exception);
        }
        if (object == null) {
            printWriter.println("Service wasn't created");
            throw new StatusException(Status.failed("Service wasn't created"));
        }
        xInterface = (XInterface)object;
        printWriter.println("ImplName: " + utils.getImplName(xInterface));
        printWriter.println("creating a new environment for object");
        TestEnvironment testEnvironment = new TestEnvironment(xInterface);
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("UIConfig");
        testEnvironment.addObjRelation("XFastPropertySet.ExcludeProps", hashSet);
        testEnvironment.addObjRelation("XMultiPropertySet.ExcludeProps", hashSet);
        this.saveAllPropertyValues(xInterface);
        return testEnvironment;
    }

    private void saveAllPropertyValues(XInterface xInterface) {
        xPS = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xInterface);
        XPropertySetInfo xPropertySetInfo = xPS.getPropertySetInfo();
        Property[] propertyArray = xPropertySetInfo.getProperties();
        m_Properties = new NamedValue[propertyArray.length];
        for (int i = 0; i < propertyArray.length; ++i) {
            try {
                PathSettings.m_Properties[i] = new NamedValue(propertyArray[i].Name, xPS.getPropertyValue(propertyArray[i].Name));
                continue;
            }
            catch (UnknownPropertyException unknownPropertyException) {
                continue;
            }
            catch (WrappedTargetException wrappedTargetException) {
                // empty catch block
            }
        }
    }
}

