/*
 * Decompiled with CFR 0.152.
 */
package mod._basctl;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.awt.Rectangle;
import com.sun.star.awt.XExtendedToolkit;
import com.sun.star.awt.XWindow;
import com.sun.star.beans.PropertyValue;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XDispatchHelper;
import com.sun.star.frame.XDispatchProvider;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XModel;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import ifc.accessibility._XAccessibleEventBroadcaster;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.AccessibilityTools;
import util.DesktopTools;
import util.WriterTools;
import util.utils;

public class AccessibleShape
extends TestCase {
    XTextDocument xTextDoc = null;
    XInterface oObj = null;
    XWindow basicIDE = null;

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("Cleaning up");
        DesktopTools.closeDoc(this.xTextDoc);
        try {
            XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)testParameters.getMSF();
            Object object = xMultiServiceFactory.createInstance("com.sun.star.frame.Desktop");
            XDesktop xDesktop = (XDesktop)UnoRuntime.queryInterface(XDesktop.class, object);
            DesktopTools.closeDoc(xDesktop.getCurrentFrame());
        }
        catch (Exception exception) {
            printWriter.println("Couldn't close IDE");
        }
    }

    protected TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) {
        Object object;
        Object object2;
        Object object3;
        XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)testParameters.getMSF();
        printWriter.println("creating a test environment");
        String string = utils.getFullTestURL("basDialog.odt");
        this.xTextDoc = WriterTools.loadTextDoc(xMultiServiceFactory, string);
        XModel xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)this.xTextDoc);
        XFrame xFrame = xModel.getCurrentController().getFrame();
        XDispatchProvider xDispatchProvider = (XDispatchProvider)UnoRuntime.queryInterface(XDispatchProvider.class, (Object)xFrame);
        printWriter.println("opening the basic dialog editor");
        try {
            object3 = xMultiServiceFactory.createInstance("com.sun.star.frame.DispatchHelper");
            object2 = (XDispatchHelper)UnoRuntime.queryInterface(XDispatchHelper.class, object3);
            object = new PropertyValue[4];
            object[0] = new PropertyValue();
            object[0].Name = "Document";
            object[0].Value = string;
            object[1] = new PropertyValue();
            object[1].Name = "LibName";
            object[1].Value = "basctl";
            object[2] = new PropertyValue();
            object[2].Name = "Name";
            object[2].Value = "Dialog1";
            object[3] = new PropertyValue();
            object[3].Name = "Type";
            object[3].Value = "Dialog";
            object2.executeDispatch(xDispatchProvider, ".uno:BasicIDEAppear", "", 0, (PropertyValue[])object);
        }
        catch (Exception exception) {
            throw new StatusException("Couldn't open Basic Dialog", exception);
        }
        utils.shortWait(3000);
        try {
            this.oObj = (XInterface)((XMultiServiceFactory)testParameters.getMSF()).createInstance("com.sun.star.awt.Toolkit");
        }
        catch (com.sun.star.uno.Exception exception) {
            printWriter.println("Couldn't get toolkit");
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't get toolkit", exception);
        }
        object3 = (XExtendedToolkit)UnoRuntime.queryInterface(XExtendedToolkit.class, (Object)this.oObj);
        object2 = new AccessibilityTools();
        this.basicIDE = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)object3.getActiveTopWindow());
        object = AccessibilityTools.getAccessibleObject(this.basicIDE);
        AccessibilityTools.printAccessibleTree(printWriter, (XAccessible)object, testParameters.getBool("DebugIsActive"));
        this.oObj = AccessibilityTools.getAccessibleObjectForRole((XAccessible)object, (short)52);
        TestEnvironment testEnvironment = new TestEnvironment(this.oObj);
        printWriter.println("Implementation Name: " + utils.getImplName(this.oObj));
        testEnvironment.addObjRelation("Destroy", Boolean.TRUE);
        Object object4 = object3;
        testEnvironment.addObjRelation("EventProducer", new _XAccessibleEventBroadcaster.EventProducer((XExtendedToolkit)object4){
            final /* synthetic */ XExtendedToolkit val$subtk;
            {
                this.val$subtk = xExtendedToolkit;
            }

            public void fireEvent() {
                XWindow xWindow = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)this.val$subtk.getActiveTopWindow());
                Rectangle rectangle = xWindow.getPosSize();
                Rectangle rectangle2 = new Rectangle();
                rectangle2.Width = rectangle.Width / 2;
                rectangle2.Height = rectangle.Height / 2;
                rectangle2.X = rectangle.X + 20;
                rectangle2.Y = rectangle.Y + 20;
                xWindow.setPosSize(rectangle2.X, rectangle2.Y, rectangle2.Width, rectangle2.Height, (short)15);
                utils.shortWait(1000);
                xWindow.setPosSize(rectangle.X, rectangle.Y, rectangle.Width, rectangle.Height, (short)15);
            }
        });
        return testEnvironment;
    }
}

