/*
 * Decompiled with CFR 0.152.
 */
package ifc.registry;

import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.registry.InvalidRegistryException;
import com.sun.star.registry.MergeConflictException;
import com.sun.star.registry.XRegistryKey;
import com.sun.star.registry.XSimpleRegistry;
import com.sun.star.uno.Exception;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;
import util.RegistryTools;

public class _XSimpleRegistry
extends MultiMethodTest {
    public XSimpleRegistry oObj = null;
    protected String nr = null;
    protected boolean configuration = false;
    protected String openF = null;
    protected String destroyF = null;
    protected String mergeF = null;

    protected void before() {
        if (this.tEnv.getObjRelation("configuration") != null) {
            this.configuration = true;
        }
        this.nr = (String)this.tEnv.getObjRelation("NR");
        this.openF = (String)this.tEnv.getObjRelation("XSimpleRegistry.open");
        if (this.openF == null) {
            throw new StatusException(Status.failed("Relation 'XSimpleRegistry.open' not found"));
        }
        this.destroyF = (String)this.tEnv.getObjRelation("XSimpleRegistry.destroy");
        if (this.destroyF == null) {
            throw new StatusException(Status.failed("Relation 'XSimpleRegistry.destroy' not found"));
        }
        this.mergeF = (String)this.tEnv.getObjRelation("XSimpleRegistry.merge");
        if (this.mergeF == null) {
            throw new StatusException(Status.failed("Relation 'XSimpleRegistry.merge' not found"));
        }
    }

    public void _open() {
        if (this.nr != null) {
            this.log.println("'open()' isn't supported by '" + this.nr + "'");
            this.tRes.tested("open()", true);
            return;
        }
        this.log.println("Trying to open registry :" + this.openF);
        try {
            this.oObj.open(this.openF, false, true);
            this.oObj.close();
        }
        catch (InvalidRegistryException invalidRegistryException) {
            invalidRegistryException.printStackTrace(this.log);
            this.tRes.tested("open()", false);
            return;
        }
        this.tRes.tested("open()", true);
    }

    public void _isReadOnly() {
        boolean bl = false;
        try {
            this.openReg(this.oObj, this.openF, false, true);
            bl = !this.oObj.isReadOnly();
            this.closeReg(this.oObj);
        }
        catch (InvalidRegistryException invalidRegistryException) {
            invalidRegistryException.printStackTrace(this.log);
            bl = false;
        }
        this.tRes.tested("isReadOnly()", bl);
    }

    public void _getRootKey() {
        boolean bl = false;
        try {
            this.openReg(this.oObj, this.openF, false, true);
            XRegistryKey xRegistryKey = this.oObj.getRootKey();
            bl = xRegistryKey != null;
            this.closeReg(this.oObj);
        }
        catch (InvalidRegistryException invalidRegistryException) {
            invalidRegistryException.printStackTrace(this.log);
            bl = false;
        }
        this.tRes.tested("getRootKey()", bl);
    }

    public void _mergeKey() {
        if (this.configuration) {
            this.log.println("You can't merge into this registry. It's just a wrapper for a configuration node, which has a fixed structure which can not be modified");
            this.tRes.tested("mergeKey()", true);
            return;
        }
        if (this.nr != null) {
            this.log.println("'mergeKey()' isn't supported by '" + this.nr + "'");
            this.tRes.tested("mergeKey()", true);
            return;
        }
        this.openReg(this.oObj, this.openF, false, true);
        try {
            RegistryTools.printRegistryInfo(this.oObj.getRootKey(), this.log);
            this.oObj.mergeKey("MergeKey", this.mergeF);
            RegistryTools.printRegistryInfo(this.oObj.getRootKey(), this.log);
        }
        catch (MergeConflictException mergeConflictException) {
            mergeConflictException.printStackTrace(this.log);
            this.tRes.tested("mergeKey()", false);
            return;
        }
        catch (InvalidRegistryException invalidRegistryException) {
            invalidRegistryException.printStackTrace(this.log);
            this.tRes.tested("mergeKey()", false);
            return;
        }
        boolean bl = false;
        XSimpleRegistry xSimpleRegistry = null;
        try {
            xSimpleRegistry = RegistryTools.createRegistryService((XMultiServiceFactory)this.tParam.getMSF());
        }
        catch (Exception exception) {
            this.log.print("Can't create registry service: ");
            exception.printStackTrace(this.log);
            this.tRes.tested("mergeKey()", false);
            return;
        }
        this.openReg(xSimpleRegistry, this.mergeF, false, true);
        try {
            XRegistryKey xRegistryKey = this.oObj.getRootKey().openKey("MergeKey");
            XRegistryKey xRegistryKey2 = xSimpleRegistry.getRootKey();
            bl = RegistryTools.compareKeyTrees(xRegistryKey, xRegistryKey2);
        }
        catch (InvalidRegistryException invalidRegistryException) {
            this.log.print("Can't get root key: ");
            invalidRegistryException.printStackTrace(this.log);
            this.tRes.tested("mergeKey()", false);
            return;
        }
        this.closeReg(xSimpleRegistry);
        this.closeReg(this.oObj);
        this.tRes.tested("mergeKey()", bl);
    }

    public void _getURL() {
        this.openReg(this.oObj, this.openF, false, true);
        String string = this.oObj.getURL();
        this.closeReg(this.oObj);
        this.log.println("Getting URL: " + string + ";");
        this.tRes.tested("getURL()", string != null);
    }

    public void _close() {
        if (this.nr != null) {
            this.log.println("'close()' isn't supported by '" + this.nr + "'");
            this.tRes.tested("close()", true);
            return;
        }
        try {
            this.oObj.open(this.openF, false, true);
            this.oObj.close();
        }
        catch (InvalidRegistryException invalidRegistryException) {
            invalidRegistryException.printStackTrace(this.log);
            this.tRes.tested("close()", false);
            return;
        }
        this.tRes.tested("close()", !this.oObj.isValid());
    }

    public void _destroy() {
        if (this.configuration) {
            this.log.println("This registry is a wrapper for a configuration access. It can not be destroyed.");
            this.tRes.tested("destroy()", true);
            return;
        }
        if (this.nr != null) {
            this.log.println("'destroy()' isn't supported by '" + this.nr + "'");
            this.tRes.tested("destroy()", true);
            return;
        }
        try {
            this.oObj.open(this.destroyF, false, true);
            this.oObj.destroy();
        }
        catch (InvalidRegistryException invalidRegistryException) {
            invalidRegistryException.printStackTrace(this.log);
            this.tRes.tested("destroy()", false);
            return;
        }
        this.tRes.tested("destroy()", !this.oObj.isValid());
    }

    public void _isValid() {
        boolean bl = true;
        this.openReg(this.oObj, this.openF, false, true);
        bl = this.oObj.isValid();
        this.closeReg(this.oObj);
        this.tRes.tested("isValid()", bl);
    }

    public void openReg(XSimpleRegistry xSimpleRegistry, String string, boolean bl, boolean bl2) {
        if (this.nr == null) {
            try {
                xSimpleRegistry.open(string, bl, bl2);
            }
            catch (InvalidRegistryException invalidRegistryException) {
                this.log.print("Couldn't open registry:");
                invalidRegistryException.printStackTrace(this.log);
            }
        }
    }

    public void closeReg(XSimpleRegistry xSimpleRegistry) {
        if (this.nr == null) {
            try {
                xSimpleRegistry.close();
            }
            catch (InvalidRegistryException invalidRegistryException) {
                this.log.print("Couldn't close registry:");
                invalidRegistryException.printStackTrace(this.log);
            }
        }
    }
}

