/*
 * Decompiled with CFR 0.152.
 */
package ifc.io;

import com.sun.star.io.BufferSizeExceededException;
import com.sun.star.io.IOException;
import com.sun.star.io.NotConnectedException;
import com.sun.star.io.XInputStream;
import com.sun.star.io.XOutputStream;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import lib.MultiMethodTest;
import lib.Status;

public class _XInputStream
extends MultiMethodTest {
    public XInputStream oObj = null;
    public XOutputStream oStream = null;
    byte[] bytes = null;
    int bytesReady = 0;

    public void before() {
        XInterface xInterface = (XInterface)this.tEnv.getObjRelation("StreamWriter");
        this.oStream = (XOutputStream)UnoRuntime.queryInterface(XOutputStream.class, (Object)xInterface);
        this.bytes = (byte[])this.tEnv.getObjRelation("ByteData");
        try {
            this.oStream.writeBytes(this.bytes);
        }
        catch (NotConnectedException notConnectedException) {
        }
        catch (BufferSizeExceededException bufferSizeExceededException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void after() {
        try {
            this.oStream.flush();
            this.oStream.closeOutput();
        }
        catch (NotConnectedException notConnectedException) {
        }
        catch (BufferSizeExceededException bufferSizeExceededException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.disposeEnvironment();
    }

    public void _available() {
        boolean bl = true;
        try {
            this.bytesReady = this.oObj.available();
            this.log.println("Bytes available :" + this.bytesReady);
        }
        catch (IOException iOException) {
            iOException.printStackTrace(this.log);
            bl = false;
        }
        this.tRes.tested("available()", bl);
    }

    public void _readBytes() {
        this.requiredMethod("available()");
        if (this.bytesReady-- > 0) {
            boolean bl;
            try {
                byte[][] byArray = new byte[1][1];
                int n = this.oObj.readBytes(byArray, 1);
                bl = n == 1 && byArray != null && byArray.length == 1;
            }
            catch (IOException iOException) {
                iOException.printStackTrace(this.log);
                bl = false;
            }
            this.tRes.tested("readBytes()", bl);
        } else {
            this.log.println("No more bytes available in the stream");
            this.tRes.tested("readBytes()", Status.skipped(false));
        }
    }

    public void _readSomeBytes() {
        this.requiredMethod("available()");
        if (this.bytesReady-- > 0) {
            boolean bl;
            try {
                byte[][] byArray = new byte[1][1];
                int n = this.oObj.readSomeBytes(byArray, 1);
                bl = n == 1 && byArray != null && byArray.length == 1;
            }
            catch (IOException iOException) {
                iOException.printStackTrace(this.log);
                bl = false;
            }
            this.tRes.tested("readSomeBytes()", bl);
        } else {
            this.log.println("No more bytes available in the stream");
            this.tRes.tested("readBytes()", Status.skipped(false));
        }
    }

    public void _skipBytes() {
        this.requiredMethod("available()");
        if (this.bytesReady-- > 0) {
            boolean bl;
            try {
                this.oObj.skipBytes(1);
                bl = true;
            }
            catch (IOException iOException) {
                iOException.printStackTrace(this.log);
                bl = false;
            }
            this.tRes.tested("skipBytes()", bl);
        } else {
            this.log.println("No more bytes available in the stream");
            this.tRes.tested("readBytes()", Status.skipped(false));
        }
    }

    public void _closeInput() {
        this.executeMethod("available()");
        this.executeMethod("readBytes()");
        this.executeMethod("readSomeBytes()");
        this.executeMethod("skipBytes()");
        boolean bl = true;
        try {
            this.oObj.closeInput();
        }
        catch (IOException iOException) {
            iOException.printStackTrace(this.log);
            bl = false;
        }
        this.tRes.tested("closeInput()", bl);
        this.disposeEnvironment();
    }
}

