/*
 * Decompiled with CFR 0.152.
 */
package ifc.i18n;

import com.sun.star.i18n.Calendar;
import com.sun.star.i18n.Currency;
import com.sun.star.i18n.ForbiddenCharacters;
import com.sun.star.i18n.FormatElement;
import com.sun.star.i18n.Implementation;
import com.sun.star.i18n.LanguageCountryInfo;
import com.sun.star.i18n.LocaleDataItem;
import com.sun.star.i18n.XLocaleData;
import com.sun.star.lang.Locale;
import lib.MultiMethodTest;

public class _XLocaleData
extends MultiMethodTest {
    public XLocaleData oObj = null;
    public String[] languages = new String[]{"de", "en", "es", "fr", "ja", "ko", "ko"};
    public String[] countries = new String[]{"DE", "US", "ES", "FR", "JP", "KR", "KR"};

    public void _getLanguageCountryInfo() {
        boolean bl = true;
        LanguageCountryInfo languageCountryInfo = null;
        for (int i = 0; i < 7; ++i) {
            languageCountryInfo = this.oObj.getLanguageCountryInfo(this.getLocale(i));
            bl &= languageCountryInfo.Language.equals(this.languages[i]) && languageCountryInfo.Country.equals(this.countries[i]);
        }
        this.tRes.tested("getLanguageCountryInfo()", bl);
    }

    public void _getLocaleItem() {
        boolean bl = true;
        LocaleDataItem localeDataItem = null;
        for (int i = 0; i < 7; ++i) {
            localeDataItem = this.oObj.getLocaleItem(this.getLocale(i));
            boolean bl2 = true;
            bl2 &= !localeDataItem.dateSeparator.equals("");
            bl2 &= !localeDataItem.decimalSeparator.equals("");
            bl2 &= !localeDataItem.doubleQuotationEnd.equals("");
            bl2 &= !localeDataItem.doubleQuotationStart.equals("");
            bl2 &= !localeDataItem.listSeparator.equals("");
            bl2 &= !localeDataItem.LongDateDayOfWeekSeparator.equals("");
            bl2 &= !localeDataItem.LongDateDaySeparator.equals("");
            bl2 &= !localeDataItem.LongDateMonthSeparator.equals("");
            bl2 &= !localeDataItem.LongDateYearSeparator.equals("");
            bl2 &= !localeDataItem.measurementSystem.equals("");
            bl2 &= !localeDataItem.quotationEnd.equals("");
            bl2 &= !localeDataItem.quotationStart.equals("");
            bl2 &= !localeDataItem.thousandSeparator.equals("");
            bl2 &= !localeDataItem.time100SecSeparator.equals("");
            bl2 &= !localeDataItem.timeAM.equals("");
            bl2 &= !localeDataItem.timePM.equals("");
            bl2 &= !localeDataItem.timeSeparator.equals("");
            if (bl2 &= !localeDataItem.unoID.equals("")) continue;
        }
        this.tRes.tested("getLocaleItem()", bl);
    }

    public void _getAllCalendars() {
        boolean bl = true;
        boolean bl2 = false;
        Calendar[] calendarArray = new Calendar[1];
        for (int i = 0; i < 7; ++i) {
            calendarArray = this.oObj.getAllCalendars(this.getLocale(i));
            for (int j = 0; j < calendarArray.length; ++j) {
                if (!this.goodCalendar(calendarArray[j])) {
                    bl2 = true;
                }
                bl &= this.goodCalendar(calendarArray[j]);
            }
            if (bl2) {
                this.log.println("FAILED for: language=" + this.languages[i] + " ; country=" + this.countries[i]);
            }
            bl2 = false;
        }
        this.tRes.tested("getAllCalendars()", bl);
    }

    public void _getAllCurrencies() {
        boolean bl = true;
        boolean bl2 = false;
        Currency[] currencyArray = new Currency[1];
        for (int i = 0; i < 7; ++i) {
            currencyArray = this.oObj.getAllCurrencies(this.getLocale(i));
            for (int j = 0; j < currencyArray.length; ++j) {
                if (!this.goodCurrency(currencyArray[j])) {
                    bl2 = true;
                }
                bl &= this.goodCurrency(currencyArray[j]);
            }
            if (bl2) {
                this.log.println("FAILED for: language=" + this.languages[i] + " ; country=" + this.countries[i]);
            }
            bl2 = false;
        }
        this.tRes.tested("getAllCurrencies()", bl);
    }

    public void _getAllFormats() {
        boolean bl = true;
        boolean bl2 = false;
        FormatElement[] formatElementArray = new FormatElement[1];
        for (int i = 0; i < 7; ++i) {
            formatElementArray = this.oObj.getAllFormats(this.getLocale(i));
            for (int j = 0; j < formatElementArray.length; ++j) {
                if (!this.goodFormat(formatElementArray[j])) {
                    bl2 = true;
                }
                bl &= this.goodFormat(formatElementArray[j]);
            }
            if (bl2) {
                this.log.println("FAILED for: language=" + this.languages[i] + " ; country=" + this.countries[i]);
            }
            bl2 = false;
        }
        this.tRes.tested("getAllFormats()", bl);
    }

    public void _getCollatorImplementations() {
        boolean bl = true;
        boolean bl2 = false;
        Implementation[] implementationArray = new Implementation[1];
        for (int i = 0; i < 7; ++i) {
            implementationArray = this.oObj.getCollatorImplementations(this.getLocale(i));
            for (int j = 0; j < implementationArray.length; ++j) {
                if (implementationArray[j].unoID.equals("")) {
                    bl2 = true;
                }
                bl &= !implementationArray[j].unoID.equals("");
            }
            if (bl2) {
                this.log.println("FAILED for: language=" + this.languages[i] + " ; country=" + this.countries[i]);
            }
            bl2 = false;
        }
        this.tRes.tested("getCollatorImplementations()", bl);
    }

    public void _getSearchOptions() {
        boolean bl = true;
        boolean bl2 = false;
        String[] stringArray = new String[1];
        for (int i = 0; i < 7; ++i) {
            stringArray = this.oObj.getSearchOptions(this.getLocale(i));
            for (int j = 0; j < stringArray.length; ++j) {
                if (stringArray[j].equals("")) {
                    bl2 = true;
                }
                bl &= !stringArray.equals("");
            }
            if (bl2) {
                this.log.println("FAILED for: language=" + this.languages[i] + " ; country=" + this.countries[i]);
            }
            bl2 = false;
        }
        this.tRes.tested("getSearchOptions()", bl);
    }

    public void _getCollationOptions() {
        boolean bl = true;
        boolean bl2 = false;
        String[] stringArray = new String[1];
        for (int i = 0; i < 7; ++i) {
            stringArray = this.oObj.getCollationOptions(this.getLocale(i));
            for (int j = 0; j < stringArray.length; ++j) {
                if (stringArray[j].equals("")) {
                    bl2 = true;
                }
                bl &= !stringArray.equals("");
            }
            if (bl2) {
                this.log.println("FAILED for: language=" + this.languages[i] + " ; country=" + this.countries[i]);
            }
            bl2 = false;
        }
        this.tRes.tested("getCollationOptions()", bl);
    }

    public void _getTransliterations() {
        boolean bl = true;
        boolean bl2 = false;
        String[] stringArray = new String[1];
        for (int i = 0; i < 7; ++i) {
            stringArray = this.oObj.getTransliterations(this.getLocale(i));
            for (int j = 0; j < stringArray.length; ++j) {
                if (stringArray[j].equals("")) {
                    bl2 = true;
                }
                bl &= !stringArray.equals("");
            }
            if (bl2) {
                this.log.println("FAILED for: language=" + this.languages[i] + " ; country=" + this.countries[i]);
            }
            bl2 = false;
        }
        this.tRes.tested("getTransliterations()", bl);
    }

    public void _getForbiddenCharacters() {
        boolean bl = true;
        ForbiddenCharacters forbiddenCharacters = null;
        for (int i = 4; i < 7; ++i) {
            forbiddenCharacters = this.oObj.getForbiddenCharacters(this.getLocale(i));
            if (bl &= !forbiddenCharacters.beginLine.equals("") && !forbiddenCharacters.endLine.equals("")) continue;
            this.log.println("FAILED for: language=" + this.languages[i] + " ; country=" + this.countries[i]);
        }
        this.tRes.tested("getForbiddenCharacters()", bl);
    }

    public void _getReservedWord() {
        boolean bl = true;
        boolean bl2 = false;
        String[] stringArray = new String[1];
        for (int i = 0; i < 7; ++i) {
            stringArray = this.oObj.getReservedWord(this.getLocale(i));
            for (int j = 0; j < stringArray.length; ++j) {
                if (stringArray[j].equals("")) {
                    bl2 = true;
                }
                bl &= !stringArray.equals("");
            }
            if (bl2) {
                this.log.println("FAILED for: language=" + this.languages[i] + " ; country=" + this.countries[i]);
            }
            bl2 = false;
        }
        this.tRes.tested("getReservedWord()", bl);
    }

    public void _getAllInstalledLocaleNames() {
        boolean bl = true;
        Locale[] localeArray = this.oObj.getAllInstalledLocaleNames();
        for (int i = 0; i < 7; ++i) {
            bl &= this.contains(localeArray, this.getLocale(i));
        }
        this.tRes.tested("getAllInstalledLocaleNames()", bl);
    }

    public Locale getLocale(int n) {
        return new Locale(this.languages[n], this.countries[n], "");
    }

    public boolean goodCalendar(Calendar calendar) {
        int n;
        boolean bl = true;
        for (n = 0; n < calendar.Days.length; ++n) {
            bl &= !calendar.Days[n].AbbrevName.equals("");
            bl &= !calendar.Days[n].FullName.equals("");
            bl &= !calendar.Days[n].ID.equals("");
        }
        for (n = 0; n < calendar.Months.length; ++n) {
            bl &= !calendar.Months[n].AbbrevName.equals("");
            bl &= !calendar.Months[n].FullName.equals("");
            bl &= !calendar.Months[n].ID.equals("");
        }
        for (n = 0; n < calendar.Eras.length; ++n) {
            bl &= !calendar.Eras[n].AbbrevName.equals("");
            bl &= !calendar.Eras[n].FullName.equals("");
            bl &= !calendar.Eras[n].ID.equals("");
        }
        bl &= !calendar.StartOfWeek.equals("");
        return bl &= !calendar.Name.equals("");
    }

    public boolean goodCurrency(Currency currency) {
        boolean bl = true;
        bl &= !currency.BankSymbol.equals("");
        bl &= !currency.Name.equals("");
        return bl &= !currency.Symbol.equals("");
    }

    public boolean goodFormat(FormatElement formatElement) {
        boolean bl = true;
        bl &= !formatElement.formatCode.equals("");
        bl &= !formatElement.formatKey.equals("");
        bl &= !formatElement.formatType.equals("");
        return bl &= !formatElement.formatUsage.equals("");
    }

    public boolean contains(Locale[] localeArray, Locale locale) {
        boolean bl = false;
        for (int i = 0; i < localeArray.length; ++i) {
            if (!localeArray[i].Country.equals(locale.Country) || !localeArray[i].Language.equals(locale.Language)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.log.println("Not contained: " + locale.Language);
        }
        return bl;
    }
}

