/*
 * Decompiled with CFR 0.152.
 */
package helper;

import com.sun.star.io.BufferSizeExceededException;
import com.sun.star.io.IOException;
import com.sun.star.io.NotConnectedException;
import com.sun.star.io.XInputStream;
import com.sun.star.io.XOutputStream;
import com.sun.star.io.XSeekable;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.ucb.XSimpleFileAccess;
import com.sun.star.uno.Exception;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.UnoRuntime;
import lib.TestParameters;

public class StreamSimulator
implements XInputStream,
XOutputStream,
XSeekable {
    private String m_sFileName;
    private XInputStream m_xInStream;
    private XOutputStream m_xOutStream;
    private XSeekable m_xSeek;
    public boolean m_bInWasUsed;
    public boolean m_bOutWasUsed;

    public StreamSimulator(String string, boolean bl, TestParameters testParameters) throws NotConnectedException {
        this.m_sFileName = string;
        this.m_bInWasUsed = false;
        this.m_bOutWasUsed = false;
        try {
            XSimpleFileAccess xSimpleFileAccess = (XSimpleFileAccess)UnoRuntime.queryInterface(XSimpleFileAccess.class, ((XMultiServiceFactory)testParameters.getMSF()).createInstance("com.sun.star.ucb.SimpleFileAccess"));
            if (xSimpleFileAccess == null) {
                throw new NotConnectedException("ucb helper not available. Can't create streams.");
            }
            if (bl) {
                this.m_xInStream = xSimpleFileAccess.openFileRead(this.m_sFileName);
                this.m_xSeek = (XSeekable)UnoRuntime.queryInterface(XSeekable.class, (Object)this.m_xInStream);
            } else {
                this.m_xOutStream = xSimpleFileAccess.openFileWrite(this.m_sFileName);
                this.m_xSeek = (XSeekable)UnoRuntime.queryInterface(XSeekable.class, (Object)this.m_xOutStream);
            }
        }
        catch (Exception exception) {
            throw new NotConnectedException("Could not open the file.");
        }
    }

    public int readBytes(byte[][] byArray, int n) throws NotConnectedException, BufferSizeExceededException, IOException {
        this.m_bInWasUsed = true;
        if (this.m_xInStream == null) {
            throw new NotConnectedException("stream not open");
        }
        int n2 = 0;
        try {
            n2 = this.m_xInStream.readBytes(byArray, n);
        }
        catch (NotConnectedException notConnectedException) {
        }
        catch (BufferSizeExceededException bufferSizeExceededException) {
        }
        catch (IOException iOException) {
        }
        catch (RuntimeException runtimeException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n2;
    }

    public int readSomeBytes(byte[][] byArray, int n) throws NotConnectedException, BufferSizeExceededException, IOException {
        this.m_bInWasUsed = true;
        if (this.m_xInStream == null) {
            throw new NotConnectedException("stream not open");
        }
        int n2 = 0;
        try {
            n2 = this.m_xInStream.readSomeBytes(byArray, n);
        }
        catch (NotConnectedException notConnectedException) {
        }
        catch (BufferSizeExceededException bufferSizeExceededException) {
        }
        catch (IOException iOException) {
        }
        catch (RuntimeException runtimeException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n2;
    }

    public void skipBytes(int n) throws NotConnectedException, BufferSizeExceededException, IOException {
        this.m_bInWasUsed = true;
        if (this.m_xInStream == null) {
            throw new NotConnectedException("stream not open");
        }
        try {
            this.m_xInStream.skipBytes(n);
        }
        catch (NotConnectedException notConnectedException) {
        }
        catch (BufferSizeExceededException bufferSizeExceededException) {
        }
        catch (IOException iOException) {
        }
        catch (RuntimeException runtimeException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int available() throws NotConnectedException, IOException {
        this.m_bInWasUsed = true;
        if (this.m_xInStream == null) {
            throw new NotConnectedException("stream not open");
        }
        int n = 0;
        try {
            n = this.m_xInStream.available();
        }
        catch (NotConnectedException notConnectedException) {
        }
        catch (IOException iOException) {
        }
        catch (RuntimeException runtimeException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    public void closeInput() throws NotConnectedException, IOException {
        this.m_bInWasUsed = true;
        if (this.m_xInStream == null) {
            throw new NotConnectedException("stream not open");
        }
        try {
            this.m_xInStream.closeInput();
        }
        catch (NotConnectedException notConnectedException) {
        }
        catch (IOException iOException) {
        }
        catch (RuntimeException runtimeException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void writeBytes(byte[] byArray) throws NotConnectedException, BufferSizeExceededException, IOException {
        this.m_bOutWasUsed = true;
        if (this.m_xOutStream == null) {
            throw new NotConnectedException("stream not open");
        }
        try {
            this.m_xOutStream.writeBytes(byArray);
        }
        catch (NotConnectedException notConnectedException) {
        }
        catch (BufferSizeExceededException bufferSizeExceededException) {
        }
        catch (IOException iOException) {
        }
        catch (RuntimeException runtimeException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void flush() throws NotConnectedException, BufferSizeExceededException, IOException {
        this.m_bOutWasUsed = true;
        if (this.m_xOutStream == null) {
            throw new NotConnectedException("stream not open");
        }
        try {
            this.m_xOutStream.flush();
        }
        catch (NotConnectedException notConnectedException) {
        }
        catch (BufferSizeExceededException bufferSizeExceededException) {
        }
        catch (IOException iOException) {
        }
        catch (RuntimeException runtimeException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void closeOutput() throws NotConnectedException, BufferSizeExceededException, IOException {
        this.m_bOutWasUsed = true;
        if (this.m_xOutStream == null) {
            throw new NotConnectedException("stream not open");
        }
        try {
            this.m_xOutStream.closeOutput();
        }
        catch (NotConnectedException notConnectedException) {
        }
        catch (BufferSizeExceededException bufferSizeExceededException) {
        }
        catch (IOException iOException) {
        }
        catch (RuntimeException runtimeException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void seek(long l) throws IllegalArgumentException, IOException {
        if (this.m_xInStream != null) {
            this.m_bInWasUsed = true;
        } else if (this.m_xOutStream != null) {
            this.m_bOutWasUsed = true;
        } else if (this.m_xSeek == null) {
            throw new IOException("stream not seekable");
        }
        try {
            this.m_xSeek.seek(l);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IOException iOException) {
        }
        catch (RuntimeException runtimeException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public long getPosition() throws IOException {
        if (this.m_xInStream != null) {
            this.m_bInWasUsed = true;
        } else if (this.m_xOutStream != null) {
            this.m_bOutWasUsed = true;
        } else if (this.m_xSeek == null) {
            throw new IOException("stream not seekable");
        }
        long l = 0L;
        try {
            l = this.m_xSeek.getPosition();
        }
        catch (IOException iOException) {
        }
        catch (RuntimeException runtimeException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return l;
    }

    public long getLength() throws IOException {
        if (this.m_xInStream != null) {
            this.m_bInWasUsed = true;
        } else if (this.m_xOutStream != null) {
            this.m_bOutWasUsed = true;
        } else if (this.m_xSeek == null) {
            throw new IOException("stream not seekable");
        }
        long l = 0L;
        try {
            l = this.m_xSeek.getLength();
        }
        catch (IOException iOException) {
        }
        catch (RuntimeException runtimeException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return l;
    }
}

