/*
 * Decompiled with CFR 0.152.
 */
package helper;

import com.sun.star.bridge.XUnoUrlResolver;
import com.sun.star.comp.helper.Bootstrap;
import com.sun.star.connection.NoConnectException;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XEnumeration;
import com.sun.star.container.XEnumerationAccess;
import com.sun.star.frame.XDesktop;
import com.sun.star.lang.DisposedException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.XCloseable;
import com.sun.star.util.XStringSubstitution;
import helper.AppProvider;
import helper.FileTools;
import helper.OfficeWatcher;
import helper.ProcessHandler;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import lib.TestParameters;
import share.DescEntry;
import share.LogWriter;
import util.DynamicClassLoader;
import util.utils;

public class OfficeProvider
implements AppProvider {
    protected static boolean debug = false;

    public boolean disposeManager(TestParameters testParameters) {
        XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)testParameters.getMSF();
        if (xMultiServiceFactory == null) {
            return true;
        }
        XDesktop xDesktop = null;
        try {
            xDesktop = (XDesktop)UnoRuntime.queryInterface(XDesktop.class, xMultiServiceFactory.createInstance("com.sun.star.frame.Desktop"));
        }
        catch (com.sun.star.uno.Exception exception) {
            return false;
        }
        xMultiServiceFactory = null;
        if (xDesktop != null) {
            xDesktop.terminate();
            return true;
        }
        return false;
    }

    public Object getManager(TestParameters testParameters) {
        String string = null;
        boolean bl = false;
        debug = testParameters.getBool("DebugIsActive");
        String string2 = (String)testParameters.get("AdditionalConnectionArguments");
        string2 = string2 == null ? ";" : "," + string2 + ";";
        String string3 = "uno:" + testParameters.get("ConnectionString") + ";urp" + string2 + "StarOffice.ServiceManager";
        if (debug) {
            System.out.print("Connecting the Office with " + string3);
        }
        XMultiServiceFactory xMultiServiceFactory = this.connectOffice(string3);
        if (testParameters.getBool("AutoRestart") && xMultiServiceFactory != null) {
            OfficeProvider.makeAppExecCommand(xMultiServiceFactory, testParameters);
        }
        if (xMultiServiceFactory == null) {
            String string4 = "";
            Exception exception = null;
            boolean bl2 = false;
            boolean bl3 = string3.indexOf("host=localhost") > 0 || string3.indexOf("pipe,name=") > 0;
            if (bl3 &= !((String)testParameters.get("AppExecutionCommand")).equals("")) {
                String string5;
                OfficeWatcher officeWatcher;
                if (debug) {
                    System.out.println("Local Connection trying to start the Office");
                }
                if ((officeWatcher = (OfficeWatcher)testParameters.get("Watcher")) != null) {
                    officeWatcher.finish = true;
                }
                if ((string = utils.validateAppExecutionCommand(string5 = (String)testParameters.get("AppExecutionCommand"), (String)testParameters.get("OperatingSystem"))).startsWith("Error")) {
                    System.out.println(string);
                    return null;
                }
                bl = !string.equals("OK");
                DynamicClassLoader dynamicClassLoader = new DynamicClassLoader();
                LogWriter logWriter = (LogWriter)dynamicClassLoader.getInstance((String)testParameters.get("LogWriter"));
                DescEntry descEntry = new DescEntry();
                descEntry.entryName = "office";
                descEntry.longName = "office";
                descEntry.EntryType = "placebo";
                descEntry.isOptional = false;
                descEntry.isToTest = false;
                descEntry.SubEntryCount = 0;
                descEntry.hasErrorMsg = false;
                descEntry.State = "non possible";
                descEntry.UserDefinedParams = testParameters;
                logWriter.initialize(descEntry, debug);
                ProcessHandler processHandler = new ProcessHandler(string5, (PrintWriter)((Object)logWriter));
                bl2 = processHandler.executeAsynchronously();
                if (bl2) {
                    testParameters.put("AppProvider", processHandler);
                    OfficeWatcher officeWatcher2 = new OfficeWatcher(testParameters);
                    testParameters.put("Watcher", officeWatcher2);
                    officeWatcher2.start();
                    officeWatcher2.ping();
                }
                for (int i = 0; i < 21 && xMultiServiceFactory == null; ++i) {
                    try {
                        Thread.sleep(i * 1000);
                        xMultiServiceFactory = OfficeProvider.connect(string3);
                        continue;
                    }
                    catch (com.sun.star.uno.Exception exception2) {
                        exception = exception2;
                        string4 = exception2.getMessage();
                        continue;
                    }
                    catch (Exception exception3) {
                        exception = exception3;
                        string4 = exception3.getMessage();
                    }
                }
                if (xMultiServiceFactory == null) {
                    System.out.println("Exception while connecting.\n" + exception);
                    if (string4 != null) {
                        System.out.println(string4);
                    }
                    if (bl) {
                        System.out.println(string);
                    }
                } else if (bl2) {
                    try {
                        XStringSubstitution xStringSubstitution = OfficeProvider.createStringSubstitution(xMultiServiceFactory);
                        String string6 = xStringSubstitution.getSubstituteVariableValue("$(user)");
                        string6 = OfficeProvider.getDirSys(string6);
                        testParameters.put("userLayer", string6);
                        String string7 = utils.getUsersTempDir() + System.getProperty("file.separator") + "user_backup" + System.currentTimeMillis();
                        testParameters.put("copyLayer", string7);
                        FileTools.copyDirectory(new File(string6), new File(string7), new String[]{"temp"});
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        System.out.println("User Variable '$(user)' not defined.");
                    }
                    catch (IOException iOException) {
                        System.out.println("Couldn't backup user layer");
                        iOException.printStackTrace();
                    }
                }
            } else {
                System.out.println("Could not connect an Office and cannot start one.");
                if (bl) {
                    System.out.println(string);
                }
            }
        }
        return xMultiServiceFactory;
    }

    protected static XMultiServiceFactory connect(String string) throws com.sun.star.uno.Exception, RuntimeException, NoConnectException, Exception {
        XComponentContext xComponentContext = Bootstrap.createInitialComponentContext(null);
        XMultiComponentFactory xMultiComponentFactory = xComponentContext.getServiceManager();
        Object object = xMultiComponentFactory.createInstanceWithContext("com.sun.star.bridge.UnoUrlResolver", xComponentContext);
        XUnoUrlResolver xUnoUrlResolver = (XUnoUrlResolver)UnoRuntime.queryInterface(XUnoUrlResolver.class, object);
        Object object2 = xUnoUrlResolver.resolve(string);
        XMultiServiceFactory xMultiServiceFactory = null;
        if (object2 != null) {
            if (debug) {
                System.out.println("resolved url");
            }
            xMultiServiceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, object2);
        }
        return xMultiServiceFactory;
    }

    public boolean closeExistingOffice(TestParameters testParameters, boolean bl) {
        boolean bl2;
        debug = testParameters.getBool("DebugIsActive");
        XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)testParameters.getMSF();
        boolean bl3 = bl2 = xMultiServiceFactory != null;
        if (bl2) {
            ProcessHandler processHandler = (ProcessHandler)testParameters.get("AppProvider");
            if (processHandler != null) {
                this.disposeOffice(xMultiServiceFactory, testParameters);
                OfficeWatcher officeWatcher = (OfficeWatcher)testParameters.get("Watcher");
                if (officeWatcher != null && officeWatcher.isAlive()) {
                    officeWatcher.finish = true;
                }
                return true;
            }
            if (bl) {
                return this.disposeOffice(xMultiServiceFactory, testParameters);
            }
        } else {
            String string = "uno:" + testParameters.get("ConnectionString") + ";urp;StarOffice.ServiceManager";
            xMultiServiceFactory = this.connectOffice(string);
            if (bl) {
                return this.disposeOffice(xMultiServiceFactory, testParameters);
            }
        }
        return true;
    }

    private XMultiServiceFactory connectOffice(String string) {
        XMultiServiceFactory xMultiServiceFactory = null;
        String string2 = "";
        if (debug) {
            System.out.println("trying to connect to " + string);
        }
        try {
            xMultiServiceFactory = OfficeProvider.connect(string);
        }
        catch (com.sun.star.uno.Exception exception) {
            string2 = exception.getMessage();
        }
        catch (Exception exception) {
            string2 = exception.getMessage();
        }
        if (debug && string2 != null && string2.length() != 0) {
            if (string2 == null) {
                string2 = "";
            }
            System.out.println("Could not connect an Office. " + string2);
        }
        return xMultiServiceFactory;
    }

    private synchronized boolean disposeOffice(XMultiServiceFactory xMultiServiceFactory, TestParameters testParameters) {
        boolean bl;
        block17: {
            ProcessHandler processHandler;
            XDesktop xDesktop = null;
            bl = true;
            if (xMultiServiceFactory != null) {
                try {
                    xDesktop = (XDesktop)UnoRuntime.queryInterface(XDesktop.class, xMultiServiceFactory.createInstance("com.sun.star.frame.Desktop"));
                    xMultiServiceFactory = null;
                    if (xDesktop != null) {
                        boolean bl2 = this.closeAllWindows(xDesktop);
                        if (!bl2 && debug) {
                            System.out.println("Couldn't close all office windows!");
                        }
                        if (debug) {
                            System.out.println("Trying to terminate the desktop");
                        }
                        xDesktop.terminate();
                        if (debug) {
                            System.out.println("Desktop terminated");
                        }
                        try {
                            int n = testParameters.getInt("OfficeCloseTimeOut");
                            if (debug) {
                                System.out.println("the Office has " + n / 1000 + " seconds for closing...");
                            }
                            Thread.sleep(n);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                catch (com.sun.star.uno.Exception exception) {
                    bl = false;
                }
                catch (DisposedException disposedException) {
                    bl = false;
                }
            }
            if ((processHandler = (ProcessHandler)testParameters.get("AppProvider")) != null) {
                OfficeWatcher officeWatcher = (OfficeWatcher)testParameters.get("Watcher");
                if (officeWatcher != null && officeWatcher.isAlive()) {
                    officeWatcher.finish = true;
                }
                processHandler.kill();
            }
            testParameters.remove("AppProvider");
            testParameters.remove("ServiceFactory");
            try {
                String string = (String)testParameters.get("userLayer");
                String string2 = (String)testParameters.get("copyLayer");
                if (string != null && string2 != null) {
                    File file = new File(string2);
                    FileTools.copyDirectory(file, new File(string), new String[]{"temp"});
                    FileTools.deleteDir(file);
                } else {
                    System.out.println("Cannot copy layer: " + string2 + " back to user layer: " + string);
                }
            }
            catch (IOException iOException) {
                if (!debug) break block17;
                System.out.println("Couldn't recover from backup");
                iOException.printStackTrace();
            }
        }
        return bl;
    }

    protected boolean closeAllWindows(XDesktop xDesktop) {
        XEnumerationAccess xEnumerationAccess = xDesktop.getComponents();
        XEnumeration xEnumeration = xEnumerationAccess.createEnumeration();
        boolean bl = true;
        try {
            while (xEnumeration.hasMoreElements()) {
                XCloseable xCloseable = (XCloseable)UnoRuntime.queryInterface(XCloseable.class, xEnumeration.nextElement());
                if (xCloseable == null) continue;
                xCloseable.close(true);
            }
        }
        catch (CloseVetoException closeVetoException) {
            bl = false;
        }
        catch (NoSuchElementException noSuchElementException) {
            bl = false;
        }
        catch (WrappedTargetException wrappedTargetException) {
            bl = false;
        }
        return bl;
    }

    public static XStringSubstitution createStringSubstitution(XMultiServiceFactory xMultiServiceFactory) {
        Object object = null;
        try {
            object = xMultiServiceFactory.createInstance("com.sun.star.util.PathSubstitution");
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace();
        }
        if (object != null) {
            return (XStringSubstitution)UnoRuntime.queryInterface(XStringSubstitution.class, object);
        }
        return null;
    }

    public static String getDirSys(String string) {
        String string2;
        String string3 = "";
        int n = string.indexOf("file://");
        int n2 = string.indexOf("file:///");
        string3 = n < 0 ? string : string.substring("file://".length());
        if ((string3 = utils.replaceAll13(string3, "%20", " ")).charAt(string3.length() - 1) != '/') {
            string3 = string3 + "/";
        }
        if ((string2 = System.getProperty("file.separator")).equalsIgnoreCase("\\")) {
            string3 = n2 >= 0 ? string3.substring(1) : "//" + string3;
            string3 = string3.replace('/', '\\');
        }
        return string3;
    }

    private static void makeAppExecCommand(XMultiServiceFactory xMultiServiceFactory, TestParameters testParameters) {
        boolean bl = testParameters.getBool("DebugIsActive");
        String string = (String)testParameters.get("AppExecutionCommand");
        String string2 = (String)testParameters.get("ConnectionString");
        String string3 = "";
        try {
            string3 = utils.getSystemURL(utils.expandMacro(xMultiServiceFactory, "$SYSBINDIR"));
        }
        catch (Exception exception) {
            if (bl) {
                System.out.println("could not get system binary directory");
            }
            return;
        }
        if (string.indexOf(string3) == -1) {
            string = string3 + System.getProperty("file.separator") + "soffice" + " -norestore -accept=" + string2 + ";urp;";
        }
        if (bl) {
            System.out.println("update AppExecutionCommand: " + string);
        }
        Object object = testParameters.put("AppExecutionCommand", string);
    }
}

