/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.text;

import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNamed;
import com.sun.star.frame.XFrame;
import com.sun.star.lang.Locale;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.style.BreakType;
import com.sun.star.table.XCellRange;
import com.sun.star.text.XSimpleText;
import com.sun.star.text.XText;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextRange;
import com.sun.star.text.XTextTable;
import com.sun.star.text.XTextTablesSupplier;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.XNumberFormatsSupplier;
import com.sun.star.view.XSelectionSupplier;
import com.sun.star.wizards.common.Desktop;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.NumberFormatter;

public class TextTableHandler {
    public XTextTablesSupplier xTextTablesSupplier;
    public XMultiServiceFactory xMSFDoc;
    public XTextDocument xTextDocument;
    public XSimpleText xSimpleText;
    private XText xText;
    private NumberFormatter oNumberFormatter;
    private Locale aCharLocale;

    public TextTableHandler(XMultiServiceFactory xMultiServiceFactory, XTextDocument xTextDocument) {
        try {
            this.xMSFDoc = xMultiServiceFactory;
            this.xTextDocument = xTextDocument;
            this.xText = xTextDocument.getText();
            this.xTextTablesSupplier = (XTextTablesSupplier)UnoRuntime.queryInterface(XTextTablesSupplier.class, (Object)xTextDocument);
            this.xSimpleText = (XSimpleText)UnoRuntime.queryInterface(XSimpleText.class, (Object)xTextDocument.getText());
            XNumberFormatsSupplier xNumberFormatsSupplier = (XNumberFormatsSupplier)UnoRuntime.queryInterface(XNumberFormatsSupplier.class, (Object)xTextDocument);
            this.aCharLocale = (Locale)Helper.getUnoStructValue(xTextDocument, "CharLocale");
            this.oNumberFormatter = new NumberFormatter(xNumberFormatsSupplier, this.aCharLocale);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public NumberFormatter getNumberFormatter() {
        return this.oNumberFormatter;
    }

    public XTextTable getlastTextTable() {
        try {
            XIndexAccess xIndexAccess = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)this.xTextTablesSupplier.getTextTables());
            int n = xIndexAccess.getCount() - 1;
            Object object = xIndexAccess.getByIndex(n);
            XTextTable xTextTable = (XTextTable)UnoRuntime.queryInterface(XTextTable.class, (Object)object);
            return xTextTable;
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(System.out);
            return null;
        }
    }

    public void insertTextTable(XTextCursor xTextCursor) {
        try {
            XInterface xInterface = (XInterface)this.xMSFDoc.createInstance("com.sun.star.text.TextTable");
            XTextContent xTextContent = (XTextContent)UnoRuntime.queryInterface(XTextContent.class, (Object)xInterface);
            if (xTextCursor == null) {
                xTextCursor = this.xTextDocument.getText().createTextCursor();
                xTextCursor.gotoEnd(false);
            }
            xTextCursor.getText().insertTextContent((XTextRange)xTextCursor, xTextContent, false);
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public void removeAllTextTables() {
        try {
            XIndexAccess xIndexAccess = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)this.xTextTablesSupplier.getTextTables());
            int n = xIndexAccess.getCount();
            for (int i = n - 1; i >= 0; --i) {
                this.removeTextTable(xIndexAccess.getByIndex(i));
            }
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public void removeLastTextTable() {
        try {
            XIndexAccess xIndexAccess = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)this.xTextTablesSupplier.getTextTables());
            Object object = xIndexAccess.getByIndex(xIndexAccess.getCount() - 1);
            this.removeTextTable(object);
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public void removeTextTable(Object object) {
        try {
            XTextContent xTextContent = (XTextContent)UnoRuntime.queryInterface(XTextContent.class, (Object)object);
            this.xTextDocument.getText().removeTextContent(xTextContent);
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public void removeTextTablebyName(String string) {
        try {
            XNameAccess xNameAccess = this.xTextTablesSupplier.getTextTables();
            if (xNameAccess.hasByName(string)) {
                this.removeTextTable(xNameAccess.getByName(string));
            }
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public void renameTextTable(String string, String string2) {
        try {
            XNameAccess xNameAccess = this.xTextTablesSupplier.getTextTables();
            if (xNameAccess.hasByName(string)) {
                Object object = xNameAccess.getByName(string);
                XNamed xNamed = (XNamed)UnoRuntime.queryInterface(XNamed.class, (Object)object);
                xNamed.setName(string2);
            }
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public static BreakType resetBreakTypeofTextTable(Object object) {
        Object var1_1 = null;
        BreakType breakType = (BreakType)Helper.getUnoStructValue(object, "BreakType");
        Helper.setUnoPropertyValue(object, "BreakType", BreakType.NONE);
        return BreakType.NONE;
    }

    public void adjustOptimalTableWidths(XMultiServiceFactory xMultiServiceFactory, XTextTable xTextTable) {
        try {
            XFrame xFrame = this.xTextDocument.getCurrentController().getFrame();
            int n = xTextTable.getColumns().getCount();
            XCellRange xCellRange = (XCellRange)UnoRuntime.queryInterface(XCellRange.class, (Object)xTextTable);
            XCellRange xCellRange2 = xCellRange.getCellRangeByPosition(0, 0, n - 1, 1);
            short s = AnyConverter.toShort((Object)Helper.getUnoPropertyValue(xTextTable, "HoriOrient"));
            XSelectionSupplier xSelectionSupplier = (XSelectionSupplier)UnoRuntime.queryInterface(XSelectionSupplier.class, (Object)this.xTextDocument.getCurrentController());
            xSelectionSupplier.select((Object)xCellRange2);
            Desktop.dispatchURL(xMultiServiceFactory, ".Uno:DistributeColumns", xFrame);
            Desktop.dispatchURL(xMultiServiceFactory, ".Uno:SetOptimalColumnWidth", xFrame);
            Helper.setUnoPropertyValue(xTextTable, "HoriOrient", new Short(s));
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(System.out);
        }
    }
}

