/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.index.RowIterator;
import org.hsqldb.lib.DoubleIntIndex;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.StopWatch;
import org.hsqldb.lib.Storage;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.ScaledRAFile;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputBinary;

final class DataFileDefrag {
    BufferedOutputStream fileStreamOut;
    long fileOffset;
    StopWatch stopw = new StopWatch();
    String filename;
    int[][] rootsList;
    Database database;
    DataFileCache cache;
    int scale;
    DoubleIntIndex transactionRowLookup;

    DataFileDefrag(Database database, DataFileCache dataFileCache, String string) {
        this.database = database;
        this.cache = dataFileCache;
        this.scale = dataFileCache.cacheFileScale;
        this.filename = string;
    }

    void process() throws HsqlException, IOException {
        boolean bl = false;
        Trace.printSystemOut("Defrag Transfer begins");
        this.transactionRowLookup = this.database.txManager.getTransactionIDList();
        HsqlArrayList hsqlArrayList = this.database.schemaManager.getAllTables();
        this.rootsList = new int[hsqlArrayList.size()][];
        Storage storage = null;
        try {
            Object object;
            int n;
            OutputStream outputStream = this.database.getFileAccess().openOutputStreamElement(this.filename + ".new");
            this.fileStreamOut = new BufferedOutputStream(outputStream, 4096);
            for (n = 0; n < 32; ++n) {
                this.fileStreamOut.write(0);
            }
            this.fileOffset = 32L;
            int n2 = hsqlArrayList.size();
            for (n = 0; n < n2; ++n) {
                object = (Table)hsqlArrayList.get(n);
                if (((Table)object).getTableType() == 4) {
                    int[] nArray = this.writeTableToDataFile((Table)object);
                    this.rootsList[n] = nArray;
                } else {
                    this.rootsList[n] = null;
                }
                Trace.printSystemOut(((Table)object).getName().name + " complete");
            }
            this.writeTransactionRows();
            this.fileStreamOut.close();
            this.fileStreamOut = null;
            storage = ScaledRAFile.newScaledRAFile(this.filename + ".new", false, 0, this.database.getURLProperties().getProperty("storage_class_name"), this.database.getURLProperties().getProperty("storage_key"));
            storage.seek(12L);
            storage.writeLong(this.fileOffset);
            storage.close();
            storage = null;
            n2 = this.rootsList.length;
            for (n = 0; n < n2; ++n) {
                object = this.rootsList[n];
                if (object == null) continue;
                Trace.printSystemOut(StringUtil.getList((int[])object, ",", ""));
            }
            bl = true;
        }
        catch (IOException iOException) {
            throw Trace.error(29, this.filename + ".new");
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw Trace.error(72);
        }
        finally {
            if (this.fileStreamOut != null) {
                this.fileStreamOut.close();
            }
            if (storage != null) {
                storage.close();
            }
            if (!bl) {
                this.database.getFileAccess().removeElement(this.filename + ".new");
            }
        }
    }

    void updateTableIndexRoots() throws HsqlException {
        HsqlArrayList hsqlArrayList = this.database.schemaManager.getAllTables();
        int n = hsqlArrayList.size();
        for (int i = 0; i < n; ++i) {
            Table table = (Table)hsqlArrayList.get(i);
            if (table.getTableType() != 4) continue;
            int[] nArray = this.rootsList[i];
            table.setIndexRoots(nArray);
        }
    }

    void updateTransactionRowIDs() throws HsqlException {
        this.database.txManager.convertTransactionIDs(this.transactionRowLookup);
    }

    int[] writeTableToDataFile(Table table) throws IOException, HsqlException {
        Row row;
        Session session = this.database.getSessionManager().getSysSession();
        RowOutputBinary rowOutputBinary = new RowOutputBinary();
        DoubleIntIndex doubleIntIndex = new DoubleIntIndex(table.getPrimaryIndex().sizeEstimate(), false);
        int[] nArray = table.getIndexRootsArray();
        long l = this.fileOffset;
        int n = 0;
        doubleIntIndex.setKeysSearchTarget();
        Trace.printSystemOut("lookup begins: " + this.stopw.elapsedTime());
        RowIterator rowIterator = table.rowIterator(session);
        while (rowIterator.hasNext()) {
            row = rowIterator.next();
            doubleIntIndex.addUnsorted(row.getPos(), (int)(l / (long)this.scale));
            if (n % 50000 == 0) {
                Trace.printSystemOut("pointer pair for row " + n + " " + row.getPos() + " " + l);
            }
            l += (long)row.getStorageSize();
            ++n;
        }
        Trace.printSystemOut(table.getName().name + " list done ", this.stopw.elapsedTime());
        n = 0;
        rowIterator = table.rowIterator(session);
        while (rowIterator.hasNext()) {
            row = rowIterator.next();
            rowOutputBinary.reset();
            row.write(rowOutputBinary, doubleIntIndex);
            this.fileStreamOut.write(rowOutputBinary.getOutputStream().getBuffer(), 0, rowOutputBinary.size());
            this.fileOffset += (long)row.getStorageSize();
            if (n % 50000 == 0) {
                Trace.printSystemOut(n + " rows " + this.stopw.elapsedTime());
            }
            ++n;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == -1) continue;
            int n2 = doubleIntIndex.findFirstEqualKeyIndex(nArray[i]);
            if (n2 == -1) {
                throw Trace.error(129);
            }
            nArray[i] = doubleIntIndex.getValue(n2);
        }
        this.setTransactionRowLookups(doubleIntIndex);
        Trace.printSystemOut(table.getName().name + " : table converted");
        return nArray;
    }

    void setTransactionRowLookups(DoubleIntIndex doubleIntIndex) {
        int n = this.transactionRowLookup.size();
        for (int i = 0; i < n; ++i) {
            int n2 = this.transactionRowLookup.getKey(i);
            int n3 = doubleIntIndex.findFirstEqualKeyIndex(n2);
            if (n3 == -1) continue;
            this.transactionRowLookup.setValue(i, doubleIntIndex.getValue(n3));
        }
    }

    void writeTransactionRows() {
        int n = this.transactionRowLookup.size();
        for (int i = 0; i < n; ++i) {
            if (this.transactionRowLookup.getValue(i) != 0) continue;
            int n2 = this.transactionRowLookup.getKey(i);
            try {
                this.transactionRowLookup.setValue(i, (int)(this.fileOffset / (long)this.scale));
                RowInputInterface rowInputInterface = this.cache.readObject(n2);
                this.fileStreamOut.write(rowInputInterface.getBuffer(), 0, rowInputInterface.getSize());
                this.fileOffset += (long)rowInputInterface.getSize();
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

