/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.sun.star.beans.PropertyValue;
import com.sun.star.document.XExporter;
import com.sun.star.document.XFilter;
import com.sun.star.document.XImporter;
import com.sun.star.io.XActiveDataSource;
import com.sun.star.io.XInputStream;
import com.sun.star.io.XOutputStream;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.ucb.XSimpleFileAccess;
import com.sun.star.uno.Any;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.xml.sax.InputSource;
import com.sun.star.xml.sax.XAttributeList;
import com.sun.star.xml.sax.XDocumentHandler;
import com.sun.star.xml.sax.XLocator;
import com.sun.star.xml.sax.XParser;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;

public class XMLTools {
    public static Object[] getDocumentHandler(XMultiServiceFactory xMultiServiceFactory) {
        Object[] objectArray = new Object[1];
        try {
            XInterface xInterface = (XInterface)xMultiServiceFactory.createInstance("com.sun.star.xml.sax.Writer");
            XInterface xInterface2 = (XInterface)xMultiServiceFactory.createInstance("com.sun.star.io.Pipe");
            XOutputStream xOutputStream = (XOutputStream)UnoRuntime.queryInterface(XOutputStream.class, (Object)xInterface2);
            XActiveDataSource xActiveDataSource = (XActiveDataSource)UnoRuntime.queryInterface(XActiveDataSource.class, (Object)xInterface);
            xActiveDataSource.setOutputStream(xOutputStream);
            XDocumentHandler xDocumentHandler = (XDocumentHandler)UnoRuntime.queryInterface(XDocumentHandler.class, (Object)xInterface);
            Any any = new Any(new Type(XDocumentHandler.class), (Object)xDocumentHandler);
            objectArray[0] = any;
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace();
        }
        return objectArray;
    }

    public static PropertyValue[] createMediaDescriptor(String[] stringArray, Object[] objectArray) {
        PropertyValue[] propertyValueArray = new PropertyValue[stringArray.length];
        for (int i = 0; i < propertyValueArray.length; ++i) {
            propertyValueArray[i] = new PropertyValue();
            propertyValueArray[i].Name = stringArray[i];
            if (objectArray == null || i >= objectArray.length) continue;
            propertyValueArray[i].Value = objectArray[i];
        }
        return propertyValueArray;
    }

    public static XDocumentHandler getFileXMLWriter(XMultiServiceFactory xMultiServiceFactory, String string) throws com.sun.star.uno.Exception {
        XInterface xInterface = (XInterface)xMultiServiceFactory.createInstance("com.sun.star.comp.ucb.SimpleFileAccess");
        XSimpleFileAccess xSimpleFileAccess = (XSimpleFileAccess)UnoRuntime.queryInterface(XSimpleFileAccess.class, (Object)xInterface);
        XInterface xInterface2 = (XInterface)xMultiServiceFactory.createInstance("com.sun.star.xml.sax.Writer");
        XActiveDataSource xActiveDataSource = (XActiveDataSource)UnoRuntime.queryInterface(XActiveDataSource.class, (Object)xInterface2);
        XDocumentHandler xDocumentHandler = (XDocumentHandler)UnoRuntime.queryInterface(XDocumentHandler.class, (Object)xInterface2);
        if (xSimpleFileAccess.exists(string)) {
            xSimpleFileAccess.kill(string);
        }
        XOutputStream xOutputStream = xSimpleFileAccess.openFileWrite(string);
        xActiveDataSource.setOutputStream(xOutputStream);
        return xDocumentHandler;
    }

    public static void parseXMLFile(XMultiServiceFactory xMultiServiceFactory, String string, XDocumentHandler xDocumentHandler) throws com.sun.star.uno.Exception {
        XInterface xInterface = (XInterface)xMultiServiceFactory.createInstance("com.sun.star.comp.ucb.SimpleFileAccess");
        XSimpleFileAccess xSimpleFileAccess = (XSimpleFileAccess)UnoRuntime.queryInterface(XSimpleFileAccess.class, (Object)xInterface);
        XInputStream xInputStream = xSimpleFileAccess.openFileRead(string);
        XInterface xInterface2 = (XInterface)xMultiServiceFactory.createInstance("com.sun.star.xml.sax.Parser");
        XParser xParser = (XParser)UnoRuntime.queryInterface(XParser.class, (Object)xInterface2);
        xParser.setDocumentHandler(xDocumentHandler);
        InputSource inputSource = new InputSource();
        inputSource.aInputStream = xInputStream;
        xParser.parseStream(inputSource);
        xInputStream.closeInput();
    }

    public static void exportDocument(XMultiServiceFactory xMultiServiceFactory, XComponent xComponent, String string, String string2, String string3) throws com.sun.star.uno.Exception {
        XDocumentHandler xDocumentHandler = XMLTools.getFileXMLWriter(xMultiServiceFactory, string3);
        Any any = new Any(new Type(XDocumentHandler.class), (Object)xDocumentHandler);
        XInterface xInterface = (XInterface)xMultiServiceFactory.createInstanceWithArguments("com.sun.star.comp." + string + ".XML" + string2 + "Exporter", new Object[]{any});
        XExporter xExporter = (XExporter)UnoRuntime.queryInterface(XExporter.class, (Object)xInterface);
        xExporter.setSourceDocument(xComponent);
        XFilter xFilter = (XFilter)UnoRuntime.queryInterface(XFilter.class, (Object)xInterface);
        xFilter.filter(XMLTools.createMediaDescriptor(new String[]{"FilterName"}, new Object[]{"Custom filter"}));
    }

    public static void importDocument(XMultiServiceFactory xMultiServiceFactory, XComponent xComponent, String string, String string2, String string3) throws com.sun.star.uno.Exception {
        XInterface xInterface = (XInterface)xMultiServiceFactory.createInstance("com.sun.star.comp." + string + ".XML" + string2 + "Importer");
        XImporter xImporter = (XImporter)UnoRuntime.queryInterface(XImporter.class, (Object)xInterface);
        XDocumentHandler xDocumentHandler = (XDocumentHandler)UnoRuntime.queryInterface(XDocumentHandler.class, (Object)xInterface);
        xImporter.setTargetDocument(xComponent);
        XMLTools.parseXMLFile(xMultiServiceFactory, string3, xDocumentHandler);
    }

    public static class XMLChecker
    extends XMLWellFormChecker {
        protected HashSet tagSet = new HashSet();
        protected Vector tags = new Vector();
        protected Vector chars = new Vector();
        protected Vector tagStack = new Vector();
        protected Vector attrStack = new Vector();

        public XMLChecker(PrintWriter printWriter, boolean bl) {
            super(printWriter, bl);
        }

        public void addTag(Tag tag) {
            this.tags.add(new Tag[]{tag, null});
            this.tagSet.add(tag.name);
        }

        public void addTagEnclosed(Tag tag, Tag tag2) {
            this.tags.add(new Tag[]{tag, tag2});
            this.tagSet.add(tag.name);
        }

        public void addCharacters(String string) {
            this.chars.add(new Object[]{string.trim(), null});
        }

        public void addCharactersEnclosed(String string, Tag tag) {
            this.chars.add(new Object[]{string.trim(), tag});
        }

        public void startElement(String string, XAttributeList xAttributeList) {
            try {
                super.startElement(string, xAttributeList);
                if (this.tagSet.contains(string)) {
                    for (int i = 0; i < this.tags.size(); ++i) {
                        Tag[] tagArray = (Tag[])this.tags.elementAt(i);
                        if (!tagArray[0].isMatchTo(string, xAttributeList)) continue;
                        if (tagArray[1] == null) {
                            this.tags.remove(i--);
                            continue;
                        }
                        boolean bl = false;
                        for (int j = 0; j < this.tagStack.size(); ++j) {
                            if (!tagArray[1].isMatchTo((String)this.tagStack.elementAt(j), (XAttributeList)this.attrStack.elementAt(j))) continue;
                            bl = true;
                            break;
                        }
                        if (!bl) continue;
                        this.tags.remove(i--);
                    }
                }
                this.tagStack.add(0, string);
                this.attrStack.add(0, new AttributeList(xAttributeList));
            }
            catch (Exception exception) {
                exception.printStackTrace(this.log);
            }
        }

        public void characters(String string) {
            super.characters(string);
            for (int i = 0; i < this.chars.size(); ++i) {
                Object[] objectArray = (Object[])this.chars.elementAt(i);
                if (!((String)objectArray[0]).equals(string)) continue;
                if (objectArray[1] == null) {
                    this.chars.remove(i--);
                    continue;
                }
                boolean bl = false;
                for (int j = 0; j < this.tagStack.size(); ++j) {
                    if (!((Tag)objectArray[1]).isMatchTo((String)this.tagStack.elementAt(j), (XAttributeList)this.attrStack.elementAt(j))) continue;
                    bl = true;
                    break;
                }
                if (!bl) continue;
                this.chars.remove(i--);
            }
        }

        public void endElement(String string) {
            try {
                super.endElement(string);
                if (this.tagStack.size() > 0) {
                    this.tagStack.remove(0);
                    this.attrStack.remove(0);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(this.log);
            }
        }

        public boolean check() {
            Object[] objectArray;
            int n;
            if (this.tags.size() > 0) {
                this.log.println("!!! Error: Some tags were not found :");
                for (n = 0; n < this.tags.size(); ++n) {
                    objectArray = (Tag[])this.tags.elementAt(n);
                    this.log.println("   Tag " + objectArray[0] + " was not found");
                    if (objectArray[1] == null) continue;
                    this.log.println("      inside tag " + objectArray[1]);
                }
            }
            if (this.chars.size() > 0) {
                this.log.println("!!! Error: Some character data blocks were not found :");
                for (n = 0; n < this.chars.size(); ++n) {
                    objectArray = (Object[])this.chars.elementAt(n);
                    this.log.println("   Character data \"" + objectArray[0] + "\" was not found ");
                    if (objectArray[1] == null) continue;
                    this.log.println("      inside tag " + objectArray[1]);
                }
            }
            if (!this.isWellFormed()) {
                this.log.println("!!! Some errors were found in XML structure");
            }
            n = this.tags.size() == 0 && this.chars.size() == 0 && this.isWellFormed() ? 1 : 0;
            this.reset();
            return n != 0;
        }
    }

    public static class Tag {
        private String name = null;
        private String[][] attrList = new String[0][3];

        public Tag(String string) {
            this.name = string;
        }

        public Tag(String string, String string2) {
            this.name = string;
            this.attrList = new String[1][3];
            this.attrList[0][0] = string2;
        }

        public Tag(String string, String string2, String string3) {
            this.name = string;
            this.attrList = new String[1][3];
            this.attrList[0][0] = string2;
            this.attrList[0][1] = "CDATA";
            this.attrList[0][2] = string3;
        }

        public Tag(String string, String[] stringArray) {
            this.name = string;
            this.attrList = new String[stringArray.length][3];
            for (int i = 0; i < stringArray.length; ++i) {
                this.attrList[i][0] = stringArray[i];
            }
        }

        public Tag(String string, String[][] stringArray) {
            this.name = string;
            this.attrList = new String[stringArray.length][3];
            for (int i = 0; i < stringArray.length; ++i) {
                this.attrList[i][0] = stringArray[i][0];
                this.attrList[i][1] = "CDATA";
                this.attrList[i][2] = stringArray[i][1];
            }
        }

        public String toString() {
            String string = "<" + this.name;
            for (int i = 0; i < this.attrList.length; ++i) {
                string = string + " " + this.attrList[i][0] + "=";
                string = this.attrList[i][2] == null ? string + "(not specified)" : string + "\"" + this.attrList[i][2] + "\"";
            }
            string = string + ">";
            return string;
        }

        protected boolean checkAttr(int n, XAttributeList xAttributeList) {
            short s = xAttributeList.getLength();
            for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
                if (!this.attrList[n][0].equals(xAttributeList.getNameByIndex(s2))) continue;
                if (this.attrList[n][2] == null) {
                    return true;
                }
                return this.attrList[n][2].equals(xAttributeList.getValueByIndex(s2));
            }
            return false;
        }

        public boolean isMatchTo(String string, XAttributeList xAttributeList) {
            if (!this.name.equals(string)) {
                return false;
            }
            boolean bl = true;
            for (int i = 0; i < this.attrList.length; ++i) {
                bl &= this.checkAttr(i, xAttributeList);
            }
            return bl;
        }
    }

    public static class XMLTagsChecker
    extends XMLWellFormChecker {
        protected Hashtable tags = new Hashtable();
        protected Hashtable chars = new Hashtable();
        protected boolean allOK = true;

        public XMLTagsChecker(PrintWriter printWriter) {
            super(printWriter);
        }

        public void addTag(String string) {
            this.tags.put(string, "");
        }

        public void addTagEnclosed(String string, String string2) {
            this.tags.put(string, string2);
        }

        public void addCharacters(String string) {
            this.chars.put(string, "");
        }

        public void addCharactersEnclosed(String string, String string2) {
            this.chars.put(string, string2);
        }

        public void startElement(String string, XAttributeList xAttributeList) {
            super.startElement(string, xAttributeList);
            if (this.tags.containsKey(string)) {
                String string2 = (String)this.tags.get(string);
                if (!string2.equals("")) {
                    boolean bl = false;
                    for (int i = 0; i < this.tagStack.size(); ++i) {
                        if (!string2.equals((String)this.tagStack.elementAt(i))) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        this.printError("Required tag <" + string + "> found, but is not enclosed in tag <" + string2 + ">");
                        this.allOK = false;
                    }
                }
                this.tags.remove(string);
            }
        }

        public void characters(String string) {
            super.characters(string);
            if (this.chars.containsKey(string)) {
                String string2 = (String)this.chars.get(string);
                if (!string2.equals("")) {
                    boolean bl = false;
                    for (int i = 0; i < this.tagStack.size(); ++i) {
                        if (!string2.equals((String)this.tagStack.elementAt(i))) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        this.printError("Required characters '" + string + "' found, but are not enclosed in tag <" + string2 + ">");
                        this.allOK = false;
                    }
                }
                this.chars.remove(string);
            }
        }

        public boolean checkTags() {
            this.allOK &= this.isWellFormed();
            Enumeration enumeration = this.tags.keys();
            Enumeration enumeration2 = this.chars.keys();
            if (enumeration.hasMoreElements()) {
                this.allOK = false;
                this.log.println("Required tags were not found in export :");
                while (enumeration.hasMoreElements()) {
                    this.log.println("   <" + (String)enumeration.nextElement() + ">");
                }
            }
            if (enumeration2.hasMoreElements()) {
                this.allOK = false;
                this.log.println("Required characters were not found in export :");
                while (enumeration2.hasMoreElements()) {
                    this.log.println("   <" + (String)enumeration2.nextElement() + ">");
                }
            }
            this.reset();
            return this.allOK;
        }
    }

    public static class XMLWellFormChecker
    extends XMLWriter {
        protected boolean docStarted = false;
        protected boolean docEnded = false;
        protected Vector tagStack = new Vector();
        protected boolean wellFormed = true;
        protected boolean noOtherErrors = true;
        protected PrintWriter log = null;
        protected boolean printXMLData = false;

        public XMLWellFormChecker(PrintWriter printWriter) {
            this.log = printWriter;
        }

        public XMLWellFormChecker(PrintWriter printWriter, boolean bl) {
            super(bl ? printWriter : null);
            this.printXMLData = bl;
            this.log = printWriter;
        }

        public void reset() {
            this.docStarted = false;
            this.docEnded = false;
            this.tagStack = new Vector();
            this.wellFormed = true;
            this.noOtherErrors = true;
            Object var1_1 = null;
            this.printXMLData = false;
        }

        public void startDocument() {
            super.startDocument();
            if (this.docStarted) {
                this.printError("Document is started twice.");
                this.wellFormed = false;
            }
            this.docStarted = true;
        }

        public void endDocument() {
            super.endDocument();
            if (!this.docStarted) {
                this.wellFormed = false;
                this.printError("Document ended but not started.");
            }
            this.docEnded = true;
        }

        public void startElement(String string, XAttributeList xAttributeList) {
            super.startElement(string, xAttributeList);
            if (xAttributeList == null) {
                this.printError("attribute list passed as parameter to startElement() method has null value for tag <" + string + ">");
                this.noOtherErrors = false;
            }
            this.tagStack.add(0, string);
        }

        public void endElement(String string) {
            super.endElement(string);
            if (this.wellFormed) {
                if (this.tagStack.size() == 0) {
                    this.wellFormed = false;
                    this.printError("No tags to close (bad closing tag </" + string + ">)");
                } else {
                    String string2 = (String)this.tagStack.elementAt(0);
                    this.tagStack.remove(0);
                    if (!string2.equals(string)) {
                        this.wellFormed = false;
                        this.printError("Bad closing tag: </" + string + ">; tag expected: </" + string2 + ">");
                    }
                }
            }
        }

        public boolean isWellFormed() {
            if (!this.docEnded) {
                this.printError("Document was not ended.");
                this.wellFormed = false;
            }
            return this.wellFormed && this.noOtherErrors;
        }

        public void printError(String string) {
            this.log.println("!!! Error: " + string);
            if (this.printXMLData) {
                return;
            }
            this.log.println("   Tag trace :");
            for (int i = 0; i < this.tagStack.size(); ++i) {
                String string2 = (String)this.tagStack.elementAt(i);
                this.log.println("      <" + string2 + ">");
            }
        }
    }

    public static class XMLWriter
    implements XDocumentHandler {
        private PrintWriter _log = null;
        private String align = "";

        public XMLWriter(PrintWriter printWriter) {
            this._log = printWriter;
        }

        public XMLWriter() {
        }

        public void processingInstruction(String string, String string2) {
            if (this._log == null) {
                return;
            }
            this._log.println(this.align + "<?" + string + " " + string2 + "?>");
        }

        public void startDocument() {
            if (this._log == null) {
                return;
            }
            this._log.println("START DOCUMENT:");
        }

        public void endDocument() {
            if (this._log == null) {
                return;
            }
            this._log.println("END DOCUMENT:");
        }

        public void setDocumentLocator(XLocator xLocator) {
            if (this._log == null) {
                return;
            }
            this._log.println("DOCUMENT LOCATOR: ('" + xLocator.getPublicId() + "','" + xLocator.getSystemId() + "')");
        }

        public void startElement(String string, XAttributeList xAttributeList) {
            if (this._log == null) {
                return;
            }
            this._log.print(this.align + "<" + string + " ");
            if (xAttributeList != null) {
                short s = xAttributeList.getLength();
                for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
                    if (s2 != 0) {
                        this._log.print(this.align + "       ");
                    }
                    this._log.print(xAttributeList.getNameByIndex(s2) + "[" + xAttributeList.getTypeByIndex(s2) + "]=\"" + xAttributeList.getValueByIndex(s2) + "\"");
                    if (s2 + 1 == s) continue;
                    this._log.println();
                }
            }
            this._log.println(">");
            this.align = this.align + "   ";
        }

        public void endElement(String string) {
            if (this._log == null) {
                return;
            }
            this.align = this.align.substring(3);
            this._log.println(this.align + "</" + string + ">");
        }

        public void characters(String string) {
            if (this._log == null) {
                return;
            }
            this._log.println(this.align + string);
        }

        public void ignorableWhitespace(String string) {
            if (this._log == null) {
                return;
            }
            this._log.println(string);
        }
    }

    public static class AttributeList
    implements XAttributeList {
        private Hashtable attrByName = new Hashtable();
        private Vector attributes = new Vector();
        private PrintWriter log = null;

        public AttributeList() {
        }

        public AttributeList(PrintWriter printWriter) {
            this.log = printWriter;
        }

        public AttributeList(XAttributeList xAttributeList) {
            if (xAttributeList == null) {
                return;
            }
            for (short s = 0; s < xAttributeList.getLength(); s = (short)(s + 1)) {
                this.add(xAttributeList.getNameByIndex(s), xAttributeList.getTypeByIndex(s), xAttributeList.getValueByIndex(s));
            }
        }

        public void add(String string, String string2, String string3) {
            Attribute attribute = new Attribute();
            attribute.Name = string;
            attribute.Type = string2;
            attribute.Value = string3;
            this.attributes.add(attribute);
            this.attrByName.put(attribute.Name, attribute);
        }

        public void add(String string, String string2) {
            this.add(string, "CDATA", string2);
        }

        public void clear() {
            this.attrByName.clear();
            this.attributes.clear();
        }

        public short getLength() {
            if (this.log != null) {
                this.log.println("getLength() called -> " + this.attributes.size());
            }
            return (short)this.attributes.size();
        }

        public String getNameByIndex(short s) {
            String string = ((Attribute)this.attributes.get((int)s)).Name;
            if (this.log != null) {
                this.log.println("getNameByIndex(" + s + ") called -> '" + string + "'");
            }
            return string;
        }

        public String getTypeByIndex(short s) {
            String string = ((Attribute)this.attributes.get((int)s)).Type;
            if (this.log != null) {
                this.log.println("getTypeByIndex(" + s + ") called -> '" + string + "'");
            }
            return string;
        }

        public String getTypeByName(String string) {
            String string2 = ((Attribute)this.attrByName.get((Object)string)).Type;
            if (this.log != null) {
                this.log.println("getTypeByName('" + string + "') called -> '" + string2 + "'");
            }
            return string2;
        }

        public String getValueByIndex(short s) {
            String string = ((Attribute)this.attributes.get((int)s)).Value;
            if (this.log != null) {
                this.log.println("getValueByIndex(" + s + ") called -> '" + string + "'");
            }
            return string;
        }

        public String getValueByName(String string) {
            String string2 = ((Attribute)this.attrByName.get((Object)string)).Value;
            if (this.log != null) {
                this.log.println("getValueByName('" + string + "') called -> '" + string2 + "'");
            }
            return string2;
        }

        private static class Attribute {
            public String Name;
            public String Type;
            public String Value;

            private Attribute() {
            }
        }
    }
}

