/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleComponent;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.awt.XWindow;
import com.sun.star.frame.XController;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XModel;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import util.utils;

public class AccessibilityTools {
    public static XAccessibleContext SearchedContext = null;
    public static XAccessible SearchedAccessible = null;
    private static boolean debug = false;

    public AccessibilityTools() {
        SearchedContext = null;
    }

    public static XAccessible getAccessibleObject(XInterface xInterface) {
        XAccessible xAccessible = null;
        try {
            xAccessible = (XAccessible)UnoRuntime.queryInterface(XAccessible.class, (Object)xInterface);
        }
        catch (Exception exception) {
            System.out.println("caught exception while getting accessible object" + exception);
            exception.printStackTrace();
        }
        return xAccessible;
    }

    public static XWindow getCurrentContainerWindow(XMultiServiceFactory xMultiServiceFactory, XModel xModel) {
        return AccessibilityTools.getWindow(xMultiServiceFactory, xModel, true);
    }

    public static XWindow getCurrentWindow(XMultiServiceFactory xMultiServiceFactory, XModel xModel) {
        return AccessibilityTools.getWindow(xMultiServiceFactory, xModel, false);
    }

    private static XWindow getWindow(XMultiServiceFactory xMultiServiceFactory, XModel xModel, boolean bl) {
        XWindow xWindow = null;
        try {
            XFrame xFrame;
            XController xController;
            if (xModel == null) {
                System.out.println("invalid model (==null)");
            }
            if ((xController = xModel.getCurrentController()) == null) {
                System.out.println("can't get controller from model");
            }
            if ((xFrame = xController.getFrame()) == null) {
                System.out.println("can't get frame from controller");
            }
            if ((xWindow = bl ? xFrame.getContainerWindow() : xFrame.getComponentWindow()) == null) {
                System.out.println("can't get window from frame");
            }
        }
        catch (Exception exception) {
            System.out.println("caught exception while getting current window" + exception);
        }
        return xWindow;
    }

    public static XAccessibleContext getAccessibleObjectForRole(XAccessible xAccessible, short s) {
        SearchedContext = null;
        SearchedAccessible = null;
        AccessibilityTools.getAccessibleObjectForRole_(xAccessible, s);
        return SearchedContext;
    }

    public static XAccessibleContext getAccessibleObjectForRole(XAccessible xAccessible, short s, boolean bl) {
        SearchedContext = null;
        SearchedAccessible = null;
        if (bl) {
            AccessibilityTools.getAccessibleObjectForRoleIgnoreShowing_(xAccessible, s);
        } else {
            AccessibilityTools.getAccessibleObjectForRole_(xAccessible, s);
        }
        return SearchedContext;
    }

    public static void getAccessibleObjectForRoleIgnoreShowing_(XAccessible xAccessible, short s) {
        XAccessibleContext xAccessibleContext = xAccessible.getAccessibleContext();
        if (xAccessibleContext.getAccessibleRole() == s) {
            SearchedContext = xAccessibleContext;
            SearchedAccessible = xAccessible;
        } else {
            int n = xAccessibleContext.getAccessibleChildCount();
            if (xAccessibleContext.getAccessibleChildCount() > 100) {
                n = 50;
            }
            for (int i = 0; i < n; ++i) {
                try {
                    AccessibilityTools.getAccessibleObjectForRoleIgnoreShowing_(xAccessibleContext.getAccessibleChild(i), s);
                    if (SearchedContext == null) continue;
                    return;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    System.out.println("Couldn't get Child");
                }
            }
        }
    }

    public static void getAccessibleObjectForRole_(XAccessible xAccessible, short s) {
        XAccessibleContext xAccessibleContext = xAccessible.getAccessibleContext();
        boolean bl = xAccessibleContext.getAccessibleStateSet().contains((short)25);
        if (xAccessibleContext.getAccessibleRole() == s && bl) {
            SearchedContext = xAccessibleContext;
            SearchedAccessible = xAccessible;
        } else {
            int n = xAccessibleContext.getAccessibleChildCount();
            if (xAccessibleContext.getAccessibleChildCount() > 100) {
                n = 50;
            }
            for (int i = 0; i < n; ++i) {
                try {
                    AccessibilityTools.getAccessibleObjectForRole_(xAccessibleContext.getAccessibleChild(i), s);
                    if (SearchedContext == null) continue;
                    return;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    System.out.println("Couldn't get Child");
                }
            }
        }
    }

    public static XAccessibleContext getAccessibleObjectForRole(XAccessible xAccessible, short s, String string) {
        return AccessibilityTools.getAccessibleObjectForRole(xAccessible, s, string, "");
    }

    public static XAccessibleContext getAccessibleObjectForRole(XAccessible xAccessible, short s, String string, boolean bl) {
        if (bl) {
            return AccessibilityTools.getAccessibleObjectForRoleIgnoreShowing(xAccessible, s, string, "");
        }
        return AccessibilityTools.getAccessibleObjectForRole(xAccessible, s, string, "");
    }

    public static XAccessibleContext getAccessibleObjectForRoleIgnoreShowing(XAccessible xAccessible, short s, String string, String string2) {
        XAccessibleContext xAccessibleContext = xAccessible.getAccessibleContext();
        if (xAccessibleContext.getAccessibleRole() == s && xAccessibleContext.getAccessibleName().indexOf(string) > -1 && utils.getImplName(xAccessibleContext).indexOf(string2) > -1) {
            SearchedAccessible = xAccessible;
            return xAccessibleContext;
        }
        int n = xAccessibleContext.getAccessibleChildCount();
        if (xAccessibleContext.getAccessibleChildCount() > 100) {
            n = 50;
        }
        for (int i = 0; i < n; ++i) {
            try {
                XAccessibleContext xAccessibleContext2 = AccessibilityTools.getAccessibleObjectForRoleIgnoreShowing(xAccessibleContext.getAccessibleChild(i), s, string, string2);
                if (xAccessibleContext2 == null) continue;
                return xAccessibleContext2;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                System.out.println("Couldn't get Child");
            }
        }
        return null;
    }

    public static XAccessibleContext getAccessibleObjectForRole(XAccessible xAccessible, short s, String string, String string2) {
        XAccessibleContext xAccessibleContext = xAccessible.getAccessibleContext();
        boolean bl = xAccessibleContext.getAccessibleStateSet().contains((short)25);
        if (xAccessibleContext.getAccessibleRole() == s && xAccessibleContext.getAccessibleName().indexOf(string) > -1 && utils.getImplName(xAccessibleContext).indexOf(string2) > -1 && bl) {
            SearchedAccessible = xAccessible;
            return xAccessibleContext;
        }
        int n = xAccessibleContext.getAccessibleChildCount();
        if (xAccessibleContext.getAccessibleChildCount() > 100) {
            n = 50;
        }
        for (int i = 0; i < n; ++i) {
            try {
                XAccessibleContext xAccessibleContext2 = AccessibilityTools.getAccessibleObjectForRole(xAccessibleContext.getAccessibleChild(i), s, string, string2);
                if (xAccessibleContext2 == null) continue;
                return xAccessibleContext2;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                System.out.println("Couldn't get Child");
            }
        }
        return null;
    }

    public static void printAccessibleTree(PrintWriter printWriter, XAccessible xAccessible, boolean bl) {
        debug = bl;
        if (debug) {
            AccessibilityTools.printAccessibleTree(printWriter, xAccessible, "");
        }
    }

    public static void printAccessibleTree(PrintWriter printWriter, XAccessible xAccessible) {
        AccessibilityTools.printAccessibleTree(printWriter, xAccessible, "");
    }

    protected static void printAccessibleTree(PrintWriter printWriter, XAccessible xAccessible, String string) {
        int n;
        XAccessibleContext xAccessibleContext = xAccessible.getAccessibleContext();
        AccessibilityTools.logging(printWriter, string + xAccessibleContext.getAccessibleRole() + "," + xAccessibleContext.getAccessibleName() + "(" + xAccessibleContext.getAccessibleDescription() + "):" + utils.getImplName(xAccessibleContext));
        XAccessibleComponent xAccessibleComponent = (XAccessibleComponent)UnoRuntime.queryInterface(XAccessibleComponent.class, (Object)xAccessible);
        if (xAccessibleComponent != null) {
            String string2 = "(" + xAccessibleComponent.getBounds().X + "," + xAccessibleComponent.getBounds().Y + ")" + " (" + xAccessibleComponent.getBounds().Width + "," + xAccessibleComponent.getBounds().Height + ")";
            string2 = "The boundary Rectangle is " + string2;
            AccessibilityTools.logging(printWriter, string + string + string2);
        }
        boolean bl = xAccessibleContext.getAccessibleStateSet().contains((short)25);
        AccessibilityTools.logging(printWriter, string + string + "StateType contains SHOWING: " + bl);
        int n2 = xAccessibleContext.getAccessibleChildCount();
        if (xAccessibleContext.getAccessibleChildCount() > 100) {
            n2 = 50;
        }
        for (n = 0; n < n2; ++n) {
            try {
                AccessibilityTools.printAccessibleTree(printWriter, xAccessibleContext.getAccessibleChild(n), string + "  ");
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                System.out.println("Couldn't get Child");
            }
        }
        if (xAccessibleContext.getAccessibleChildCount() > 100) {
            n2 = xAccessibleContext.getAccessibleChildCount();
            n = xAccessibleContext.getAccessibleChildCount() - 50;
            AccessibilityTools.logging(printWriter, string + "  " + " ...... [skipped] ......");
            for (int i = n; i < n2; ++i) {
                try {
                    AccessibilityTools.printAccessibleTree(printWriter, xAccessibleContext.getAccessibleChild(i), string + "  ");
                    continue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    System.out.println("Couldn't get Child");
                }
            }
        }
    }

    public static String accessibleToString(Object object) {
        XAccessibleContext xAccessibleContext = (XAccessibleContext)UnoRuntime.queryInterface(XAccessibleContext.class, object);
        if (xAccessibleContext != null) {
            return "" + xAccessibleContext.getAccessibleRole() + "," + xAccessibleContext.getAccessibleName() + "(" + xAccessibleContext.getAccessibleDescription() + "):";
        }
        XAccessible xAccessible = (XAccessible)UnoRuntime.queryInterface(XAccessible.class, object);
        if (xAccessible == null) {
            return "(Not supported)";
        }
        xAccessibleContext = xAccessible.getAccessibleContext();
        return "" + xAccessibleContext.getAccessibleRole() + "," + xAccessibleContext.getAccessibleName() + "(" + xAccessibleContext.getAccessibleDescription() + ")";
    }

    public static boolean equals(XAccessible xAccessible, XAccessible xAccessible2) {
        if (xAccessible == null || xAccessible2 == null) {
            return xAccessible == xAccessible2;
        }
        return AccessibilityTools.equals(xAccessible.getAccessibleContext(), xAccessible2.getAccessibleContext());
    }

    public static boolean equals(XAccessibleContext xAccessibleContext, XAccessibleContext xAccessibleContext2) {
        if (xAccessibleContext == null || xAccessibleContext2 == null) {
            return xAccessibleContext == xAccessibleContext2;
        }
        if (xAccessibleContext.getAccessibleRole() != xAccessibleContext2.getAccessibleRole()) {
            return false;
        }
        if (!xAccessibleContext.getAccessibleName().equals(xAccessibleContext2.getAccessibleName())) {
            return false;
        }
        if (!xAccessibleContext.getAccessibleDescription().equals(xAccessibleContext2.getAccessibleDescription())) {
            return false;
        }
        if (xAccessibleContext.getAccessibleChildCount() != xAccessibleContext2.getAccessibleChildCount()) {
            return false;
        }
        return AccessibilityTools.equals(xAccessibleContext.getAccessibleParent(), xAccessibleContext2.getAccessibleParent());
    }

    private static void logging(PrintWriter printWriter, String string) {
        if (debug) {
            printWriter.println(string);
        }
    }
}

