/*
 * Decompiled with CFR 0.152.
 */
package lib;

import java.io.PrintWriter;
import lib.TestEnvironment;
import lib.TestParameters;

public abstract class TestCase {
    public PrintWriter log;

    public void setLogWriter(PrintWriter printWriter) {
        this.log = printWriter;
    }

    public void initializeTestCase(TestParameters testParameters) {
        this.initialize(testParameters, this.log);
    }

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
    }

    public void cleanupTestCase(TestParameters testParameters) {
        this.cleanup(testParameters, this.log);
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
    }

    public synchronized TestEnvironment getTestEnvironment(TestParameters testParameters) {
        TestEnvironment testEnvironment = null;
        try {
            testEnvironment = this.createTestEnvironment(testParameters, this.log);
            System.out.println("Environment created");
            if (testEnvironment != null) {
                testEnvironment.setTestCase(this);
            }
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            if (string == null) {
                string = exception.toString();
            }
            System.out.println("Exception while getting Environment " + string);
            exception.printStackTrace();
        }
        return testEnvironment;
    }

    public synchronized void disposeTestEnvironment(TestEnvironment testEnvironment, TestParameters testParameters) {
        this.cleanup(testParameters, this.log);
    }

    protected abstract TestEnvironment createTestEnvironment(TestParameters var1, PrintWriter var2);

    protected void cleanupTestEnvironment(TestParameters testParameters, TestEnvironment testEnvironment, PrintWriter printWriter) {
    }

    public String getObjectName() {
        String string = this.getClass().getName();
        return string.substring(string.lastIndexOf(46) + 1);
    }
}

