/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.letter;

import com.sun.star.awt.XTextComponent;
import com.sun.star.awt.XWindow;
import com.sun.star.awt.XWindowPeer;
import com.sun.star.beans.PropertyValue;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.document.XDocumentInfo;
import com.sun.star.document.XDocumentInfoSupplier;
import com.sun.star.frame.XTerminateListener;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.task.XInteractionHandler;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextFrame;
import com.sun.star.ucb.CommandAbortedException;
import com.sun.star.ucb.XSimpleFileAccess;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.XCloseable;
import com.sun.star.wizards.common.Configuration;
import com.sun.star.wizards.common.Desktop;
import com.sun.star.wizards.common.FileAccess;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.NoValidPathException;
import com.sun.star.wizards.common.SystemDialog;
import com.sun.star.wizards.document.OfficeDocument;
import com.sun.star.wizards.letter.CGLetter;
import com.sun.star.wizards.letter.CGLetterWizard;
import com.sun.star.wizards.letter.CGPaperElementLocation;
import com.sun.star.wizards.letter.LetterDocument;
import com.sun.star.wizards.letter.LetterWizardDialog;
import com.sun.star.wizards.letter.LocaleCodes;
import com.sun.star.wizards.text.TextFieldHandler;
import com.sun.star.wizards.text.TextFrameHandler;
import com.sun.star.wizards.text.ViewHandler;
import com.sun.star.wizards.ui.PathSelection;
import com.sun.star.wizards.ui.UnoDialog2;
import com.sun.star.wizards.ui.XPathSelectionListener;
import com.sun.star.wizards.ui.event.DataAware;
import com.sun.star.wizards.ui.event.RadioDataAware;
import com.sun.star.wizards.ui.event.UnoDataAware;
import java.util.Collection;
import java.util.Vector;

public class LetterWizardDialogImpl
extends LetterWizardDialog {
    static LetterDocument myLetterDoc;
    static boolean running;
    XMultiServiceFactory xmsf;
    XTextDocument xTextDocument;
    PathSelection myPathSelection;
    CGLetterWizard myConfig;
    Vector mainDA = new Vector();
    Vector letterDA = new Vector();
    Vector businessDA = new Vector();
    String[][] BusinessFiles;
    String[][] OfficialFiles;
    String[][] PrivateFiles;
    String[] Norms;
    String[] NormPaths;
    String[] NormNames;
    String sTemplatePath;
    String sUserTemplatePath;
    String sBitmapPath;
    String sLetterPath;
    String sLetterLangPackPath;
    String sWorkPath;
    String sCurrentNorm;
    String sPath;
    boolean bEditTemplate;
    boolean bSaveSuccess = false;
    private boolean filenameChanged = false;
    LetterDocument.BusinessPaperObject BusCompanyLogo = null;
    LetterDocument.BusinessPaperObject BusCompanyAddress = null;
    LetterDocument.BusinessPaperObject BusCompanyAddressReceiver = null;
    LetterDocument.BusinessPaperObject BusFooter = null;
    static final int RM_TYPESTYLE = 1;
    static final int RM_BUSINESSPAPER = 2;
    static final int RM_ELEMENTS = 3;
    static final int RM_SENDERRECEIVER = 4;
    static final int RM_FOOTER = 5;
    static final int RM_FINALSETTINGS = 6;

    public LetterWizardDialogImpl(XMultiServiceFactory xMultiServiceFactory) {
        super(xMultiServiceFactory);
        this.xmsf = xMultiServiceFactory;
    }

    public static void main(String[] stringArray) {
        String string = "uno:socket,host=127.0.0.1,port=8100;urp,negotiate=0,forcesynchronous=1;StarOffice.NamingService";
        XMultiServiceFactory xMultiServiceFactory = null;
        try {
            xMultiServiceFactory = Desktop.connect((String)string);
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        LetterWizardDialogImpl letterWizardDialogImpl = new LetterWizardDialogImpl(xMultiServiceFactory);
        letterWizardDialogImpl.startWizard(xMultiServiceFactory, null);
    }

    public void startWizard(XMultiServiceFactory xMultiServiceFactory, Object[] objectArray) {
        running = true;
        try {
            int n;
            this.setMaxStep(6);
            myLetterDoc = new LetterDocument(xMultiServiceFactory, (XTerminateListener)this);
            this.drawNaviBar();
            this.buildStep1();
            this.buildStep2();
            this.buildStep3();
            this.buildStep4();
            this.buildStep5();
            this.buildStep6();
            this.initializePaths();
            this.initializeNorms();
            this.initializeSalutation();
            this.initializeGreeting();
            this.insertPathSelectionControl();
            this.initConfiguration();
            this.myConfig.cp_BusinessLetter.cp_Norm = n = this.getOfficeLinguistic();
            this.myConfig.cp_PrivateOfficialLetter.cp_Norm = n;
            this.myConfig.cp_PrivateLetter.cp_Norm = n;
            this.initializeTemplates(xMultiServiceFactory);
            if (this.myConfig.cp_BusinessLetter.cp_Greeting.equals("")) {
                this.myConfig.cp_BusinessLetter.cp_Greeting = this.resources.GreetingLabels[0];
            }
            if (this.myConfig.cp_BusinessLetter.cp_Salutation.equals("")) {
                this.myConfig.cp_BusinessLetter.cp_Salutation = this.resources.SalutationLabels[0];
            }
            if (this.myConfig.cp_PrivateOfficialLetter.cp_Greeting.equals("")) {
                this.myConfig.cp_PrivateOfficialLetter.cp_Greeting = this.resources.GreetingLabels[1];
            }
            if (this.myConfig.cp_PrivateOfficialLetter.cp_Salutation.equals("")) {
                this.myConfig.cp_PrivateOfficialLetter.cp_Salutation = this.resources.SalutationLabels[1];
            }
            if (this.myConfig.cp_PrivateLetter.cp_Greeting.equals("")) {
                this.myConfig.cp_PrivateLetter.cp_Greeting = this.resources.GreetingLabels[2];
            }
            if (this.myConfig.cp_PrivateLetter.cp_Salutation.equals("")) {
                this.myConfig.cp_PrivateLetter.cp_Salutation = this.resources.SalutationLabels[2];
            }
            this.updateUI();
            if (this.myPathSelection.xSaveTextBox.getText().equalsIgnoreCase("")) {
                this.myPathSelection.initializePath();
            }
            XWindow xWindow = LetterWizardDialogImpl.myLetterDoc.xFrame.getContainerWindow();
            XWindowPeer xWindowPeer = (XWindowPeer)UnoRuntime.queryInterface(XWindowPeer.class, (Object)xWindow);
            this.createWindowPeer(xWindowPeer);
            this.insertRoadmap();
            this.setConfiguration();
            this.setDefaultForGreetingAndSalutation();
            this.initializeElements();
            LetterWizardDialogImpl.myLetterDoc.xFrame.getComponentWindow().setEnable(false);
            this.xWindow.setVisible(true);
        }
        catch (com.sun.star.uno.Exception exception) {
            this.removeTerminateListener();
            exception.printStackTrace(System.out);
        }
    }

    public void cancelWizard() {
        this.xWindow.setVisible(false);
        this.closeDocument();
        this.removeTerminateListener();
        running = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishWizard() {
        this.switchToStep(this.getCurrentStep(), this.getMaxStep());
        try {
            int n;
            FileAccess fileAccess = new FileAccess(this.xMSF);
            this.sPath = this.myPathSelection.getSelectedPath();
            if (this.sPath.equals("")) {
                this.myPathSelection.triggerPathPicker();
                this.sPath = this.myPathSelection.getSelectedPath();
            }
            this.sPath = fileAccess.getURL(this.sPath);
            if (!this.filenameChanged && fileAccess.exists(this.sPath, true) && (n = SystemDialog.showMessageBox((XMultiServiceFactory)this.xMSF, (XWindowPeer)this.xControl.getPeer(), (String)"MessBox", (int)-2130706432, (String)this.resources.resOverwriteWarning)) == 3) {
                return;
            }
            myLetterDoc.setWizardTemplateDocInfo(this.resources.resLetterWizardDialog_title, this.resources.resTemplateDescription);
            myLetterDoc.killEmptyUserFields();
            LetterWizardDialogImpl.myLetterDoc.keepLogoFrame = this.chkUseLogo.getState() != 0;
            LetterWizardDialogImpl.myLetterDoc.keepBendMarksFrame = this.chkUseBendMarks.getState() != 0;
            LetterWizardDialogImpl.myLetterDoc.keepLetterSignsFrame = this.chkUseSigns.getState() != 0;
            myLetterDoc.killEmptyFrames();
            this.bSaveSuccess = OfficeDocument.store((XMultiServiceFactory)this.xMSF, (XComponent)this.xTextDocument, (String)this.sPath, (String)"writer8_template", (boolean)false, (String)("Template could not be saved to " + this.sPath));
            if (this.bSaveSuccess) {
                this.saveConfiguration();
                this.xWindow.setVisible(false);
                this.closeDocument();
                XInteractionHandler xInteractionHandler = (XInteractionHandler)UnoRuntime.queryInterface(XInteractionHandler.class, (Object)this.xMSF.createInstance("com.sun.star.comp.uui.UUIInteractionHandler"));
                PropertyValue[] propertyValueArray = new PropertyValue[4];
                propertyValueArray[0] = new PropertyValue();
                propertyValueArray[0].Name = "AsTemplate";
                propertyValueArray[1] = new PropertyValue();
                propertyValueArray[1].Name = "MacroExecutionMode";
                propertyValueArray[1].Value = new Short(2);
                propertyValueArray[2] = new PropertyValue();
                propertyValueArray[2].Name = "UpdateDocMode";
                propertyValueArray[2].Value = new Short(3);
                propertyValueArray[3] = new PropertyValue();
                propertyValueArray[3].Name = "InteractionHandler";
                propertyValueArray[3].Value = xInteractionHandler;
                propertyValueArray[0].Value = this.bEditTemplate ? Boolean.FALSE : Boolean.TRUE;
                Object object = OfficeDocument.load((XInterface)Desktop.getDesktop((XMultiServiceFactory)this.xMSF), (String)this.sPath, (String)"_default", (PropertyValue[])propertyValueArray);
                XTextDocument xTextDocument = (XTextDocument)object;
                XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)xTextDocument);
                ViewHandler viewHandler = new ViewHandler(xMultiServiceFactory, xTextDocument);
                viewHandler.setViewSetting("ZoomType", (Object)new Short(0));
            }
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace();
        }
        finally {
            this.removeTerminateListener();
            running = false;
        }
    }

    public void closeDocument() {
        try {
            this.xComponent.dispose();
            XCloseable xCloseable = (XCloseable)UnoRuntime.queryInterface(XCloseable.class, (Object)LetterWizardDialogImpl.myLetterDoc.xFrame);
            xCloseable.close(false);
        }
        catch (CloseVetoException closeVetoException) {
            closeVetoException.printStackTrace();
        }
    }

    public void optBusinessLetterItemChanged() {
        DataAware.setDataObject((Collection)this.letterDA, (Object)((Object)this.myConfig.cp_BusinessLetter), (boolean)true);
        this.setControlProperty("lblBusinessStyle", "Enabled", Boolean.TRUE);
        this.setControlProperty("lstBusinessStyle", "Enabled", Boolean.TRUE);
        this.setControlProperty("chkBusinessPaper", "Enabled", Boolean.TRUE);
        this.setControlProperty("lblPrivOfficialStyle", "Enabled", Boolean.FALSE);
        this.setControlProperty("lstPrivOfficialStyle", "Enabled", Boolean.FALSE);
        this.setControlProperty("lblPrivateStyle", "Enabled", Boolean.FALSE);
        this.setControlProperty("lstPrivateStyle", "Enabled", Boolean.FALSE);
        this.lstBusinessStyleItemChanged();
        this.enableSenderReceiver();
        this.setPossibleFooter(true);
        if (this.myPathSelection.xSaveTextBox.getText().equalsIgnoreCase("")) {
            this.myPathSelection.initializePath();
        }
    }

    public void optPrivOfficialLetterItemChanged() {
        DataAware.setDataObject((Collection)this.letterDA, (Object)((Object)this.myConfig.cp_PrivateOfficialLetter), (boolean)true);
        this.setControlProperty("lblBusinessStyle", "Enabled", Boolean.FALSE);
        this.setControlProperty("lstBusinessStyle", "Enabled", Boolean.FALSE);
        this.setControlProperty("chkBusinessPaper", "Enabled", Boolean.FALSE);
        this.setControlProperty("lblPrivOfficialStyle", "Enabled", Boolean.TRUE);
        this.setControlProperty("lstPrivOfficialStyle", "Enabled", Boolean.TRUE);
        this.setControlProperty("lblPrivateStyle", "Enabled", Boolean.FALSE);
        this.setControlProperty("lstPrivateStyle", "Enabled", Boolean.FALSE);
        this.lstPrivOfficialStyleItemChanged();
        this.disableBusinessPaper();
        this.enableSenderReceiver();
        this.setPossibleFooter(true);
        if (this.myPathSelection.xSaveTextBox.getText().equalsIgnoreCase("")) {
            this.myPathSelection.initializePath();
        }
    }

    public void optPrivateLetterItemChanged() {
        DataAware.setDataObject((Collection)this.letterDA, (Object)((Object)this.myConfig.cp_PrivateLetter), (boolean)true);
        this.setControlProperty("lblBusinessStyle", "Enabled", Boolean.FALSE);
        this.setControlProperty("lstBusinessStyle", "Enabled", Boolean.FALSE);
        this.setControlProperty("chkBusinessPaper", "Enabled", Boolean.FALSE);
        this.setControlProperty("lblPrivOfficialStyle", "Enabled", Boolean.FALSE);
        this.setControlProperty("lstPrivOfficialStyle", "Enabled", Boolean.FALSE);
        this.setControlProperty("lblPrivateStyle", "Enabled", Boolean.TRUE);
        this.setControlProperty("lstPrivateStyle", "Enabled", Boolean.TRUE);
        this.lstPrivateStyleItemChanged();
        this.disableBusinessPaper();
        this.disableSenderReceiver();
        this.setPossibleFooter(false);
        if (this.myPathSelection.xSaveTextBox.getText().equalsIgnoreCase("")) {
            this.myPathSelection.initializePath();
        }
    }

    public void optSenderPlaceholderItemChanged() {
        this.setControlProperty("lblSenderName", "Enabled", Boolean.FALSE);
        this.setControlProperty("lblSenderStreet", "Enabled", Boolean.FALSE);
        this.setControlProperty("lblPostCodeCity", "Enabled", Boolean.FALSE);
        this.setControlProperty("txtSenderName", "Enabled", Boolean.FALSE);
        this.setControlProperty("txtSenderStreet", "Enabled", Boolean.FALSE);
        this.setControlProperty("txtSenderPostCode", "Enabled", Boolean.FALSE);
        this.setControlProperty("txtSenderState", "Enabled", Boolean.FALSE);
        this.setControlProperty("txtSenderCity", "Enabled", Boolean.FALSE);
        myLetterDoc.fillSenderWithUserData();
    }

    public void optSenderDefineItemChanged() {
        this.setControlProperty("lblSenderName", "Enabled", Boolean.TRUE);
        this.setControlProperty("lblSenderStreet", "Enabled", Boolean.TRUE);
        this.setControlProperty("lblPostCodeCity", "Enabled", Boolean.TRUE);
        this.setControlProperty("txtSenderName", "Enabled", Boolean.TRUE);
        this.setControlProperty("txtSenderStreet", "Enabled", Boolean.TRUE);
        this.setControlProperty("txtSenderPostCode", "Enabled", Boolean.TRUE);
        this.setControlProperty("txtSenderState", "Enabled", Boolean.TRUE);
        this.setControlProperty("txtSenderCity", "Enabled", Boolean.TRUE);
        this.txtSenderNameTextChanged();
        this.txtSenderStreetTextChanged();
        this.txtSenderPostCodeTextChanged();
        this.txtSenderStateTextChanged();
        this.txtSenderCityTextChanged();
    }

    public void optCreateLetterItemChanged() {
        this.bEditTemplate = false;
    }

    public void optMakeChangesItemChanged() {
        this.bEditTemplate = true;
    }

    public void optReceiverPlaceholderItemChanged() {
        OfficeDocument.attachEventCall((XComponent)this.xTextDocument, (String)"OnNew", (String)"StarBasic", (String)"macro:///Template.Correspondence.Placeholder()");
    }

    public void optReceiverDatabaseItemChanged() {
        OfficeDocument.attachEventCall((XComponent)this.xTextDocument, (String)"OnNew", (String)"StarBasic", (String)"macro:///Template.Correspondence.Database()");
    }

    public void lstBusinessStyleItemChanged() {
        this.xTextDocument = myLetterDoc.loadAsPreview(this.BusinessFiles[1][this.lstBusinessStyle.getSelectedItemPos()], false);
        LetterWizardDialogImpl.myLetterDoc.xTextDocument.lockControllers();
        this.initializeElements();
        this.chkBusinessPaperItemChanged();
        this.setElements(false);
        LetterWizardDialogImpl.myLetterDoc.xTextDocument.unlockControllers();
        this.activate();
    }

    public void lstPrivOfficialStyleItemChanged() {
        this.xTextDocument = myLetterDoc.loadAsPreview(this.OfficialFiles[1][this.lstPrivOfficialStyle.getSelectedItemPos()], false);
        LetterWizardDialogImpl.myLetterDoc.xTextDocument.lockControllers();
        this.initializeElements();
        this.setElements(false);
        LetterWizardDialogImpl.myLetterDoc.xTextDocument.unlockControllers();
        this.activate();
    }

    public void lstPrivateStyleItemChanged() {
        this.xTextDocument = myLetterDoc.loadAsPreview(this.PrivateFiles[1][this.lstPrivateStyle.getSelectedItemPos()], false);
        LetterWizardDialogImpl.myLetterDoc.xTextDocument.lockControllers();
        this.initializeElements();
        this.setElements(true);
        LetterWizardDialogImpl.myLetterDoc.xTextDocument.unlockControllers();
        this.activate();
    }

    public void numLogoHeightTextChanged() {
        this.BusCompanyLogo.iHeight = (int)(this.numLogoHeight.getValue() * 1000.0);
        this.BusCompanyLogo.setFramePosition();
    }

    public void numLogoWidthTextChanged() {
        this.BusCompanyLogo.iWidth = (int)(this.numLogoWidth.getValue() * 1000.0);
        this.BusCompanyLogo.setFramePosition();
    }

    public void numLogoXTextChanged() {
        this.BusCompanyLogo.iXPos = (int)(this.numLogoX.getValue() * 1000.0);
        this.BusCompanyLogo.setFramePosition();
    }

    public void numLogoYTextChanged() {
        this.BusCompanyLogo.iYPos = (int)(this.numLogoY.getValue() * 1000.0);
        this.BusCompanyLogo.setFramePosition();
    }

    public void numAddressWidthTextChanged() {
        this.BusCompanyAddress.iWidth = (int)(this.numAddressWidth.getValue() * 1000.0);
        this.BusCompanyAddress.setFramePosition();
    }

    public void numAddressXTextChanged() {
        this.BusCompanyAddress.iXPos = (int)(this.numAddressX.getValue() * 1000.0);
        this.BusCompanyAddress.setFramePosition();
    }

    public void numAddressYTextChanged() {
        this.BusCompanyAddress.iYPos = (int)(this.numAddressY.getValue() * 1000.0);
        this.BusCompanyAddress.setFramePosition();
    }

    public void numAddressHeightTextChanged() {
        this.BusCompanyAddress.iHeight = (int)(this.numAddressHeight.getValue() * 1000.0);
        this.BusCompanyAddress.setFramePosition();
    }

    public void numFooterHeightTextChanged() {
        this.BusFooter.iHeight = (int)(this.numFooterHeight.getValue() * 1000.0);
        this.BusFooter.iYPos = LetterWizardDialogImpl.myLetterDoc.DocSize.Height - this.BusFooter.iHeight;
        this.BusFooter.setFramePosition();
    }

    public void chkPaperCompanyLogoItemChanged() {
        if (this.chkPaperCompanyLogo.getState() != 0) {
            if (this.numLogoWidth.getValue() == 0.0) {
                this.numLogoWidth.setValue(0.1);
            }
            if (this.numLogoHeight.getValue() == 0.0) {
                this.numLogoHeight.setValue(0.1);
            }
            LetterDocument letterDocument = myLetterDoc;
            ((Object)((Object)letterDocument)).getClass();
            this.BusCompanyLogo = letterDocument.new LetterDocument.BusinessPaperObject("Company Logo", (int)(this.numLogoWidth.getValue() * 1000.0), (int)(this.numLogoHeight.getValue() * 1000.0), (int)(this.numLogoX.getValue() * 1000.0), (int)(this.numLogoY.getValue() * 1000.0));
            this.setControlProperty("numLogoHeight", "Enabled", Boolean.TRUE);
            this.setControlProperty("lblCompanyLogoHeight", "Enabled", Boolean.TRUE);
            this.setControlProperty("numLogoWidth", "Enabled", Boolean.TRUE);
            this.setControlProperty("lblCompanyLogoWidth", "Enabled", Boolean.TRUE);
            this.setControlProperty("numLogoX", "Enabled", Boolean.TRUE);
            this.setControlProperty("lblCompanyLogoX", "Enabled", Boolean.TRUE);
            this.setControlProperty("numLogoY", "Enabled", Boolean.TRUE);
            this.setControlProperty("lblCompanyLogoY", "Enabled", Boolean.TRUE);
            this.setPossibleLogo(false);
        } else {
            if (this.BusCompanyLogo != null) {
                this.BusCompanyLogo.removeFrame();
            }
            this.setControlProperty("numLogoHeight", "Enabled", Boolean.FALSE);
            this.setControlProperty("lblCompanyLogoHeight", "Enabled", Boolean.FALSE);
            this.setControlProperty("numLogoWidth", "Enabled", Boolean.FALSE);
            this.setControlProperty("lblCompanyLogoWidth", "Enabled", Boolean.FALSE);
            this.setControlProperty("numLogoX", "Enabled", Boolean.FALSE);
            this.setControlProperty("lblCompanyLogoX", "Enabled", Boolean.FALSE);
            this.setControlProperty("numLogoY", "Enabled", Boolean.FALSE);
            this.setControlProperty("lblCompanyLogoY", "Enabled", Boolean.FALSE);
            this.setPossibleLogo(true);
        }
    }

    public void chkPaperCompanyAddressItemChanged() {
        if (this.chkPaperCompanyAddress.getState() != 0) {
            if (this.numAddressWidth.getValue() == 0.0) {
                this.numAddressWidth.setValue(0.1);
            }
            if (this.numAddressHeight.getValue() == 0.0) {
                this.numAddressHeight.setValue(0.1);
            }
            LetterDocument letterDocument = myLetterDoc;
            ((Object)((Object)letterDocument)).getClass();
            this.BusCompanyAddress = letterDocument.new LetterDocument.BusinessPaperObject("Company Address", (int)(this.numAddressWidth.getValue() * 1000.0), (int)(this.numAddressHeight.getValue() * 1000.0), (int)(this.numAddressX.getValue() * 1000.0), (int)(this.numAddressY.getValue() * 1000.0));
            this.setControlProperty("numAddressHeight", "Enabled", Boolean.TRUE);
            this.setControlProperty("lblCompanyAddressHeight", "Enabled", Boolean.TRUE);
            this.setControlProperty("numAddressWidth", "Enabled", Boolean.TRUE);
            this.setControlProperty("lblCompanyAddressWidth", "Enabled", Boolean.TRUE);
            this.setControlProperty("numAddressX", "Enabled", Boolean.TRUE);
            this.setControlProperty("lblCompanyAddressX", "Enabled", Boolean.TRUE);
            this.setControlProperty("numAddressY", "Enabled", Boolean.TRUE);
            this.setControlProperty("lblCompanyAddressY", "Enabled", Boolean.TRUE);
            if (myLetterDoc.hasElement("Sender Address")) {
                myLetterDoc.switchElement("Sender Address", false);
            }
            if (this.chkCompanyReceiver.getState() != 0) {
                this.setPossibleSenderData(false);
            }
        } else {
            if (this.BusCompanyAddress != null) {
                this.BusCompanyAddress.removeFrame();
            }
            this.setControlProperty("numAddressHeight", "Enabled", Boolean.FALSE);
            this.setControlProperty("lblCompanyAddressHeight", "Enabled", Boolean.FALSE);
            this.setControlProperty("numAddressWidth", "Enabled", Boolean.FALSE);
            this.setControlProperty("lblCompanyAddressWidth", "Enabled", Boolean.FALSE);
            this.setControlProperty("numAddressX", "Enabled", Boolean.FALSE);
            this.setControlProperty("lblCompanyAddressX", "Enabled", Boolean.FALSE);
            this.setControlProperty("numAddressY", "Enabled", Boolean.FALSE);
            this.setControlProperty("lblCompanyAddressY", "Enabled", Boolean.FALSE);
            if (myLetterDoc.hasElement("Sender Address")) {
                myLetterDoc.switchElement("Sender Address", true);
            }
            this.setPossibleSenderData(true);
            if (this.optSenderDefine.getState()) {
                this.optSenderDefineItemChanged();
            }
            if (this.optSenderPlaceholder.getState()) {
                this.optSenderPlaceholderItemChanged();
            }
        }
    }

    public void chkCompanyReceiverItemChanged() {
        XTextFrame xTextFrame = null;
        if (this.chkCompanyReceiver.getState() != 0) {
            try {
                xTextFrame = TextFrameHandler.getFrameByName((String)"Receiver Address", (XTextDocument)this.xTextDocument);
                Integer n = (Integer)Helper.getUnoPropertyValue((Object)xTextFrame, (String)"Width");
                int n2 = n;
                Integer n3 = (Integer)Helper.getUnoPropertyValue((Object)xTextFrame, (String)"HoriOrientPosition");
                int n4 = n3;
                Integer n5 = (Integer)Helper.getUnoPropertyValue((Object)xTextFrame, (String)"VertOrientPosition");
                int n6 = n5;
                int n7 = 500;
                LetterDocument letterDocument = myLetterDoc;
                ((Object)((Object)letterDocument)).getClass();
                this.BusCompanyAddressReceiver = letterDocument.new LetterDocument.BusinessPaperObject(" ", n2, n7, n4, n6 - n7);
                this.setPossibleAddressReceiver(false);
            }
            catch (NoSuchElementException noSuchElementException) {
                noSuchElementException.printStackTrace();
            }
            catch (WrappedTargetException wrappedTargetException) {
                wrappedTargetException.printStackTrace();
            }
            if (this.chkPaperCompanyAddress.getState() != 0) {
                this.setPossibleSenderData(false);
            }
        } else {
            if (this.BusCompanyAddressReceiver != null) {
                this.BusCompanyAddressReceiver.removeFrame();
            }
            this.setPossibleAddressReceiver(true);
            this.setPossibleSenderData(true);
            if (this.optSenderDefine.getState()) {
                this.optSenderDefineItemChanged();
            }
            if (this.optSenderPlaceholder.getState()) {
                this.optSenderPlaceholderItemChanged();
            }
        }
    }

    public void chkPaperFooterItemChanged() {
        if (this.chkPaperFooter.getState() != 0) {
            if (this.numFooterHeight.getValue() == 0.0) {
                this.numFooterHeight.setValue(0.1);
            }
            LetterDocument letterDocument = myLetterDoc;
            ((Object)((Object)letterDocument)).getClass();
            this.BusFooter = letterDocument.new LetterDocument.BusinessPaperObject("Footer", LetterWizardDialogImpl.myLetterDoc.DocSize.Width, (int)(this.numFooterHeight.getValue() * 1000.0), 0, (int)((double)LetterWizardDialogImpl.myLetterDoc.DocSize.Height - this.numFooterHeight.getValue() * 1000.0));
            this.setControlProperty("numFooterHeight", "Enabled", Boolean.TRUE);
            this.setControlProperty("lblFooterHeight", "Enabled", Boolean.TRUE);
            this.setPossibleFooter(false);
        } else {
            if (this.BusFooter != null) {
                this.BusFooter.removeFrame();
            }
            this.setControlProperty("numFooterHeight", "Enabled", Boolean.FALSE);
            this.setControlProperty("lblFooterHeight", "Enabled", Boolean.FALSE);
            this.setPossibleFooter(true);
        }
    }

    public void chkUseLogoItemChanged() {
        try {
            if (myLetterDoc.hasElement("Company Logo")) {
                boolean bl = AnyConverter.toBoolean((Object)this.getControlProperty("chkUseLogo", "Enabled")) && this.chkUseLogo.getState() != 0;
                myLetterDoc.switchElement("Company Logo", bl);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
    }

    public void chkUseAddressReceiverItemChanged() {
        try {
            if (myLetterDoc.hasElement("Sender Address Repeated")) {
                boolean bl = AnyConverter.toBoolean((Object)this.getControlProperty("chkUseAddressReceiver", "Enabled")) && this.chkUseAddressReceiver.getState() != 0;
                myLetterDoc.switchElement("Sender Address Repeated", bl);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
    }

    public void chkUseSignsItemChanged() {
        if (myLetterDoc.hasElement("Letter Signs")) {
            myLetterDoc.switchElement("Letter Signs", this.chkUseSigns.getState() != 0);
        }
    }

    public void chkUseSubjectItemChanged() {
        if (myLetterDoc.hasElement("Subject Line")) {
            myLetterDoc.switchElement("Subject Line", this.chkUseSubject.getState() != 0);
        }
    }

    public void chkUseBendMarksItemChanged() {
        if (myLetterDoc.hasElement("Bend Marks")) {
            myLetterDoc.switchElement("Bend Marks", this.chkUseBendMarks.getState() != 0);
        }
    }

    public void chkUseFooterItemChanged() {
        try {
            boolean bl;
            boolean bl2 = bl = this.chkUseFooter.getState() != 0 && AnyConverter.toBoolean((Object)this.getControlProperty("chkUseFooter", "Enabled"));
            if (this.chkFooterNextPages.getState() != 0) {
                myLetterDoc.switchFooter("First Page", false, this.chkFooterPageNumbers.getState() != 0, this.txtFooter.getText());
                myLetterDoc.switchFooter("Standard", bl, this.chkFooterPageNumbers.getState() != 0, this.txtFooter.getText());
            } else {
                myLetterDoc.switchFooter("First Page", bl, this.chkFooterPageNumbers.getState() != 0, this.txtFooter.getText());
                myLetterDoc.switchFooter("Standard", bl, this.chkFooterPageNumbers.getState() != 0, this.txtFooter.getText());
            }
            XInterface xInterface = this.getRoadmapItemByID(5);
            Helper.setUnoPropertyValue((Object)xInterface, (String)"Enabled", (Object)new Boolean(bl));
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public void chkFooterNextPagesItemChanged() {
        this.chkUseFooterItemChanged();
    }

    public void chkFooterPageNumbersItemChanged() {
        this.chkUseFooterItemChanged();
    }

    private void setPossibleFooter(boolean bl) {
        this.setControlProperty("chkUseFooter", "Enabled", new Boolean(bl));
        this.chkUseFooterItemChanged();
    }

    private void setPossibleAddressReceiver(boolean bl) {
        if (myLetterDoc.hasElement("Sender Address Repeated")) {
            this.setControlProperty("chkUseAddressReceiver", "Enabled", new Boolean(bl));
            this.chkUseAddressReceiverItemChanged();
        }
    }

    private void setPossibleLogo(boolean bl) {
        if (myLetterDoc.hasElement("Company Logo")) {
            this.setControlProperty("chkUseLogo", "Enabled", new Boolean(bl));
            this.chkUseLogoItemChanged();
        }
    }

    public void txtFooterTextChanged() {
        this.chkUseFooterItemChanged();
    }

    public void txtSenderNameTextChanged() {
        TextFieldHandler textFieldHandler = new TextFieldHandler(LetterWizardDialogImpl.myLetterDoc.xMSF, this.xTextDocument);
        textFieldHandler.changeUserFieldContent("Company", this.txtSenderName.getText());
    }

    public void txtSenderStreetTextChanged() {
        TextFieldHandler textFieldHandler = new TextFieldHandler(LetterWizardDialogImpl.myLetterDoc.xMSF, this.xTextDocument);
        textFieldHandler.changeUserFieldContent("Street", this.txtSenderStreet.getText());
    }

    public void txtSenderCityTextChanged() {
        TextFieldHandler textFieldHandler = new TextFieldHandler(LetterWizardDialogImpl.myLetterDoc.xMSF, this.xTextDocument);
        textFieldHandler.changeUserFieldContent("City", this.txtSenderCity.getText());
    }

    public void txtSenderPostCodeTextChanged() {
        TextFieldHandler textFieldHandler = new TextFieldHandler(LetterWizardDialogImpl.myLetterDoc.xMSF, this.xTextDocument);
        textFieldHandler.changeUserFieldContent("PostCode", this.txtSenderPostCode.getText());
    }

    public void txtSenderStateTextChanged() {
        TextFieldHandler textFieldHandler = new TextFieldHandler(LetterWizardDialogImpl.myLetterDoc.xMSF, this.xTextDocument);
        textFieldHandler.changeUserFieldContent("State", this.txtSenderState.getText());
    }

    public void txtTemplateNameTextChanged() {
        XDocumentInfoSupplier xDocumentInfoSupplier = (XDocumentInfoSupplier)UnoRuntime.queryInterface(XDocumentInfoSupplier.class, (Object)this.xTextDocument);
        XDocumentInfo xDocumentInfo = xDocumentInfoSupplier.getDocumentInfo();
        String string = this.txtTemplateName.getText();
        Helper.setUnoPropertyValue((Object)xDocumentInfo, (String)"Title", (Object)string);
    }

    public void chkUseSalutationItemChanged() {
        XTextComponent xTextComponent = (XTextComponent)UnoRuntime.queryInterface(XTextComponent.class, (Object)this.lstSalutation);
        myLetterDoc.switchUserField("Salutation", xTextComponent.getText(), this.chkUseSalutation.getState() != 0);
        this.setControlProperty("lstSalutation", "Enabled", new Boolean(this.chkUseSalutation.getState() != 0));
    }

    public void lstSalutationItemChanged() {
        XTextComponent xTextComponent = (XTextComponent)UnoRuntime.queryInterface(XTextComponent.class, (Object)this.lstSalutation);
        myLetterDoc.switchUserField("Salutation", xTextComponent.getText(), this.chkUseSalutation.getState() != 0);
    }

    public void lstSalutationTextChanged() {
    }

    public void chkUseGreetingItemChanged() {
        XTextComponent xTextComponent = (XTextComponent)UnoRuntime.queryInterface(XTextComponent.class, (Object)this.lstGreeting);
        myLetterDoc.switchUserField("Greeting", xTextComponent.getText(), this.chkUseGreeting.getState() != 0);
        this.setControlProperty("lstGreeting", "Enabled", new Boolean(this.chkUseGreeting.getState() != 0));
    }

    private void setDefaultForGreetingAndSalutation() {
        XTextComponent xTextComponent = (XTextComponent)UnoRuntime.queryInterface(XTextComponent.class, (Object)this.lstSalutation);
        if (xTextComponent.getText().equals("")) {
            xTextComponent.setText(this.resources.SalutationLabels[0]);
        }
        if ((xTextComponent = (XTextComponent)UnoRuntime.queryInterface(XTextComponent.class, (Object)this.lstGreeting)).getText().equals("")) {
            xTextComponent.setText(this.resources.GreetingLabels[0]);
        }
    }

    public void lstGreetingItemChanged() {
        XTextComponent xTextComponent = (XTextComponent)UnoRuntime.queryInterface(XTextComponent.class, (Object)this.lstGreeting);
        myLetterDoc.switchUserField("Greeting", xTextComponent.getText(), this.chkUseGreeting.getState() != 0);
    }

    public void lstGreetingTextChanged() {
    }

    public void chkBusinessPaperItemChanged() {
        if (this.chkBusinessPaper.getState() != 0) {
            this.enableBusinessPaper();
        } else {
            this.disableBusinessPaper();
            this.setPossibleSenderData(true);
        }
    }

    private int getOfficeLinguistic() {
        int n = 0;
        String string = Configuration.getOfficeLinguistic((XMultiServiceFactory)this.xMSF);
        for (int i = 0; i < this.Norms.length; ++i) {
            if (!this.Norms[i].equalsIgnoreCase(string)) continue;
            n = i;
        }
        return n;
    }

    private void setPossibleSenderData(boolean bl) {
        this.setControlProperty("optSenderDefine", "Enabled", new Boolean(bl));
        this.setControlProperty("optSenderPlaceholder", "Enabled", new Boolean(bl));
        this.setControlProperty("lblSenderAddress", "Enabled", new Boolean(bl));
        if (!bl) {
            this.setControlProperty("txtSenderCity", "Enabled", new Boolean(bl));
            this.setControlProperty("txtSenderName", "Enabled", new Boolean(bl));
            this.setControlProperty("txtSenderPostCode", "Enabled", new Boolean(bl));
            this.setControlProperty("txtSenderStreet", "Enabled", new Boolean(bl));
            this.setControlProperty("txtSenderCity", "Enabled", new Boolean(bl));
            this.setControlProperty("txtSenderState", "Enabled", new Boolean(bl));
            this.setControlProperty("lblSenderName", "Enabled", new Boolean(bl));
            this.setControlProperty("lblSenderStreet", "Enabled", new Boolean(bl));
            this.setControlProperty("lblPostCodeCity", "Enabled", new Boolean(bl));
        }
    }

    private void enableSenderReceiver() {
        XInterface xInterface = this.getRoadmapItemByID(4);
        Helper.setUnoPropertyValue((Object)xInterface, (String)"Enabled", (Object)Boolean.TRUE);
    }

    private void disableSenderReceiver() {
        XInterface xInterface = this.getRoadmapItemByID(4);
        Helper.setUnoPropertyValue((Object)xInterface, (String)"Enabled", (Object)Boolean.FALSE);
    }

    private void enableBusinessPaper() {
        XInterface xInterface = this.getRoadmapItemByID(2);
        Helper.setUnoPropertyValue((Object)xInterface, (String)"Enabled", (Object)Boolean.TRUE);
        this.chkPaperCompanyLogoItemChanged();
        this.chkPaperCompanyAddressItemChanged();
        this.chkPaperFooterItemChanged();
        this.chkCompanyReceiverItemChanged();
    }

    private void disableBusinessPaper() {
        XInterface xInterface = this.getRoadmapItemByID(2);
        Helper.setUnoPropertyValue((Object)xInterface, (String)"Enabled", (Object)Boolean.FALSE);
        if (this.BusCompanyLogo != null) {
            this.BusCompanyLogo.removeFrame();
        }
        if (this.BusCompanyAddress != null) {
            this.BusCompanyAddress.removeFrame();
        }
        if (this.BusFooter != null) {
            this.BusFooter.removeFrame();
        }
        if (this.BusCompanyAddressReceiver != null) {
            this.BusCompanyAddressReceiver.removeFrame();
        }
        this.setPossibleAddressReceiver(true);
        this.setPossibleFooter(true);
        this.setPossibleLogo(true);
        if (myLetterDoc.hasElement("Sender Address")) {
            myLetterDoc.switchElement("Sender Address", true);
        }
    }

    public void lstLetterNormItemChanged() {
        this.sCurrentNorm = this.Norms[this.getCurrentLetter().cp_Norm];
        this.initializeTemplates(this.xMSF);
        if (this.optBusinessLetter.getState()) {
            this.lstBusinessStyleItemChanged();
        }
        if (this.optPrivOfficialLetter.getState()) {
            this.lstPrivOfficialStyleItemChanged();
        }
        if (this.optPrivateLetter.getState()) {
            this.lstPrivateStyleItemChanged();
        }
    }

    public void initializeSalutation() {
        this.setControlProperty("lstSalutation", "StringItemList", this.resources.SalutationLabels);
    }

    public void initializeGreeting() {
        this.setControlProperty("lstGreeting", "StringItemList", this.resources.GreetingLabels);
    }

    public void initializeNorms() {
        int n;
        String[] stringArray;
        Object object;
        Object object2;
        String[] stringArray2;
        LocaleCodes localeCodes = new LocaleCodes(this.xmsf);
        String[] stringArray3 = localeCodes.getIDs();
        Object[] objectArray = new Object[]{"", ""};
        String[] stringArray4 = new String[]{"", ""};
        String[] stringArray5 = new String[]{"", ""};
        Vector<String> vector = new Vector<String>();
        String string = "/wizard/letter/";
        try {
            int n2;
            this.sTemplatePath = FileAccess.deleteLastSlashfromUrl((String)this.sTemplatePath);
            stringArray2 = this.sTemplatePath.split("/");
            object2 = "";
            for (int i = 0; i < stringArray2.length - 1; ++i) {
                object2 = (String)object2 + stringArray2[i] + "/";
            }
            object = object2;
            object = FileAccess.deleteLastSlashfromUrl((String)object);
            this.sLetterPath = (String)object + string;
            stringArray = (String[])this.xMSF.createInstance("com.sun.star.ucb.SimpleFileAccess");
            XSimpleFileAccess xSimpleFileAccess = (XSimpleFileAccess)UnoRuntime.queryInterface(XSimpleFileAccess.class, (Object)stringArray);
            stringArray4 = xSimpleFileAccess.getFolderContents((String)object, true);
            stringArray5 = xSimpleFileAccess.getFolderContents(this.sLetterPath, true);
            for (n2 = 0; n2 < stringArray4.length; ++n2) {
                String string2 = FileAccess.getFilename((String)stringArray4[n2]);
                if (string2.equalsIgnoreCase("wizard")) continue;
                vector.add(stringArray4[n2] + string + string2);
            }
            for (n2 = 0; n2 < stringArray5.length; ++n2) {
                boolean bl = false;
                for (n = 0; n < stringArray4.length; ++n) {
                    if (!FileAccess.getFilename((String)stringArray5[n2]).equalsIgnoreCase(FileAccess.getFilename((String)stringArray4[n]))) continue;
                    bl = true;
                }
                if (bl) continue;
                vector.add(stringArray5[n2]);
            }
            objectArray = vector.toArray();
        }
        catch (CommandAbortedException commandAbortedException) {
            commandAbortedException.printStackTrace();
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace();
        }
        stringArray2 = new Vector();
        object2 = new Vector();
        object = new Vector();
        boolean bl = false;
        String string3 = "";
        String string4 = "";
        n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            String[] stringArray6;
            int n3;
            bl = false;
            string3 = FileAccess.getFilename((String)((String)objectArray[i]));
            for (n3 = 0; n3 < stringArray3.length; ++n3) {
                stringArray6 = stringArray3[n3].split(";");
                if (!string3.equalsIgnoreCase(stringArray6[1])) continue;
                string4 = stringArray6[2];
                bl = true;
                n3 = stringArray3.length;
            }
            if (!bl) {
                for (n3 = 0; n3 < stringArray3.length; ++n3) {
                    stringArray6 = stringArray3[n3].split(";");
                    if (!string3.equalsIgnoreCase(stringArray6[1].substring(0, 2))) continue;
                    string4 = stringArray6[2];
                    bl = true;
                    n3 = stringArray3.length;
                }
            }
            if (!bl) continue;
            stringArray2.add(string3);
            ((Vector)object2).add((String)objectArray[i]);
            ((Vector)object).add(localeCodes.getLanguageString(string4));
        }
        this.Norms = new String[stringArray2.size()];
        stringArray2.toArray(this.Norms);
        this.NormPaths = new String[((Vector)object2).size()];
        ((Vector)object2).toArray(this.NormPaths);
        stringArray = new String[((Vector)object).size()];
        ((Vector)object).toArray(stringArray);
        this.setControlProperty("lstLetterNorm", "StringItemList", stringArray);
    }

    private CGLetter getCurrentLetter() {
        switch (this.myConfig.cp_LetterType) {
            case 0: {
                return this.myConfig.cp_BusinessLetter;
            }
            case 1: {
                return this.myConfig.cp_PrivateOfficialLetter;
            }
            case 2: {
                return this.myConfig.cp_PrivateLetter;
            }
        }
        return null;
    }

    private void initializePaths() {
        try {
            this.sTemplatePath = FileAccess.getOfficePath((XMultiServiceFactory)this.xMSF, (String)"Template", (String)"share", (String)"/wizard");
            this.sUserTemplatePath = FileAccess.getOfficePath((XMultiServiceFactory)this.xMSF, (String)"Template", (String)"user", (String)"");
            this.sBitmapPath = FileAccess.combinePaths((XMultiServiceFactory)this.xMSF, (String)this.sTemplatePath, (String)"/wizard/bitmap");
        }
        catch (NoValidPathException noValidPathException) {
            noValidPathException.printStackTrace();
        }
    }

    public boolean initializeTemplates(XMultiServiceFactory xMultiServiceFactory) {
        this.sCurrentNorm = this.Norms[this.getCurrentLetter().cp_Norm];
        String string = this.NormPaths[this.getCurrentLetter().cp_Norm];
        this.BusinessFiles = FileAccess.getFolderTitles((XMultiServiceFactory)xMultiServiceFactory, (String)"bus", (String)string);
        this.OfficialFiles = FileAccess.getFolderTitles((XMultiServiceFactory)xMultiServiceFactory, (String)"off", (String)string);
        this.PrivateFiles = FileAccess.getFolderTitles((XMultiServiceFactory)xMultiServiceFactory, (String)"pri", (String)string);
        this.setControlProperty("lstBusinessStyle", "StringItemList", this.BusinessFiles[0]);
        this.setControlProperty("lstPrivOfficialStyle", "StringItemList", this.OfficialFiles[0]);
        this.setControlProperty("lstPrivateStyle", "StringItemList", this.PrivateFiles[0]);
        this.setControlProperty("lstBusinessStyle", "SelectedItems", new short[]{0});
        this.setControlProperty("lstPrivOfficialStyle", "SelectedItems", new short[]{0});
        this.setControlProperty("lstPrivateStyle", "SelectedItems", new short[]{0});
        return true;
    }

    public void initializeElements() {
        this.setControlProperty("chkUseLogo", "Enabled", new Boolean(myLetterDoc.hasElement("Company Logo")));
        this.setControlProperty("chkUseBendMarks", "Enabled", new Boolean(myLetterDoc.hasElement("Bend Marks")));
        this.setControlProperty("chkUseAddressReceiver", "Enabled", new Boolean(myLetterDoc.hasElement("Sender Address Repeated")));
        this.setControlProperty("chkUseSubject", "Enabled", new Boolean(myLetterDoc.hasElement("Subject Line")));
        this.setControlProperty("chkUseSigns", "Enabled", new Boolean(myLetterDoc.hasElement("Letter Signs")));
        myLetterDoc.updateDateFields();
    }

    public void setConfiguration() {
        if (this.optBusinessLetter.getState()) {
            this.optBusinessLetterItemChanged();
        }
        if (this.optPrivOfficialLetter.getState()) {
            this.optPrivOfficialLetterItemChanged();
        }
        if (this.optPrivateLetter.getState()) {
            this.optPrivateLetterItemChanged();
        }
    }

    public void setElements(boolean bl) {
        if (this.optSenderDefine.getState()) {
            this.optSenderDefineItemChanged();
        }
        if (this.optSenderPlaceholder.getState()) {
            this.optSenderPlaceholderItemChanged();
        }
        this.chkUseSignsItemChanged();
        this.chkUseSubjectItemChanged();
        this.chkUseSalutationItemChanged();
        this.chkUseGreetingItemChanged();
        this.chkUseBendMarksItemChanged();
        this.chkUseAddressReceiverItemChanged();
        this.txtTemplateNameTextChanged();
        if (this.optReceiverDatabase.getState() && !bl) {
            this.optReceiverDatabaseItemChanged();
        }
        if (this.optReceiverPlaceholder.getState() && !bl) {
            this.optReceiverPlaceholderItemChanged();
        }
        if (this.optCreateLetter.getState()) {
            this.optCreateLetterItemChanged();
        }
        if (this.optMakeChanges.getState()) {
            this.optMakeChangesItemChanged();
        }
    }

    public void insertRoadmap() {
        this.addRoadmap();
        int n = 0;
        n = this.insertRoadmapItem(0, true, this.resources.RoadmapLabels[1], 1);
        n = this.insertRoadmapItem(n, false, this.resources.RoadmapLabels[2], 2);
        n = this.insertRoadmapItem(n, true, this.resources.RoadmapLabels[3], 3);
        n = this.insertRoadmapItem(n, true, this.resources.RoadmapLabels[4], 4);
        n = this.insertRoadmapItem(n, false, this.resources.RoadmapLabels[5], 5);
        n = this.insertRoadmapItem(n, true, this.resources.RoadmapLabels[6], 6);
        this.setRoadmapInteractive(true);
        this.setRoadmapComplete(true);
        this.setCurrentRoadmapItemID((short)1);
    }

    public void insertPathSelectionControl() {
        this.myPathSelection = new PathSelection(this.xMSF, (UnoDialog2)this, 0, 1);
        this.myPathSelection.insert(6, 97, 70, 205, (short)45, this.resources.reslblTemplatePath_value, true, "HID:40815", "HID:40816");
        this.myPathSelection.sDefaultDirectory = this.sUserTemplatePath;
        this.myPathSelection.sDefaultName = "myLetterTemplate.ott";
        this.myPathSelection.sDefaultFilter = "writer8_template";
        this.myPathSelection.addSelectionListener((XPathSelectionListener)new myPathSelectionListener());
    }

    public void initConfiguration() {
        try {
            this.myConfig = new CGLetterWizard();
            Object object = Configuration.getConfigurationRoot((XMultiServiceFactory)this.xMSF, (String)"/org.openoffice.Office.Writer/Wizards/Letter", (boolean)false);
            this.myConfig.readConfiguration(object, "cp_");
            this.mainDA.add(RadioDataAware.attachRadioButtons((Object)((Object)this.myConfig), (String)"cp_LetterType", (Object[])new Object[]{this.optBusinessLetter, this.optPrivOfficialLetter, this.optPrivateLetter}, null, (boolean)true));
            this.mainDA.add(UnoDataAware.attachListBox((Object)((Object)this.myConfig.cp_BusinessLetter), (String)"cp_Style", (Object)this.lstBusinessStyle, null, (boolean)true));
            this.mainDA.add(UnoDataAware.attachListBox((Object)((Object)this.myConfig.cp_PrivateOfficialLetter), (String)"cp_Style", (Object)this.lstPrivOfficialStyle, null, (boolean)true));
            this.mainDA.add(UnoDataAware.attachListBox((Object)((Object)this.myConfig.cp_PrivateLetter), (String)"cp_Style", (Object)this.lstPrivateStyle, null, (boolean)true));
            this.mainDA.add(UnoDataAware.attachCheckBox((Object)((Object)this.myConfig.cp_BusinessLetter), (String)"cp_BusinessPaper", (Object)this.chkBusinessPaper, null, (boolean)true));
            CGLetter cGLetter = this.myConfig.cp_BusinessLetter;
            CGPaperElementLocation cGPaperElementLocation = this.myConfig.cp_BusinessLetter.cp_CompanyLogo;
            CGPaperElementLocation cGPaperElementLocation2 = this.myConfig.cp_BusinessLetter.cp_CompanyAddress;
            this.businessDA.add(UnoDataAware.attachCheckBox((Object)((Object)cGPaperElementLocation), (String)"cp_Display", (Object)this.chkPaperCompanyLogo, null, (boolean)true));
            this.businessDA.add(UnoDataAware.attachNumericControl((Object)((Object)cGPaperElementLocation), (String)"cp_Width", (Object)this.numLogoWidth, null, (boolean)true));
            this.businessDA.add(UnoDataAware.attachNumericControl((Object)((Object)cGPaperElementLocation), (String)"cp_Height", (Object)this.numLogoHeight, null, (boolean)true));
            this.businessDA.add(UnoDataAware.attachNumericControl((Object)((Object)cGPaperElementLocation), (String)"cp_X", (Object)this.numLogoX, null, (boolean)true));
            this.businessDA.add(UnoDataAware.attachNumericControl((Object)((Object)cGPaperElementLocation), (String)"cp_Y", (Object)this.numLogoY, null, (boolean)true));
            this.businessDA.add(UnoDataAware.attachCheckBox((Object)((Object)cGPaperElementLocation2), (String)"cp_Display", (Object)this.chkPaperCompanyAddress, null, (boolean)true));
            this.businessDA.add(UnoDataAware.attachNumericControl((Object)((Object)cGPaperElementLocation2), (String)"cp_Width", (Object)this.numAddressWidth, null, (boolean)true));
            this.businessDA.add(UnoDataAware.attachNumericControl((Object)((Object)cGPaperElementLocation2), (String)"cp_Height", (Object)this.numAddressHeight, null, (boolean)true));
            this.businessDA.add(UnoDataAware.attachNumericControl((Object)((Object)cGPaperElementLocation2), (String)"cp_X", (Object)this.numAddressX, null, (boolean)true));
            this.businessDA.add(UnoDataAware.attachNumericControl((Object)((Object)cGPaperElementLocation2), (String)"cp_Y", (Object)this.numAddressY, null, (boolean)true));
            this.businessDA.add(UnoDataAware.attachCheckBox((Object)((Object)cGLetter), (String)"cp_PaperCompanyAddressReceiverField", (Object)this.chkCompanyReceiver, null, (boolean)true));
            this.businessDA.add(UnoDataAware.attachCheckBox((Object)((Object)cGLetter), (String)"cp_PaperFooter", (Object)this.chkPaperFooter, null, (boolean)true));
            this.businessDA.add(UnoDataAware.attachNumericControl((Object)((Object)cGLetter), (String)"cp_PaperFooterHeight", (Object)this.numFooterHeight, null, (boolean)true));
            this.letterDA.add(UnoDataAware.attachListBox((Object)((Object)cGLetter), (String)"cp_Norm", (Object)this.lstLetterNorm, null, (boolean)true));
            this.letterDA.add(UnoDataAware.attachCheckBox((Object)((Object)cGLetter), (String)"cp_PrintCompanyLogo", (Object)this.chkUseLogo, null, (boolean)true));
            this.letterDA.add(UnoDataAware.attachCheckBox((Object)((Object)cGLetter), (String)"cp_PrintCompanyAddressReceiverField", (Object)this.chkUseAddressReceiver, null, (boolean)true));
            this.letterDA.add(UnoDataAware.attachCheckBox((Object)((Object)cGLetter), (String)"cp_PrintLetterSigns", (Object)this.chkUseSigns, null, (boolean)true));
            this.letterDA.add(UnoDataAware.attachCheckBox((Object)((Object)cGLetter), (String)"cp_PrintSubjectLine", (Object)this.chkUseSubject, null, (boolean)true));
            this.letterDA.add(UnoDataAware.attachCheckBox((Object)((Object)cGLetter), (String)"cp_PrintSalutation", (Object)this.chkUseSalutation, null, (boolean)true));
            this.letterDA.add(UnoDataAware.attachCheckBox((Object)((Object)cGLetter), (String)"cp_PrintBendMarks", (Object)this.chkUseBendMarks, null, (boolean)true));
            this.letterDA.add(UnoDataAware.attachCheckBox((Object)((Object)cGLetter), (String)"cp_PrintGreeting", (Object)this.chkUseGreeting, null, (boolean)true));
            this.letterDA.add(UnoDataAware.attachCheckBox((Object)((Object)cGLetter), (String)"cp_PrintFooter", (Object)this.chkUseFooter, null, (boolean)true));
            this.letterDA.add(UnoDataAware.attachEditControl((Object)((Object)cGLetter), (String)"cp_Salutation", (Object)this.lstSalutation, null, (boolean)true));
            this.letterDA.add(UnoDataAware.attachEditControl((Object)((Object)cGLetter), (String)"cp_Greeting", (Object)this.lstGreeting, null, (boolean)true));
            this.letterDA.add(RadioDataAware.attachRadioButtons((Object)((Object)cGLetter), (String)"cp_SenderAddressType", (Object[])new Object[]{this.optSenderDefine, this.optSenderPlaceholder}, null, (boolean)true));
            this.letterDA.add(UnoDataAware.attachEditControl((Object)((Object)cGLetter), (String)"cp_SenderCompanyName", (Object)this.txtSenderName, null, (boolean)true));
            this.letterDA.add(UnoDataAware.attachEditControl((Object)((Object)cGLetter), (String)"cp_SenderStreet", (Object)this.txtSenderStreet, null, (boolean)true));
            this.letterDA.add(UnoDataAware.attachEditControl((Object)((Object)cGLetter), (String)"cp_SenderPostCode", (Object)this.txtSenderPostCode, null, (boolean)true));
            this.letterDA.add(UnoDataAware.attachEditControl((Object)((Object)cGLetter), (String)"cp_SenderState", (Object)this.txtSenderState, null, (boolean)true));
            this.letterDA.add(UnoDataAware.attachEditControl((Object)((Object)cGLetter), (String)"cp_SenderCity", (Object)this.txtSenderCity, null, (boolean)true));
            this.letterDA.add(RadioDataAware.attachRadioButtons((Object)((Object)cGLetter), (String)"cp_ReceiverAddressType", (Object[])new Object[]{this.optReceiverDatabase, this.optReceiverPlaceholder}, null, (boolean)true));
            this.letterDA.add(UnoDataAware.attachEditControl((Object)((Object)cGLetter), (String)"cp_Footer", (Object)this.txtFooter, null, (boolean)true));
            this.letterDA.add(UnoDataAware.attachCheckBox((Object)((Object)cGLetter), (String)"cp_FooterOnlySecondPage", (Object)this.chkFooterNextPages, null, (boolean)true));
            this.letterDA.add(UnoDataAware.attachCheckBox((Object)((Object)cGLetter), (String)"cp_FooterPageNumbers", (Object)this.chkFooterPageNumbers, null, (boolean)true));
            this.letterDA.add(RadioDataAware.attachRadioButtons((Object)((Object)cGLetter), (String)"cp_CreationType", (Object[])new Object[]{this.optCreateLetter, this.optMakeChanges}, null, (boolean)true));
            this.letterDA.add(UnoDataAware.attachEditControl((Object)((Object)cGLetter), (String)"cp_TemplateName", (Object)this.txtTemplateName, null, (boolean)true));
            this.letterDA.add(UnoDataAware.attachEditControl((Object)((Object)cGLetter), (String)"cp_TemplatePath", (Object)this.myPathSelection.xSaveTextBox, null, (boolean)true));
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace();
        }
    }

    private void updateUI() {
        UnoDataAware.updateUI((Collection)this.mainDA);
        UnoDataAware.updateUI((Collection)this.letterDA);
        UnoDataAware.updateUI((Collection)this.businessDA);
    }

    public void saveConfiguration() {
        try {
            Object object = Configuration.getConfigurationRoot((XMultiServiceFactory)this.xMSF, (String)"/org.openoffice.Office.Writer/Wizards/Letter", (boolean)true);
            this.myConfig.writeConfiguration(object, "cp_");
            Configuration.commit((Object)object);
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace();
        }
    }

    private class myPathSelectionListener
    implements XPathSelectionListener {
        private myPathSelectionListener() {
        }

        public void validatePath() {
            if (LetterWizardDialogImpl.this.myPathSelection.usedPathPicker) {
                LetterWizardDialogImpl.this.filenameChanged = true;
            }
            LetterWizardDialogImpl.this.myPathSelection.usedPathPicker = false;
        }
    }
}

