/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class ObjArray
implements Serializable {
    static final long serialVersionUID = 7448768847663119705L;
    private int size;
    private static final int FIELDS_STORE_SIZE = 6;
    private transient Object f0;
    private transient Object f1;
    private transient Object f2;
    private transient Object f3;
    private transient Object f4;
    private transient Object f5;
    private transient Object[] data;

    public ObjArray() {
    }

    public ObjArray(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n > 6) {
            this.data = new Object[n - 6];
        }
    }

    public final boolean isEmpty() {
        return this.size == 0;
    }

    public final int size() {
        return this.size;
    }

    public final void setSize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        int n2 = this.size;
        if (n < n2) {
            for (int i = n; i != n2; ++i) {
                this.setImpl(i, null);
            }
        } else if (n > n2 && n > 6) {
            this.ensureCapacity(n);
        }
        this.size = n;
    }

    public final Object get(int n) {
        if (0 > n || n >= this.size) {
            throw ObjArray.invalidIndex(n, this.size);
        }
        return this.getImpl(n);
    }

    public final void set(int n, Object object) {
        if (0 > n || n >= this.size) {
            throw ObjArray.invalidIndex(n, this.size);
        }
        this.setImpl(n, object);
    }

    private Object getImpl(int n) {
        switch (n) {
            case 0: {
                return this.f0;
            }
            case 1: {
                return this.f1;
            }
            case 2: {
                return this.f2;
            }
            case 3: {
                return this.f3;
            }
            case 4: {
                return this.f4;
            }
            case 5: {
                return this.f5;
            }
        }
        return this.data[n - 6];
    }

    private void setImpl(int n, Object object) {
        switch (n) {
            case 0: {
                this.f0 = object;
                break;
            }
            case 1: {
                this.f1 = object;
                break;
            }
            case 2: {
                this.f2 = object;
                break;
            }
            case 3: {
                this.f3 = object;
                break;
            }
            case 4: {
                this.f4 = object;
                break;
            }
            case 5: {
                this.f5 = object;
                break;
            }
            default: {
                this.data[n - 6] = object;
            }
        }
    }

    public int indexOf(Object object) {
        int n = this.size;
        for (int i = 0; i != n; ++i) {
            Object object2 = this.getImpl(i);
            if (object2 != object && (object2 == null || !object2.equals(object))) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(Object object) {
        int n = this.size;
        while (n != 0) {
            Object object2;
            if ((object2 = this.getImpl(--n)) != object && (object2 == null || !object2.equals(object))) continue;
            return n;
        }
        return -1;
    }

    public final Object peek() {
        int n = this.size;
        if (n == 0) {
            throw ObjArray.invalidEmptyStackAccess();
        }
        return this.getImpl(n - 1);
    }

    public final Object pop() {
        Object object;
        int n = this.size;
        switch (--n) {
            case -1: {
                throw ObjArray.invalidEmptyStackAccess();
            }
            case 0: {
                object = this.f0;
                this.f0 = null;
                break;
            }
            case 1: {
                object = this.f1;
                this.f1 = null;
                break;
            }
            case 2: {
                object = this.f2;
                this.f2 = null;
                break;
            }
            case 3: {
                object = this.f3;
                this.f3 = null;
                break;
            }
            case 4: {
                object = this.f4;
                this.f4 = null;
                break;
            }
            case 5: {
                object = this.f5;
                this.f5 = null;
                break;
            }
            default: {
                object = this.data[n - 6];
                this.data[n - 6] = null;
            }
        }
        this.size = n;
        return object;
    }

    public final void push(Object object) {
        this.add(object);
    }

    public final void add(Object object) {
        int n = this.size;
        if (n >= 6) {
            this.ensureCapacity(n + 1);
        }
        this.size = n + 1;
        this.setImpl(n, object);
    }

    public final void add(int n, Object object) {
        int n2 = this.size;
        if (0 > n || n > n2) {
            throw ObjArray.invalidIndex(n, n2 + 1);
        }
        switch (n) {
            case 0: {
                if (n2 == 0) {
                    this.f0 = object;
                    break;
                }
                Object object2 = this.f0;
                this.f0 = object;
                object = object2;
            }
            case 1: {
                if (n2 == 1) {
                    this.f1 = object;
                    break;
                }
                Object object2 = this.f1;
                this.f1 = object;
                object = object2;
            }
            case 2: {
                if (n2 == 2) {
                    this.f2 = object;
                    break;
                }
                Object object2 = this.f2;
                this.f2 = object;
                object = object2;
            }
            case 3: {
                if (n2 == 3) {
                    this.f3 = object;
                    break;
                }
                Object object2 = this.f3;
                this.f3 = object;
                object = object2;
            }
            case 4: {
                if (n2 == 4) {
                    this.f4 = object;
                    break;
                }
                Object object2 = this.f4;
                this.f4 = object;
                object = object2;
            }
            case 5: {
                if (n2 == 5) {
                    this.f5 = object;
                    break;
                }
                Object object2 = this.f5;
                this.f5 = object;
                object = object2;
                n = 6;
            }
            default: {
                this.ensureCapacity(n2 + 1);
                if (n != n2) {
                    System.arraycopy(this.data, n - 6, this.data, n - 6 + 1, n2 - n);
                }
                this.data[n - 6] = object;
            }
        }
        this.size = n2 + 1;
    }

    public final void remove(int n) {
        int n2 = this.size;
        if (0 > n || n >= n2) {
            throw ObjArray.invalidIndex(n, n2);
        }
        --n2;
        switch (n) {
            case 0: {
                if (n2 == 0) {
                    this.f0 = null;
                    break;
                }
                this.f0 = this.f1;
            }
            case 1: {
                if (n2 == 1) {
                    this.f1 = null;
                    break;
                }
                this.f1 = this.f2;
            }
            case 2: {
                if (n2 == 2) {
                    this.f2 = null;
                    break;
                }
                this.f2 = this.f3;
            }
            case 3: {
                if (n2 == 3) {
                    this.f3 = null;
                    break;
                }
                this.f3 = this.f4;
            }
            case 4: {
                if (n2 == 4) {
                    this.f4 = null;
                    break;
                }
                this.f4 = this.f5;
            }
            case 5: {
                if (n2 == 5) {
                    this.f5 = null;
                    break;
                }
                this.f5 = this.data[0];
                n = 6;
            }
            default: {
                if (n != n2) {
                    System.arraycopy(this.data, n - 6 + 1, this.data, n - 6, n2 - n);
                }
                this.data[n2 - 6] = null;
            }
        }
        this.size = n2;
    }

    public final void clear() {
        int n = this.size;
        for (int i = 0; i != n; ++i) {
            this.setImpl(i, null);
        }
        this.size = 0;
    }

    public final Object[] toArray() {
        Object[] objectArray = new Object[this.size];
        this.toArray(objectArray, 0);
        return objectArray;
    }

    public final void toArray(Object[] objectArray) {
        this.toArray(objectArray, 0);
    }

    public final void toArray(Object[] objectArray, int n) {
        int n2 = this.size;
        switch (n2) {
            default: {
                System.arraycopy(this.data, 0, objectArray, n + 6, n2 - 6);
            }
            case 6: {
                objectArray[n + 5] = this.f5;
            }
            case 5: {
                objectArray[n + 4] = this.f4;
            }
            case 4: {
                objectArray[n + 3] = this.f3;
            }
            case 3: {
                objectArray[n + 2] = this.f2;
            }
            case 2: {
                objectArray[n + 1] = this.f1;
            }
            case 1: {
                objectArray[n + 0] = this.f0;
            }
            case 0: 
        }
    }

    private void ensureCapacity(int n) {
        int n2 = n - 6;
        if (n2 <= 0) {
            throw new IllegalArgumentException();
        }
        if (this.data == null) {
            int n3 = 12;
            if (n3 < n2) {
                n3 = n2;
            }
            this.data = new Object[n3];
        } else {
            int n4 = this.data.length;
            if (n4 < n2) {
                n4 = n4 <= 6 ? 12 : (n4 *= 2);
                if (n4 < n2) {
                    n4 = n2;
                }
                Object[] objectArray = new Object[n4];
                if (this.size > 6) {
                    System.arraycopy(this.data, 0, objectArray, 0, this.size - 6);
                }
                this.data = objectArray;
            }
        }
    }

    private static RuntimeException invalidIndex(int n, int n2) {
        String string = n + " \u2209 [0, " + n2 + ')';
        return new IndexOutOfBoundsException(string);
    }

    private static RuntimeException invalidEmptyStackAccess() {
        throw new RuntimeException("Empty stack");
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        int n = this.size;
        for (int i = 0; i != n; ++i) {
            Object object = this.getImpl(i);
            objectOutputStream.writeObject(object);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = this.size;
        if (n > 6) {
            this.data = new Object[n - 6];
        }
        for (int i = 0; i != n; ++i) {
            Object object = objectInputStream.readObject();
            this.setImpl(i, object);
        }
    }
}

