/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import org.mozilla.classfile.ClassFileWriter;
import org.mozilla.javascript.ClassNameHelper;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.GeneratedClassLoader;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.NativeJavaClass;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SecurityController;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.WrappedException;

public class JavaAdapter
extends ScriptableObject {
    private static int serial;
    private static Hashtable generatedClasses;

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public String getClassName() {
        return "JavaAdapter";
    }

    public static Object convertResult(Object object, Class clazz) {
        if (object == Undefined.instance && clazz != ScriptRuntime.ObjectClass && clazz != ScriptRuntime.StringClass) {
            return null;
        }
        return NativeJavaObject.coerceType(clazz, object, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Scriptable setAdapterProto(Scriptable scriptable, Object object) {
        Context context = Context.enter();
        try {
            Scriptable scriptable2 = ScriptableObject.getTopLevelScope(scriptable);
            Scriptable scriptable3 = ScriptRuntime.toObject(scriptable2, object);
            scriptable3.setPrototype(scriptable);
            Scriptable scriptable4 = scriptable3;
            return scriptable4;
        }
        finally {
            context.exit();
        }
    }

    public static Object getAdapterSelf(Class clazz, Object object) throws NoSuchFieldException, IllegalAccessException {
        Field field = clazz.getDeclaredField("self");
        return field.get(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Object jsConstructor(Context context, Object[] objectArray, Function function, boolean bl) throws InstantiationException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, NoSuchFieldException {
        Object object;
        Object[] objectArray2;
        Object object2;
        Class clazz = null;
        Class[] classArray = new Class[objectArray.length - 1];
        int n = 0;
        for (int i = 0; i < objectArray.length - 1; ++i) {
            if (!(objectArray[i] instanceof NativeJavaClass)) {
                throw NativeGlobal.constructError(context, "TypeError", "expected java class object", function);
            }
            object2 = ((NativeJavaClass)objectArray[i]).getClassObject();
            if (!((Class)object2).isInterface()) {
                if (clazz != null) {
                    String string = "Only one class may be extended by a JavaAdapter. Had " + clazz.getName() + " and " + ((Class)object2).getName();
                    throw NativeGlobal.constructError(context, "TypeError", string, function);
                }
                clazz = object2;
                continue;
            }
            classArray[n++] = object2;
        }
        if (clazz == null) {
            clazz = Object.class;
        }
        Class[] classArray2 = new Class[n];
        System.arraycopy(classArray, 0, classArray2, 0, n);
        object2 = (Scriptable)objectArray[objectArray.length - 1];
        ClassSignature classSignature = new ClassSignature(clazz, classArray2, (Scriptable)object2);
        Class clazz2 = (Class)generatedClasses.get(classSignature);
        if (clazz2 == null) {
            objectArray2 = generatedClasses;
            // MONITORENTER : generatedClasses
            object = "adapter" + serial++;
            // MONITOREXIT : objectArray2
            clazz2 = JavaAdapter.createAdapterClass(context, (Scriptable)object2, (String)object, clazz, classArray2, null, null);
            generatedClasses.put(classSignature, clazz2);
        }
        object = new Class[]{Scriptable.class};
        objectArray2 = new Object[]{object2};
        Object t = clazz2.getConstructor((Class<?>)object).newInstance(objectArray2);
        return JavaAdapter.getAdapterSelf(clazz2, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object createAdapterClass(Class clazz, Class[] classArray, Scriptable scriptable, Scriptable scriptable2) throws ClassNotFoundException {
        Object object;
        Object[] objectArray;
        ClassSignature classSignature = new ClassSignature(clazz, classArray, scriptable);
        Class clazz2 = (Class)generatedClasses.get(classSignature);
        if (clazz2 == null) {
            objectArray = generatedClasses;
            synchronized (objectArray) {
                object = "adapter" + serial++;
            }
            objectArray = Context.enter();
            try {
                clazz2 = JavaAdapter.createAdapterClass((Context)objectArray, scriptable, (String)object, clazz, classArray, null, null);
                generatedClasses.put(classSignature, clazz2);
            }
            finally {
                Context.exit();
            }
        }
        try {
            object = new Class[]{Scriptable.class, Scriptable.class};
            objectArray = new Object[]{scriptable, scriptable2};
            return clazz2.getConstructor((Class<?>)object).newInstance(objectArray);
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        throw new ClassNotFoundException("adapter");
    }

    public static Class createAdapterClass(Context context, Scriptable scriptable, String string, Class clazz, Class[] classArray, String string2, ClassNameHelper classNameHelper) throws ClassNotFoundException {
        GeneratedClassLoader generatedClassLoader;
        Object object;
        Object object2;
        Object object3;
        String string3;
        int n;
        ClassFileWriter classFileWriter = new ClassFileWriter(string, clazz.getName(), "<adapter>");
        classFileWriter.addField("delegee", "Lorg/mozilla/javascript/Scriptable;", (short)17);
        classFileWriter.addField("self", "Lorg/mozilla/javascript/Scriptable;", (short)17);
        int n2 = classArray == null ? 0 : classArray.length;
        for (int i = 0; i < n2; ++i) {
            if (classArray[i] == null) continue;
            classFileWriter.addInterface(classArray[i].getName());
        }
        String string4 = clazz.getName().replace('.', '/');
        JavaAdapter.generateCtor(classFileWriter, string, string4);
        JavaAdapter.generateSerialCtor(classFileWriter, string, string4);
        if (string2 != null) {
            JavaAdapter.generateEmptyCtor(classFileWriter, string, string4, string2);
        }
        ObjToIntMap objToIntMap = new ObjToIntMap();
        ObjToIntMap objToIntMap2 = new ObjToIntMap();
        for (int i = 0; i < n2; ++i) {
            Method[] methodArray = classArray[i].getMethods();
            for (int j = 0; j < methodArray.length; ++j) {
                Method method = methodArray[j];
                n = method.getModifiers();
                if (Modifier.isStatic(n) || Modifier.isFinal(n) || scriptable == null) continue;
                if (!ScriptableObject.hasProperty(scriptable, method.getName())) {
                    try {
                        clazz.getMethod(method.getName(), method.getParameterTypes());
                        continue;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
                if (objToIntMap.has(string3 = (String)(object3 = method.getName()) + JavaAdapter.getMethodSignature(method))) continue;
                JavaAdapter.generateMethod(classFileWriter, string, (String)object3, method.getParameterTypes(), method.getReturnType());
                objToIntMap.put(string3, 0);
                objToIntMap2.put(object3, 0);
            }
        }
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            int n3 = method.getModifiers();
            if (Modifier.isStatic(n3) || Modifier.isFinal(n3) || (n = (int)(Modifier.isAbstract(n3) ? 1 : 0)) == 0 && (scriptable == null || !ScriptableObject.hasProperty(scriptable, method.getName()))) continue;
            object3 = method.getName();
            string3 = JavaAdapter.getMethodSignature(method);
            object2 = (String)object3 + string3;
            if (!objToIntMap.has(object2)) {
                JavaAdapter.generateMethod(classFileWriter, string, (String)object3, method.getParameterTypes(), method.getReturnType());
                objToIntMap.put(object2, 0);
                objToIntMap2.put(object3, 0);
            }
            if (n != 0) continue;
            JavaAdapter.generateSuper(classFileWriter, string, string4, (String)object3, string3, method.getParameterTypes(), method.getReturnType());
        }
        for (object = scriptable; object != null; object = object.getPrototype()) {
            Object[] objectArray = scriptable.getIds();
            for (int i = 0; i < objectArray.length; ++i) {
                int n4;
                String string5;
                if (!(objectArray[i] instanceof String) || objToIntMap2.has(string5 = (String)objectArray[i])) continue;
                object3 = object.get(string5, (Scriptable)object);
                if (object3 instanceof Function) {
                    object2 = (Function)object3;
                    n4 = (int)Context.toNumber(ScriptableObject.getProperty((Scriptable)object2, "length"));
                } else {
                    if (!(object3 instanceof FunctionNode)) continue;
                    n4 = ((FunctionNode)object3).getVariableTable().getParameterCount();
                }
                object2 = new Class[n4];
                for (int j = 0; j < n4; ++j) {
                    object2[j] = Object.class;
                }
                JavaAdapter.generateMethod(classFileWriter, string, string5, object2, Object.class);
            }
        }
        object = classFileWriter.toByteArray();
        if (classNameHelper != null) {
            try {
                if (!classNameHelper.getClassRepository().storeClass(string, (byte[])object, true)) {
                    return null;
                }
            }
            catch (IOException iOException) {
                throw WrappedException.wrapException(iOException);
            }
        }
        ClassLoader classLoader = context.getApplicationClassLoader();
        SecurityController securityController = context.getSecurityController();
        if (securityController == null) {
            generatedClassLoader = context.createClassLoader(classLoader);
        } else {
            object3 = securityController.getDynamicSecurityDomain(null);
            generatedClassLoader = securityController.createClassLoader(classLoader, object3);
        }
        object3 = generatedClassLoader.defineClass(string, (byte[])object);
        generatedClassLoader.linkClass((Class)object3);
        return object3;
    }

    public static Object callMethod(Scriptable scriptable, Object object, String string, Object[] objectArray) {
        Context context = Context.enter();
        try {
            Object object2 = ScriptableObject.getProperty(scriptable, string);
            if (object2 == Scriptable.NOT_FOUND) {
                Scriptable scriptable2 = Undefined.instance;
                return scriptable2;
            }
            Object object3 = ScriptRuntime.call(context, object2, object, objectArray, scriptable);
            return object3;
        }
        catch (JavaScriptException javaScriptException) {
            throw WrappedException.wrapException(javaScriptException);
        }
        finally {
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Scriptable toObject(Object object, Scriptable scriptable, Class clazz) {
        Context context = Context.enter();
        try {
            Scriptable scriptable2 = ScriptRuntime.toObject(context, scriptable, object, clazz);
            return scriptable2;
        }
        finally {
            Context.exit();
        }
    }

    private static void generateCtor(ClassFileWriter classFileWriter, String string, String string2) {
        classFileWriter.startMethod("<init>", "(Lorg/mozilla/javascript/Scriptable;)V", (short)1);
        classFileWriter.add((byte)42);
        classFileWriter.add((byte)-73, string2, "<init>", "()", "V");
        classFileWriter.add((byte)42);
        classFileWriter.add((byte)43);
        classFileWriter.add((byte)-75, string, "delegee", "Lorg/mozilla/javascript/Scriptable;");
        classFileWriter.add((byte)43);
        classFileWriter.add((byte)42);
        classFileWriter.add((byte)-72, "org/mozilla/javascript/JavaAdapter", "setAdapterProto", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;)", "Lorg/mozilla/javascript/Scriptable;");
        classFileWriter.add((byte)76);
        classFileWriter.add((byte)42);
        classFileWriter.add((byte)43);
        classFileWriter.add((byte)-75, string, "self", "Lorg/mozilla/javascript/Scriptable;");
        classFileWriter.add((byte)-79);
        classFileWriter.stopMethod((short)20, null);
    }

    private static void generateSerialCtor(ClassFileWriter classFileWriter, String string, String string2) {
        classFileWriter.startMethod("<init>", "(Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;)V", (short)1);
        classFileWriter.add((byte)42);
        classFileWriter.add((byte)-73, string2, "<init>", "()", "V");
        classFileWriter.add((byte)42);
        classFileWriter.add((byte)43);
        classFileWriter.add((byte)-75, string, "delegee", "Lorg/mozilla/javascript/Scriptable;");
        classFileWriter.add((byte)42);
        classFileWriter.add((byte)44);
        classFileWriter.add((byte)-75, string, "self", "Lorg/mozilla/javascript/Scriptable;");
        classFileWriter.add((byte)-79);
        classFileWriter.stopMethod((short)20, null);
    }

    private static void generateEmptyCtor(ClassFileWriter classFileWriter, String string, String string2, String string3) {
        classFileWriter.startMethod("<init>", "()V", (short)1);
        classFileWriter.add((byte)42);
        classFileWriter.add((byte)-73, string2, "<init>", "()", "V");
        classFileWriter.add((byte)-69, string3);
        classFileWriter.add((byte)89);
        classFileWriter.add((byte)-73, string3, "<init>", "()", "V");
        classFileWriter.add((byte)-72, "org/mozilla/javascript/ScriptRuntime", "runScript", "(Lorg/mozilla/javascript/Script;)", "Lorg/mozilla/javascript/Scriptable;");
        classFileWriter.add((byte)76);
        classFileWriter.add((byte)42);
        classFileWriter.add((byte)43);
        classFileWriter.add((byte)-75, string, "delegee", "Lorg/mozilla/javascript/Scriptable;");
        classFileWriter.add((byte)43);
        classFileWriter.add((byte)42);
        classFileWriter.add((byte)-72, "org/mozilla/javascript/JavaAdapter", "setAdapterProto", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;)", "Lorg/mozilla/javascript/Scriptable;");
        classFileWriter.add((byte)76);
        classFileWriter.add((byte)42);
        classFileWriter.add((byte)43);
        classFileWriter.add((byte)-75, string, "self", "Lorg/mozilla/javascript/Scriptable;");
        classFileWriter.add((byte)-79);
        classFileWriter.stopMethod((short)20, null);
    }

    private static int generateWrapParam(ClassFileWriter classFileWriter, int n, Class clazz) {
        if (clazz.equals(Boolean.TYPE)) {
            classFileWriter.add((byte)-69, "java/lang/Boolean");
            classFileWriter.add((byte)89);
            classFileWriter.add((byte)21, n++);
            classFileWriter.add((byte)-73, "java/lang/Boolean", "<init>", "(Z)", "V");
        } else if (clazz.equals(Character.TYPE)) {
            classFileWriter.add((byte)-69, "java/lang/String");
            classFileWriter.add((byte)89);
            classFileWriter.add((byte)4);
            classFileWriter.add((byte)-68, 5);
            classFileWriter.add((byte)89);
            classFileWriter.add((byte)3);
            classFileWriter.add((byte)21, n++);
            classFileWriter.add((byte)85);
            classFileWriter.add((byte)-73, "java/lang/String", "<init>", "([C)", "V");
        } else {
            classFileWriter.add((byte)-69, "java/lang/Double");
            classFileWriter.add((byte)89);
            String string = clazz.getName();
            switch (string.charAt(0)) {
                case 'b': 
                case 'i': 
                case 's': {
                    classFileWriter.add((byte)21, n++);
                    classFileWriter.add((byte)-121);
                    break;
                }
                case 'l': {
                    classFileWriter.add((byte)22, n);
                    classFileWriter.add((byte)-118);
                    n += 2;
                    break;
                }
                case 'f': {
                    classFileWriter.add((byte)23, n++);
                    classFileWriter.add((byte)-115);
                    break;
                }
                case 'd': {
                    classFileWriter.add((byte)24, n);
                    n += 2;
                }
            }
            classFileWriter.add((byte)-73, "java/lang/Double", "<init>", "(D)", "V");
        }
        return n;
    }

    private static void generateReturnResult(ClassFileWriter classFileWriter, Class clazz) {
        if (clazz.equals(Boolean.TYPE)) {
            classFileWriter.add((byte)-72, "org/mozilla/javascript/Context", "toBoolean", "(Ljava/lang/Object;)", "Z");
            classFileWriter.add((byte)-84);
        } else if (clazz.equals(Character.TYPE)) {
            classFileWriter.add((byte)-72, "org/mozilla/javascript/Context", "toString", "(Ljava/lang/Object;)", "Ljava/lang/String;");
            classFileWriter.add((byte)3);
            classFileWriter.add((byte)-74, "java/lang/String", "charAt", "(I)", "C");
            classFileWriter.add((byte)-84);
        } else if (clazz.isPrimitive()) {
            classFileWriter.add((byte)-72, "org/mozilla/javascript/Context", "toNumber", "(Ljava/lang/Object;)", "D");
            String string = clazz.getName();
            switch (string.charAt(0)) {
                case 'b': 
                case 'i': 
                case 's': {
                    classFileWriter.add((byte)-114);
                    classFileWriter.add((byte)-84);
                    break;
                }
                case 'l': {
                    classFileWriter.add((byte)-113);
                    classFileWriter.add((byte)-83);
                    break;
                }
                case 'f': {
                    classFileWriter.add((byte)-112);
                    classFileWriter.add((byte)-82);
                    break;
                }
                case 'd': {
                    classFileWriter.add((byte)-81);
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected return type " + clazz.toString());
                }
            }
        } else {
            String string = clazz.getName();
            classFileWriter.addLoadConstant(string);
            classFileWriter.add((byte)-72, "java/lang/Class", "forName", "(Ljava/lang/String;)", "Ljava/lang/Class;");
            classFileWriter.add((byte)-72, "org/mozilla/javascript/JavaAdapter", "convertResult", "(Ljava/lang/Object;Ljava/lang/Class;)", "Ljava/lang/Object;");
            classFileWriter.add((byte)-64, string.replace('.', '/'));
            classFileWriter.add((byte)-80);
        }
    }

    private static void generateMethod(ClassFileWriter classFileWriter, String string, String string2, Class[] classArray, Class clazz) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        int n = 1;
        for (int i = 0; i < classArray.length; ++i) {
            Class clazz2 = classArray[i];
            JavaAdapter.appendTypeString(stringBuffer, clazz2);
            n = clazz2.equals(Long.TYPE) || clazz2.equals(Double.TYPE) ? (int)((short)(n + 2)) : (int)((short)(n + 1));
        }
        stringBuffer.append(')');
        JavaAdapter.appendTypeString(stringBuffer, clazz);
        String string3 = stringBuffer.toString();
        classFileWriter.startMethod(string2, string3, (short)1);
        classFileWriter.add((byte)16, (byte)classArray.length);
        classFileWriter.add((byte)-67, "java/lang/Object");
        classFileWriter.add((byte)58, n);
        short s = (short)(n + 1);
        boolean bl = false;
        int n2 = 1;
        for (int i = 0; i < classArray.length; ++i) {
            classFileWriter.add((byte)25, n);
            classFileWriter.add((byte)16, i);
            if (classArray[i].isPrimitive()) {
                n2 = JavaAdapter.generateWrapParam(classFileWriter, n2, classArray[i]);
            } else {
                classFileWriter.add((byte)25, n2++);
                if (!bl) {
                    classFileWriter.add((byte)42);
                    classFileWriter.add((byte)-76, string, "delegee", "Lorg/mozilla/javascript/Scriptable;");
                    classFileWriter.add((byte)58, s);
                    bl = true;
                }
                classFileWriter.add((byte)25, s);
                classFileWriter.addLoadConstant(classArray[i].getName());
                classFileWriter.add((byte)-72, "java/lang/Class", "forName", "(Ljava/lang/String;)", "Ljava/lang/Class;");
                classFileWriter.add((byte)-72, "org/mozilla/javascript/JavaAdapter", "toObject", "(Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;Ljava/lang/Class;)", "Lorg/mozilla/javascript/Scriptable;");
            }
            classFileWriter.add((byte)83);
        }
        classFileWriter.add((byte)42);
        classFileWriter.add((byte)-76, string, "delegee", "Lorg/mozilla/javascript/Scriptable;");
        classFileWriter.add((byte)42);
        classFileWriter.add((byte)-76, string, "self", "Lorg/mozilla/javascript/Scriptable;");
        classFileWriter.addLoadConstant(string2);
        classFileWriter.add((byte)25, n);
        classFileWriter.add((byte)-72, "org/mozilla/javascript/JavaAdapter", "callMethod", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;Ljava/lang/String;[Ljava/lang/Object;)", "Ljava/lang/Object;");
        if (clazz.equals(Void.TYPE)) {
            classFileWriter.add((byte)87);
            classFileWriter.add((byte)-79);
        } else {
            JavaAdapter.generateReturnResult(classFileWriter, clazz);
        }
        classFileWriter.stopMethod((short)(s + 3), null);
    }

    private static int generatePushParam(ClassFileWriter classFileWriter, int n, Class clazz) {
        String string = clazz.getName();
        switch (string.charAt(0)) {
            case 'b': 
            case 'c': 
            case 'i': 
            case 's': 
            case 'z': {
                classFileWriter.add((byte)21, n++);
                break;
            }
            case 'l': {
                classFileWriter.add((byte)22, n);
                n += 2;
                break;
            }
            case 'f': {
                classFileWriter.add((byte)23, n++);
                break;
            }
            case 'd': {
                classFileWriter.add((byte)24, n);
                n += 2;
            }
        }
        return n;
    }

    private static void generatePopResult(ClassFileWriter classFileWriter, Class clazz) {
        if (clazz.isPrimitive()) {
            String string = clazz.getName();
            switch (string.charAt(0)) {
                case 'b': 
                case 'c': 
                case 'i': 
                case 's': 
                case 'z': {
                    classFileWriter.add((byte)-84);
                    break;
                }
                case 'l': {
                    classFileWriter.add((byte)-83);
                    break;
                }
                case 'f': {
                    classFileWriter.add((byte)-82);
                    break;
                }
                case 'd': {
                    classFileWriter.add((byte)-81);
                }
            }
        } else {
            classFileWriter.add((byte)-80);
        }
    }

    private static void generateSuper(ClassFileWriter classFileWriter, String string, String string2, String string3, String string4, Class[] classArray, Class clazz) {
        int n;
        classFileWriter.startMethod("super$" + string3, string4, (short)1);
        classFileWriter.add((byte)25, 0);
        int n2 = 1;
        for (n = 0; n < classArray.length; ++n) {
            if (classArray[n].isPrimitive()) {
                n2 = JavaAdapter.generatePushParam(classFileWriter, n2, classArray[n]);
                continue;
            }
            classFileWriter.add((byte)25, n2++);
        }
        n = string4.indexOf(41);
        classFileWriter.add((byte)-73, string2, string3, string4.substring(0, n + 1), string4.substring(n + 1));
        Class clazz2 = clazz;
        if (!clazz2.equals(Void.TYPE)) {
            JavaAdapter.generatePopResult(classFileWriter, clazz2);
        } else {
            classFileWriter.add((byte)-79);
        }
        classFileWriter.stopMethod((short)(n2 + 1), null);
    }

    private static String getMethodSignature(Method method) {
        Class<?>[] classArray = method.getParameterTypes();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        for (int i = 0; i < classArray.length; ++i) {
            Class<?> clazz = classArray[i];
            JavaAdapter.appendTypeString(stringBuffer, clazz);
        }
        stringBuffer.append(')');
        JavaAdapter.appendTypeString(stringBuffer, method.getReturnType());
        return stringBuffer.toString();
    }

    private static StringBuffer appendTypeString(StringBuffer stringBuffer, Class clazz) {
        while (clazz.isArray()) {
            stringBuffer.append('[');
            clazz = clazz.getComponentType();
        }
        if (clazz.isPrimitive()) {
            if (clazz.equals(Boolean.TYPE)) {
                stringBuffer.append('Z');
            } else if (clazz.equals(Long.TYPE)) {
                stringBuffer.append('J');
            } else {
                String string = clazz.getName();
                stringBuffer.append(Character.toUpperCase(string.charAt(0)));
            }
        } else {
            stringBuffer.append('L');
            stringBuffer.append(clazz.getName().replace('.', '/'));
            stringBuffer.append(';');
        }
        return stringBuffer;
    }

    static {
        generatedClasses = new Hashtable(7);
    }

    static class ClassSignature {
        Class mSuperClass;
        Class[] mInterfaces;
        Object[] mProperties;

        ClassSignature(Class clazz, Class[] classArray, Scriptable scriptable) {
            this.mSuperClass = clazz;
            this.mInterfaces = classArray;
            this.mProperties = ScriptableObject.getPropertyIds(scriptable);
        }

        public boolean equals(Object object) {
            if (object instanceof ClassSignature) {
                ClassSignature classSignature = (ClassSignature)object;
                if (this.mSuperClass == classSignature.mSuperClass) {
                    int n;
                    Class[] classArray = classSignature.mInterfaces;
                    if (this.mInterfaces != classArray) {
                        if (this.mInterfaces == null || classArray == null) {
                            return false;
                        }
                        if (this.mInterfaces.length != classArray.length) {
                            return false;
                        }
                        for (n = 0; n < classArray.length; ++n) {
                            if (this.mInterfaces[n] == classArray[n]) continue;
                            return false;
                        }
                    }
                    if (this.mProperties.length != classSignature.mProperties.length) {
                        return false;
                    }
                    for (n = 0; n < this.mProperties.length; ++n) {
                        if (this.mProperties[n].equals(classSignature.mProperties[n])) continue;
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return this.mSuperClass.hashCode();
        }
    }
}

