/*
 * Decompiled with CFR 0.152.
 */
package mod._xmloff.Impress;

import com.sun.star.container.XNamed;
import com.sun.star.document.XExporter;
import com.sun.star.drawing.XDrawPages;
import com.sun.star.drawing.XDrawPagesSupplier;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Any;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.xml.sax.XDocumentHandler;
import ifc.document._XFilter;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.SOfficeFactory;
import util.XMLTools;
import util.utils;

public class XMLContentExporter
extends TestCase {
    XComponent xImpressDoc = null;

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        try {
            printWriter.println("creating an impress document");
            this.xImpressDoc = sOfficeFactory.createImpressDoc(null);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create document", exception);
        }
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("    disposing xImpressDoc ");
        this.xImpressDoc.dispose();
    }

    public synchronized TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) throws StatusException {
        Object object;
        XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)testParameters.getMSF();
        XInterface xInterface = null;
        FilterChecker filterChecker = new FilterChecker(printWriter);
        Any any = new Any(new Type(XDocumentHandler.class), (Object)filterChecker);
        try {
            xInterface = (XInterface)xMultiServiceFactory.createInstanceWithArguments("com.sun.star.comp.Impress.XMLContentExporter", new Object[]{any});
            object = (XExporter)UnoRuntime.queryInterface(XExporter.class, (Object)xInterface);
            object.setSourceDocument(this.xImpressDoc);
            XDrawPagesSupplier xDrawPagesSupplier = (XDrawPagesSupplier)UnoRuntime.queryInterface(XDrawPagesSupplier.class, (Object)this.xImpressDoc);
            XDrawPages xDrawPages = xDrawPagesSupplier.getDrawPages();
            XNamed xNamed = (XNamed)UnoRuntime.queryInterface(XNamed.class, xDrawPages.getByIndex(0));
            xNamed.setName("XMLContentExporter");
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Can't create component.", exception);
        }
        filterChecker.addTag(new XMLTools.Tag("office:document-content"));
        filterChecker.addTagEnclosed(new XMLTools.Tag("office:body"), new XMLTools.Tag("office:document-content"));
        filterChecker.addTagEnclosed(new XMLTools.Tag("draw:page", "draw:name", "XMLContentExporter"), new XMLTools.Tag("office:body"));
        printWriter.println("creating a new environment");
        object = new TestEnvironment(xInterface);
        ((TestEnvironment)object).addObjRelation("MediaDescriptor", XMLTools.createMediaDescriptor(new String[]{"FilterName"}, new Object[]{"simpress: StarOffice XML (Impress)"}));
        ((TestEnvironment)object).addObjRelation("SourceDocument", this.xImpressDoc);
        ((TestEnvironment)object).addObjRelation("XFilter.Checker", filterChecker);
        printWriter.println("Implementation Name: " + utils.getImplName(xInterface));
        return object;
    }

    protected class FilterChecker
    extends XMLTools.XMLChecker
    implements _XFilter.FilterChecker {
        public FilterChecker(PrintWriter printWriter) {
            super(printWriter, true);
        }

        public boolean checkFilter() {
            return this.check();
        }
    }
}

