/*
 * Decompiled with CFR 0.152.
 */
package mod._toolkit;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleAction;
import com.sun.star.accessibility.XAccessibleComponent;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.awt.Point;
import com.sun.star.awt.XExtendedToolkit;
import com.sun.star.awt.XWindow;
import com.sun.star.beans.PropertyValue;
import com.sun.star.frame.XController;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XDispatchProvider;
import com.sun.star.frame.XModel;
import com.sun.star.lang.DisposedException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.URL;
import com.sun.star.util.XURLTransformer;
import ifc.accessibility._XAccessibleEventBroadcaster;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.AccessibilityTools;
import util.DesktopTools;
import util.SOfficeFactory;
import util.utils;

public class AccessibleTabPage
extends TestCase {
    private static XDesktop the_Desk;
    private static XTextDocument xTextDoc;
    private static XAccessibleAction accCloseButton;

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        the_Desk = (XDesktop)UnoRuntime.queryInterface(XDesktop.class, DesktopTools.createDesktop((XMultiServiceFactory)testParameters.getMSF()));
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        try {
            if (accCloseButton != null) {
                printWriter.println("closing InsertFields Dialog");
                accCloseButton.doAccessibleAction(0);
                this.shortWait();
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            indexOutOfBoundsException.printStackTrace(printWriter);
        }
        catch (DisposedException disposedException) {
            printWriter.println("Couldn't close dialog " + disposedException.getMessage());
        }
        printWriter.println("disposing xTextDoc");
        if (xTextDoc != null) {
            this.closeDoc();
        }
    }

    protected TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) {
        XInterface xInterface;
        printWriter.println("creating a test environment");
        try {
            if (accCloseButton != null) {
                printWriter.println("closing InsertFields Dialog");
                accCloseButton.doAccessibleAction(0);
                this.shortWait();
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            indexOutOfBoundsException.printStackTrace(printWriter);
        }
        catch (DisposedException disposedException) {
            printWriter.println("Couldn't close dialog " + disposedException.getMessage());
        }
        printWriter.println("disposing xTextDoc");
        if (xTextDoc != null) {
            this.closeDoc();
        }
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        try {
            printWriter.println("creating a text document");
            xTextDoc = sOfficeFactory.createTextDoc(null);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create document", exception);
        }
        this.shortWait();
        XModel xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)xTextDoc);
        XController xController = xModel.getCurrentController();
        XDispatchProvider xDispatchProvider = (XDispatchProvider)UnoRuntime.queryInterface(XDispatchProvider.class, (Object)xController);
        XURLTransformer xURLTransformer = null;
        try {
            xInterface = (XInterface)((XMultiServiceFactory)testParameters.getMSF()).createInstance("com.sun.star.util.URLTransformer");
            xURLTransformer = (XURLTransformer)UnoRuntime.queryInterface(XURLTransformer.class, (Object)xInterface);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create URLTransformer", exception);
        }
        xInterface = null;
        printWriter.println("opening InsertField dialog");
        URL[] uRLArray = new URL[]{new URL()};
        uRLArray[0].Complete = ".uno:InsertField";
        xURLTransformer.parseStrict(uRLArray);
        xInterface = xDispatchProvider.queryDispatch(uRLArray[0], "", 0);
        PropertyValue[] propertyValueArray = new PropertyValue[]{};
        xInterface.dispatch(uRLArray[0], propertyValueArray);
        this.shortWait();
        XInterface xInterface2 = null;
        try {
            xInterface2 = (XInterface)((XMultiServiceFactory)testParameters.getMSF()).createInstance("com.sun.star.awt.Toolkit");
        }
        catch (Exception exception) {
            printWriter.println("Couldn't get toolkit");
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't get toolkit", exception);
        }
        XExtendedToolkit xExtendedToolkit = (XExtendedToolkit)UnoRuntime.queryInterface(XExtendedToolkit.class, (Object)xInterface2);
        AccessibilityTools accessibilityTools = new AccessibilityTools();
        this.shortWait();
        XWindow xWindow = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)xExtendedToolkit.getActiveTopWindow());
        XAccessible xAccessible = AccessibilityTools.getAccessibleObject(xWindow);
        XAccessibleContext xAccessibleContext = AccessibilityTools.getAccessibleObjectForRole(xAccessible, (short)44, "Close");
        accCloseButton = (XAccessibleAction)UnoRuntime.queryInterface(XAccessibleAction.class, (Object)xAccessibleContext);
        xInterface2 = AccessibilityTools.getAccessibleObjectForRole(xAccessible, (short)38);
        printWriter.println("ImplementationName: " + utils.getImplName(xInterface2));
        TestEnvironment testEnvironment = new TestEnvironment(xInterface2);
        testEnvironment.addObjRelation("EditOnly", "toolkit.AccessibleTabPage");
        testEnvironment.addObjRelation("LimitedBounds", "toolkit.AccessibleTabPage");
        XAccessibleComponent xAccessibleComponent = (XAccessibleComponent)UnoRuntime.queryInterface(XAccessibleComponent.class, (Object)xInterface2);
        Point point = xAccessibleComponent.getLocationOnScreen();
        this.shortWait();
        XAccessibleContext xAccessibleContext2 = AccessibilityTools.getAccessibleObjectForRole(xAccessible, (short)38, "Variables");
        final XAccessibleComponent xAccessibleComponent2 = (XAccessibleComponent)UnoRuntime.queryInterface(XAccessibleComponent.class, (Object)xAccessibleContext2);
        testEnvironment.addObjRelation("EventProducer", new _XAccessibleEventBroadcaster.EventProducer(){

            public void fireEvent() {
                xAccessibleComponent2.grabFocus();
            }
        });
        return testEnvironment;
    }

    private void shortWait() {
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            System.out.println("While waiting :" + interruptedException);
        }
    }

    protected void closeDoc() {
        DesktopTools.closeDoc(xTextDoc);
    }

    static {
        accCloseButton = null;
    }
}

