/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.container.XNameAccess;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextTable;
import com.sun.star.text.XTextTablesSupplier;
import com.sun.star.uno.UnoRuntime;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;

public class SwXTextTables
extends TestCase {
    XTextDocument xTextDoc;

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        try {
            printWriter.println("creating a textdocument");
            this.xTextDoc = sOfficeFactory.createTextDoc(null);
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create document", exception);
        }
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("    disposing xTextDoc ");
        DesktopTools.closeDoc(this.xTextDoc);
    }

    public synchronized TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) {
        XNameAccess xNameAccess = null;
        int n = 4;
        int n2 = 5;
        printWriter.println("creating a test environment");
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        TestEnvironment testEnvironment = null;
        XTextTable xTextTable = null;
        try {
            xTextTable = SOfficeFactory.createTextTable(this.xTextDoc);
            SOfficeFactory.insertTextContent(this.xTextDoc, xTextTable);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create TextTable : " + exception.getMessage(), exception);
        }
        XTextTable xTextTable2 = null;
        try {
            xTextTable2 = SOfficeFactory.createTextTable(this.xTextDoc);
            SOfficeFactory.insertTextContent(this.xTextDoc, xTextTable2);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create TextTable two: " + exception.getMessage(), exception);
        }
        XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)this.xTextDoc);
        XTextTablesSupplier xTextTablesSupplier = (XTextTablesSupplier)UnoRuntime.queryInterface(XTextTablesSupplier.class, (Object)xMultiServiceFactory);
        xNameAccess = xTextTablesSupplier.getTextTables();
        if (xTextTable != null) {
            printWriter.println("Creating instance...");
            testEnvironment = new TestEnvironment(xNameAccess);
        }
        printWriter.println("adding TextDocument as mod relation to environment");
        testEnvironment.addObjRelation("TEXTDOC", this.xTextDoc);
        testEnvironment.addObjRelation("ROW", new Integer(n));
        testEnvironment.addObjRelation("COL", new Integer(n2));
        try {
            testEnvironment.addObjRelation("INST", SOfficeFactory.createTextTable(this.xTextDoc));
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create TextTable : " + exception.getMessage(), exception);
        }
        return testEnvironment;
    }
}

