/*
 * Decompiled with CFR 0.152.
 */
package mod._sd;

import com.sun.star.container.XIndexAccess;
import com.sun.star.drawing.XDrawPage;
import com.sun.star.drawing.XDrawPages;
import com.sun.star.drawing.XDrawPagesSupplier;
import com.sun.star.drawing.XShapes;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.InstCreator;
import util.SOfficeFactory;
import util.ShapeDsc;

public class SdGenericDrawPage
extends TestCase {
    XComponent xDrawDoc;

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        try {
            printWriter.println("creating a draw document");
            this.xDrawDoc = sOfficeFactory.createDrawDoc(null);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create document", exception);
        }
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("disposing xDrawDoc");
        DesktopTools.closeDoc(this.xDrawDoc);
    }

    protected synchronized TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) {
        XDrawPage xDrawPage = null;
        XShapes xShapes = null;
        printWriter.println("creating a test environment");
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        printWriter.println("getting Drawpage");
        XDrawPagesSupplier xDrawPagesSupplier = (XDrawPagesSupplier)UnoRuntime.queryInterface(XDrawPagesSupplier.class, (Object)this.xDrawDoc);
        XDrawPages xDrawPages = xDrawPagesSupplier.getDrawPages();
        XIndexAccess xIndexAccess = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)xDrawPages);
        try {
            xDrawPage = (XDrawPage)AnyConverter.toObject((Type)new Type(XDrawPage.class), (Object)xIndexAccess.getByIndex(0));
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't get DrawPage", exception);
        }
        printWriter.println("inserting some Shapes");
        xShapes = (XShapes)UnoRuntime.queryInterface(XShapes.class, (Object)xDrawPage);
        xShapes.add(sOfficeFactory.createShape(this.xDrawDoc, 2000, 1500, 1000, 1000, "Line"));
        xShapes.add(sOfficeFactory.createShape(this.xDrawDoc, 3000, 4500, 15000, 1000, "Ellipse"));
        xShapes.add(sOfficeFactory.createShape(this.xDrawDoc, 5000, 3500, 7500, 5000, "Rectangle"));
        printWriter.println("creating a new environment for drawpage object");
        TestEnvironment testEnvironment = new TestEnvironment(xDrawPage);
        ShapeDsc shapeDsc = new ShapeDsc(5000, 3500, 7500, 10000, "Rectangle");
        printWriter.println("adding Shape as mod relation to environment");
        testEnvironment.addObjRelation("Shape", new InstCreator(this.xDrawDoc, shapeDsc));
        testEnvironment.addObjRelation("DrawPage", xDrawPage);
        return testEnvironment;
    }
}

