/*
 * Decompiled with CFR 0.152.
 */
package mod._sc;

import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNamed;
import com.sun.star.document.XExporter;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.sheet.XSpreadsheets;
import com.sun.star.uno.Any;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.xml.sax.XDocumentHandler;
import ifc.document._XFilter;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.CalcTools;
import util.DesktopTools;
import util.SOfficeFactory;
import util.XMLTools;

public class XMLExporter
extends TestCase {
    static XComponent xSheetDoc;

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        try {
            printWriter.println("creating a calc document");
            xSheetDoc = sOfficeFactory.openDoc("scalc", "_blank");
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create document", exception);
        }
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("    disposing xCalcDoc ");
        DesktopTools.closeDoc(xSheetDoc);
    }

    protected synchronized TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) {
        Object object;
        XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)testParameters.getMSF();
        XInterface xInterface = null;
        FilterChecker filterChecker = new FilterChecker(printWriter);
        Any any = new Any(new Type(XDocumentHandler.class), (Object)filterChecker);
        try {
            xInterface = (XInterface)xMultiServiceFactory.createInstanceWithArguments("com.sun.star.comp.Calc.XMLExporter", new Object[]{any});
            object = (XExporter)UnoRuntime.queryInterface(XExporter.class, (Object)xInterface);
            object.setSourceDocument(xSheetDoc);
            XSpreadsheetDocument xSpreadsheetDocument = (XSpreadsheetDocument)UnoRuntime.queryInterface(XSpreadsheetDocument.class, (Object)xSheetDoc);
            XSpreadsheets xSpreadsheets = xSpreadsheetDocument.getSheets();
            XIndexAccess xIndexAccess = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)xSpreadsheets);
            XSpreadsheet xSpreadsheet = (XSpreadsheet)AnyConverter.toObject((Type)new Type(XSpreadsheet.class), (Object)xIndexAccess.getByIndex(0));
            XNamed xNamed = (XNamed)UnoRuntime.queryInterface(XNamed.class, (Object)xSpreadsheet);
            xNamed.setName("XMLExporter_SheetTestName");
            printWriter.println("fill sheet with contnet...");
            CalcTools.fillCalcSheetWithContent(xSpreadsheet, 3, 3, 50, 50);
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Can't create component.", exception);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Can't create environment.", exception);
        }
        filterChecker.addTag(new XMLTools.Tag("office:document"));
        filterChecker.addTagEnclosed(new XMLTools.Tag("office:meta"), new XMLTools.Tag("office:document"));
        filterChecker.addTagEnclosed(new XMLTools.Tag("office:settings"), new XMLTools.Tag("office:document"));
        filterChecker.addTagEnclosed(new XMLTools.Tag("office:script"), new XMLTools.Tag("office:document"));
        filterChecker.addTagEnclosed(new XMLTools.Tag("office:styles"), new XMLTools.Tag("office:document"));
        filterChecker.addTagEnclosed(new XMLTools.Tag("office:body"), new XMLTools.Tag("office:document"));
        filterChecker.addTagEnclosed(new XMLTools.Tag("table:table"), new XMLTools.Tag("office:body"));
        filterChecker.addTag(new XMLTools.Tag("table:table", "table:name", "XMLExporter_SheetTestName"));
        printWriter.println("creating a new environment");
        object = new TestEnvironment(xInterface);
        ((TestEnvironment)object).addObjRelation("MediaDescriptor", XMLTools.createMediaDescriptor(new String[]{"FilterName"}, new Object[]{"scalc: StarOffice XML (Calc)"}));
        ((TestEnvironment)object).addObjRelation("SourceDocument", xSheetDoc);
        ((TestEnvironment)object).addObjRelation("XFilter.Checker", filterChecker);
        return object;
    }

    protected class FilterChecker
    extends XMLTools.XMLChecker
    implements _XFilter.FilterChecker {
        public FilterChecker(PrintWriter printWriter) {
            super(printWriter, false);
        }

        public boolean checkFilter() {
            return this.check();
        }
    }
}

