/*
 * Decompiled with CFR 0.152.
 */
package mod._sc;

import com.sun.star.container.XIndexAccess;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.sheet.XSpreadsheets;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.XImportable;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;

public class ScImportDescriptorBase
extends TestCase {
    XSpreadsheetDocument xSpreadsheetDoc;

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        try {
            printWriter.println("creating a Spreadsheet document");
            this.xSpreadsheetDoc = sOfficeFactory.createCalcDoc(null);
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create document", exception);
        }
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("    disposing xSheetDoc ");
        XComponent xComponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)this.xSpreadsheetDoc);
        DesktopTools.closeDoc(xComponent);
    }

    public TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) throws StatusException {
        XInterface xInterface = null;
        XImportable xImportable = null;
        printWriter.println("creating a test environment");
        printWriter.println("getting sheets");
        XSpreadsheets xSpreadsheets = this.xSpreadsheetDoc.getSheets();
        if (xSpreadsheets == null) {
            printWriter.println("FAILED");
        } else {
            printWriter.println("OK");
        }
        printWriter.println("getting a sheet");
        XIndexAccess xIndexAccess = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)xSpreadsheets);
        try {
            xInterface = (XInterface)UnoRuntime.queryInterface(XInterface.class, xIndexAccess.getByIndex(0));
        }
        catch (Exception exception) {
            throw new StatusException("Couldn't get a spreadsheet", exception);
        }
        xImportable = (XImportable)UnoRuntime.queryInterface(XImportable.class, (Object)xInterface);
        TestEnvironment testEnvironment = new TestEnvironment(xInterface);
        testEnvironment.addObjRelation("xIMP", xImportable);
        return testEnvironment;
    }
}

