/*
 * Decompiled with CFR 0.152.
 */
package ifc.view;

import com.sun.star.beans.PropertyState;
import com.sun.star.beans.PropertyValue;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.view.PrintJobEvent;
import com.sun.star.view.XPrintJobBroadcaster;
import com.sun.star.view.XPrintJobListener;
import com.sun.star.view.XPrintable;
import java.io.File;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;
import util.utils;

public class _XPrintJobBroadcaster
extends MultiMethodTest {
    public XPrintJobBroadcaster oObj = null;
    MyPrintJobListener listenerImpl = null;

    public void before() {
        this.listenerImpl = (MyPrintJobListener)this.tEnv.getObjRelation("XPrintJobBroadcaster.XPrintJobListener");
        if (this.listenerImpl == null) {
            throw new StatusException(Status.failed(" No test possible. The XPrintJobListener interface has to be implemented."));
        }
    }

    public void _addPrintJobListener() {
        this.oObj.addPrintJobListener(this.listenerImpl);
        this.listenerImpl.fireEvent();
        utils.shortWait(1000);
        this.tRes.tested("addPrintJobListener()", this.listenerImpl.actionTriggered());
    }

    public void _removePrintJobListener() {
        this.requiredMethod("addPrintJobListener");
        this.oObj.removePrintJobListener(this.listenerImpl);
        utils.shortWait(5000);
        this.listenerImpl.reset();
        this.listenerImpl.fireEvent();
        this.tRes.tested("removePrintJobListener()", !this.listenerImpl.actionTriggered());
    }

    public static class MyPrintJobListener
    implements XPrintJobListener {
        boolean eventCalled = false;
        XPrintable xPrintable = null;
        PropertyValue[] printProps = null;
        String printFileName = null;

        public MyPrintJobListener(Object object, String string) {
            this.printFileName = string;
            this.xPrintable = (XPrintable)UnoRuntime.queryInterface(XPrintable.class, object);
            this.printProps = new PropertyValue[2];
            this.printProps[0] = new PropertyValue();
            this.printProps[0].Name = "FileName";
            this.printProps[0].Value = string;
            this.printProps[0].State = PropertyState.DEFAULT_VALUE;
            this.printProps[1] = new PropertyValue();
            this.printProps[1].Name = "Wait";
            this.printProps[1].Value = new Boolean(true);
        }

        public boolean actionTriggered() {
            return this.eventCalled;
        }

        public void fireEvent() {
            try {
                this.xPrintable.print(this.printProps);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        public void reset() {
            File file = new File(this.printFileName);
            if (file.exists()) {
                file.delete();
            }
            this.eventCalled = false;
        }

        public void printJobEvent(PrintJobEvent printJobEvent) {
            this.eventCalled = true;
        }

        public void disposing(EventObject eventObject) {
        }
    }
}

