/*
 * Decompiled with CFR 0.152.
 */
package ifc.io;

import com.sun.star.io.BufferSizeExceededException;
import com.sun.star.io.IOException;
import com.sun.star.io.NotConnectedException;
import com.sun.star.io.XDataInputStream;
import com.sun.star.io.XDataOutputStream;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.util.Vector;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;

public class _XDataInputStream
extends MultiMethodTest {
    public XDataInputStream oObj = null;
    public XDataOutputStream oStream = null;
    private boolean writeBoolean;
    private byte writeByte;
    private char writeChar;
    private double writeDouble;
    private float writeFloat;
    private long writeHyper;
    private int writeLong;
    private short writeShort;
    private String writeUTF;

    public void before() {
        XInterface xInterface = (XInterface)this.tEnv.getObjRelation("StreamWriter");
        this.oStream = (XDataOutputStream)UnoRuntime.queryInterface(XDataOutputStream.class, (Object)xInterface);
        Vector vector = (Vector)this.tEnv.getObjRelation("StreamData");
        if (vector == null || this.oStream == null) {
            throw new StatusException(Status.failed("Object relation not found."));
        }
        Object var3_3 = null;
        for (int i = 0; i < vector.size(); ++i) {
            var3_3 = vector.get(i);
            if (var3_3 instanceof Boolean) {
                this.writeBoolean = var3_3;
                continue;
            }
            if (var3_3 instanceof Byte) {
                this.writeByte = var3_3;
                continue;
            }
            if (var3_3 instanceof Character) {
                this.writeChar = ((Character)var3_3).charValue();
                continue;
            }
            if (var3_3 instanceof Short) {
                this.writeShort = var3_3;
                continue;
            }
            if (var3_3 instanceof Integer) {
                this.writeLong = var3_3;
                continue;
            }
            if (var3_3 instanceof Long) {
                this.writeHyper = var3_3;
                continue;
            }
            if (var3_3 instanceof Float) {
                this.writeFloat = ((Float)var3_3).floatValue();
                continue;
            }
            if (var3_3 instanceof Double) {
                this.writeDouble = var3_3;
                continue;
            }
            if (!(var3_3 instanceof String)) continue;
            this.writeUTF = var3_3;
        }
    }

    public void _readBoolean() {
        boolean bl = true;
        try {
            this.oStream.writeBoolean(this.writeBoolean);
        }
        catch (IOException iOException) {
            iOException.printStackTrace(this.log);
            throw new StatusException("Can't write data to the stream", iOException);
        }
        try {
            byte by = this.oObj.readBoolean();
            boolean bl2 = bl = by != 0 == this.writeBoolean;
            if (!bl) {
                this.log.println("Must be read " + this.writeBoolean + " but was read " + (by != 0));
            }
        }
        catch (IOException iOException) {
            this.log.println("Couldn't  read Boolean from stream");
            iOException.printStackTrace(this.log);
            bl = false;
        }
        this.tRes.tested("readBoolean()", bl);
    }

    public void _readByte() {
        boolean bl = true;
        try {
            this.oStream.writeByte(this.writeByte);
        }
        catch (IOException iOException) {
            iOException.printStackTrace(this.log);
            throw new StatusException("Can't write data to the stream", iOException);
        }
        try {
            byte by = this.oObj.readByte();
            boolean bl2 = bl = by == this.writeByte;
            if (!bl) {
                this.log.println("Must be read " + this.writeByte + " but was read " + by);
            }
        }
        catch (IOException iOException) {
            this.log.println("Couldn't read Byte from stream");
            iOException.printStackTrace(this.log);
            bl = false;
        }
        this.tRes.tested("readByte()", bl);
    }

    public void _readChar() {
        boolean bl = true;
        try {
            this.oStream.writeChar(this.writeChar);
        }
        catch (IOException iOException) {
            iOException.printStackTrace(this.log);
            throw new StatusException("Can't write data to the stream", iOException);
        }
        try {
            char c = this.oObj.readChar();
            boolean bl2 = bl = c == this.writeChar;
            if (!bl) {
                this.log.println("Must be read " + this.writeChar + " but was read " + c);
            }
        }
        catch (IOException iOException) {
            this.log.println("Couldn't read Char from stream");
            iOException.printStackTrace(this.log);
            bl = false;
        }
        this.tRes.tested("readChar()", bl);
    }

    public void _readShort() {
        boolean bl = true;
        try {
            this.oStream.writeShort(this.writeShort);
        }
        catch (IOException iOException) {
            iOException.printStackTrace(this.log);
            throw new StatusException("Can't write data to the stream", iOException);
        }
        try {
            short s = this.oObj.readShort();
            boolean bl2 = bl = s == this.writeShort;
            if (!bl) {
                this.log.println("Must be read " + this.writeShort + " but was read " + s);
            }
        }
        catch (IOException iOException) {
            this.log.println("Couldn't read Short from stream");
            iOException.printStackTrace(this.log);
            bl = false;
        }
        this.tRes.tested("readShort()", bl);
    }

    public void _readLong() {
        try {
            this.oStream.writeLong(this.writeLong);
        }
        catch (IOException iOException) {
            iOException.printStackTrace(this.log);
            throw new StatusException("Can't write data to the stream", iOException);
        }
        boolean bl = true;
        try {
            int n = this.oObj.readLong();
            boolean bl2 = bl = n == this.writeLong;
            if (!bl) {
                this.log.println("Must be read " + this.writeLong + " but was read " + n);
            }
        }
        catch (IOException iOException) {
            this.log.println("Couldn't read Long from stream");
            iOException.printStackTrace(this.log);
            bl = false;
        }
        this.tRes.tested("readLong()", bl);
    }

    public void _readHyper() {
        boolean bl = true;
        try {
            this.oStream.writeHyper(this.writeHyper);
        }
        catch (IOException iOException) {
            iOException.printStackTrace(this.log);
            throw new StatusException("Can't write data to the stream", iOException);
        }
        try {
            long l = this.oObj.readHyper();
            boolean bl2 = bl = l == this.writeHyper;
            if (!bl) {
                this.log.println("Must be read " + this.writeHyper + " but was read " + l);
            }
        }
        catch (IOException iOException) {
            this.log.println("Couldn't read Hyper from stream");
            iOException.printStackTrace(this.log);
            bl = false;
        }
        this.tRes.tested("readHyper()", bl);
    }

    public void _readFloat() {
        boolean bl = true;
        try {
            this.oStream.writeFloat(this.writeFloat);
        }
        catch (IOException iOException) {
            iOException.printStackTrace(this.log);
            throw new StatusException("Can't write data to the stream", iOException);
        }
        try {
            float f = this.oObj.readFloat();
            boolean bl2 = bl = f == this.writeFloat;
            if (!bl) {
                this.log.println("Must be read " + this.writeFloat + " but was read " + f);
            }
        }
        catch (IOException iOException) {
            this.log.println("Couldn't read Float from stream");
            iOException.printStackTrace(this.log);
            bl = false;
        }
        this.tRes.tested("readFloat()", bl);
    }

    public void _readDouble() {
        boolean bl = true;
        try {
            this.oStream.writeDouble(this.writeDouble);
        }
        catch (IOException iOException) {
            iOException.printStackTrace(this.log);
            throw new StatusException("Can't write data to the stream", iOException);
        }
        try {
            double d = this.oObj.readDouble();
            boolean bl2 = bl = d == this.writeDouble;
            if (!bl) {
                this.log.println("Must be read " + this.writeDouble + " but was read " + d);
            }
        }
        catch (IOException iOException) {
            this.log.println("Couldn't read Double from stream");
            iOException.printStackTrace(this.log);
            bl = false;
        }
        this.tRes.tested("readDouble()", bl);
    }

    public void _readUTF() {
        boolean bl = true;
        try {
            this.oStream.writeUTF(this.writeUTF);
        }
        catch (IOException iOException) {
            iOException.printStackTrace(this.log);
            throw new StatusException("Can't write data to the stream", iOException);
        }
        try {
            String string = this.oObj.readUTF();
            bl = this.writeUTF.equals(string);
            if (!bl) {
                this.log.println("Must be read '" + this.writeUTF + "' but was read '" + string + "'");
            }
        }
        catch (IOException iOException) {
            this.log.println("Couldn't read String from stream");
            iOException.printStackTrace(this.log);
            bl = false;
        }
        this.tRes.tested("readUTF()", bl);
    }

    public void after() {
        try {
            this.oStream.flush();
        }
        catch (NotConnectedException notConnectedException) {
            notConnectedException.printStackTrace(this.log);
        }
        catch (BufferSizeExceededException bufferSizeExceededException) {
            bufferSizeExceededException.printStackTrace(this.log);
        }
        catch (IOException iOException) {
            iOException.printStackTrace(this.log);
        }
        this.disposeEnvironment();
    }
}

