/*
 * Decompiled with CFR 0.152.
 */
package ifc.configuration.backend;

import com.sun.star.configuration.backend.BackendAccessException;
import com.sun.star.configuration.backend.MalformedDataException;
import com.sun.star.configuration.backend.XLayer;
import com.sun.star.configuration.backend.XMultiLayerStratum;
import com.sun.star.configuration.backend.XUpdatableLayer;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.NoSupportException;
import com.sun.star.lang.NullPointerException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiServiceFactory;
import lib.MultiMethodTest;
import util.XLayerHandlerImpl;
import util.utils;

public class _XMultiLayerStratum
extends MultiMethodTest {
    public XMultiLayerStratum oObj;
    protected String aLayerID;

    public void _getLayer() {
        XLayer xLayer;
        boolean bl = true;
        try {
            xLayer = this.oObj.getLayer("", "");
            this.log.println("Exception expected -- FAILED");
            bl = false;
        }
        catch (BackendAccessException backendAccessException) {
            this.log.println("unexpected Exception " + backendAccessException + " -- FAILED");
            bl = false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.log.println("expected Exception -- OK");
        }
        try {
            xLayer = this.oObj.getLayer(this.aLayerID, "");
            bl &= xLayer != null;
            if (xLayer == null) {
                this.log.println("\treturned Layer is NULL -- FAILED");
            }
            bl &= this.checkLayer(xLayer);
        }
        catch (BackendAccessException backendAccessException) {
            this.log.println("unexpected Exception -- FAILED");
            bl = false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.log.println("unexpected Exception -- FAILED");
            bl = false;
        }
        this.tRes.tested("getLayer()", bl);
    }

    public void _getLayers() {
        boolean bl = true;
        try {
            String[] stringArray = new String[]{"1 /org/openoffice/Office/Jobs.xcu", "2 /org/openoffice/Office/Linguistic.xcu"};
            XLayer[] xLayerArray = this.oObj.getLayers(stringArray, "");
            bl = xLayerArray.length == 2;
            this.log.println("Getting two XLayers -- OK");
            this.log.println("Checking first on " + stringArray[0]);
            bl &= this.checkLayer(xLayerArray[0]);
            this.log.println("Checking second on " + stringArray[1]);
            bl &= this.checkLayer(xLayerArray[1]);
        }
        catch (BackendAccessException backendAccessException) {
            this.log.println("unexpected Exception -- FAILED");
            bl = false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.log.println("unexpected Exception -- FAILED");
            bl = false;
        }
        this.tRes.tested("getLayers()", bl);
    }

    public void _getMultipleLayers() {
        boolean bl = true;
        try {
            String[] stringArray = new String[]{"1 /org/openoffice/Office/Jobs.xcu", "2 /org/openoffice/Office/Linguistic.xcu"};
            String[] stringArray2 = new String[]{"", ""};
            XLayer[] xLayerArray = this.oObj.getMultipleLayers(stringArray, stringArray2);
            bl = xLayerArray.length == 2;
            this.log.println("Getting two XLayers -- OK");
            this.log.println("Checking first on " + stringArray[0]);
            bl &= this.checkLayer(xLayerArray[0]);
            this.log.println("Checking second on " + stringArray[1]);
            bl &= this.checkLayer(xLayerArray[1]);
        }
        catch (BackendAccessException backendAccessException) {
            this.log.println("unexpected Exception -- FAILED");
            bl = false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.log.println("unexpected Exception -- FAILED");
            bl = false;
        }
        this.tRes.tested("getMultipleLayers()", bl);
    }

    public void _getUpdatableLayer() {
        XUpdatableLayer xUpdatableLayer;
        boolean bl = true;
        try {
            xUpdatableLayer = this.oObj.getUpdatableLayer("");
            this.log.println("Exception expected -- FAILED");
            bl = false;
        }
        catch (BackendAccessException backendAccessException) {
            this.log.println("unexpected Exception " + backendAccessException + " -- FAILED");
            bl = false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.log.println("expected Exception -- OK");
        }
        catch (NoSupportException noSupportException) {
            this.log.println("unexpected Exception -- FAILED");
            bl = false;
        }
        try {
            xUpdatableLayer = this.oObj.getUpdatableLayer(this.aLayerID);
            bl &= xUpdatableLayer != null;
            if (xUpdatableLayer == null) {
                this.log.println("\treturned Layer is NULL -- FAILED");
            }
            bl &= this.checkLayer(xUpdatableLayer);
        }
        catch (BackendAccessException backendAccessException) {
            this.log.println("unexpected Exception -- FAILED");
            bl = false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.log.println("unexpected Exception -- FAILED");
            bl = false;
        }
        catch (NoSupportException noSupportException) {
            this.log.println("unexpected Exception -- FAILED");
            bl = false;
        }
        this.tRes.tested("getUpdatableLayer()", bl);
    }

    public void _getUpdateLayerId() {
        String string;
        boolean bl = true;
        try {
            string = this.oObj.getUpdateLayerId("org.openoffice.Office.TypeDetection", "illegal");
            this.log.println("Exception expected -- FAILED");
            bl = false;
        }
        catch (BackendAccessException backendAccessException) {
            this.log.println("expected Exception -- OK");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.log.println("unexpected Exception -- FAILED");
            bl = false;
        }
        catch (NoSupportException noSupportException) {
            this.log.println("unexpected Exception -- FAILED");
            bl = false;
        }
        try {
            string = utils.getOfficeURL((XMultiServiceFactory)this.tParam.getMSF()) + "/../share/registry";
            String string2 = this.oObj.getUpdateLayerId("org.openoffice.Office.Linguistic", string);
            bl &= string2.endsWith("Linguistic.xcu");
            if (!string2.endsWith("Linguistic.xcu")) {
                this.log.println("\tExpected the id to end with Linguistic.xcu");
                this.log.println("\tBut got " + string2);
                this.log.println("\t=> FAILED");
            }
        }
        catch (BackendAccessException backendAccessException) {
            this.log.println("unexpected Exception -- FAILED");
            bl = false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.log.println("unexpected Exception " + illegalArgumentException + " -- FAILED");
            bl = false;
        }
        catch (NoSupportException noSupportException) {
            this.log.println("unexpected Exception -- FAILED");
            bl = false;
        }
        this.tRes.tested("getUpdateLayerId()", bl);
    }

    public void _listLayerIds() {
        Object object;
        boolean bl = true;
        try {
            object = this.oObj.listLayerIds("org.openoffice.Office.TypeDetection", "illegal");
            this.log.println("Exception expected -- FAILED");
            bl = false;
        }
        catch (BackendAccessException backendAccessException) {
            this.log.println("expected Exception -- OK");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.log.println("unexpected Exception -- FAILED");
            bl = false;
        }
        try {
            object = utils.getOfficeURL((XMultiServiceFactory)this.tParam.getMSF()) + "/../share/registry";
            String[] stringArray = this.oObj.listLayerIds("org.openoffice.Office.Jobs", (String)object);
            bl &= stringArray[0].endsWith("Jobs.xcu");
            this.aLayerID = stringArray[0];
            if (!stringArray[0].endsWith("Jobs.xcu")) {
                this.log.println("\tExpected the id to end with Jobs.xcu");
                this.log.println("\tBut got " + stringArray[0]);
                this.log.println("\t=> FAILED");
            }
        }
        catch (BackendAccessException backendAccessException) {
            this.log.println("unexpected Exception -- FAILED");
            bl = false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.log.println("unexpected Exception -- FAILED");
            bl = false;
        }
        this.tRes.tested("listLayerIds()", bl);
    }

    protected boolean checkLayer(XLayer xLayer) {
        boolean bl = false;
        this.log.println("Checking for Exception in case of null argument");
        try {
            xLayer.readData(null);
        }
        catch (NullPointerException nullPointerException) {
            this.log.println("Expected Exception -- OK");
            bl = true;
        }
        catch (WrappedTargetException wrappedTargetException) {
            this.log.println("Unexpected Exception (" + wrappedTargetException + ") -- FAILED");
        }
        catch (MalformedDataException malformedDataException) {
            this.log.println("Unexpected Exception (" + malformedDataException + ") -- FAILED");
        }
        this.log.println("checking read data with own XLayerHandler implementation");
        try {
            XLayerHandlerImpl xLayerHandlerImpl = new XLayerHandlerImpl();
            xLayer.readData(xLayerHandlerImpl);
            String string = xLayerHandlerImpl.getCalls();
            this.log.println(string);
            int n = string.indexOf("startLayer");
            if (n < 0) {
                this.log.println("startLayer wasn't called -- FAILED");
                bl &= false;
            } else {
                this.log.println("startLayer was called -- OK");
                bl &= true;
            }
            int n2 = string.indexOf("endLayer");
            if (n2 < 0) {
                this.log.println("endLayer wasn't called -- FAILED");
                bl &= false;
            } else {
                this.log.println("endLayer was called -- OK");
                bl &= true;
            }
        }
        catch (NullPointerException nullPointerException) {
            this.log.println("Unexpected Exception (" + nullPointerException + ") -- FAILED");
            bl &= false;
        }
        catch (WrappedTargetException wrappedTargetException) {
            this.log.println("Unexpected Exception (" + wrappedTargetException + ") -- FAILED");
            bl &= false;
        }
        catch (MalformedDataException malformedDataException) {
            this.log.println("Unexpected Exception (" + malformedDataException + ") -- FAILED");
            bl &= false;
        }
        return bl;
    }
}

