/*
 * Decompiled with CFR 0.152.
 */
package ifc.accessibility;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleSelection;
import com.sun.star.accessibility.XAccessibleTable;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.uno.UnoRuntime;
import lib.MultiMethodTest;

public class _XAccessibleTable
extends MultiMethodTest {
    public XAccessibleTable oObj = null;
    XAccessibleSelection xASel = null;
    XAccessibleContext xACont = null;
    int rowCount = 0;
    int colCount = 0;
    XAccessible xCellAc = null;

    protected void before() {
        this.xASel = (XAccessibleSelection)UnoRuntime.queryInterface(XAccessibleSelection.class, (Object)this.oObj);
        if (this.xASel == null) {
            this.log.println("The component doesn't implement the interface XAccessibleSelection.");
            this.log.println("This interface is required for more detailed tests.");
        }
        this.xACont = (XAccessibleContext)UnoRuntime.queryInterface(XAccessibleContext.class, (Object)this.oObj);
    }

    public void _getAccessibleRowCount() {
        this.rowCount = this.oObj.getAccessibleRowCount();
        this.log.println("Accessible row count: " + this.rowCount);
        this.tRes.tested("getAccessibleRowCount()", true);
    }

    public void _getAccessibleColumnCount() {
        this.colCount = this.oObj.getAccessibleColumnCount();
        this.log.println("Accessible column count: " + this.colCount);
        this.tRes.tested("getAccessibleColumnCount()", true);
    }

    public void _getAccessibleRowDescription() {
        String string;
        this.requiredMethod("getAccessibleRowCount()");
        boolean bl = true;
        try {
            this.log.print("getAccessibleRowDescription(-1): ");
            string = this.oObj.getAccessibleRowDescription(-1);
            this.log.println("'" + string + "'");
            this.log.println("Exception was expected");
            bl &= false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("expected exception");
            bl &= true;
        }
        try {
            this.log.print("getAccessibleRowDescription(" + this.rowCount + "): ");
            string = this.oObj.getAccessibleRowDescription(this.rowCount);
            this.log.println("'" + string + "'");
            this.log.println("Exception was expected");
            bl &= false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("expected exception");
            bl &= true;
        }
        try {
            this.log.print("getAccessibleRowDescription(" + (this.rowCount - 1) + "): ");
            string = this.oObj.getAccessibleRowDescription(this.rowCount - 1);
            bl &= string != null;
            this.log.println("'" + string + "'");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("Unexpected exception");
            indexOutOfBoundsException.printStackTrace(this.log);
            bl &= false;
        }
        this.tRes.tested("getAccessibleRowDescription()", bl);
    }

    public void _getAccessibleColumnDescription() {
        String string;
        this.requiredMethod("getAccessibleColumnCount()");
        boolean bl = true;
        try {
            this.log.print("getAccessibleColumnDescription(-1): ");
            string = this.oObj.getAccessibleColumnDescription(-1);
            this.log.println("'" + string + "'");
            this.log.println("Exception was expected");
            bl &= false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("expected exception");
            bl &= true;
        }
        try {
            this.log.print("getAccessibleColumnDescription(" + this.colCount + "): ");
            string = this.oObj.getAccessibleColumnDescription(this.colCount);
            this.log.println("'" + string + "'");
            this.log.println("Exception was expected");
            bl &= false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("expected exception");
            bl &= true;
        }
        try {
            this.log.print("getAccessibleColumnDescription(" + (this.colCount - 1) + "): ");
            string = this.oObj.getAccessibleColumnDescription(this.colCount - 1);
            bl &= string != null;
            this.log.println("'" + string + "'");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("Unexpected exception");
            indexOutOfBoundsException.printStackTrace(this.log);
            bl &= false;
        }
        this.tRes.tested("getAccessibleColumnDescription()", bl);
    }

    public void _getAccessibleRowExtentAt() {
        int n;
        this.requiredMethod("getAccessibleRowCount()");
        this.requiredMethod("getAccessibleColumnCount()");
        boolean bl = true;
        try {
            this.log.print("getAccessibleRowExtentAt(-1," + (this.colCount - 1) + "):");
            n = this.oObj.getAccessibleRowExtentAt(-1, this.colCount - 1);
            this.log.println(n);
            this.log.println("Exception was expected");
            bl &= false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("expected exception");
            bl &= true;
        }
        try {
            this.log.print("getAccessibleRowExtentAt(" + (this.rowCount - 1) + ",-1):");
            n = this.oObj.getAccessibleRowExtentAt(this.rowCount - 1, -1);
            this.log.println(n);
            this.log.println("Exception was expected");
            bl &= false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("expected exception");
            bl &= true;
        }
        try {
            this.log.print("getAccessibleRowExtentAt(0," + this.colCount + "):");
            int n2 = this.oObj.getAccessibleRowExtentAt(0, this.colCount);
            this.log.println(n2);
            this.log.println("Exception was expected");
            bl &= false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("expected exception");
            bl &= true;
        }
        try {
            this.log.print("getAccessibleRowExtentAt(" + this.rowCount + ",0):");
            int n3 = this.oObj.getAccessibleRowExtentAt(this.rowCount, 0);
            this.log.println(n3);
            this.log.println("Exception was expected");
            bl &= false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("expected exception");
            bl &= true;
        }
        try {
            this.log.print("getAccessibleRowExtentAt(" + (this.rowCount - 1) + "," + (this.colCount - 1) + "):");
            int n4 = this.oObj.getAccessibleRowExtentAt(this.rowCount - 1, this.colCount - 1);
            this.log.println(n4);
            bl &= n4 >= 1;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("Unexpected exception");
            indexOutOfBoundsException.printStackTrace(this.log);
            bl &= false;
        }
        this.tRes.tested("getAccessibleRowExtentAt()", bl);
    }

    public void _getAccessibleColumnExtentAt() {
        int n;
        this.requiredMethod("getAccessibleRowCount()");
        this.requiredMethod("getAccessibleColumnCount()");
        boolean bl = true;
        try {
            this.log.print("getAccessibleColumnExtentAt(-1," + (this.colCount - 1) + "):");
            n = this.oObj.getAccessibleColumnExtentAt(-1, this.colCount - 1);
            this.log.println(n);
            this.log.println("Exception was expected");
            bl &= false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("expected exception");
            bl &= true;
        }
        try {
            this.log.print("getAccessibleColumnExtentAt(" + (this.rowCount - 1) + ",-1):");
            n = this.oObj.getAccessibleColumnExtentAt(this.rowCount - 1, -1);
            this.log.println(n);
            this.log.println("Exception was expected");
            bl &= false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("expected exception");
            bl &= true;
        }
        try {
            this.log.print("getAccessibleColumnExtentAt(0," + this.colCount + "):");
            int n2 = this.oObj.getAccessibleColumnExtentAt(0, this.colCount);
            this.log.println(n2);
            this.log.println("Exception was expected");
            bl &= false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("expected exception");
            bl &= true;
        }
        try {
            this.log.print("getAccessibleColumnExtentAt(" + this.rowCount + ",0):");
            int n3 = this.oObj.getAccessibleColumnExtentAt(this.rowCount, 0);
            this.log.println(n3);
            this.log.println("Exception was expected");
            bl &= false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("expected exception");
            bl &= true;
        }
        try {
            this.log.print("getAccessibleColumnExtentAt(" + (this.rowCount - 1) + "," + (this.colCount - 1) + "):");
            int n4 = this.oObj.getAccessibleColumnExtentAt(this.rowCount - 1, this.colCount - 1);
            this.log.println(n4);
            bl &= n4 >= 1;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("Unexpected exception");
            indexOutOfBoundsException.printStackTrace(this.log);
            bl &= false;
        }
        this.tRes.tested("getAccessibleColumnExtentAt()", bl);
    }

    public void _getAccessibleRowHeaders() {
        XAccessibleTable xAccessibleTable = this.oObj.getAccessibleRowHeaders();
        this.log.println("getAccessibleRowHeaders(): " + xAccessibleTable);
        this.tRes.tested("getAccessibleRowHeaders()", true);
    }

    public void _getAccessibleColumnHeaders() {
        XAccessibleTable xAccessibleTable = this.oObj.getAccessibleColumnHeaders();
        this.log.println("getAccessibleColumnHeaders(): " + xAccessibleTable);
        this.tRes.tested("getAccessibleColumnHeaders()", true);
    }

    public void _getSelectedAccessibleRows() {
        this.requiredMethod("getAccessibleRowCount()");
        boolean bl = true;
        boolean bl2 = true;
        int[] nArray = null;
        if (this.xASel != null) {
            this.log.println("XAccessibleSelection.selectAllAccessibleChildren()");
            this.xASel.selectAllAccessibleChildren();
        }
        this.log.println("getSelectedAccessibleRows()");
        nArray = this.oObj.getSelectedAccessibleRows();
        this.log.println("Length of the returned sequince: " + nArray.length);
        bl = this.xASel != null ? (bl &= nArray.length == this.rowCount) : (bl &= nArray.length == 0);
        if (nArray.length > 0) {
            this.log.println("Checking that returned sequence is in ascending order");
        }
        for (int i = 1; i < nArray.length; ++i) {
            bl &= (bl2 &= nArray[i] >= nArray[i - 1]);
            if (bl2) continue;
            this.log.println("Element #" + i + ":" + nArray[i] + " is less than element #" + (i - 1) + ": " + nArray[i - 1]);
            break;
        }
        this.tRes.tested("getSelectedAccessibleRows()", bl);
    }

    public void _getSelectedAccessibleColumns() {
        this.requiredMethod("getAccessibleColumnCount()");
        boolean bl = true;
        boolean bl2 = true;
        int[] nArray = null;
        if (this.xASel != null) {
            this.log.println("XAccessibleSelection.selectAllAccessibleChildren()");
            this.xASel.selectAllAccessibleChildren();
        }
        this.log.println("getSelectedAccessibleColumns()");
        nArray = this.oObj.getSelectedAccessibleColumns();
        this.log.println("Length of the returned sequince: " + nArray.length);
        bl = this.xASel != null ? (bl &= nArray.length == this.colCount) : (bl &= nArray.length == 0);
        if (nArray.length > 0) {
            this.log.println("Checking that returned sequence is in ascending order");
        }
        for (int i = 1; i < nArray.length; ++i) {
            bl &= (bl2 &= nArray[i] >= nArray[i - 1]);
            if (bl2) continue;
            this.log.println("Element #" + i + ":" + nArray[i] + " is less than element #" + (i - 1) + ": " + nArray[i - 1]);
            break;
        }
        this.tRes.tested("getSelectedAccessibleColumns()", bl);
    }

    public void _isAccessibleRowSelected() {
        this.requiredMethod("getAccessibleRowCount()");
        boolean bl = true;
        boolean bl2 = true;
        try {
            this.log.print("isAccessibleRowSelected(-1): ");
            bl2 = this.oObj.isAccessibleRowSelected(-1);
            this.log.println(bl2);
            this.log.println("Exception was expected");
            bl &= false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("expected exception");
            bl &= true;
        }
        try {
            this.log.print("isAccessibleRowSelected(" + this.rowCount + "): ");
            bl2 = this.oObj.isAccessibleRowSelected(this.rowCount);
            this.log.println(bl2);
            this.log.println("Exception was expected");
            bl &= false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("expected exception");
            bl &= true;
        }
        if (this.xASel != null) {
            this.log.println("XAccessibleSelection.selectAllAccessibleChildren()");
            this.xASel.selectAllAccessibleChildren();
        }
        try {
            this.log.println("Checking of every row selection...");
            for (int i = 0; i < this.rowCount; ++i) {
                boolean bl3 = this.oObj.isAccessibleRowSelected(i);
                bl2 = this.xASel == null ? !bl3 : bl3;
                bl &= bl2;
                if (bl2) continue;
                this.log.println("isAccessibleRowSelected(" + i + "): " + bl3);
                break;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("Unexpected exception");
            indexOutOfBoundsException.printStackTrace(this.log);
            bl &= false;
        }
        this.tRes.tested("isAccessibleRowSelected()", bl);
    }

    public void _isAccessibleColumnSelected() {
        this.requiredMethod("getAccessibleColumnCount()");
        boolean bl = true;
        boolean bl2 = true;
        try {
            this.log.print("isAccessibleColumnSelected(-1): ");
            bl2 = this.oObj.isAccessibleColumnSelected(-1);
            this.log.println(bl2);
            this.log.println("Exception was expected");
            bl &= false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("expected exception");
            bl &= true;
        }
        try {
            this.log.print("isAccessibleColumnSelected(" + this.colCount + "): ");
            bl2 = this.oObj.isAccessibleColumnSelected(this.colCount);
            this.log.println(bl2);
            this.log.println("Exception was expected");
            bl &= false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("expected exception");
            bl &= true;
        }
        if (this.xASel != null) {
            this.log.println("XAccessibleSelection.selectAllAccessibleChildren()");
            this.xASel.selectAllAccessibleChildren();
        }
        try {
            this.log.println("Checking of every column selection...");
            for (int i = 0; i < this.colCount; ++i) {
                boolean bl3 = this.oObj.isAccessibleColumnSelected(i);
                bl2 = this.xASel == null ? !bl3 : bl3;
                bl &= bl2;
                if (bl2) continue;
                this.log.println("isAccessibleColumnSelected(" + i + "): " + bl3);
                break;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("Unexpected exception");
            indexOutOfBoundsException.printStackTrace(this.log);
            bl &= false;
        }
        this.tRes.tested("isAccessibleColumnSelected()", bl);
    }

    public void _getAccessibleCellAt() {
        this.requiredMethod("getAccessibleRowCount()");
        this.requiredMethod("getAccessibleColumnCount()");
        boolean bl = true;
        try {
            this.log.print("getAccessibleCellAt(-1," + (this.colCount - 1) + "):");
            this.xCellAc = this.oObj.getAccessibleCellAt(-1, this.colCount - 1);
            this.log.println(this.xCellAc);
            this.log.println("Exception was expected");
            bl &= false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("expected exception");
            bl &= true;
        }
        try {
            this.log.print("getAccessibleCellAt(" + (this.rowCount - 1) + ",-1):");
            this.xCellAc = this.oObj.getAccessibleCellAt(this.rowCount - 1, -1);
            this.log.println(this.xCellAc);
            this.log.println("Exception was expected");
            bl &= false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("expected exception");
            bl &= true;
        }
        try {
            this.log.print("getAccessibleCellAt(0, " + this.colCount + "):");
            this.xCellAc = this.oObj.getAccessibleCellAt(0, this.colCount);
            this.log.println(this.xCellAc);
            this.log.println("Exception was expected");
            bl &= false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("expected exception");
            bl &= true;
        }
        try {
            this.log.print("getAccessibleCellAt(" + this.rowCount + ",0):");
            XAccessible xAccessible = this.oObj.getAccessibleCellAt(this.rowCount, 0);
            this.log.println(xAccessible);
            this.log.println("Exception was expected");
            bl &= false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("expected exception");
            bl &= true;
        }
        try {
            this.log.print("getAccessibleCellAt(" + (this.rowCount - 1) + "," + (this.colCount - 1) + "): ");
            this.xCellAc = this.oObj.getAccessibleCellAt(this.rowCount - 1, this.colCount - 1);
            this.log.println(this.xCellAc);
            bl &= this.xCellAc != null;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("Unexpected exception");
            indexOutOfBoundsException.printStackTrace(this.log);
            bl &= false;
        }
        this.tRes.tested("getAccessibleCellAt()", bl);
    }

    public void _getAccessibleCaption() {
        XAccessible xAccessible = this.oObj.getAccessibleCaption();
        this.log.println("getAccessibleCaption(): " + xAccessible);
        this.tRes.tested("getAccessibleCaption()", true);
    }

    public void _getAccessibleSummary() {
        XAccessible xAccessible = this.oObj.getAccessibleSummary();
        this.log.println("getAccessibleSummary(): " + xAccessible);
        this.tRes.tested("getAccessibleSummary()", true);
    }

    public void _isAccessibleSelected() {
        this.requiredMethod("getAccessibleRowCount()");
        this.requiredMethod("getAccessibleColumnCount()");
        boolean bl = true;
        boolean bl2 = true;
        try {
            this.log.print("isAccessibleSelected(-1," + (this.colCount - 1) + "):");
            bl2 = this.oObj.isAccessibleSelected(-1, this.colCount - 1);
            this.log.println(bl2);
            this.log.println("Exception was expected");
            bl &= false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("expected exception");
            bl &= true;
        }
        try {
            this.log.print("isAccessibleSelected(" + (this.rowCount - 1) + ",-1):");
            bl2 = this.oObj.isAccessibleSelected(this.rowCount - 1, -1);
            this.log.println(bl2);
            this.log.println("Exception was expected");
            bl &= false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("expected exception");
            bl &= true;
        }
        try {
            this.log.print("isAccessibleSelected(0, " + this.colCount + "):");
            bl2 = this.oObj.isAccessibleSelected(0, this.colCount);
            this.log.println(bl2);
            this.log.println("Exception was expected");
            bl &= false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("expected exception");
            bl &= true;
        }
        try {
            this.log.print("isAccessibleSelected(" + this.rowCount + ",0):");
            bl2 = this.oObj.isAccessibleSelected(this.rowCount, 0);
            this.log.println(bl2);
            this.log.println("Exception was expected");
            bl &= false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("expected exception");
            bl &= true;
        }
        if (this.xASel != null) {
            this.log.println("XAccessibleSelection.selectAllAccessibleChildren()");
            this.xASel.selectAllAccessibleChildren();
        }
        try {
            this.log.print("isAccessibleSelected(" + (this.rowCount - 1) + "," + (this.colCount - 1) + "): ");
            boolean bl3 = this.oObj.isAccessibleSelected(this.rowCount - 1, this.colCount - 1);
            this.log.println(bl3);
            bl2 = this.xASel == null ? !bl3 : bl3;
            bl &= bl2;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("Unexpected exception");
            indexOutOfBoundsException.printStackTrace(this.log);
            bl &= false;
        }
        this.tRes.tested("isAccessibleSelected()", bl);
    }

    public void _getAccessibleIndex() {
        int n;
        this.executeMethod("getAccessibleCellAt()");
        boolean bl = true;
        try {
            this.log.print("getAccessibleIndex(-1," + (this.colCount - 1) + "):");
            n = this.oObj.getAccessibleIndex(-1, this.colCount - 1);
            this.log.println(n);
            this.log.println("Exception was expected");
            bl &= false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("expected exception");
            bl &= true;
        }
        try {
            this.log.print("getAccessibleIndex(" + (this.rowCount - 1) + ",-1):");
            n = this.oObj.getAccessibleIndex(this.rowCount - 1, -1);
            this.log.println(n);
            this.log.println("Exception was expected");
            bl &= false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("expected exception");
            bl &= true;
        }
        try {
            this.log.print("getAccessibleIndex(0," + this.colCount + "):");
            int n2 = this.oObj.getAccessibleIndex(0, this.colCount);
            this.log.println(n2);
            this.log.println("Exception was expected");
            bl &= false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("expected exception");
            bl &= true;
        }
        try {
            this.log.print("getAccessibleIndex(" + this.rowCount + ",0):");
            int n3 = this.oObj.getAccessibleIndex(this.rowCount, 0);
            this.log.println(n3);
            this.log.println("Exception was expected");
            bl &= false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("expected exception");
            bl &= true;
        }
        try {
            this.log.print("getAccessibleIndex(" + (this.rowCount - 1) + "," + (this.colCount - 1) + "): ");
            int n4 = this.oObj.getAccessibleIndex(this.rowCount - 1, this.colCount - 1);
            this.log.println(n4);
            if (this.xCellAc != null) {
                XAccessibleContext xAccessibleContext = this.xCellAc.getAccessibleContext();
                int n5 = xAccessibleContext.getAccessibleIndexInParent();
                this.log.println("Expected index: " + n5);
                bl &= n5 == n4;
            } else {
                bl &= true;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("Unexpected exception");
            indexOutOfBoundsException.printStackTrace(this.log);
            bl &= false;
        }
        this.tRes.tested("getAccessibleIndex()", bl);
    }

    public void _getAccessibleRow() {
        int n;
        this.requiredMethod("getAccessibleRowCount()");
        boolean bl = true;
        if (this.xACont != null) {
            int n2;
            n = this.xACont.getAccessibleChildCount();
            this.log.println("accessible child count: " + n);
            try {
                this.log.print("getAccessibleRow(" + n + "): ");
                n2 = this.oObj.getAccessibleRow(n);
                this.log.println(n2);
                this.log.println("Exception was expected");
                bl &= false;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.log.println("expected exception");
                bl &= true;
            }
            try {
                this.log.print("getAccessibleRow(" + (n - 1) + "): ");
                n2 = this.oObj.getAccessibleRow(n - 1);
                this.log.println(n2);
                bl &= n2 >= 0 && n2 <= this.rowCount;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.log.println("Unexpected exception");
                indexOutOfBoundsException.printStackTrace(this.log);
                bl &= false;
            }
        }
        try {
            this.log.print("getAccessibleRow(-1): ");
            n = this.oObj.getAccessibleRow(-1);
            this.log.println(n);
            this.log.println("Exception was expected");
            bl &= false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("expected exception");
            bl &= true;
        }
        try {
            this.log.print("getAccessibleRow(0): ");
            int n3 = this.oObj.getAccessibleRow(0);
            this.log.println(n3);
            bl &= n3 >= 0 && n3 <= this.rowCount;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("Unexpected exception");
            indexOutOfBoundsException.printStackTrace(this.log);
            bl &= false;
        }
        this.tRes.tested("getAccessibleRow()", bl);
    }

    public void _getAccessibleColumn() {
        int n;
        this.requiredMethod("getAccessibleColumnCount()");
        boolean bl = true;
        if (this.xACont != null) {
            int n2;
            n = this.xACont.getAccessibleChildCount();
            this.log.println("accessible child count: " + n);
            try {
                this.log.print("getAccessibleColumn(" + n + "): ");
                n2 = this.oObj.getAccessibleColumn(n);
                this.log.println(n2);
                this.log.println("Exception was expected");
                bl &= false;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.log.println("expected exception");
                bl &= true;
            }
            try {
                this.log.print("getAccessibleColumn(" + (n - 1) + "): ");
                n2 = this.oObj.getAccessibleColumn(n - 1);
                this.log.println(n2);
                bl &= n2 >= 0 && n2 <= this.colCount;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.log.println("Unexpected exception");
                indexOutOfBoundsException.printStackTrace(this.log);
                bl &= false;
            }
        }
        try {
            this.log.print("getAccessibleColumn(-1): ");
            n = this.oObj.getAccessibleColumn(-1);
            this.log.println(n);
            this.log.println("Exception was expected");
            bl &= false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("expected exception");
            bl &= true;
        }
        try {
            this.log.print("getAccessibleColumn(0): ");
            int n3 = this.oObj.getAccessibleColumn(0);
            this.log.println(n3);
            bl &= n3 >= 0 && n3 <= this.rowCount;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.log.println("Unexpected exception");
            indexOutOfBoundsException.printStackTrace(this.log);
            bl &= false;
        }
        this.tRes.tested("getAccessibleColumn()", bl);
    }
}

