/*
 * Decompiled with CFR 0.152.
 */
package mod._toolkit;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleAction;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.awt.XWindow;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XModel;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import ifc.accessibility._XAccessibleEventBroadcaster;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.AccessibilityTools;
import util.DesktopTools;
import util.SOfficeFactory;
import util.utils;

public class AccessibleToolBoxItem
extends TestCase {
    private static XDesktop the_Desk;
    private static XTextDocument xTextDoc;
    static /* synthetic */ Class class$com$sun$star$frame$XDesktop;
    static /* synthetic */ Class class$com$sun$star$frame$XModel;
    static /* synthetic */ Class class$com$sun$star$accessibility$XAccessibleAction;

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        the_Desk = (XDesktop)UnoRuntime.queryInterface(class$com$sun$star$frame$XDesktop == null ? (class$com$sun$star$frame$XDesktop = AccessibleToolBoxItem.class$("com.sun.star.frame.XDesktop")) : class$com$sun$star$frame$XDesktop, DesktopTools.createDesktop((XMultiServiceFactory)testParameters.getMSF()));
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("disposing xTextDoc");
        if (xTextDoc != null) {
            this.closeDoc();
        }
    }

    protected TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("creating a test environment");
        if (xTextDoc != null) {
            this.closeDoc();
        }
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        try {
            printWriter.println("creating a text document");
            xTextDoc = sOfficeFactory.createTextDoc(null);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create document", exception);
        }
        XModel xModel = (XModel)UnoRuntime.queryInterface(class$com$sun$star$frame$XModel == null ? (class$com$sun$star$frame$XModel = AccessibleToolBoxItem.class$("com.sun.star.frame.XModel")) : class$com$sun$star$frame$XModel, (Object)xTextDoc);
        XAccessibleContext xAccessibleContext = null;
        AccessibilityTools accessibilityTools = new AccessibilityTools();
        XWindow xWindow = AccessibilityTools.getCurrentContainerWindow((XMultiServiceFactory)testParameters.getMSF(), xModel);
        XAccessible xAccessible = AccessibilityTools.getAccessibleObject((XInterface)xWindow);
        AccessibilityTools.printAccessibleTree(printWriter, xAccessible, testParameters.getBool("DebugIsActive"));
        xAccessibleContext = AccessibilityTools.getAccessibleObjectForRole(xAccessible, (short)62, "Bold");
        printWriter.println("ImplementationName: " + utils.getImplName(xAccessibleContext));
        TestEnvironment testEnvironment = new TestEnvironment((XInterface)xAccessibleContext);
        testEnvironment.addObjRelation("EditOnly", "This method isn't supported in this dialog");
        testEnvironment.addObjRelation("LimitedBounds", "yes");
        final XAccessibleAction xAccessibleAction = (XAccessibleAction)UnoRuntime.queryInterface(class$com$sun$star$accessibility$XAccessibleAction == null ? (class$com$sun$star$accessibility$XAccessibleAction = AccessibleToolBoxItem.class$("com.sun.star.accessibility.XAccessibleAction")) : class$com$sun$star$accessibility$XAccessibleAction, (Object)xAccessibleContext);
        testEnvironment.addObjRelation("EventProducer", new _XAccessibleEventBroadcaster.EventProducer(){

            public void fireEvent() {
                try {
                    xAccessibleAction.doAccessibleAction(0);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        });
        testEnvironment.addObjRelation("XAccessibleText.Text", "Bold");
        return testEnvironment;
    }

    protected void closeDoc() {
        DesktopTools.closeDoc((XInterface)xTextDoc);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

