/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XText;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextRange;
import com.sun.star.uno.Exception;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;
import util.utils;

public class SwXTextRange
extends TestCase {
    XTextDocument xTextDoc;

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        try {
            printWriter.println("creating a textdocument");
            this.xTextDoc = sOfficeFactory.createTextDoc(null);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create document", exception);
        }
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("    disposing xTextDoc ");
        DesktopTools.closeDoc((XInterface)this.xTextDoc);
    }

    public synchronized TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) throws StatusException {
        XText xText = null;
        printWriter.println("creating a test environment");
        printWriter.println("getting the TextRange of the text document");
        xText = this.xTextDoc.getText();
        XTextCursor xTextCursor = xText.createTextCursor();
        XTextRange xTextRange = xTextCursor.getStart();
        printWriter.println("creating a new environment for textrange object");
        TestEnvironment testEnvironment = new TestEnvironment((XInterface)xTextRange);
        printWriter.println("adding TextDocument as mod relation to environment");
        testEnvironment.addObjRelation("TEXTDOC", this.xTextDoc);
        System.out.println("Implementation Name: " + utils.getImplName(xTextRange));
        return testEnvironment;
    }
}

