/*
 * Decompiled with CFR 0.152.
 */
package mod._nestedreg.uno;

import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.registry.InvalidRegistryException;
import com.sun.star.registry.XSimpleRegistry;
import com.sun.star.uno.XInterface;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.RegistryTools;
import util.utils;

public class NestedRegistry
extends TestCase {
    protected static int uniq = 0;
    XSimpleRegistry reg1;
    XSimpleRegistry reg2;

    public synchronized void disposeTestEnvironment(TestEnvironment testEnvironment, TestParameters testParameters) {
        try {
            this.reg1.destroy();
            this.reg2.destroy();
        }
        catch (InvalidRegistryException invalidRegistryException) {
            // empty catch block
        }
    }

    protected void copyFile(String string, String string2, PrintWriter printWriter) throws IOException {
        File file = new File(string);
        File file2 = new File(string2);
        if (file2.exists()) {
            file2.delete();
        }
        file2.createNewFile();
        file2.deleteOnExit();
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        byte[] byArray = new byte[1024];
        int n = 0;
        while ((n = fileInputStream.read(byArray)) > 0) {
            fileOutputStream.write(byArray, 0, n);
        }
        fileInputStream.close();
        fileOutputStream.close();
    }

    protected TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) {
        Object object;
        XInterface xInterface = null;
        Object object2 = null;
        Object var5_5 = null;
        String string = utils.getOfficeTempDirSys((XMultiServiceFactory)testParameters.getMSF());
        String string2 = string + "XSimpleRegistry_open" + uniq + ".rdb";
        String string3 = string + "XSimpleRegistry_destroy" + uniq + ".rdb";
        String string4 = string + "XSimpleRegistry_merge" + uniq + ".rdb";
        ++uniq;
        printWriter.println("creating copies of the registry for XSimpleRegistry");
        try {
            object = utils.getFullTestDocName("XSimpleRegistry.rdb");
            this.copyFile((String)object, string2, printWriter);
            this.copyFile((String)object, string4, printWriter);
        }
        catch (IOException iOException) {
            printWriter.println("Exception occured while copying files");
            iOException.printStackTrace(printWriter);
            throw new StatusException("Exception occured while copying files", iOException);
        }
        try {
            object = (XMultiServiceFactory)testParameters.getMSF();
            this.reg1 = RegistryTools.createRegistryService((XMultiServiceFactory)object);
            this.reg1.open(string4, false, true);
            this.reg2 = RegistryTools.createRegistryService((XMultiServiceFactory)object);
            this.reg2.open(string2, false, true);
            Object[] objectArray = new XSimpleRegistry[]{this.reg1, this.reg2};
            object2 = object.createInstanceWithArguments("com.sun.star.comp.stoc.NestedRegistry", objectArray);
        }
        catch (Exception exception) {
            printWriter.println("Introspection Service not available");
        }
        xInterface = (XInterface)object2;
        printWriter.println("    creating a new environment for Introspection object");
        object = new TestEnvironment(xInterface);
        ((TestEnvironment)object).addObjRelation("NR", "NestedRegistry");
        ((TestEnvironment)object).addObjRelation("XSimpleRegistry.open", string2);
        ((TestEnvironment)object).addObjRelation("XSimpleRegistry.merge", string4);
        ((TestEnvironment)object).addObjRelation("XSimpleRegistry.destroy", string3);
        return object;
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
    }
}

