/*
 * Decompiled with CFR 0.152.
 */
package ifc.xml.sax;

import com.sun.star.xml.sax.SAXException;
import com.sun.star.xml.sax.XAttributeList;
import com.sun.star.xml.sax.XDocumentHandler;
import com.sun.star.xml.sax.XLocator;
import java.io.PrintWriter;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;
import util.XMLTools;

public class _XDocumentHandler
extends MultiMethodTest {
    public XDocumentHandler oObj = null;
    private String[][] xmlData = null;
    private DocumentLocator locator = null;
    private ImportChecker checker = null;
    private boolean locatorResult = true;
    private SAXException locatorException = null;
    private boolean ToBeSkipped = false;

    public void before() {
        this.locator = new DocumentLocator(this.log);
        if (this.tEnv.getTestCase().getObjectName().equals("XMLSettingsImporter")) {
            this.log.println("Settings can't be imported in the current Implementation");
            this.ToBeSkipped = true;
        }
        this.xmlData = (String[][])this.tEnv.getObjRelation("XDocumentHandler.XMLData");
        this.checker = (ImportChecker)this.tEnv.getObjRelation("XDocumentHandler.ImportChecker");
        TargetDocumentSetter targetDocumentSetter = (TargetDocumentSetter)this.tEnv.getObjRelation("XDocumentHandler.TargetDocumentSetter");
        if (this.xmlData == null || this.checker == null) {
            throw new StatusException(Status.failed("Relation wasn't found"));
        }
        if (targetDocumentSetter == null) {
            this.log.println("object realtion 'XDocumentHandler.TargetDocumentSetter' not used.");
            this.log.println("be shure that the test have a target to write throu");
        }
    }

    public void _startDocument() {
        if (this.ToBeSkipped) {
            this.tRes.tested("startDocument()", Status.skipped(true));
            return;
        }
        try {
            this.oObj.setDocumentLocator((XLocator)this.locator);
        }
        catch (SAXException sAXException) {
            this.locatorException = sAXException;
            this.locatorResult = false;
        }
        boolean bl = true;
        try {
            this.oObj.startDocument();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace(this.log);
            this.log.println("Wrapped exception :" + sAXException.WrappedException);
            bl = false;
        }
        this.tRes.tested("startDocument()", bl);
    }

    public void _endDocument() {
        if (this.ToBeSkipped) {
            this.tRes.tested("endDocument()", Status.skipped(true));
            return;
        }
        this.requiredMethod("startElement()");
        this.executeMethod("endElement()");
        this.executeMethod("characters()");
        this.executeMethod("ignorableWhitespace()");
        this.executeMethod("processingInstruction()");
        boolean bl = true;
        try {
            this.oObj.endDocument();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace(this.log);
            this.log.println("Wrapped exception :" + sAXException.WrappedException);
            bl = false;
        }
        this.log.println("Check if import was successful ...");
        this.tRes.tested("endDocument()", bl &= this.checker.checkImport());
    }

    public void _startElement() {
        if (this.ToBeSkipped) {
            this.tRes.tested("startElement()", Status.skipped(true));
            return;
        }
        boolean bl = true;
        try {
            this.log.println("StartElement Processing XML data ...");
            for (int i = 0; i < this.xmlData.length; ++i) {
                String[] stringArray = this.xmlData[i];
                String string = "";
                if ("start".equals(stringArray[0])) {
                    string = string + "<";
                    String string2 = stringArray[1];
                    string = string + string2;
                    XMLTools.AttributeList attributeList = new XMLTools.AttributeList();
                    for (int j = 2; j < stringArray.length; j += 3) {
                        attributeList.add(stringArray[j], stringArray[j + 1], stringArray[j + 2]);
                        string = string + " " + stringArray[j] + "(" + stringArray[j + 1] + ")=\"" + stringArray[j + 2] + "\"";
                    }
                    string = string + ">";
                    this.log.println(string);
                    this.oObj.startElement(string2, (XAttributeList)attributeList);
                    continue;
                }
                if ("end".equals(stringArray[0])) {
                    this.log.println("</" + stringArray[1] + ">");
                    this.oObj.endElement(stringArray[1]);
                    continue;
                }
                if ("chars".equals(stringArray[0])) {
                    this.log.println("'" + stringArray[1] + "'");
                    this.oObj.characters(stringArray[1]);
                    continue;
                }
                if ("spaces".equals(stringArray[0])) {
                    this.log.println("(spaces)'" + stringArray[1] + "'");
                    this.oObj.ignorableWhitespace(stringArray[1]);
                    continue;
                }
                if ("instruct".equals(stringArray[0])) {
                    this.log.println("<?" + stringArray[1] + " " + stringArray[2] + "?>");
                    this.oObj.processingInstruction(stringArray[1], stringArray[2]);
                    continue;
                }
                this.log.println("!!! Bad object relation !!!");
                throw new StatusException(Status.failed("Bad relation"));
            }
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace(this.log);
            this.log.println("Wrapped exception :" + sAXException.WrappedException);
            bl = false;
        }
        this.tRes.tested("startElement()", bl);
    }

    public void _endElement() {
        if (this.ToBeSkipped) {
            this.tRes.tested("endElement()", Status.skipped(true));
            return;
        }
        this.requiredMethod("startElement()");
        boolean bl = true;
        this.tRes.tested("endElement()", bl);
    }

    public void _characters() {
        if (this.ToBeSkipped) {
            this.tRes.tested("characters()", Status.skipped(true));
            return;
        }
        this.requiredMethod("startElement()");
        boolean bl = true;
        this.tRes.tested("characters()", bl);
    }

    public void _ignorableWhitespace() {
        if (this.ToBeSkipped) {
            this.tRes.tested("ignorableWhitespace()", Status.skipped(true));
            return;
        }
        this.requiredMethod("startElement()");
        boolean bl = true;
        this.tRes.tested("ignorableWhitespace()", bl);
    }

    public void _processingInstruction() {
        if (this.ToBeSkipped) {
            this.tRes.tested("processingInstruction()", Status.skipped(true));
            return;
        }
        this.requiredMethod("startElement()");
        boolean bl = true;
        this.tRes.tested("processingInstruction()", bl);
    }

    public void _setDocumentLocator() {
        if (this.ToBeSkipped) {
            this.tRes.tested("setDocumentLocator()", Status.skipped(true));
            return;
        }
        this.executeMethod("endDocument()");
        boolean bl = this.locatorResult;
        if (this.locatorException != null) {
            this.log.println("Exception occured during setDocumentLocator() call:");
            this.locatorException.printStackTrace(this.log);
            this.log.println("Wrapped exception :" + this.locatorException.WrappedException);
            bl = false;
        }
        this.tRes.tested("setDocumentLocator()", bl);
    }

    public static interface TargetDocumentSetter {
        public void setTargetDocument();
    }

    public static interface ImportChecker {
        public boolean checkImport();
    }

    private static class DocumentLocator
    implements XLocator {
        public boolean aMethodCalled = false;
        private PrintWriter log = null;

        public DocumentLocator(PrintWriter printWriter) {
            this.log = printWriter;
        }

        public int getColumnNumber() {
            this.log.println("getColumnNumber() method called.");
            this.aMethodCalled = true;
            return 10;
        }

        public int getLineNumber() {
            this.log.println("getLineNumber() method called.");
            this.aMethodCalled = true;
            return 9;
        }

        public String getPublicId() {
            this.log.println("getPublicId() method called.");
            this.aMethodCalled = true;
            return "file://d:/file.txt";
        }

        public String getSystemId() {
            this.log.println("getSystemId() method called.");
            this.aMethodCalled = true;
            return "system";
        }
    }
}

