/*
 * Decompiled with CFR 0.152.
 */
package ifc.sheet;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleComponent;
import com.sun.star.awt.Point;
import com.sun.star.awt.Rectangle;
import com.sun.star.awt.XExtendedToolkit;
import com.sun.star.awt.XTopWindow;
import com.sun.star.awt.XWindow;
import com.sun.star.beans.PropertyValue;
import com.sun.star.frame.XModel;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sheet.RangeSelectionEvent;
import com.sun.star.sheet.XRangeSelection;
import com.sun.star.sheet.XRangeSelectionChangeListener;
import com.sun.star.sheet.XRangeSelectionListener;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.awt.AWTException;
import java.awt.Robot;
import java.io.PrintWriter;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;
import util.AccessibilityTools;
import util.utils;

public class _XRangeSelection
extends MultiMethodTest {
    public XRangeSelection oObj = null;
    MyRangeSelectionListener aListener = null;
    static /* synthetic */ Class class$com$sun$star$awt$XTopWindow;
    static /* synthetic */ Class class$com$sun$star$frame$XModel;
    static /* synthetic */ Class class$com$sun$star$accessibility$XAccessibleComponent;
    static /* synthetic */ Class class$com$sun$star$awt$XExtendedToolkit;
    static /* synthetic */ Class class$com$sun$star$accessibility$XAccessible;
    static /* synthetic */ Class class$com$sun$star$awt$XWindow;

    public void before() {
        this.aListener = new MyRangeSelectionListener(this.log);
        XModel xModel = (XModel)this.tEnv.getObjRelation("FirstModel");
        if (xModel == null) {
            throw new StatusException(Status.failed("Object relation FirstModel' not set."));
        }
        XWindow xWindow = xModel.getCurrentController().getFrame().getContainerWindow();
        XTopWindow xTopWindow = (XTopWindow)UnoRuntime.queryInterface(class$com$sun$star$awt$XTopWindow == null ? (class$com$sun$star$awt$XTopWindow = _XRangeSelection.class$("com.sun.star.awt.XTopWindow")) : class$com$sun$star$awt$XTopWindow, (Object)xWindow);
        xTopWindow.toFront();
        utils.shortWait(500);
    }

    public void _abortRangeSelection() {
        this.requiredMethod("removeRangeSelectionChangeListener()");
        this.requiredMethod("removeRangeSelectionListener()");
        this.oObj.abortRangeSelection();
        this.tRes.tested("abortRangeSelection()", true);
    }

    public void _addRangeSelectionChangeListener() {
        this.oObj.addRangeSelectionChangeListener((XRangeSelectionChangeListener)this.aListener);
        this.tRes.tested("addRangeSelectionChangeListener()", true);
    }

    public void _addRangeSelectionListener() {
        this.oObj.addRangeSelectionListener((XRangeSelectionListener)this.aListener);
        this.tRes.tested("addRangeSelectionListener()", true);
    }

    public void _removeRangeSelectionChangeListener() {
        this.oObj.removeRangeSelectionChangeListener((XRangeSelectionChangeListener)this.aListener);
        this.tRes.tested("removeRangeSelectionChangeListener()", true);
    }

    public void _removeRangeSelectionListener() {
        this.oObj.removeRangeSelectionListener((XRangeSelectionListener)this.aListener);
        this.tRes.tested("removeRangeSelectionListener()", true);
    }

    public void _startRangeSelection() {
        this.requiredMethod("addRangeSelectionChangeListener()");
        this.requiredMethod("addRangeSelectionListener()");
        Point point = this.getSheetCenter();
        if (point == null) {
            throw new StatusException(Status.failed("Couldn't get the sheet center."));
        }
        PropertyValue[] propertyValueArray = new PropertyValue[3];
        propertyValueArray[0] = new PropertyValue();
        propertyValueArray[0].Name = "InitialValue";
        propertyValueArray[0].Value = "B3:D5";
        propertyValueArray[1] = new PropertyValue();
        propertyValueArray[1].Name = "Title";
        propertyValueArray[1].Value = "the title";
        propertyValueArray[2] = new PropertyValue();
        propertyValueArray[2].Name = "CloseOnMouseRelease";
        propertyValueArray[2].Value = Boolean.FALSE;
        this.oObj.startRangeSelection(propertyValueArray);
        utils.shortWait(1000);
        Point point2 = this.getCloser(point);
        if (point2 == null) {
            throw new StatusException(Status.failed("Couldn't get the close Button."));
        }
        this.clickOnSheet(point);
        utils.shortWait(5000);
        this.clickOnSheet(point2);
        utils.shortWait(5000);
        propertyValueArray[0].Value = "C4:E6";
        this.oObj.startRangeSelection(propertyValueArray);
        utils.shortWait(1000);
        propertyValueArray[0].Value = "C2:E3";
        this.oObj.startRangeSelection(propertyValueArray);
        utils.shortWait(1000);
        this.oObj.startRangeSelection(propertyValueArray);
        utils.shortWait(1000);
        this.oObj.abortRangeSelection();
        this.aListener.reset();
        System.out.println("Listener called: " + this.aListener.bAbortCalled);
        this.tRes.tested("startRangeSelection()", this.aListener.listenerCalled());
    }

    protected Point getSheetCenter() {
        XAccessible xAccessible;
        XTopWindow xTopWindow;
        this.log.println("Trying to get AccessibleSpreadsheet");
        AccessibilityTools accessibilityTools = new AccessibilityTools();
        XComponent xComponent = (XComponent)this.tEnv.getObjRelation("DOCUMENT");
        XModel xModel = (XModel)UnoRuntime.queryInterface(class$com$sun$star$frame$XModel == null ? (class$com$sun$star$frame$XModel = _XRangeSelection.class$("com.sun.star.frame.XModel")) : class$com$sun$star$frame$XModel, (Object)xComponent);
        System.out.println("Name: " + xModel.getCurrentController().getFrame().getName());
        XWindow xWindow = AccessibilityTools.getCurrentWindow((XMultiServiceFactory)this.tParam.getMSF(), xModel);
        XAccessible xAccessible2 = AccessibilityTools.getAccessibleObject((XInterface)xWindow);
        AccessibilityTools.getAccessibleObjectForRole(xAccessible2, (short)58);
        XAccessibleComponent xAccessibleComponent = (XAccessibleComponent)UnoRuntime.queryInterface(class$com$sun$star$accessibility$XAccessibleComponent == null ? (class$com$sun$star$accessibility$XAccessibleComponent = _XRangeSelection.class$("com.sun.star.accessibility.XAccessibleComponent")) : class$com$sun$star$accessibility$XAccessibleComponent, (Object)AccessibilityTools.SearchedContext);
        this.log.println("Got " + utils.getImplName(xAccessibleComponent));
        Object object = null;
        try {
            object = ((XMultiServiceFactory)this.tParam.getMSF()).createInstance("com.sun.star.awt.Toolkit");
        }
        catch (Exception exception) {
            this.log.println("Couldn't get toolkit");
            exception.printStackTrace(this.log);
            throw new StatusException("Couldn't get toolkit", exception);
        }
        XExtendedToolkit xExtendedToolkit = (XExtendedToolkit)UnoRuntime.queryInterface(class$com$sun$star$awt$XExtendedToolkit == null ? (class$com$sun$star$awt$XExtendedToolkit = _XRangeSelection.class$("com.sun.star.awt.XExtendedToolkit")) : class$com$sun$star$awt$XExtendedToolkit, object);
        XTopWindow xTopWindow2 = null;
        int n = xExtendedToolkit.getTopWindowCount();
        for (int i = 0; i < n; ++i) {
            try {
                xTopWindow = xExtendedToolkit.getTopWindow(i);
                xAccessible = (XAccessible)UnoRuntime.queryInterface(class$com$sun$star$accessibility$XAccessible == null ? _XRangeSelection.class$("com.sun.star.accessibility.XAccessible") : class$com$sun$star$accessibility$XAccessible, (Object)xTopWindow);
                if (xAccessible != null) {
                    if (xAccessible.getAccessibleContext().getAccessibleName().indexOf("d2") <= 0) continue;
                    xTopWindow2 = xTopWindow;
                    continue;
                }
                this.log.println("\t unknown window");
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        if (xTopWindow2 == null) {
            System.out.println("No TopWindow :-(");
            return null;
        }
        Point point = xAccessibleComponent.getLocationOnScreen();
        xTopWindow = xAccessibleComponent.getBounds();
        xAccessible = new Point();
        xAccessible.X = point.X + xTopWindow.Width / 2;
        xAccessible.Y = point.Y + xTopWindow.Height / 2;
        return xAccessible;
    }

    private Point getCloser(Point point) {
        Point point2;
        XAccessible xAccessible;
        XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)this.tParam.getMSF();
        Object object = null;
        try {
            object = xMultiServiceFactory.createInstance("com.sun.star.awt.Toolkit");
        }
        catch (Exception exception) {
            throw new StatusException("Could not create 'com.sun.star.awt.Toolkit'.", exception);
        }
        XExtendedToolkit xExtendedToolkit = (XExtendedToolkit)UnoRuntime.queryInterface(class$com$sun$star$awt$XExtendedToolkit == null ? (class$com$sun$star$awt$XExtendedToolkit = _XRangeSelection.class$("com.sun.star.awt.XExtendedToolkit")) : class$com$sun$star$awt$XExtendedToolkit, object);
        AccessibilityTools accessibilityTools = new AccessibilityTools();
        XWindow xWindow = (XWindow)UnoRuntime.queryInterface(class$com$sun$star$awt$XWindow == null ? (class$com$sun$star$awt$XWindow = _XRangeSelection.class$("com.sun.star.awt.XWindow")) : class$com$sun$star$awt$XWindow, (Object)xExtendedToolkit.getActiveTopWindow());
        XAccessible xAccessible2 = AccessibilityTools.getAccessibleObject((XInterface)xWindow);
        XTopWindow xTopWindow = null;
        XAccessibleComponent xAccessibleComponent = null;
        int n = xExtendedToolkit.getTopWindowCount();
        for (int i = 0; i < n; ++i) {
            try {
                XTopWindow xTopWindow2 = xExtendedToolkit.getTopWindow(i);
                xAccessible = (XAccessible)UnoRuntime.queryInterface(class$com$sun$star$accessibility$XAccessible == null ? _XRangeSelection.class$("com.sun.star.accessibility.XAccessible") : class$com$sun$star$accessibility$XAccessible, (Object)xTopWindow2);
                if (xAccessible != null) {
                    System.out.println("Name: " + xAccessible.getAccessibleContext().getAccessibleName());
                    if (!xAccessible.getAccessibleContext().getAccessibleName().startsWith("the title")) continue;
                    xTopWindow = xTopWindow2;
                    xAccessibleComponent = (XAccessibleComponent)UnoRuntime.queryInterface(class$com$sun$star$accessibility$XAccessibleComponent == null ? _XRangeSelection.class$("com.sun.star.accessibility.XAccessibleComponent") : class$com$sun$star$accessibility$XAccessibleComponent, (Object)(point2 = xAccessible.getAccessibleContext()));
                    if (xAccessibleComponent == null) {
                        System.out.println("!!!! MIST !!!!");
                        continue;
                    }
                    System.out.println("########## KLAPPT ########## ");
                    continue;
                }
                this.log.println("\t unknown window");
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        if (xTopWindow == null) {
            System.out.println("No TopWindow :-(");
            return null;
        }
        xWindow = (XWindow)UnoRuntime.queryInterface(class$com$sun$star$awt$XWindow == null ? (class$com$sun$star$awt$XWindow = _XRangeSelection.class$("com.sun.star.awt.XWindow")) : class$com$sun$star$awt$XWindow, xTopWindow);
        Rectangle rectangle = xWindow.getPosSize();
        boolean bl = false;
        while (!bl) {
            if (rectangle.X <= point.X && point.X <= rectangle.X + rectangle.Width) {
                if (rectangle.Y <= point.Y && point.Y <= rectangle.Y + rectangle.Height) {
                    rectangle.X += 10;
                    rectangle.Y += 10;
                    xWindow.setPosSize(rectangle.X, rectangle.Y, rectangle.Width, rectangle.Height, (short)3);
                    continue;
                }
                bl = true;
                continue;
            }
            bl = true;
        }
        xAccessible = xAccessibleComponent.getLocationOnScreen();
        point2 = new Point();
        point2.X = xAccessible.X + rectangle.Width - 2;
        point2.Y = xAccessible.Y + 5;
        System.out.println("Closer: " + point2.X + "   " + point2.Y);
        return point2;
    }

    protected boolean clickOnSheet(Point point) {
        this.log.println("Clicking in the center of the AccessibleSpreadsheet");
        try {
            Robot robot = new Robot();
            robot.mouseMove(point.X, point.Y);
            robot.mousePress(16);
            utils.shortWait(1000);
            robot.mouseRelease(16);
            utils.shortWait(1000);
        }
        catch (AWTException aWTException) {
            this.log.println("couldn't press mouse button");
        }
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class MyRangeSelectionListener
    implements XRangeSelectionListener,
    XRangeSelectionChangeListener {
        boolean bAbortCalled = false;
        boolean bChangeCalled = false;
        boolean bDoneCalled = false;
        PrintWriter log = null;

        public MyRangeSelectionListener(PrintWriter printWriter) {
            this.log = printWriter;
        }

        public void aborted(RangeSelectionEvent rangeSelectionEvent) {
            this.log.println("Called 'aborted' with: " + rangeSelectionEvent.RangeDescriptor);
            this.bAbortCalled = true;
        }

        public void descriptorChanged(RangeSelectionEvent rangeSelectionEvent) {
            this.log.println("Called 'descriptorChanged' with: " + rangeSelectionEvent.RangeDescriptor);
            this.bChangeCalled = true;
        }

        public void done(RangeSelectionEvent rangeSelectionEvent) {
            this.log.println("Called 'done' with: " + rangeSelectionEvent.RangeDescriptor);
            this.bDoneCalled = true;
        }

        public boolean listenerCalled() {
            return this.bAbortCalled & this.bChangeCalled & this.bDoneCalled;
        }

        public void reset() {
            this.bAbortCalled = false;
            this.bChangeCalled = false;
            this.bDoneCalled = false;
        }

        public void disposing(EventObject eventObject) {
        }
    }
}

