/*
 * Decompiled with CFR 0.152.
 */
package ifc.i18n;

import com.sun.star.i18n.TransliterationModules;
import com.sun.star.i18n.TransliterationModulesNew;
import com.sun.star.i18n.XTransliteration;
import com.sun.star.lang.Locale;
import lib.MultiMethodTest;

public class _XTransliteration
extends MultiMethodTest {
    public XTransliteration oObj = null;
    private String[] mod = null;
    private Locale loc = new Locale("en", "EN", "");

    public void _getAvailableModules() {
        this.mod = this.oObj.getAvailableModules(this.loc, (short)1);
        if (this.mod != null) {
            this.log.println("Available modules :");
            for (int i = 0; i < this.mod.length; ++i) {
                this.log.println("  '" + this.mod[i] + "'");
            }
        } else {
            this.log.println("!!! NULL returned !!!");
        }
        this.tRes.tested("getAvailableModules()", this.mod != null && this.mod.length > 0);
    }

    public void _loadModule() {
        this.log.println("Load module IGNORE_CASE");
        this.oObj.loadModule(TransliterationModules.IGNORE_CASE, this.loc);
        String string = this.oObj.getName();
        boolean bl = string.equals("case ignore (generic)");
        this.log.println("getName return: " + string);
        this.tRes.tested("loadModule()", bl);
    }

    public void _loadModuleNew() {
        boolean bl = true;
        this.oObj.loadModuleNew(new TransliterationModulesNew[]{TransliterationModulesNew.LOWERCASE_UPPERCASE}, this.loc);
        String string = this.oObj.getName();
        bl = string.equals("lower_to_upper(generic)");
        this.log.println("getName return: " + string);
        this.tRes.tested("loadModuleNew()", bl);
    }

    public void _loadModuleByImplName() {
        this.log.println("Load module LOWERCASE_UPPERCASE");
        this.oObj.loadModuleByImplName("LOWERCASE_UPPERCASE", this.loc);
        String string = this.oObj.getName();
        boolean bl = string.equals("lower_to_upper(generic)");
        this.log.println("getName return: " + string);
        this.tRes.tested("loadModuleByImplName()", bl);
    }

    public void _loadModulesByImplNames() {
        this.log.println("Load module UPPERCASE_LOWERCASE");
        this.oObj.loadModulesByImplNames(new String[]{"UPPERCASE_LOWERCASE"}, this.loc);
        String string = this.oObj.getName();
        boolean bl = string.equals("upper_to_lower(generic)");
        this.log.println("getName return: " + string);
        this.tRes.tested("loadModulesByImplNames()", bl);
    }

    public void _getType() {
        this.oObj.loadModule(TransliterationModules.LOWERCASE_UPPERCASE, this.loc);
        boolean bl = this.oObj.getType() == 1;
        this.tRes.tested("getType()", bl);
    }

    public void _getName() {
        this.oObj.loadModule(TransliterationModules.LOWERCASE_UPPERCASE, this.loc);
        String string = this.oObj.getName();
        boolean bl = string.equals("lower_to_upper(generic)");
        this.log.println("getName return: " + string);
        this.tRes.tested("getName()", bl);
    }

    public void _transliterate() {
        this.oObj.loadModule(TransliterationModules.LOWERCASE_UPPERCASE, this.loc);
        int[][] nArrayArray = new int[1][];
        String string = this.oObj.transliterate("AaBbCc", 1, 4, (int[][])nArrayArray);
        boolean bl = "ABBC".equals(string) && nArrayArray[0].length == 4 && nArrayArray[0][0] == 1 && nArrayArray[0][1] == 2 && nArrayArray[0][2] == 3 && nArrayArray[0][3] == 4;
        this.tRes.tested("transliterate()", bl);
    }

    public void _transliterateRange() {
        boolean bl;
        this.oObj.loadModule(TransliterationModules.IGNORE_CASE, this.loc);
        String[] stringArray = this.oObj.transliterateRange("a", "i");
        this.log.println("transliterateRange return:");
        for (bl = false; bl < stringArray.length; bl += 1) {
            this.log.println(stringArray[bl]);
        }
        boolean bl2 = bl = stringArray != null && stringArray.length == 4 && "A".equals(stringArray[0]) && "I".equals(stringArray[1]) && "a".equals(stringArray[2]) && "i".equals(stringArray[3]) || "a".equals(stringArray[0]) && "i".equals(stringArray[1]) && "A".equals(stringArray[2]) && "I".equals(stringArray[3]);
        if (!bl) {
            this.log.println("Unexpected range returned :");
            for (int i = 0; i < stringArray.length; ++i) {
                this.log.print("'" + stringArray[i] + "', ");
            }
            this.log.println();
        }
        this.tRes.tested("transliterateRange()", bl);
    }

    public void _folding() {
        this.oObj.loadModule(TransliterationModules.LOWERCASE_UPPERCASE, this.loc);
        int[][] nArrayArray = new int[1][];
        String string = this.oObj.folding("AaBbCc", 1, 4, (int[][])nArrayArray);
        boolean bl = "ABBC".equals(string) && nArrayArray[0].length == 4 && nArrayArray[0][0] == 1 && nArrayArray[0][1] == 2 && nArrayArray[0][2] == 3 && nArrayArray[0][3] == 4;
        this.tRes.tested("folding()", bl);
    }

    public void _equals() {
        this.oObj.loadModule(TransliterationModules.LOWERCASE_UPPERCASE, this.loc);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        boolean bl = this.oObj.equals("aAbBcC", 1, 3, nArray, "aAbBcC", 1, 3, nArray2);
        this.log.println("Returned : " + bl + " Match1 = " + nArray[0] + " Match2 = " + nArray2[0]);
        this.tRes.tested("equals()", bl);
    }

    public void _compareSubstring() {
        this.oObj.loadModule(TransliterationModules.LOWERCASE_UPPERCASE, this.loc);
        boolean bl = true;
        bl &= this.testSubstring("", 0, 0, "", 0, 0, 0);
        bl &= this.testSubstring("aa", 1, 0, "", 0, 0, 0);
        bl &= this.testSubstring("aa", 1, 0, "aa", 2, 0, 0);
        bl &= this.testSubstring("a", 0, 1, "a", 0, 1, 0);
        bl &= this.testSubstring("ab", 0, 2, "ab", 0, 2, 0);
        bl &= this.testSubstring("abc", 1, 2, "abc", 1, 2, 0);
        bl &= this.testSubstring("abcdef", 0, 3, "123abc", 3, 3, 0);
        bl &= this.testSubstring("abcdef", 1, 1, "123abc", 4, 1, 0);
        bl &= this.testSubstring("a", 0, 1, "a", 0, 0, 1);
        bl &= this.testSubstring("aaa", 1, 1, "", 0, 0, 1);
        bl &= this.testSubstring("bbb", 2, 1, "aaa", 2, 1, 1);
        bl &= this.testSubstring("abc", 0, 3, "abc", 0, 2, 1);
        this.tRes.tested("compareSubstring()", bl &= this.testSubstring("bbc", 1, 2, "bbc", 0, 2, 1));
    }

    private boolean testSubstring(String string, int n, int n2, String string2, int n3, int n4, int n5) {
        boolean bl = true;
        int n6 = -666;
        try {
            n6 = this.oObj.compareSubstring(string, n, n2, string2, n3, n4);
        }
        catch (NullPointerException nullPointerException) {
            this.log.println("Exception while method calling occurs :" + nullPointerException);
        }
        if (n6 != n5) {
            this.log.print("Comparing FAILED; return: " + n6 + ", expected: " + n5 + " ");
            bl = false;
        } else {
            this.log.print("Comparing OK : ");
        }
        this.log.println("('" + string + "', " + n + ", " + n2 + ", '" + string2 + "', " + n3 + ", " + n4 + ")");
        n6 = -666;
        try {
            n6 = this.oObj.compareSubstring(string2, n3, n4, string, n, n2);
        }
        catch (NullPointerException nullPointerException) {
            this.log.println("Exception while method calling occurs :" + nullPointerException);
        }
        if (n6 != -n5) {
            this.log.print("Comparing FAILED; return: " + n6 + ", expected: " + -n5 + " ");
            bl = false;
        } else {
            this.log.print("Comparing OK :");
        }
        this.log.println("('" + string2 + "', " + n3 + ", " + n4 + ", '" + string + "', " + n + ", " + n2 + ")");
        return bl;
    }

    public void _compareString() {
        this.oObj.loadModule(TransliterationModules.LOWERCASE_UPPERCASE, this.loc);
        boolean bl = true;
        bl &= this.testString("", "", 0);
        bl &= this.testString("a", "", 1);
        bl &= this.testString("a", "a", 0);
        bl &= this.testString("A", "a", 0);
        bl &= this.testString("b", "a", 1);
        bl &= this.testString("\n", "\n", 0);
        bl &= this.testString("\n", "\t", 1);
        bl &= this.testString("aaa", "aaa", 0);
        bl &= this.testString("aaA", "aaa", 0);
        bl &= this.testString("aaa", "aa", 1);
        bl &= this.testString("ab", "aaa", 1);
        bl &= this.testString("aba", "aa", 1);
        bl &= this.testString("aaa\t\na", "aaa\t\na", 0);
        this.tRes.tested("compareString()", bl &= this.testString("aaa\t\nb", "aaa\t\na", 1));
    }

    protected boolean testString(String string, String string2, int n) {
        if (n == 0) {
            return this.testString(string, string2, n, false);
        }
        return this.testString(string, string2, n, true);
    }

    private boolean testString(String string, String string2, int n, boolean bl) {
        boolean bl2 = true;
        int n2 = -666;
        try {
            n2 = this.oObj.compareString(string, string2);
        }
        catch (NullPointerException nullPointerException) {
            this.log.println("Exception while method calling occurs :" + nullPointerException);
        }
        if (n2 == n) {
            this.log.println("Comparing of '" + string + "' and '" + string2 + "' OK");
        } else {
            this.log.println("Comparing of '" + string + "' and '" + string2 + "' FAILED; return: " + n2 + ", expected: " + n);
            bl2 = false;
        }
        if (!bl) {
            return bl2;
        }
        n2 = -666;
        try {
            n2 = this.oObj.compareString(string2, string);
        }
        catch (NullPointerException nullPointerException) {
            this.log.println("Exception while method calling occurs :" + nullPointerException);
        }
        if (n2 == -n) {
            this.log.println("Comparing of '" + string2 + "' and '" + string + "' OK");
        } else {
            this.log.println("Comparing of '" + string2 + "' and '" + string + "' FAILED; return: " + n2 + ", expected: " + -n);
            bl2 = false;
        }
        return bl2;
    }
}

