/*
 * Decompiled with CFR 0.152.
 */
package ifc.frame;

import com.sun.star.awt.XWindow;
import com.sun.star.frame.FrameAction;
import com.sun.star.frame.FrameActionEvent;
import com.sun.star.frame.XController;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XFrameActionListener;
import com.sun.star.frame.XFramesSupplier;
import com.sun.star.lang.EventObject;
import com.sun.star.uno.RuntimeException;
import java.io.PrintWriter;
import lib.MultiMethodTest;
import lib.TestEnvironment;

public class _XFrame
extends MultiMethodTest {
    final FrameAction[] actionEvent = new FrameAction[1];
    final boolean[] listenerCalled = new boolean[]{false};
    final boolean[] activatedCalled = new boolean[]{false};
    final boolean[] deactivatedCalled = new boolean[]{false};
    final TestFrameActionListener listener = new TestFrameActionListener();
    public static XFrame oObj = null;

    public void _getName() {
        String string = oObj.getName();
        if (string == null) {
            this.log.println("getName() returned null: FAILED");
        }
        this.tRes.tested("getName()", string != null);
    }

    public void _setName() {
        String string = "XFrame";
        oObj.setName(string);
        String string2 = oObj.getName();
        boolean bl = string.equals(string2);
        if (!bl) {
            this.log.println("setName('" + string + "'), but getName() return '" + string2 + "'");
        }
        this.tRes.tested("setName()", bl);
    }

    public void _activate() {
        oObj.activate();
        this.tRes.tested("activate()", true);
    }

    public void _deactivate() {
        oObj.deactivate();
        oObj.activate();
        this.tRes.tested("deactivate()", true);
    }

    public void _isActive() {
        boolean bl;
        boolean bl2 = true;
        if (this.tEnv.getTestCase().getObjectName().equals("Desktop")) {
            this.log.println("Desktop is always active");
            this.tRes.tested("isActive()", oObj.isActive());
            return;
        }
        oObj.deactivate();
        bl2 &= !oObj.isActive();
        if (oObj.isActive()) {
            this.log.println("after deactivate() method call, isActive() returned true");
        }
        oObj.activate();
        bl2 &= oObj.isActive();
        if (!oObj.isActive()) {
            this.log.println("after activate() method call, isActive() returned false");
        }
        if (bl = _XFrame.isDesktop(this.log, this.tEnv, "isActive()")) {
            bl2 = bl;
        }
        this.tRes.tested("isActive()", bl2);
    }

    public void _addFrameActionListener() {
        boolean bl = true;
        oObj.addFrameActionListener((XFrameActionListener)this.listener);
        oObj.activate();
        oObj.deactivate();
        oObj.activate();
        if (this.tEnv.getTestCase().getObjectName().equals("Desktop")) {
            this.log.println("No actions supported by Desktop");
            this.tRes.tested("addFrameActionListener()", true);
            return;
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!this.listenerCalled[0]) {
            this.log.println("listener was not called.");
            bl = false;
        } else {
            if (!this.activatedCalled[0]) {
                this.log.println("Listener was called, FRAME_ACTIVATED was not");
                bl = false;
            }
            if (!this.deactivatedCalled[0]) {
                this.log.println("Listener was called, FRAME_DEACTIVATING was not");
                bl = false;
            }
        }
        boolean bl2 = _XFrame.isDesktop(this.log, this.tEnv, "addFrameActionListener()");
        if (bl2) {
            bl = bl2;
        }
        this.tRes.tested("addFrameActionListener()", bl);
    }

    public void _removeFrameActionListener() {
        boolean bl;
        boolean bl2 = true;
        this.requiredMethod("addFrameActionListener()");
        this.listenerCalled[0] = false;
        oObj.removeFrameActionListener((XFrameActionListener)this.listener);
        oObj.activate();
        oObj.deactivate();
        oObj.activate();
        if (this.tEnv.getTestCase().getObjectName().equals("Desktop")) {
            this.log.println("No actions supported by Desktop");
            this.tRes.tested("removeFrameActionListener()", true);
            return;
        }
        if (this.listenerCalled[0]) {
            this.log.println("Listener wasn't removed, and was called");
        }
        bl2 = (bl = _XFrame.isDesktop(this.log, this.tEnv, "removeFrameActionListener()")) ? bl : !this.listenerCalled[0];
        this.tRes.tested("removeFrameActionListener()", bl2);
    }

    public void _getCreator() {
        boolean bl;
        boolean bl2 = true;
        if (this.tEnv.getTestCase().getObjectName().equals("Desktop")) {
            this.log.println("Desktop has no creator");
            this.tRes.tested("getCreator()", true);
            return;
        }
        XFramesSupplier xFramesSupplier = oObj.getCreator();
        if (xFramesSupplier == null) {
            this.log.println("getCreator() returns null");
        }
        bl2 = (bl = _XFrame.isDesktop(this.log, this.tEnv, "getCreator()")) ? bl : xFramesSupplier != null;
        this.tRes.tested("getCreator()", bl2);
    }

    public void _getComponentWindow() {
        boolean bl;
        boolean bl2 = true;
        XWindow xWindow = oObj.getComponentWindow();
        if (this.tEnv.getTestCase().getObjectName().equals("Desktop")) {
            this.log.println("Desktop has no component window");
            this.tRes.tested("getComponentWindow()", true);
            return;
        }
        if (xWindow == null) {
            this.log.println("getComponentWindow() returns null");
        }
        bl2 = (bl = _XFrame.isDesktop(this.log, this.tEnv, "getComponentWindow()")) ? bl : xWindow != null;
        this.tRes.tested("getComponentWindow()", bl2);
    }

    public void _getContainerWindow() {
        boolean bl;
        boolean bl2 = true;
        if (this.tEnv.getTestCase().getObjectName().equals("Desktop")) {
            this.log.println("Desktop has no container window");
            this.tRes.tested("getContainerWindow()", true);
            return;
        }
        XWindow xWindow = oObj.getContainerWindow();
        if (xWindow == null) {
            this.log.println("getContainerWindow() returns null");
        }
        bl2 = (bl = _XFrame.isDesktop(this.log, this.tEnv, "getContainerWindow()")) ? bl : xWindow != null;
        this.tRes.tested("getContainerWindow()", bl2);
    }

    public void _getController() {
        boolean bl = true;
        XController xController = oObj.getController();
        if (this.tEnv.getTestCase().getObjectName().equals("Desktop")) {
            this.log.println("Desktop has no controller");
            this.tRes.tested("getController()", true);
            return;
        }
        if (xController == null) {
            this.log.println("getController() returns null");
            bl = false;
        } else {
            XFrame xFrame = xController.getFrame();
            if (!oObj.equals(xFrame)) {
                this.log.println("Frame returned by controller not equals to frame testing");
                bl = false;
            }
        }
        boolean bl2 = _XFrame.isDesktop(this.log, this.tEnv, "getController()");
        if (bl2) {
            bl = bl2;
        }
        this.tRes.tested("getController()", bl);
    }

    public void _isTop() {
        this.log.println("isTop() = " + oObj.isTop());
        this.tRes.tested("isTop()", true);
    }

    public void _findFrame() {
        XFrame xFrame;
        boolean bl = true;
        XFrame xFrame2 = (XFrame)this.tEnv.getObjRelation("XFrame");
        if (xFrame2 != null) {
            this.log.println("Trying to find a frame with name 'XFrame' ...");
            xFrame = oObj.findFrame("XFrame", 55);
            if (xFrame == null) {
                this.log.println("findFrame(\"XFrame,com.sun.star.frame.FrameSearchFlag.GLOBAL\") returns null");
                bl = false;
            } else if (!xFrame2.equals(xFrame)) {
                this.log.println("findFrame(\"XFrame,com.sun.star.frame.FrameSearchFlag.GLOBAL\")  returns frame which is not equal to passed in relation");
                bl = false;
            }
        }
        this.log.println("Trying to find a frame with name '_self' ...");
        xFrame = oObj.findFrame("_self", 0);
        if (xFrame == null) {
            this.log.println("findFrame(\"_self\") returns null");
            bl = false;
        } else if (!oObj.equals(xFrame)) {
            this.log.println("findFrame(\"_self\")  returns frame which is not equal to tested");
            bl = false;
        }
        this.tRes.tested("findFrame()", bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _contextChanged() {
        boolean bl = true;
        TestFrameActionListener testFrameActionListener = new TestFrameActionListener();
        if (this.tEnv.getTestCase().getObjectName().equals("Desktop")) {
            this.log.println("Desktop cann't change context");
            this.tRes.tested("contextChanged()", true);
            return;
        }
        this.listenerCalled[0] = false;
        oObj.addFrameActionListener((XFrameActionListener)testFrameActionListener);
        try {
            oObj.contextChanged();
            if (!this.listenerCalled[0]) {
                this.log.println("listener was not called on contextChanged() call.");
                bl = false;
            } else if (this.actionEvent[0] != FrameAction.CONTEXT_CHANGED) {
                this.log.println("listener was called, but Action != CONTEXT_CHANGED");
                bl = false;
            }
        }
        finally {
            oObj.removeFrameActionListener((XFrameActionListener)testFrameActionListener);
        }
        boolean bl2 = _XFrame.isDesktop(this.log, this.tEnv, "contextChanged()");
        if (bl2) {
            bl = bl2;
        }
        this.tRes.tested("contextChanged()", bl);
    }

    public void _setCreator() {
        if (this.tEnv.getTestCase().getObjectName().equals("Desktop")) {
            this.log.println("Desktop has no creator");
            this.tRes.tested("setCreator()", true);
            return;
        }
        XFramesSupplier xFramesSupplier = oObj.getCreator();
        oObj.setCreator(null);
        this.tRes.tested("setCreator()", oObj.getCreator() == null);
        oObj.setCreator(xFramesSupplier);
    }

    public void _setComponent() {
        this.requiredMethod("getName()");
        this.requiredMethod("setName()");
        this.requiredMethod("activate()");
        this.requiredMethod("deactivate()");
        this.requiredMethod("isActive()");
        this.requiredMethod("addFrameActionListener()");
        this.requiredMethod("getComponentWindow()");
        this.requiredMethod("getContainerWindow()");
        this.requiredMethod("getController()");
        this.requiredMethod("isTop()");
        this.requiredMethod("findFrame()");
        this.requiredMethod("contextChanged()");
        this.requiredMethod("setCreator()");
        boolean bl = true;
        XWindow xWindow = oObj.getComponentWindow();
        XController xController = oObj.getController();
        boolean bl2 = oObj.setComponent(null, null);
        if (bl2) {
            bl &= oObj.getComponentWindow() == null;
            if (!(bl &= oObj.getController() == null)) {
                this.log.println("setComponent() returns true, but component is not changed.");
            }
        } else {
            bl &= oObj.getComponentWindow() == xWindow;
            if (!(bl &= oObj.getController() == xController)) {
                this.log.println("setComponent() returns false, but component ischanged.");
            }
        }
        this.tRes.tested("setComponent()", bl);
    }

    public void _initialize() {
        this.requiredMethod("setComponent()");
        XWindow xWindow = oObj.getContainerWindow();
        boolean bl = true;
        try {
            oObj.initialize(xWindow);
        }
        catch (RuntimeException runtimeException) {
            String string = "Frame::initialized() is called more then once, which isnt usefull nor allowed.";
            if (runtimeException.toString().indexOf(string) != -1) {
                this.log.println(runtimeException.toString());
                this.log.println("methods throws exception, but it's OK");
            }
            this.log.println(runtimeException.toString());
            bl = false;
        }
        this.tRes.tested("initialize()", bl);
    }

    public static boolean isDesktop(PrintWriter printWriter, TestEnvironment testEnvironment, String string) {
        Object object = testEnvironment.getObjRelation("Desktop");
        if (object != null) {
            printWriter.println("The Desktop doesn't support the method " + string);
            printWriter.println("It will always return true");
            return true;
        }
        return false;
    }

    public void after() {
        this.disposeEnvironment();
    }

    private class TestFrameActionListener
    implements XFrameActionListener {
        private TestFrameActionListener() {
        }

        public void frameAction(FrameActionEvent frameActionEvent) {
            _XFrame.this.listenerCalled[0] = true;
            _XFrame.this.activatedCalled[0] = _XFrame.this.activatedCalled[0] | frameActionEvent.Action == FrameAction.FRAME_ACTIVATED;
            _XFrame.this.deactivatedCalled[0] = _XFrame.this.deactivatedCalled[0] | frameActionEvent.Action == FrameAction.FRAME_DEACTIVATING;
            _XFrame.this.actionEvent[0] = frameActionEvent.Action;
        }

        public void disposing(EventObject eventObject) {
        }
    }
}

