/*
 * Decompiled with CFR 0.152.
 */
package convwatch;

import com.sun.star.beans.PropertyValue;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XNameAccess;
import com.sun.star.document.XTypeDetection;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XModel;
import com.sun.star.frame.XStorable;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.view.XPrintable;
import convwatch.ConvWatchCancelException;
import convwatch.DB;
import convwatch.FileHelper;
import convwatch.GlobalLogWriter;
import convwatch.GraphicalTestArguments;
import convwatch.MSOfficePrint;
import convwatch.OSHelper;
import helper.URLHelper;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class OfficePrint {
    static /* synthetic */ Class class$com$sun$star$frame$XModel;
    static /* synthetic */ Class class$com$sun$star$frame$XDesktop;
    static /* synthetic */ Class class$com$sun$star$frame$XComponentLoader;
    static /* synthetic */ Class class$com$sun$star$lang$XServiceInfo;
    static /* synthetic */ Class class$com$sun$star$frame$XStorable;
    static /* synthetic */ Class class$com$sun$star$view$XPrintable;
    static /* synthetic */ Class class$com$sun$star$document$XTypeDetection;
    static /* synthetic */ Class class$com$sun$star$container$XNameAccess;

    static void waitInSeconds(int n, String string) {
        GlobalLogWriter.get().println("Wait " + String.valueOf(n) + " sec. Reason: " + string);
        try {
            Thread.sleep(n * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static void showDocumentType(XComponent xComponent) {
        XModel xModel = (XModel)UnoRuntime.queryInterface(class$com$sun$star$frame$XModel == null ? (class$com$sun$star$frame$XModel = OfficePrint.class$("com.sun.star.frame.XModel")) : class$com$sun$star$frame$XModel, (Object)xComponent);
        PropertyValue[] propertyValueArray = xModel.getArgs();
        for (int i = 0; i < propertyValueArray.length; ++i) {
            PropertyValue propertyValue = propertyValueArray[i];
            if (!propertyValue.Name.equals("FilterName") && !propertyValue.Name.equals("MediaType")) continue;
            GlobalLogWriter.get().println("  Property: '" + propertyValue.Name + "' := '" + propertyValue.Value + "'");
        }
    }

    public static XComponent loadFromURL(GraphicalTestArguments graphicalTestArguments, String string) {
        XComponent xComponent = null;
        try {
            Object object;
            if (graphicalTestArguments.getMultiServiceFactory() == null) {
                GlobalLogWriter.get().println("MultiServiceFactory in GraphicalTestArgument not set.");
                return null;
            }
            XDesktop xDesktop = (XDesktop)UnoRuntime.queryInterface(class$com$sun$star$frame$XDesktop == null ? (class$com$sun$star$frame$XDesktop = OfficePrint.class$("com.sun.star.frame.XDesktop")) : class$com$sun$star$frame$XDesktop, object = graphicalTestArguments.getMultiServiceFactory().createInstance("com.sun.star.frame.Desktop"));
            if (xDesktop != null) {
                PropertyValue propertyValue;
                GlobalLogWriter.get().println("com.sun.star.frame.Desktop created.");
                int n = 0;
                if (graphicalTestArguments.isHidden()) {
                    ++n;
                }
                if (graphicalTestArguments.getImportFilterName() != null && graphicalTestArguments.getImportFilterName().length() > 0) {
                    ++n;
                }
                int n2 = 0;
                PropertyValue[] propertyValueArray = new PropertyValue[n];
                if (graphicalTestArguments.isHidden()) {
                    propertyValue = new PropertyValue();
                    propertyValue.Name = "Hidden";
                    propertyValue.Value = Boolean.TRUE;
                    propertyValueArray[n2++] = propertyValue;
                }
                if (graphicalTestArguments.getImportFilterName() != null && graphicalTestArguments.getImportFilterName().length() > 0) {
                    propertyValue = new PropertyValue();
                    propertyValue.Name = "FilterName";
                    propertyValue.Value = graphicalTestArguments.getImportFilterName();
                    propertyValueArray[n2++] = propertyValue;
                }
                GlobalLogWriter.get().println("Load document");
                propertyValue = (XComponentLoader)UnoRuntime.queryInterface(class$com$sun$star$frame$XComponentLoader == null ? (class$com$sun$star$frame$XComponentLoader = OfficePrint.class$("com.sun.star.frame.XComponentLoader")) : class$com$sun$star$frame$XComponentLoader, (Object)xDesktop);
                graphicalTestArguments.getPerformance().startTime(0);
                xComponent = propertyValue.loadComponentFromURL(string, "_blank", 0, propertyValueArray);
                graphicalTestArguments.getPerformance().stopTime(0);
                if (xComponent != null) {
                    GlobalLogWriter.get().println(" done.");
                    OfficePrint.showDocumentType(xComponent);
                } else {
                    GlobalLogWriter.get().println(" failed.");
                    if (graphicalTestArguments.getImportFilterName() != null && graphicalTestArguments.getImportFilterName().length() > 0) {
                        GlobalLogWriter.get().println(" Please check FilterName := '" + graphicalTestArguments.getImportFilterName() + "'");
                    }
                    GlobalLogWriter.get().println("");
                }
            } else {
                GlobalLogWriter.get().println("com.sun.star.frame.Desktop failed.");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            xComponent = null;
        }
        return xComponent;
    }

    static boolean exportToPDF(XComponent xComponent, String string) {
        XServiceInfo xServiceInfo = (XServiceInfo)UnoRuntime.queryInterface(class$com$sun$star$lang$XServiceInfo == null ? (class$com$sun$star$lang$XServiceInfo = OfficePrint.class$("com.sun.star.lang.XServiceInfo")) : class$com$sun$star$lang$XServiceInfo, (Object)xComponent);
        PropertyValue[] propertyValueArray = new PropertyValue[]{new PropertyValue()};
        propertyValueArray[0].Name = "FilterName";
        propertyValueArray[0].Value = OfficePrint.getFilterName_forPDF(xServiceInfo);
        boolean bl = true;
        try {
            XStorable xStorable = (XStorable)UnoRuntime.queryInterface(class$com$sun$star$frame$XStorable == null ? (class$com$sun$star$frame$XStorable = OfficePrint.class$("com.sun.star.frame.XStorable")) : class$com$sun$star$frame$XStorable, (Object)xComponent);
            xStorable.storeToURL(string, propertyValueArray);
        }
        catch (com.sun.star.io.IOException iOException) {
            bl = false;
        }
        return bl;
    }

    static String getFilterName_forPDF(XServiceInfo xServiceInfo) {
        String string = "";
        if (xServiceInfo.supportsService("com.sun.star.text.TextDocument")) {
            string = "writer_pdf_Export";
        } else if (xServiceInfo.supportsService("com.sun.star.sheet.SpreadsheetDocument")) {
            string = "calc_pdf_Export";
        } else if (xServiceInfo.supportsService("com.sun.star.drawing.DrawingDocument")) {
            string = "draw_pdf_Export";
        } else if (xServiceInfo.supportsService("com.sun.star.presentation.PresentationDocument")) {
            string = "impress_pdf_Export";
        } else if (xServiceInfo.supportsService("com.sun.star.text.WebDocument")) {
            string = "writer_web_pdf_Export";
        } else if (xServiceInfo.supportsService("com.sun.star.text.GlobalDocument")) {
            string = "writer_globaldocument_pdf_Export";
        } else if (xServiceInfo.supportsService("com.sun.star.formulaFormulaProperties")) {
            string = "math_pdf_Export";
        }
        return string;
    }

    public static boolean storeAsPDF(GraphicalTestArguments graphicalTestArguments, String string, String string2) {
        boolean bl = false;
        XComponent xComponent = OfficePrint.loadFromURL(graphicalTestArguments, string);
        if (xComponent == null) {
            GlobalLogWriter.get().println("Can't load document.");
            return bl;
        }
        bl = OfficePrint.storeAsPDF(graphicalTestArguments, xComponent, string2);
        OfficePrint.createInfoFile(string2, graphicalTestArguments, "as pdf");
        GlobalLogWriter.get().println("close document.");
        xComponent.dispose();
        return bl;
    }

    public static boolean storeAsPDF(GraphicalTestArguments graphicalTestArguments, XComponent xComponent, String string) {
        boolean bl = true;
        graphicalTestArguments.getPerformance().startTime(4);
        bl = OfficePrint.exportToPDF(xComponent, string);
        graphicalTestArguments.getPerformance().stopTime(4);
        if (!bl) {
            GlobalLogWriter.get().println("Can't store document as PDF.");
            bl = false;
        }
        return bl;
    }

    public static boolean printToFileWithOOo(GraphicalTestArguments graphicalTestArguments, String string, String string2, String string3) {
        boolean bl = false;
        XComponent xComponent = OfficePrint.loadFromURL(graphicalTestArguments, string);
        if (xComponent != null) {
            if (string.equals(string2)) {
                GlobalLogWriter.get().println("Warning: Inputpath and Outputpath are equal. Document will not stored again.");
                graphicalTestArguments.disallowStore();
            }
            bl = OfficePrint.printToFileWithOOo(graphicalTestArguments, xComponent, string2, string3);
            GlobalLogWriter.get().println("close document.");
            xComponent.dispose();
        } else {
            GlobalLogWriter.get().println("loadDocumentFromURL() failed with document: " + string);
        }
        return bl;
    }

    public static void createInfoFile(String string, GraphicalTestArguments graphicalTestArguments) {
        OfficePrint.createInfoFile(string, graphicalTestArguments, "");
    }

    public static void createInfoFile(String string, GraphicalTestArguments graphicalTestArguments, String string2) {
        Object object;
        String string3;
        if (string.startsWith("file:///")) {
            string3 = FileHelper.getSystemPathFromFileURL(string);
            GlobalLogWriter.get().println("CreateInfoFile: '" + string3 + "'");
        } else {
            string3 = string;
        }
        String string4 = FileHelper.getPath(string3);
        String string5 = FileHelper.getBasename(string3);
        String string6 = FileHelper.getNameNoSuffix(string5);
        String string7 = System.getProperty("file.separator");
        String string8 = System.getProperty("line.separator");
        String string9 = string4 + string7 + string6 + ".info";
        File file = new File(string9);
        String string10 = "";
        try {
            object = new FileWriter(file.toString());
            ((Writer)object).write("# automatically created file by graphical compare" + string8);
            if (graphicalTestArguments != null) {
                if (string2 != null && string2.equals("msoffice")) {
                    ((Writer)object).write("# buildid from wordloadfile" + string8);
                    string10 = graphicalTestArguments.getPerformance().getMSOfficeVersion();
                    ((Writer)object).write("buildid=" + string10 + string8);
                } else {
                    ((Writer)object).write("# buildid is read out of the bootstrap file" + string8);
                    string10 = graphicalTestArguments.getBuildID();
                    ((Writer)object).write("buildid=" + string10 + string8);
                }
                ((Writer)object).write(string8);
                ((Writer)object).write("# resolution given in DPI" + string8);
                ((Writer)object).write("resolution=" + graphicalTestArguments.getResolutionInDPI() + string8);
            } else {
                ((Writer)object).write("buildid=" + string2 + string8);
            }
            ((Writer)object).write(string8);
            ((Writer)object).write("# Values out of System.getProperty(...)" + string8);
            ((Writer)object).write("os.name=" + System.getProperty("os.name") + string8);
            ((Writer)object).write("os.arch=" + System.getProperty("os.arch") + string8);
            ((Writer)object).write("os.version=" + System.getProperty("os.version") + string8);
            if (graphicalTestArguments != null) {
                ((Writer)object).write(string8);
                ((Writer)object).write("# Performance output, values are given in milli sec." + string8);
                graphicalTestArguments.getPerformance().print((FileWriter)object);
            }
            ((OutputStreamWriter)object).flush();
            ((OutputStreamWriter)object).close();
        }
        catch (IOException iOException) {
            GlobalLogWriter.get().println("can't create Info file.");
            iOException.printStackTrace();
        }
        object = FileHelper.getSuffix(graphicalTestArguments.getInputFile());
        if (((String)object).startsWith(".")) {
            object = ((String)object).substring(1);
        }
        DB.writeToDB(graphicalTestArguments.getDBInfoString(), graphicalTestArguments.getInputFile(), string6, (String)object, string10, graphicalTestArguments.getReferenceType(), graphicalTestArguments.getResolutionInDPI());
    }

    public static boolean printToFileWithOOo(GraphicalTestArguments graphicalTestArguments, XComponent xComponent, String string, String string2) {
        boolean bl = false;
        boolean bl2 = true;
        if (xComponent == null) {
            GlobalLogWriter.get().println("No document is given.");
            return bl;
        }
        try {
            GlobalLogWriter.get().println("Document print.");
            XPrintable xPrintable = (XPrintable)UnoRuntime.queryInterface(class$com$sun$star$view$XPrintable == null ? (class$com$sun$star$view$XPrintable = OfficePrint.class$("com.sun.star.view.XPrintable")) : class$com$sun$star$view$XPrintable, (Object)xComponent);
            if (xPrintable != null) {
                PropertyValue[] propertyValueArray;
                String string3;
                if (OSHelper.isWindows() && graphicalTestArguments.getPrinterName() != null) {
                    PropertyValue[] propertyValueArray2 = new PropertyValue[1];
                    PropertyValue propertyValue = new PropertyValue();
                    propertyValue.Name = "Name";
                    propertyValue.Value = graphicalTestArguments.getPrinterName();
                    propertyValueArray2[0] = propertyValue;
                    GlobalLogWriter.get().println("Printername is not null, so set to " + graphicalTestArguments.getPrinterName());
                    xPrintable.setPrinter(propertyValueArray2);
                }
                int n = 1;
                if (!graphicalTestArguments.printAllPages()) {
                    ++n;
                }
                int n2 = 0;
                PropertyValue[] propertyValueArray3 = new PropertyValue[n];
                PropertyValue propertyValue = new PropertyValue();
                propertyValue.Name = "FileName";
                propertyValue.Value = string2;
                propertyValueArray3[n2++] = propertyValue;
                if (!graphicalTestArguments.printAllPages()) {
                    string3 = "";
                    if (graphicalTestArguments.getMaxPages() > 0) {
                        string3 = "1-" + String.valueOf(graphicalTestArguments.getMaxPages());
                    }
                    if (graphicalTestArguments.getOnlyPages().length() != 0) {
                        if (string3.length() != 0) {
                            string3 = string3 + ";";
                        }
                        string3 = string3 + String.valueOf(graphicalTestArguments.getOnlyPages());
                    }
                    propertyValue = new PropertyValue();
                    propertyValue.Name = "Pages";
                    propertyValue.Value = string3;
                    propertyValueArray3[n2++] = propertyValue;
                }
                if (string != null && graphicalTestArguments.isStoreAllowed() && (string3 = (XStorable)UnoRuntime.queryInterface(class$com$sun$star$frame$XStorable == null ? (class$com$sun$star$frame$XStorable = OfficePrint.class$("com.sun.star.frame.XStorable")) : class$com$sun$star$frame$XStorable, (Object)xComponent)) != null) {
                    propertyValueArray = new PropertyValue[]{};
                    GlobalLogWriter.get().println("Document stored.");
                    graphicalTestArguments.getPerformance().startTime(1);
                    string3.storeAsURL(string, propertyValueArray);
                    graphicalTestArguments.getPerformance().stopTime(1);
                }
                GlobalLogWriter.get().println("start printing.");
                graphicalTestArguments.getPerformance().startTime(2);
                xPrintable.print(propertyValueArray3);
                OfficePrint.waitInSeconds(1, "unknown.");
                GlobalLogWriter.get().println("Wait until document is printed.");
                boolean bl3 = true;
                while (bl3) {
                    propertyValueArray = xPrintable.getPrinter();
                    int n3 = 0;
                    while (!"IsBusy".equals(propertyValueArray[n3].Name)) {
                        ++n3;
                    }
                    bl3 = propertyValueArray[n3].Value == Boolean.TRUE;
                    OfficePrint.waitInSeconds(1, "is print ready?");
                }
                graphicalTestArguments.getPerformance().stopTime(2);
                OfficePrint.createInfoFile(string2, graphicalTestArguments);
            } else {
                GlobalLogWriter.get().println("Can't get XPrintable.");
            }
            bl2 = false;
            bl = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = false;
        }
        if (bl2) {
            GlobalLogWriter.get().println("convwatch.OfficePrint: FAILED");
        } else {
            GlobalLogWriter.get().println("convwatch.OfficePrint: OK");
        }
        return bl;
    }

    public static boolean isReferenceExists(GraphicalTestArguments graphicalTestArguments, String string, String string2) {
        String string3;
        if (!FileHelper.exists(string2)) {
            return false;
        }
        String string4 = System.getProperty("file.separator");
        String string5 = FileHelper.getBasename(string2);
        String string6 = string != null ? string : (string3 = FileHelper.getPath(string2));
        string3 = FileHelper.getNameNoSuffix(string5);
        String string7 = string6 + string4 + string3 + ".prn";
        if (FileHelper.exists(string7) && !graphicalTestArguments.getOverwrite()) {
            GlobalLogWriter.get().println("Reference already exist, don't overwrite. Set DOC_COMPARATOR_OVERWRITE_REFERENCE=true to force overwrite.");
            return true;
        }
        return false;
    }

    public static boolean buildReference(GraphicalTestArguments graphicalTestArguments, String string, String string2) throws ConvWatchCancelException {
        String string3;
        String string4;
        String string5;
        if (!FileHelper.exists(string2)) {
            throw new ConvWatchCancelException("buildReference(): Input file: " + string2 + " does not exist.");
        }
        String string6 = System.getProperty("file.separator");
        String string7 = URLHelper.getFileURLFromSystemPath(string2);
        String string8 = FileHelper.getBasename(string2);
        String string9 = null;
        if (string != null) {
            string5 = string;
            FileHelper.makeDirectories("", string5);
        } else {
            string5 = string4 = FileHelper.getPath(string2);
        }
        string9 = null;
        string4 = FileHelper.getNameNoSuffix(string8);
        String string10 = string5 + string6 + string4 + ".prn";
        if (FileHelper.exists(string10) && !graphicalTestArguments.getOverwrite()) {
            GlobalLogWriter.get().println("Reference already exist, don't overwrite. Set DOC_COMPARATOR_OVERWRITE_REFERENCE=true to force overwrite.");
            return true;
        }
        if (graphicalTestArguments.getReferenceType().toLowerCase().equals("msoffice")) {
            string3 = URLHelper.getFileURLFromSystemPath(string10);
        } else if (graphicalTestArguments.getReferenceType().toLowerCase().equals("pdf")) {
            string3 = URLHelper.getFileURLFromSystemPath(string10);
        } else if (graphicalTestArguments.getReferenceType().toLowerCase().equals("ooo")) {
            string3 = URLHelper.getFileURLFromSystemPath(string10);
        } else {
            GlobalLogWriter.get().println("OfficePrint.buildreference(): Unknown print type.");
            return false;
        }
        return OfficePrint.printToFile(graphicalTestArguments, string7, string9, string3);
    }

    public static boolean printToFile(GraphicalTestArguments graphicalTestArguments, String string, String string2, String string3) throws ConvWatchCancelException {
        boolean bl = false;
        Object var5_5 = null;
        String string4 = FileHelper.getSuffix(string);
        if (string4.toLowerCase().endsWith(".png") || string4.toLowerCase().endsWith(".gif") || string4.toLowerCase().endsWith(".jpg") || string4.toLowerCase().endsWith(".bmp")) {
            return false;
        }
        if (graphicalTestArguments.getReferenceType().toLowerCase().equals("ooo")) {
            bl = OfficePrint.printToFileWithOOo(graphicalTestArguments, string, string2, string3);
        } else if (graphicalTestArguments.getReferenceType().toLowerCase().equals("pdf")) {
            GlobalLogWriter.get().println("USE PDF AS EXPORT FORMAT.");
            bl = OfficePrint.storeAsPDF(graphicalTestArguments, string, string3);
        } else if (graphicalTestArguments.getReferenceType().toLowerCase().equals("msoffice")) {
            if (MSOfficePrint.isMSOfficeDocumentFormat(string)) {
                GlobalLogWriter.get().println("USE MSOFFICE AS EXPORT FORMAT.");
                MSOfficePrint mSOfficePrint = new MSOfficePrint();
                try {
                    mSOfficePrint.printToFileWithMSOffice(graphicalTestArguments, FileHelper.getSystemPathFromFileURL(string), FileHelper.getSystemPathFromFileURL(string3));
                }
                catch (ConvWatchCancelException convWatchCancelException) {
                    convWatchCancelException.printStackTrace();
                    GlobalLogWriter.get().println(convWatchCancelException.getMessage());
                    throw new ConvWatchCancelException("Exception caught. Problem with MSOffice printer methods.");
                }
                catch (IOException iOException) {
                    GlobalLogWriter.get().println(iOException.getMessage());
                    throw new ConvWatchCancelException("IOException caught. Problem with MSOffice printer methods.");
                }
                bl = true;
            } else {
                GlobalLogWriter.get().println("This document type is not recognized as MSOffice format, as default fallback StarOffice/OpenOffice.org instead is used.");
                bl = OfficePrint.printToFileWithOOo(graphicalTestArguments, string, string2, string3);
            }
        } else {
            throw new ConvWatchCancelException("OfficePrint.printToFile(): Unknown print type.");
        }
        return bl;
    }

    static void showType(String string, XMultiServiceFactory xMultiServiceFactory) {
        Object object;
        if (string.length() == 0) {
            return;
        }
        if (xMultiServiceFactory == null) {
            GlobalLogWriter.get().println("MultiServiceFactory not set.");
            return;
        }
        XTypeDetection xTypeDetection = null;
        try {
            object = xMultiServiceFactory.createInstance("com.sun.star.document.TypeDetection");
            xTypeDetection = (XTypeDetection)UnoRuntime.queryInterface(class$com$sun$star$document$XTypeDetection == null ? (class$com$sun$star$document$XTypeDetection = OfficePrint.class$("com.sun.star.document.XTypeDetection")) : class$com$sun$star$document$XTypeDetection, object);
        }
        catch (Exception exception) {
            GlobalLogWriter.get().println("Can't get com.sun.star.document.TypeDetection.");
            return;
        }
        if (xTypeDetection != null) {
            object = xTypeDetection.queryTypeByURL(string);
            GlobalLogWriter.get().println("Type is: " + (String)object);
        }
    }

    public static String getInternalFilterName(String string, XMultiServiceFactory xMultiServiceFactory) {
        XNameAccess xNameAccess;
        if (string.length() == 0) {
            return null;
        }
        if (xMultiServiceFactory == null) {
            GlobalLogWriter.get().println("MultiServiceFactory not set.");
            return null;
        }
        Object object = null;
        try {
            object = xMultiServiceFactory.createInstance("com.sun.star.document.FilterFactory");
        }
        catch (Exception exception) {
            GlobalLogWriter.get().println("Can't get com.sun.star.document.FilterFactory.");
            return null;
        }
        if (object != null && (xNameAccess = (XNameAccess)UnoRuntime.queryInterface(class$com$sun$star$container$XNameAccess == null ? (class$com$sun$star$container$XNameAccess = OfficePrint.class$("com.sun.star.container.XNameAccess")) : class$com$sun$star$container$XNameAccess, object)) != null) {
            if (!xNameAccess.hasByName(string)) {
                GlobalLogWriter.get().println("FilterFactory.hasByName() says there exist no '" + string + "'");
                return null;
            }
            Object[] objectArray = null;
            try {
                objectArray = (Object[])xNameAccess.getByName(string);
                if (objectArray != null) {
                    String string2 = null;
                    for (int i = 0; i < objectArray.length; ++i) {
                        String string3;
                        PropertyValue propertyValue = (PropertyValue)objectArray[i];
                        if (!propertyValue.Name.equals("Type")) continue;
                        string2 = string3 = (String)propertyValue.Value;
                    }
                    return string2;
                }
                GlobalLogWriter.get().println("There are no elements for FilterName '" + string + "'");
                return null;
            }
            catch (NoSuchElementException noSuchElementException) {
                GlobalLogWriter.get().println("NoSuchElementException caught. " + noSuchElementException.getMessage());
            }
            catch (WrappedTargetException wrappedTargetException) {
                GlobalLogWriter.get().println("WrappedTargetException caught. " + wrappedTargetException.getMessage());
            }
        }
        return null;
    }

    static String getServiceNameFromFilterName(String string, XMultiServiceFactory xMultiServiceFactory) {
        XNameAccess xNameAccess;
        if (string.length() == 0) {
            return null;
        }
        if (xMultiServiceFactory == null) {
            GlobalLogWriter.get().println("MultiServiceFactory not set.");
            return null;
        }
        Object object = null;
        try {
            object = xMultiServiceFactory.createInstance("com.sun.star.document.FilterFactory");
        }
        catch (Exception exception) {
            GlobalLogWriter.get().println("Can't get com.sun.star.document.FilterFactory.");
            return null;
        }
        if (object != null && (xNameAccess = (XNameAccess)UnoRuntime.queryInterface(class$com$sun$star$container$XNameAccess == null ? (class$com$sun$star$container$XNameAccess = OfficePrint.class$("com.sun.star.container.XNameAccess")) : class$com$sun$star$container$XNameAccess, object)) != null) {
            if (!xNameAccess.hasByName(string)) {
                GlobalLogWriter.get().println("FilterFactory.hasByName() says there exist no '" + string + "'");
                return null;
            }
            Object[] objectArray = null;
            try {
                objectArray = (Object[])xNameAccess.getByName(string);
                if (objectArray != null) {
                    String string2 = null;
                    for (int i = 0; i < objectArray.length; ++i) {
                        String string3;
                        PropertyValue propertyValue = (PropertyValue)objectArray[i];
                        if (!propertyValue.Name.equals("DocumentService")) continue;
                        string2 = string3 = (String)propertyValue.Value;
                        break;
                    }
                    return string2;
                }
                GlobalLogWriter.get().println("There are no elements for FilterName '" + string + "'");
                return null;
            }
            catch (NoSuchElementException noSuchElementException) {
                GlobalLogWriter.get().println("NoSuchElementException caught. " + noSuchElementException.getMessage());
            }
            catch (WrappedTargetException wrappedTargetException) {
                GlobalLogWriter.get().println("WrappedTargetException caught. " + wrappedTargetException.getMessage());
            }
        }
        return null;
    }

    public static String getFileExtension(String string, XMultiServiceFactory xMultiServiceFactory) {
        Object object;
        if (string.length() == 0) {
            return null;
        }
        if (xMultiServiceFactory == null) {
            GlobalLogWriter.get().println("MultiServiceFactory not set.");
            return null;
        }
        XTypeDetection xTypeDetection = null;
        try {
            object = xMultiServiceFactory.createInstance("com.sun.star.document.TypeDetection");
            xTypeDetection = (XTypeDetection)UnoRuntime.queryInterface(class$com$sun$star$document$XTypeDetection == null ? (class$com$sun$star$document$XTypeDetection = OfficePrint.class$("com.sun.star.document.XTypeDetection")) : class$com$sun$star$document$XTypeDetection, object);
        }
        catch (Exception exception) {
            GlobalLogWriter.get().println("Can't get com.sun.star.document.TypeDetection.");
            return null;
        }
        if (xTypeDetection != null && (object = (XNameAccess)UnoRuntime.queryInterface(class$com$sun$star$container$XNameAccess == null ? (class$com$sun$star$container$XNameAccess = OfficePrint.class$("com.sun.star.container.XNameAccess")) : class$com$sun$star$container$XNameAccess, (Object)xTypeDetection)) != null) {
            if (!object.hasByName(string)) {
                GlobalLogWriter.get().println("TypeDetection.hasByName() says there exist no '" + string + "'");
                return null;
            }
            Object[] objectArray = null;
            try {
                objectArray = (Object[])object.getByName(string);
                if (objectArray != null) {
                    String string2 = null;
                    for (int i = 0; i < objectArray.length; ++i) {
                        PropertyValue propertyValue = (PropertyValue)objectArray[i];
                        if (!propertyValue.Name.equals("Extensions")) continue;
                        String[] stringArray = (String[])propertyValue.Value;
                        GlobalLogWriter.get().println("   Possible extensions are: " + String.valueOf(stringArray.length));
                        if (stringArray.length <= 0) continue;
                        for (int j = 0; j < stringArray.length; ++j) {
                            GlobalLogWriter.get().println(" " + stringArray[j]);
                        }
                        string2 = stringArray[0];
                        GlobalLogWriter.get().println("");
                    }
                    return string2;
                }
                GlobalLogWriter.get().println("There are no elements for FilterName '" + string + "'");
                return null;
            }
            catch (NoSuchElementException noSuchElementException) {
                GlobalLogWriter.get().println("NoSuchElementException caught. " + noSuchElementException.getMessage());
            }
            catch (WrappedTargetException wrappedTargetException) {
                GlobalLogWriter.get().println("WrappedTargetException caught. " + wrappedTargetException.getMessage());
            }
        }
        return null;
    }

    public static void convertDocument(String string, String string2, GraphicalTestArguments graphicalTestArguments) throws ConvWatchCancelException {
        Object object;
        String string3;
        String string4;
        XMultiServiceFactory xMultiServiceFactory = graphicalTestArguments.getMultiServiceFactory();
        if (xMultiServiceFactory == null) {
            GlobalLogWriter.get().println("MultiServiceFactory in GraphicalTestArgument not set.");
            return;
        }
        String string5 = URLHelper.getFileURLFromSystemPath(string);
        XComponent xComponent = OfficePrint.loadFromURL(graphicalTestArguments, string5);
        if (xComponent == null) {
            GlobalLogWriter.get().println("Can't load document '" + string5 + "'");
            return;
        }
        if (string2 == null) {
            GlobalLogWriter.get().println("Outputpath not set.");
            return;
        }
        if (!graphicalTestArguments.isStoreAllowed()) {
            GlobalLogWriter.get().println("It's not allowed to store, check Input/Output path.");
            return;
        }
        OfficePrint.waitInSeconds(1, "wait after loadFromURL.");
        XServiceInfo xServiceInfo = (XServiceInfo)UnoRuntime.queryInterface(class$com$sun$star$lang$XServiceInfo == null ? (class$com$sun$star$lang$XServiceInfo = OfficePrint.class$("com.sun.star.lang.XServiceInfo")) : class$com$sun$star$lang$XServiceInfo, (Object)xComponent);
        XStorable xStorable = (XStorable)UnoRuntime.queryInterface(class$com$sun$star$frame$XStorable == null ? (class$com$sun$star$frame$XStorable = OfficePrint.class$("com.sun.star.frame.XStorable")) : class$com$sun$star$frame$XStorable, (Object)xComponent);
        if (xStorable == null) {
            GlobalLogWriter.get().println("com.sun.star.frame.XStorable is null");
            return;
        }
        String string6 = graphicalTestArguments.getExportFilterName();
        int n = 0;
        if (string6 != null && string6.length() > 0) {
            ++n;
        }
        PropertyValue[] propertyValueArray = new PropertyValue[n];
        int n2 = 0;
        String string7 = "";
        if (string6 != null && string6.length() > 0) {
            string4 = OfficePrint.getInternalFilterName(string6, xMultiServiceFactory);
            string3 = OfficePrint.getServiceNameFromFilterName(string6, xMultiServiceFactory);
            GlobalLogWriter.get().println("Filter detection:");
            boolean bl = false;
            if (string3 == null || string4 == null) {
                GlobalLogWriter.get().println("Given FilterName '" + string6 + "' seems to be unknown.");
                bl = true;
            }
            if (!xServiceInfo.supportsService(string3)) {
                GlobalLogWriter.get().println("Service from FilterName '" + string3 + "' is not supported by loaded document.");
                bl = true;
            }
            if (bl) {
                GlobalLogWriter.get().println("Please check 'DOC_CONVERTER_EXPORT_FILTER_NAME' in the property file.");
                return;
            }
            if (string4 != null && string4.length() > 0 && (string7 = OfficePrint.getFileExtension(string4, xMultiServiceFactory)) == null) {
                GlobalLogWriter.get().println("Can't found an extension for filtername, take it from the source.");
            }
            object = new PropertyValue();
            ((PropertyValue)object).Name = "FilterName";
            ((PropertyValue)object).Value = string6;
            propertyValueArray[n2++] = object;
            GlobalLogWriter.get().println("FilterName is set to: " + string6);
        }
        string4 = "";
        try {
            string3 = FileHelper.getBasename(string);
            String string8 = FileHelper.getNameNoSuffix(string3);
            object = System.getProperty("file.separator");
            String string9 = string2;
            if (!string9.endsWith((String)object)) {
                string9 = string9 + (String)object;
            }
            if (FileHelper.exists(string9 = string7 != null && string7.length() > 0 ? string9 + string8 + "." + string7 : string9 + string3) && !graphicalTestArguments.getOverwrite()) {
                GlobalLogWriter.get().println("File already exist, don't overwrite. Set DOC_COMPARATOR_OVERWRITE_REFERENCE=true to force overwrite.");
                return;
            }
            string4 = URLHelper.getFileURLFromSystemPath(string9);
            GlobalLogWriter.get().println("Store document as '" + string4 + "'");
            xStorable.storeAsURL(string4, propertyValueArray);
            GlobalLogWriter.get().println("Document stored.");
        }
        catch (com.sun.star.io.IOException iOException) {
            GlobalLogWriter.get().println("Can't store document '" + string4 + "'. Message is :'" + iOException.getMessage() + "'");
        }
        OfficePrint.waitInSeconds(1, "unknown.");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

