/*
 * Decompiled with CFR 0.152.
 */
package convwatch;

import com.sun.star.lang.DisposedException;
import com.sun.star.lang.XMultiServiceFactory;
import convwatch.ConvWatchCancelException;
import convwatch.ConvWatchException;
import convwatch.DB;
import convwatch.DirectoryHelper;
import convwatch.EnhancedComplexTestCase;
import convwatch.FileHelper;
import convwatch.GlobalLogWriter;
import convwatch.GraphicalDifferenceCheck;
import convwatch.GraphicalTestArguments;
import convwatch.HTMLOutputter;
import convwatch.LISTOutputter;
import convwatch.OSHelper;
import helper.OfficeProvider;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;

public class ConvWatchStarter
extends EnhancedComplexTestCase {
    String m_sInputPath = "";
    String m_sReferencePath = "";
    String m_sOutputPath = "";
    String m_sDiffPath = null;

    public String[] getTestMethodNames() {
        return new String[]{"compareGraphicalDiffs"};
    }

    private void initMember() {
        String string;
        String string2 = (String)param.get("DOC_COMPARATOR_INPUT_PATH");
        boolean bl = false;
        if (string2 == null || string2.length() == 0) {
            log.println("Please set input path (path to documents) DOC_COMPARATOR_INPUT_PATH=path.");
            bl = true;
        } else {
            log.println("found DOC_COMPARATOR_INPUT_PATH " + string2);
            this.m_sInputPath = string2;
        }
        String string3 = (String)param.get("DOC_COMPARATOR_REFERENCE_PATH");
        if (string3 == null || string3.length() == 0) {
            log.println("Assumtion, reference directory and input directory are the same.");
            this.m_sReferencePath = this.m_sInputPath;
        } else {
            log.println("found DOC_COMPARATOR_REFERENCE_PATH " + string3);
            this.m_sReferencePath = string3;
        }
        String string4 = (String)param.get("DOC_COMPARATOR_OUTPUT_PATH");
        if (string4 == null || string4.length() == 0) {
            log.println("Please set output path (path to a temp directory) DOC_COMPARATOR_OUTPUT_PATH=path.");
            bl = true;
        } else {
            log.println("found DOC_COMPARATOR_OUTPUT_PATH " + string4);
            this.m_sOutputPath = string4;
        }
        if (bl) {
            this.assure("Must quit", false);
        }
        if ((string = (String)param.get("DOC_COMPARATOR_DIFF_PATH")) != null && string.length() != 0) {
            log.println("found DOC_COMPARATOR_DIFF_PATH " + string);
            this.m_sDiffPath = string;
        }
        if (this.m_sInputPath.startsWith("file:") || this.m_sReferencePath.startsWith("file:") || this.m_sOutputPath.startsWith("file:")) {
            this.assure("We can't handle file: URL right, use system path instead.", false);
        }
    }

    protected Object[] mustInstalledSoftware() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!OSHelper.isWindows()) {
            arrayList.add("composite -version");
            arrayList.add("identify -version");
            arrayList.add("gs -version");
        } else {
            arrayList.add("composite.exe -version");
            arrayList.add("identify.exe -version");
            arrayList.add("gswin32c.exe -version");
        }
        return arrayList.toArray();
    }

    public void compareGraphicalDiffs() {
        GlobalLogWriter.set(log);
        this.checkEnvironment(this.mustInstalledSoftware());
        GraphicalTestArguments graphicalTestArguments = this.getGraphicalTestArguments();
        if (graphicalTestArguments == null) {
            this.assure("Must quit", false);
        }
        this.initMember();
        String string = graphicalTestArguments.getBuildID();
        log.println("Current Office has buildid: " + string);
        HTMLOutputter hTMLOutputter = HTMLOutputter.create(this.m_sOutputPath, "index.html", "", "");
        hTMLOutputter.header(this.m_sOutputPath);
        hTMLOutputter.indexSection(this.m_sOutputPath);
        LISTOutputter lISTOutputter = LISTOutputter.create(this.m_sOutputPath, "allfiles.txt");
        File file = new File(this.m_sInputPath);
        if (file.isDirectory()) {
            String string2 = System.getProperty("file.separator");
            FileFilter fileFilter = graphicalTestArguments.getFileFilter();
            Object[] objectArray = DirectoryHelper.traverse(this.m_sInputPath, fileFilter, graphicalTestArguments.includeSubDirectories());
            if (objectArray.length == 0) {
                log.println("Nothing to do, there are no document files found.");
            } else {
                for (int i = 0; i < objectArray.length; ++i) {
                    String string3 = (String)objectArray[i];
                    log.println("- next file is: ------------------------------");
                    log.println(string3);
                    String string4 = FileHelper.removeFirstDirectorysAndBasenameFrom(string3, this.m_sInputPath);
                    String string5 = this.m_sReferencePath;
                    String string6 = this.m_sOutputPath;
                    String string7 = this.m_sDiffPath;
                    if (string4.length() > 0) {
                        if (string5 != null) {
                            string5 = string5 + string2 + string4;
                        }
                        string6 = string6 + string2 + string4;
                        if (string7 != null) {
                            string7 = string7 + string2 + string4;
                        }
                    }
                    if (!graphicalTestArguments.checkIfUsable(string3)) continue;
                    this.runGDCWithStatus(hTMLOutputter, lISTOutputter, string3, string6, string5, string7, string4);
                }
            }
        } else if (graphicalTestArguments.checkIfUsable(this.m_sInputPath)) {
            this.runGDCWithStatus(hTMLOutputter, lISTOutputter, this.m_sInputPath, this.m_sOutputPath, this.m_sReferencePath, this.m_sDiffPath, "");
        }
        lISTOutputter.close();
        hTMLOutputter.close();
        log.println("The file '" + hTMLOutputter.getFilename() + "' shows a html based status.");
    }

    void runGDCWithStatus(HTMLOutputter hTMLOutputter, LISTOutputter lISTOutputter, String string, String string2, String string3, String string4, String string5) {
        Object object;
        GraphicalTestArguments graphicalTestArguments = this.getGraphicalTestArguments();
        OfficeProvider officeProvider = null;
        if (graphicalTestArguments.shouldOfficeStart()) {
            graphicalTestArguments.getPerformance().startTime(3);
            officeProvider = new OfficeProvider();
            object = (XMultiServiceFactory)officeProvider.getManager(param);
            param.put("ServiceFactory", object);
            graphicalTestArguments.getPerformance().stopTime(3);
            long l = graphicalTestArguments.getPerformance().getTime(3);
            graphicalTestArguments = this.getGraphicalTestArguments();
            graphicalTestArguments.getPerformance().setTime(3, l);
        }
        object = "";
        String string6 = "";
        try {
            DB.startFile(graphicalTestArguments.getDBInfoString(), string);
            GraphicalDifferenceCheck.checkOneFile(string, string2, string3, string4, graphicalTestArguments);
            object = "PASSED, OK";
            DB.finishedFile(graphicalTestArguments.getDBInfoString(), string);
        }
        catch (ConvWatchCancelException convWatchCancelException) {
            this.assure(convWatchCancelException.getMessage(), false, true);
            object = "CANCELED, FAILED";
            string6 = convWatchCancelException.getMessage();
            DB.reallyfailedFile(graphicalTestArguments.getDBInfoString(), string);
        }
        catch (ConvWatchException convWatchException) {
            this.assure(convWatchException.getMessage(), false, true);
            string6 = convWatchException.getMessage();
            object = "PASSED, FAILED";
            DB.failedFile(graphicalTestArguments.getDBInfoString(), string);
        }
        catch (DisposedException disposedException) {
            this.assure(disposedException.getMessage(), false, true);
            string6 = disposedException.getMessage();
            object = "FAILED, FAILED";
            DB.reallyfailedFile(graphicalTestArguments.getDBInfoString(), string);
        }
        String string7 = System.getProperty("file.separator");
        String string8 = FileHelper.getBasename(string);
        String string9 = FileHelper.getNameNoSuffix(string8);
        String string10 = string5.length() > 0 ? string5 + string7 + string9 + ".ini" : string9 + ".ini";
        lISTOutputter.writeValue(string10);
        String string11 = graphicalTestArguments.getHTMLOutputPrefix();
        GlobalLogWriter.get().println("----------------------------------------------------------------------");
        GlobalLogWriter.get().println(" OutputPath: " + string2);
        GlobalLogWriter.get().println("    NewPath: " + string5);
        GlobalLogWriter.get().println("----------------------------------------------------------------------");
        String string12 = string11 + string2 + string7 + string9 + ".ini";
        String string13 = string11 + string2 + string7 + "DiffDiff_" + string9 + ".ini";
        String string14 = string9;
        String string15 = string9 + " (DiffDiff)";
        if (string4 != null && string4.length() > 0) {
            hTMLOutputter.indexLine(string13, string15, string12, string14, (String)object, string6);
        } else {
            hTMLOutputter.indexLine(string12, string14, "", "", (String)object, string6);
        }
        if (officeProvider != null) {
            officeProvider.closeExistingOffice(param, true);
        }
    }
}

