/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb;

import com.sleepycat.bdb.DataEnvironment;
import com.sleepycat.bdb.DataIndex;
import com.sleepycat.bdb.DataStore;
import com.sleepycat.bdb.DataThang;
import com.sleepycat.bdb.IntegrityConstraintException;
import com.sleepycat.bdb.bind.KeyExtractor;
import com.sleepycat.db.Db;
import com.sleepycat.db.DbException;
import com.sleepycat.db.Dbc;
import java.io.IOException;

public class ForeignKeyIndex
extends DataIndex {
    public static final int ON_DELETE_ABORT = 0;
    public static final int ON_DELETE_CASCADE = 1;
    public static final int ON_DELETE_CLEAR = 2;
    DataStore foreignStore;
    int deleteAction;

    public ForeignKeyIndex(DataStore store, Db db, KeyExtractor keyExtractor, DataStore foreignStore, int deleteAction) {
        super(store, db, foreignStore.keyFormat, keyExtractor);
        this.foreignStore = foreignStore;
        this.deleteAction = deleteAction;
        foreignStore.addInverseIndex(this);
        if (deleteAction == 2 && keyExtractor.getPrimaryKeyFormat() != null) {
            throw new IllegalArgumentException("ON_DELETE_CLEAR cannot be used with key extractor that requires primary key");
        }
    }

    public final DataStore getForeignStore() {
        return this.foreignStore;
    }

    public final int getDeleteAction() {
        return this.deleteAction;
    }

    final void applyIndexInsert(DataThang keyThang, DataThang newIndexKey) throws DbException, IOException {
        int err = this.foreignStore.db.get(newIndexKey, DataThang.getDiscardDataThang(), 0);
        if (err != 0) {
            throw new IllegalArgumentException("Integrity error inserting in " + this.db + ", index key not found in " + this.foreignStore.db);
        }
        super.applyIndexInsert(keyThang, newIndexKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void applyForeignDelete(DataThang foreignPrimaryKeyThang) throws DbException, IOException {
        DataEnvironment env = this.store.db.env;
        DataThang primaryKeyThang = new DataThang();
        int err = this.db.get(foreignPrimaryKeyThang, primaryKeyThang, 0);
        if (err == 0) {
            switch (this.deleteAction) {
                case 0: {
                    throw new IntegrityConstraintException("ON_DELETE_ABORT: deletion not allowed");
                }
                case 1: {
                    DataThang tempThang = new DataThang();
                    Dbc cursor = this.store.db.openCursor(true);
                    try {
                        err = cursor.get(primaryKeyThang, tempThang, Db.DB_SET | env.getWriteLockFlag());
                        if (err == 0) {
                            cursor.delete(0);
                            this.store.applyChange(primaryKeyThang, tempThang, null);
                            break;
                        }
                        throw new IntegrityConstraintException("ON_DELETE_CASCADE: index entry not found");
                    }
                    finally {
                        this.store.db.closeCursor(cursor);
                    }
                }
                case 2: {
                    DataThang valueThang = new DataThang();
                    Dbc cursor = this.store.db.openCursor(true);
                    try {
                        err = cursor.get(primaryKeyThang, valueThang, Db.DB_SET | env.getWriteLockFlag());
                        if (err == 0) {
                            this.keyExtractor.clearIndexKey(this.keyExtractor.getValueFormat() != null ? valueThang : null);
                            cursor.put(primaryKeyThang, valueThang, Db.DB_CURRENT);
                            break;
                        }
                        throw new IntegrityConstraintException("ON_DELETE_CLEAR: index entry not found");
                    }
                    finally {
                        this.store.db.closeCursor(cursor);
                    }
                }
                default: {
                    throw new IllegalArgumentException("unknown delete action " + this.deleteAction);
                }
            }
        }
    }
}

