/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.filter.config.tools.merge;

import com.sun.star.filter.config.tools.utils.ConfigHelper;
import com.sun.star.filter.config.tools.utils.FileHelper;
import com.sun.star.filter.config.tools.utils.Logger;
import com.sun.star.filter.config.tools.utils.XMLHelper;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;

public class Merger {
    private static final String PROP_XMLVERSION = "xmlversion";
    private static final String PROP_XMLENCODING = "xmlencoding";
    private static final String PROP_XMLPATH = "xmlpath";
    private static final String PROP_XMLPACKAGE = "xmlpackage";
    private static final String PROP_SETNAME_TYPES = "setname_types";
    private static final String PROP_SETNAME_FILTERS = "setname_filters";
    private static final String PROP_SETNAME_LOADERS = "setname_frameloaders";
    private static final String PROP_SETNAME_HANDLERS = "setname_contenthandlers";
    private static final String PROP_SUBDIR_TYPES = "subdir_types";
    private static final String PROP_SUBDIR_FILTERS = "subdir_filters";
    private static final String PROP_SUBDIR_LOADERS = "subdir_frameloaders";
    private static final String PROP_SUBDIR_HANDLERS = "subdir_contenthandlers";
    private static final String PROP_EXTENSION_XCU = "extension_xcu";
    private static final String PROP_EXTENSION_PKG = "extension_pkg";
    private static final String PROP_DELIMITER = "delimiter";
    private static final String PROP_TRIM = "trim";
    private static final String PROP_DECODE = "decode";
    private static final String PROP_FRAGMENTSDIR = "fragmentsdir";
    private static final String PROP_TEMPDIR = "tempdir";
    private static final String PROP_OUTDIR = "outdir";
    private static final String PROP_PKG = "pkg";
    private static final String PROP_DEBUG = "debug";
    private static final String PROP_TCFG = "tcfg";
    private static final String PROP_FCFG = "fcfg";
    private static final String PROP_LCFG = "lcfg";
    private static final String PROP_CCFG = "ccfg";
    private static final String PROP_LANGUAGEPACK = "languagepack";
    private static final String PROP_ITEMS = "items";
    private ConfigHelper m_aCfg;
    private Logger m_aLog;
    private File m_aFragmentsDir;
    private File m_aTempDir;
    private File m_aOutDir;
    private Vector m_lTypes;
    private Vector m_lFilters;
    private Vector m_lLoaders;
    private Vector m_lHandlers;

    public Merger(ConfigHelper configHelper, Logger logger) throws Exception {
        ConfigHelper configHelper2;
        this.m_aCfg = configHelper;
        this.m_aLog = logger;
        this.m_aFragmentsDir = new File(this.m_aCfg.getString(PROP_FRAGMENTSDIR));
        this.m_aTempDir = new File(this.m_aCfg.getString(PROP_TEMPDIR));
        String string = this.m_aCfg.getString(PROP_DELIMITER);
        boolean bl = this.m_aCfg.getBoolean(PROP_TRIM);
        boolean bl2 = this.m_aCfg.getBoolean(PROP_DECODE);
        try {
            configHelper2 = new ConfigHelper(this.m_aCfg.getString(PROP_TCFG), null);
            this.m_lTypes = configHelper2.getStringList(PROP_ITEMS, string, bl, bl2);
        }
        catch (NoSuchElementException noSuchElementException) {
            this.m_lTypes = new Vector();
        }
        try {
            configHelper2 = new ConfigHelper(this.m_aCfg.getString(PROP_FCFG), null);
            this.m_lFilters = configHelper2.getStringList(PROP_ITEMS, string, bl, bl2);
        }
        catch (NoSuchElementException noSuchElementException) {
            this.m_lFilters = new Vector();
        }
        try {
            configHelper2 = new ConfigHelper(this.m_aCfg.getString(PROP_LCFG), null);
            this.m_lLoaders = configHelper2.getStringList(PROP_ITEMS, string, bl, bl2);
        }
        catch (NoSuchElementException noSuchElementException) {
            this.m_lLoaders = new Vector();
        }
        try {
            configHelper2 = new ConfigHelper(this.m_aCfg.getString(PROP_CCFG), null);
            this.m_lHandlers = configHelper2.getStringList(PROP_ITEMS, string, bl, bl2);
        }
        catch (NoSuchElementException noSuchElementException) {
            this.m_lHandlers = new Vector();
        }
    }

    public synchronized void merge() throws Exception {
        StringBuffer stringBuffer = new StringBuffer(1000000);
        String string = this.m_aCfg.getString(PROP_PKG);
        this.m_aLog.setGlobalInfo("create package \"" + string + "\" ...");
        this.m_aLog.setDetailedInfo("generate package header ... ");
        stringBuffer.append(XMLHelper.generateHeader(this.m_aCfg.getString(PROP_XMLVERSION), this.m_aCfg.getString(PROP_XMLENCODING), this.m_aCfg.getString(PROP_XMLPATH), this.m_aCfg.getString(PROP_XMLPACKAGE), this.m_aCfg.getBoolean(PROP_LANGUAGEPACK, false)));
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            String string2 = null;
            String string3 = null;
            Vector vector = null;
            try {
                switch (i) {
                    case 0: {
                        this.m_aLog.setDetailedInfo("generate set for types ... ");
                        string2 = this.m_aCfg.getString(PROP_SETNAME_TYPES);
                        string3 = this.m_aCfg.getString(PROP_SUBDIR_TYPES);
                        vector = this.m_lTypes;
                        break;
                    }
                    case 1: {
                        this.m_aLog.setDetailedInfo("generate set for filter ... ");
                        string2 = this.m_aCfg.getString(PROP_SETNAME_FILTERS);
                        string3 = this.m_aCfg.getString(PROP_SUBDIR_FILTERS);
                        vector = this.m_lFilters;
                        break;
                    }
                    case 2: {
                        this.m_aLog.setDetailedInfo("generate set for frame loader ... ");
                        string2 = this.m_aCfg.getString(PROP_SETNAME_LOADERS);
                        string3 = this.m_aCfg.getString(PROP_SUBDIR_LOADERS);
                        vector = this.m_lLoaders;
                        break;
                    }
                    case 3: {
                        this.m_aLog.setDetailedInfo("generate set for content handler ... ");
                        string2 = this.m_aCfg.getString(PROP_SETNAME_HANDLERS);
                        string3 = this.m_aCfg.getString(PROP_SUBDIR_HANDLERS);
                        vector = this.m_lHandlers;
                    }
                }
                n += vector.size();
                this.getFragments(new File(this.m_aFragmentsDir, string3), string2, vector, 1, stringBuffer);
                continue;
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
        this.m_aLog.setDetailedInfo("generate package footer ... ");
        stringBuffer.append(XMLHelper.generateFooter());
        if (n < 1) {
            this.m_aLog.setWarning("Package is empty and will not result into a xml file on disk!? Please check configuration file.");
            return;
        }
        this.m_aLog.setGlobalInfo("package contains " + n + " items");
        File file = new File(string);
        this.m_aLog.setGlobalInfo("write temp package \"" + file.getPath());
        FileHelper.writeEncodedBufferToFile(file, "UTF-8", false, stringBuffer);
    }

    private void getFragments(File file, String string, Vector vector, int n, StringBuffer stringBuffer) throws Exception {
        int n2;
        if (vector.size() < 1) {
            this.m_aLog.setWarning("List of fragments is empty!? Will be ignored ...");
            return;
        }
        Enumeration enumeration = vector.elements();
        String string2 = this.m_aCfg.getString(PROP_EXTENSION_XCU);
        for (n2 = 0; n2 < n; ++n2) {
            stringBuffer.append("\t");
        }
        stringBuffer.append("<node oor:name=\"" + string + "\">\n");
        ++n;
        n2 = this.m_aCfg.getBoolean(PROP_LANGUAGEPACK, false) ? 1 : 0;
        boolean bl = this.m_aCfg.getBoolean(PROP_DEBUG, false);
        String string3 = "UTF-8";
        if (bl) {
            string3 = "UTF-8Special";
        }
        while (enumeration.hasMoreElements()) {
            String string4 = (String)enumeration.nextElement();
            File file2 = new File(file, string4 + "." + string2);
            if (!file2.exists()) {
                if (n2 != 0) {
                    this.m_aLog.setWarning("language fragment \"" + file2.getPath() + "\" does not exist. Will be ignored.");
                    continue;
                }
                throw new IOException("fragment \"" + file2.getPath() + "\" does not exists.");
            }
            if (!file2.isFile()) {
                this.m_aLog.setWarning("fragment \"" + file2.getPath() + "\" seem to be not a valid file.");
                continue;
            }
            this.m_aLog.setDetailedInfo("merge fragment \"" + file2.getPath() + "\" ...");
            FileHelper.readEncodedBufferFromFile(file2, string3, stringBuffer);
            stringBuffer.append("\n");
        }
        --n;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("\t");
        }
        stringBuffer.append("</node>\n");
    }
}

